/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.core;

import org.apache.log4j.Logger;
import pl.mpak.orbada.Consts;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.db.InternalDatabase;
import pl.mpak.orbada.plugins.IApplication;
import pl.mpak.orbada.plugins.OrbadaPlugin;
import pl.mpak.orbada.plugins.providers.abs.IOrbadaPluginProvider;
import pl.mpak.orbada.plugins.queue.PluginQueue;
import pl.mpak.plugins.CallMethod;
import pl.mpak.plugins.Plugin;
import pl.mpak.plugins.PluginFound;
import pl.mpak.plugins.PluginManager;
import pl.mpak.plugins.PluginManagerListener;
import pl.mpak.plugins.spi.IPlugin;
import pl.mpak.plugins.spi.IPluginProvider;
import pl.mpak.usedb.core.Command;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.variant.Variant;

public class OrbadaPluginManager
extends PluginManager {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);
    private Logger logger;
    private PluginQueue queue = new PluginQueue((PluginManager)this);

    public OrbadaPluginManager(Logger logger) {
        super(OrbadaPlugin.class);
        this.queue.start();
        this.logger = logger;
        this.setLogger(logger);
        this.addPluginManagerListener(new PluginManagerListener(){

            public void beginProcess(PluginManagerListener.ManageProcess type, int count) {
            }

            public void process(PluginManagerListener.ManageProcess type, IPlugin plugin) {
                if (type == PluginManagerListener.ManageProcess.LOAD) {
                    OrbadaPluginManager.this.logger.debug("Plugin \"" + plugin.getDescriptiveName() + "\" loaded");
                } else if (type == PluginManagerListener.ManageProcess.UNLOAD) {
                    OrbadaPluginManager.this.logger.debug("Plugin \"" + plugin.getDescriptiveName() + "\" unloaded");
                } else if (type == PluginManagerListener.ManageProcess.INITIALIZE) {
                    OrbadaPluginManager.this.logger.debug("Plugin \"" + plugin.getDescriptiveName() + "\" initialized");
                }
            }

            public void endProcess(PluginManagerListener.ManageProcess type) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFoundPlugins() {
        if (InternalDatabase.get() == null) {
            return;
        }
        Query query = InternalDatabase.get().createQuery();
        try {
            try {
                query.setCloseResultAfterOpen(true);
                query.setSqlText("select plg_class_name, plg_enabled from plugins where plg_usr_id = :USR_ID");
                query.paramByName("USR_ID").setString(Application.get().getUserId());
                query.open();
                for (int i = 0; i < this.getFoundList().size(); ++i) {
                    PluginFound pf = (PluginFound)this.getFoundList().get(i);
                    if (query.locate("plg_class_name", new Variant(pf.getClassName()))) {
                        pf.setEnabled(StringUtil.toBoolean((String)query.fieldByName("plg_enabled").getString()));
                    }
                    this.logger.debug("Founded plugin \"" + pf.getClassName() + "\" " + (pf.isEnabled() ? "enabled" : "disabled"));
                }
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
        finally {
            query.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLoadedPlugins() {
        if (InternalDatabase.get() == null) {
            return;
        }
        Query query = InternalDatabase.get().createQuery();
        try {
            Application.renderSplashText(stringManager.getString("OrbadaPluginManager-register-plugin-3dot"));
            try {
                Command resetCommand = InternalDatabase.get().createCommand("update plugins set plg_loaded = 'N' where plg_usr_id = :USR_ID", false);
                resetCommand.paramByName("usr_id").setString(Application.get().getUserId());
                resetCommand.execute();
                Command updateCommand = InternalDatabase.get().createCommand("update plugins\n   set plg_file_name = :plg_file_name,\n       plg_class_name = :plg_class_name,\n       plg_description = :plg_description,\n       plg_author = :plg_author,\n       plg_version = :plg_version,\n       plg_web_site = :plg_web_site,\n       plg_update_site = :plg_update_site\n where plg_id = :plg_id\n   and plg_usr_id = :USR_ID", false);
                Command insertCommand = InternalDatabase.get().createCommand("insert into plugins (\n  plg_id, plg_usr_id, plg_file_name, plg_class_name, plg_description, plg_author, plg_version,\n  plg_web_site, plg_update_site, plg_enabled, plg_loaded)\nvalues (\n  :plg_id, :plg_usr_id, :plg_file_name, :plg_class_name, :plg_description, :plg_author, :plg_version,\n  :plg_web_site, :plg_update_site, 'T', 'T')", false);
                Command loaded = InternalDatabase.get().createCommand("update plugins set plg_loaded = 'T' where plg_id = :plg_id and plg_usr_id = :USR_ID", false);
                query.setCloseResultAfterOpen(true);
                query.setSqlText("select plg_id, plg_version from plugins where plg_usr_id = :USR_ID");
                query.paramByName("USR_ID").setString(Application.get().getUserId());
                query.open();
                for (int i = 0; i < this.getPluginList().size(); ++i) {
                    Plugin p = (Plugin)this.getPluginList().get(i);
                    if (query.locate("plg_id", new Variant(p.getUniqueID()))) {
                        if (p.getPlugin() instanceof OrbadaPlugin && !query.isEmpty()) {
                            ((OrbadaPlugin)p.getPlugin()).setLastVersion(query.fieldByName("plg_version").getString());
                        }
                        loaded.paramByName("plg_id").setString(p.getUniqueID());
                        loaded.paramByName("usr_id").setString(Application.get().getUserId());
                        loaded.execute();
                        if (p.getVersion().equals(query.fieldByName("plg_version").getString())) continue;
                        try {
                            updateCommand.paramByName("plg_id").setString(p.getUniqueID());
                            updateCommand.paramByName("plg_file_name").setString(p.getSource());
                            updateCommand.paramByName("plg_class_name").setString(p.getClassName());
                            updateCommand.paramByName("plg_description").setString(p.getDescriptiveName());
                            updateCommand.paramByName("plg_author").setString(p.getAuthor());
                            updateCommand.paramByName("plg_version").setString(p.getVersion());
                            updateCommand.paramByName("plg_web_site").setString(p.getWebSite());
                            updateCommand.paramByName("plg_update_site").setString(p.getUpdateSite());
                            updateCommand.paramByName("usr_id").setString(Application.get().getUserId());
                            updateCommand.execute();
                        }
                        catch (Exception ex) {
                            ExceptionUtil.processException((Throwable)ex);
                        }
                        continue;
                    }
                    try {
                        insertCommand.paramByName("plg_id").setString(p.getUniqueID());
                        insertCommand.paramByName("plg_usr_id").setString(Application.get().getUserId());
                        insertCommand.paramByName("plg_file_name").setString(p.getSource());
                        insertCommand.paramByName("plg_class_name").setString(p.getClassName());
                        insertCommand.paramByName("plg_description").setString(p.getDescriptiveName());
                        insertCommand.paramByName("plg_author").setString(p.getAuthor());
                        insertCommand.paramByName("plg_version").setString(p.getVersion());
                        insertCommand.paramByName("plg_web_site").setString(p.getWebSite());
                        insertCommand.paramByName("plg_update_site").setString(p.getUpdateSite());
                        insertCommand.execute();
                        continue;
                    }
                    catch (Exception ex) {
                        ExceptionUtil.processException((Throwable)ex);
                    }
                }
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
        finally {
            query.close();
        }
    }

    public void setEnabled(String id, boolean enabled) {
        Command command = InternalDatabase.get().createCommand();
        try {
            command.setSqlText("update plugins set plg_enabled = :plg_enabled where plg_id = :plg_id and plg_usr_id = :USR_ID");
            command.paramByName("plg_enabled").setString(enabled ? "T" : "N");
            command.paramByName("plg_id").setString(id);
            command.paramByName("usr_id").setString(Application.get().getUserId());
            command.execute();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public <T extends IPluginProvider> T[] getServiceArray(Class<T> t) {
        IPluginProvider[] array;
        Application app = Application.get();
        for (IPluginProvider tt : array = super.getServiceArray(t)) {
            if (!(tt instanceof IOrbadaPluginProvider)) continue;
            ((IOrbadaPluginProvider)tt).setApplication((IApplication)app);
        }
        return array;
    }

    public void findPlugins() {
        this.logger.debug("Plugin searching...");
        super.findPlugins();
        this.checkFoundPlugins();
        this.logger.debug("Plugin founds Okay");
    }

    public void loadPlugins() {
        Application.renderSplashText(stringManager.getString("OrbadaPluginManager-loading-plugins-3dot"));
        this.logger.debug("Plugin loading...");
        super.loadPlugins();
        this.updateLoadedPlugins();
        this.logger.debug("Plugin loaded Okay");
    }

    public void initializePlugins() {
        int i;
        this.logger.debug("Plugin initializing...");
        for (i = 0; i < this.getCount(); ++i) {
            this.logger.debug("BEFORE:" + this.getPlugin(i).getUniqueID());
        }
        super.callMethodPlugins(new CallMethod(){

            public void call(IPlugin plugin) {
                ((OrbadaPlugin)plugin).setApplication((IApplication)Application.get());
            }
        });
        super.initializePlugins();
        for (i = 0; i < this.getCount(); ++i) {
            this.logger.debug("AFTER:" + this.getPlugin(i).getUniqueID());
        }
        this.logger.debug("Plugin initializing: Okay");
    }

    public void unloadPlugins() {
        this.logger.debug("Plugin unloading...");
        super.unloadPlugins();
        this.logger.debug("Plugin unloaded Okay");
    }

    public PluginQueue getPluginQueue() {
        return this.queue;
    }
}

