/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.db;

import java.awt.EventQueue;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import pl.mpak.orbada.OrbadaException;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.db.Driver;
import pl.mpak.orbada.db.DriverClassLoaderManager;
import pl.mpak.orbada.db.DriverType;
import pl.mpak.orbada.db.InternalDatabase;
import pl.mpak.orbada.db.OrbadaDatabase;
import pl.mpak.orbada.db.Schema;
import pl.mpak.orbada.plugins.providers.DatabaseInfoProvider;
import pl.mpak.orbada.plugins.providers.DatabaseProvider;
import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.DatabaseManager;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringUtil;
import pl.mpak.util.variant.Variant;
import pl.mpak.util.variant.VariantException;

public class ConnectionFactory {
    private String url;
    private String user;
    private String password;
    private String sch_id;
    private Schema schema;
    private Driver driver;
    private Database cloneDatabase;

    public ConnectionFactory(Database cloneDatabase) {
        this.cloneDatabase = cloneDatabase;
        this.url = cloneDatabase.getUrl();
        this.user = cloneDatabase.getUserName();
        this.password = cloneDatabase.getPassword();
        this.sch_id = cloneDatabase.getUserProperties().getProperty("schemaId");
    }

    public ConnectionFactory(String url, String user, String password, String sch_id) {
        this.url = url;
        this.user = user;
        this.password = password;
        this.sch_id = sch_id;
    }

    public ConnectionFactory(String url, String user, String password, Schema schema) {
        this.url = url;
        this.user = user;
        this.password = password;
        this.schema = schema;
    }

    public static ConnectionFactory createInstance() {
        return new ConnectionFactory(null, null, null, (String)null);
    }

    public static ConnectionFactory createInstance(String url, String user, String password, String sch_id) {
        return new ConnectionFactory(url, user, password, sch_id);
    }

    public static ConnectionFactory createInstance(String url, String user, String password, Schema schema) {
        return new ConnectionFactory(url, user, password, schema);
    }

    public Database createDatabase() throws UseDBException, OrbadaException, VariantException, SQLException {
        return this.createDatabase(false);
    }

    public Database createDatabase(boolean testConnection) throws UseDBException, OrbadaException, VariantException, SQLException {
        if (this.schema == null) {
            this.schema = new Schema(InternalDatabase.get(), this.sch_id);
        }
        if (!this.schema.fieldByName("sch_drv_id").getValue().isNullValue()) {
            this.driver = this.schema.getDriver();
        }
        if (this.getDriverClass() == null) {
            throw new OrbadaException(1001);
        }
        if (this.url == null || "".equals(this.url)) {
            this.url = this.schema.replacePatts(this.driver.fieldByName("drv_url_template").getValue().toString());
            if (this.url == null || "".equals(this.url)) {
                throw new OrbadaException(1005);
            }
        }
        if (!Application.get().isUserAdmin() && this.url.equalsIgnoreCase(InternalDatabase.get().getUrl()) && this.user.equalsIgnoreCase(InternalDatabase.get().getUserName())) {
            throw new OrbadaException(1004);
        }
        String driverClass = this.getDriverClass();
        final OrbadaDatabase database = (OrbadaDatabase)DatabaseManager.createDatabase(OrbadaDatabase.class);
        try {
            database.setDriver(DriverClassLoaderManager.getDriver(this.getLibrarySource(), this.getExtraLibrary(), driverClass));
        }
        catch (Exception ex) {
            throw new OrbadaException(1001, (Throwable)ex);
        }
        database.setUrl(this.url);
        database.setUserName(this.user);
        database.setPassword(this.password);
        Properties properties = this.schema.getProperties();
        if (properties != null) {
            for (Map.Entry<Object, Object> e : properties.entrySet()) {
                database.getProperties().put(e.getKey(), e.getValue());
            }
        }
        if ((properties = this.schema.getUserProperties()) != null) {
            for (Map.Entry<Object, Object> e : properties.entrySet()) {
                database.getUserProperties().put(e.getKey(), e.getValue());
            }
        }
        database.connect();
        if (!testConnection) {
            DatabaseProvider[] dpa;
            if (this.cloneDatabase == null) {
                database.setPublicName(this.schema.getPublicNameResolved(this.user));
            } else {
                database.setPublicName(this.cloneDatabase.getPublicName() + " (Kopia)");
            }
            try {
                DriverType dt = this.driver.getDriverType();
                database.getUserProperties().setProperty("dtp_id", dt.getId());
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
            database.getUserProperties().setProperty("schemaId", this.sch_id.toString());
            database.setDriverType(this.driver.fieldByName("DRV_TYPE_NAME").getValue().toString());
            database.setServerName(this.schema.fieldByName("SCH_DATABASE").getValue().toString());
            try {
                if (database.getMetaData().supportsTransactions()) {
                    database.setAutoCommit(StringUtil.toBoolean((String)this.schema.fieldByName("sch_auto_commit").getValue().getString()));
                }
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
            this.schema.fieldByName("sch_selected").setValue(new Variant(System.currentTimeMillis()));
            try {
                DatabaseInfoProvider[] dip = (DatabaseInfoProvider[])Application.get().getServiceArray(DatabaseInfoProvider.class);
                if (dip != null && dip.length > 0) {
                    for (int i = 0; i < dip.length; ++i) {
                        if (!dip[i].isForDatabase((Database)database)) continue;
                        this.schema.fieldByName("sch_db_version").setValue(new Variant(dip[i].getVersion((Database)database)));
                    }
                } else {
                    DatabaseMetaData dmd = database.getConnection().getMetaData();
                    this.schema.fieldByName("sch_db_version").setValue(new Variant(dmd.getDatabaseMajorVersion() + "." + dmd.getDatabaseMinorVersion()));
                }
            }
            catch (SQLException ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
            if (this.cloneDatabase == null) {
                try {
                    this.schema.applyUpdate();
                }
                catch (Exception ex) {
                    ExceptionUtil.processException((Throwable)ex);
                }
            }
            for (DatabaseProvider dp : dpa = (DatabaseProvider[])Application.get().getServiceArray(DatabaseProvider.class)) {
                if (!dp.isForDatabase((Database)database)) continue;
                dp.afterConnection((Database)database);
            }
            if (this.cloneDatabase == null) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Application.get().getMainFrame().openPerspectiveFor(database, ConnectionFactory.this.schema);
                    }
                });
            }
        }
        database.createSession(this.schema.getSchId());
        return database;
    }

    public String getDriverClass() {
        if (this.driver != null) {
            return this.driver.fieldByName("drv_class_name").getValue().toString();
        }
        return null;
    }

    public String getLibrarySource() {
        if (this.driver != null && !this.driver.fieldByName("DRV_LIBRARY_SOURCE").isNull()) {
            return this.driver.fieldByName("DRV_LIBRARY_SOURCE").getValue().toString();
        }
        return null;
    }

    public String getExtraLibrary() {
        if (this.driver != null && !this.driver.fieldByName("DRV_EXTRA_LIBRARY").isNull()) {
            return this.driver.fieldByName("DRV_EXTRA_LIBRARY").getValue().toString();
        }
        return null;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

