/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.db;

import java.io.File;
import java.net.MalformedURLException;
import java.sql.Driver;
import java.util.HashMap;
import java.util.StringTokenizer;
import pl.mpak.orbada.db.DriverClassLoader;
import pl.mpak.util.StringUtil;

public class DriverClassLoaderManager {
    private static HashMap<String, DriverClassLoader> driverMap = new HashMap();

    public static Driver getDriver(String source, String extraLibs, String className) throws MalformedURLException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (!StringUtil.isEmpty((String)source) && new File(source).exists()) {
            DriverClassLoader dcl = driverMap.get(source);
            if (dcl == null) {
                dcl = new DriverClassLoader(source);
                if (!StringUtil.isEmpty((String)extraLibs)) {
                    StringTokenizer st = new StringTokenizer(extraLibs, ";");
                    while (st.hasMoreTokens()) {
                        File lib = new File(st.nextToken());
                        if (!lib.exists()) continue;
                        dcl.addURL(lib.toURI().toURL());
                    }
                }
                driverMap.put(source, dcl);
            }
            return dcl.getDriver(className);
        }
        return (Driver)Class.forName(className).newInstance();
    }

    public static void reset() {
        driverMap.clear();
    }
}

