/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.db;

import java.sql.SQLException;
import java.util.Date;
import pl.mpak.orbada.Consts;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.db.InternalDatabase;
import pl.mpak.orbada.db.SchemaSession;
import pl.mpak.orbada.plugins.providers.IDatabaseProvider;
import pl.mpak.orbada.plugins.queue.PluginMessage;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class OrbadaDatabase
extends Database {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);
    private SchemaSession schemaSession;

    public void connect() throws SQLException {
        super.connect();
    }

    void createSession(String schId) {
        this.schemaSession = new SchemaSession(InternalDatabase.get());
        this.schemaSession.setStartTime(Long.valueOf(new Date().getTime()));
        this.schemaSession.setOsesId(Application.get().getOrbadaSessionId());
        this.schemaSession.setSchId(schId);
        this.schemaSession.setUser(this.getUserName());
        this.schemaSession.setUrl(this.getUrl());
        try {
            this.schemaSession.applyInsert();
            this.getUserProperties().setProperty("schema-session-id", this.schemaSession.getId());
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public void disconnect() throws SQLException {
        if (!((Object)((Object)this)).equals(InternalDatabase.get())) {
            IDatabaseProvider[] dpa;
            for (IDatabaseProvider dp : dpa = (IDatabaseProvider[])Application.get().getServiceArray(IDatabaseProvider.class)) {
                if (!dp.isForDatabase((Database)this)) continue;
                dp.beforeDisconnect((Database)this);
            }
        } else if (InternalDatabase.get().getUrl().toUpperCase().indexOf("jdbc:hsqldb:file:".toUpperCase()) != -1) {
            try {
                InternalDatabase.get().executeCommand("shutdown compact");
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
        super.disconnect();
        if (this.schemaSession != null) {
            this.schemaSession.setEndTime(Long.valueOf(new Date().getTime()));
            try {
                this.schemaSession.applyUpdate();
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }

    public void commit() throws SQLException {
        super.commit();
        Application.get().postPluginMessage(new PluginMessage("orbada-system-plugin", "status-text", (Object)stringManager.getString("OrbadaDatabase-changes-accepted")));
        Application.get().postPluginMessage(new PluginMessage(null, "transaction-state-change", (Object)"commit"));
    }

    public void rollback() throws SQLException {
        super.rollback();
        Application.get().postPluginMessage(new PluginMessage("orbada-system-plugin", "status-text", (Object)stringManager.getString("OrbadaDatabase-changes-rollbacks")));
        Application.get().postPluginMessage(new PluginMessage(null, "transaction-state-change", (Object)"rollback"));
    }

    public void startTransaction() throws SQLException {
        super.startTransaction();
        Application.get().postPluginMessage(new PluginMessage("orbada-system-plugin", "status-text", (Object)stringManager.getString("OrbadaDatabase-changes-start_transaction")));
        Application.get().postPluginMessage(new PluginMessage(null, "transaction-state-change", (Object)"start"));
    }

    public void executeCommandNoException(String sqlText) {
        try {
            this.createCommand(sqlText, true);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }
}

