/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import pl.mpak.g2.G2Util;
import pl.mpak.orbada.Consts;
import pl.mpak.orbada.core.Application;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.VerticalFlowLayout;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class AboutOrbadaDialog
extends JDialog {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);
    public static final String[] orbadaTranlateHelp = new String[]{"Piotr R\u00f3\u017cnicki"};
    public static final String[] orbadaProgrammingSupport = new String[]{"Piotr R\u00f3\u017cnicki"};
    public static final String[] orbadaTestAndSuggestion = new String[]{"Piotr R\u00f3\u017cnicki", "Tomasz Michalski", "Micha\u0142 Kurczabi\u0144ski", stringManager.getString("about-dialog-test-andothers")};
    public static final String[] orbadaSplashScreens = new String[]{"Robert Proksa"};
    private BufferedImage bufferImage;
    private JButton buttonCancel;
    private Action cmClose;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JLabel labelInfo;
    private JLabel labelProgramSupport;
    private JLabel labelSplash;
    private JLabel labelSplashScreens;
    private JLabel labelTestSugestion;
    private JLabel labelTransHelps;
    private JPanel panelThanks;
    private JTabbedPane tabInfo;

    public AboutOrbadaDialog() {
        super(SwingUtil.getRootFrame(), true);
        this.initComponents();
        this.init();
    }

    public static void showDialog() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AboutOrbadaDialog dialog = new AboutOrbadaDialog();
                dialog.setVisible(true);
            }
        });
    }

    private void init() {
        this.bufferImage = G2Util.createImage((URL)this.getClass().getResource("/res/splashscreen.jpg"));
        Graphics2D g2 = (Graphics2D)this.bufferImage.getGraphics();
        Application.drawSplashInfo(g2, new Rectangle(this.bufferImage.getWidth(), this.bufferImage.getHeight()));
        this.labelSplash.setIcon(new ImageIcon(this.bufferImage));
        this.labelSplash.setPreferredSize(new Dimension(this.bufferImage.getWidth(), this.bufferImage.getHeight()));
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append(String.format(stringManager.getString("AboutOrbadaDialog-version"), "Dzianisz, Polska", Consts.orbadaVersion));
        sb.append(String.format(stringManager.getString("AboutOrbadaDialog-author"), "Andrzej Ka\u0142u\u017ca", "2007-2015"));
        sb.append(stringManager.getString("AboutOrbadaDialog-project"));
        sb.append("<hr>");
        sb.append(String.format(stringManager.getString("AboutOrbadaDialog-orbada-id"), Application.get().getOrbadaString("unique-id")));
        sb.append(String.format(stringManager.getString("AboutOrbadaDialog-update"), "2015-04-02"));
        this.labelInfo.setText(sb.toString());
        this.labelTransHelps.setText("<html>" + StringUtil.toString((String[])orbadaTranlateHelp, (String)"<br>"));
        this.labelProgramSupport.setText("<html>" + StringUtil.toString((String[])orbadaProgrammingSupport, (String)"<br>"));
        this.labelTestSugestion.setText("<html>" + StringUtil.toString((String[])orbadaTestAndSuggestion, (String)"<br>"));
        this.labelSplashScreens.setText("<html>" + StringUtil.toString((String[])orbadaSplashScreens, (String)"<br>"));
        this.pack();
        this.getRootPane().getInputMap(2).put(this.cmClose.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmClose);
        SwingUtil.setButtonSizesTheSame((AbstractButton[])new AbstractButton[]{this.buttonCancel});
        SwingUtil.centerWithinScreen((Window)this);
    }

    private void initComponents() {
        this.cmClose = new Action();
        this.jPanel1 = new JPanel();
        this.tabInfo = new JTabbedPane();
        this.labelSplash = new JLabel();
        this.panelThanks = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.labelTransHelps = new JLabel();
        this.jLabel2 = new JLabel();
        this.labelProgramSupport = new JLabel();
        this.jLabel3 = new JLabel();
        this.labelTestSugestion = new JLabel();
        this.jLabel4 = new JLabel();
        this.labelSplashScreens = new JLabel();
        this.labelInfo = new JLabel();
        this.jPanel2 = new JPanel();
        this.buttonCancel = new JButton();
        this.cmClose.setActionCommandKey("cmCancel");
        this.cmClose.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmClose.setText(stringManager.getString("cmClose-text"));
        this.cmClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AboutOrbadaDialog.this.cmCloseActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(stringManager.getString("AboutOrbadaDialog-title"));
        this.setResizable(false);
        this.getContentPane().setLayout(new FlowLayout());
        this.jPanel1.setLayout((LayoutManager)new VerticalFlowLayout());
        this.tabInfo.setFocusable(false);
        this.labelSplash.setHorizontalAlignment(0);
        this.labelSplash.setPreferredSize(new Dimension(500, 300));
        this.tabInfo.addTab(stringManager.getString("tab-orbada"), this.labelSplash);
        this.jScrollPane1.setBorder(null);
        this.jPanel3.setBackground(UIManager.getDefaults().getColor("window"));
        this.jLabel1.setText(stringManager.getString("about-dialog-translate-help-h-dd"));
        this.labelTransHelps.setText(" ");
        this.jLabel2.setText(stringManager.getString("about-dialog-programmer-support-h-dd"));
        this.labelProgramSupport.setText(" ");
        this.jLabel3.setText(stringManager.getString("about-dialog-tests-sugestion-h-dd"));
        this.labelTestSugestion.setText(" ");
        this.jLabel4.setText(stringManager.getString("about-dialog-splashscreen-h-dd"));
        this.labelSplashScreens.setText(" ");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -2, -1, -2).addComponent(this.labelTransHelps).addComponent(this.jLabel2, -2, -1, -2).addComponent(this.labelProgramSupport).addComponent(this.jLabel3, -2, -1, -2).addComponent(this.labelTestSugestion).addComponent(this.jLabel4, -2, -1, -2).addComponent(this.labelSplashScreens)).addContainerGap(239, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelTransHelps).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelProgramSupport).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelTestSugestion).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelSplashScreens).addContainerGap(123, Short.MAX_VALUE)));
        this.jScrollPane1.setViewportView(this.jPanel3);
        GroupLayout panelThanksLayout = new GroupLayout(this.panelThanks);
        this.panelThanks.setLayout(panelThanksLayout);
        panelThanksLayout.setHorizontalGroup(panelThanksLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 500, Short.MAX_VALUE));
        panelThanksLayout.setVerticalGroup(panelThanksLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 300, Short.MAX_VALUE));
        this.tabInfo.addTab(stringManager.getString("tab-thanks"), this.panelThanks);
        this.jPanel1.add(this.tabInfo);
        this.labelInfo.setText("jLabel1");
        this.jPanel1.add(this.labelInfo);
        this.buttonCancel.setAction((javax.swing.Action)this.cmClose);
        this.buttonCancel.setMargin(new Insets(2, 2, 2, 2));
        this.buttonCancel.setPreferredSize(new Dimension(85, 25));
        this.jPanel2.add(this.buttonCancel);
        this.jPanel1.add(this.jPanel2);
        this.getContentPane().add(this.jPanel1);
        this.pack();
    }

    private void cmCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

