/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import pl.mpak.orbada.Consts;
import pl.mpak.orbada.core.Application;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.IconPanel;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class ChangeUserPasswordDialog
extends JDialog {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);
    private int modalResult = 0;
    private JButton buttonCancel;
    private JButton buttonOk;
    private Action cmCancel;
    private Action cmOk;
    private IconPanel iconPanel1;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel labelPassword;
    private JPasswordField textNewPassword;
    private JPasswordField textPassword;
    private JPasswordField textReplayPassword;

    public ChangeUserPasswordDialog() {
        super(SwingUtil.getRootFrame());
        this.initComponents();
        this.init();
    }

    public static void showDialog() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChangeUserPasswordDialog dialog = new ChangeUserPasswordDialog();
                dialog.setVisible(true);
            }
        });
    }

    private void init() {
        if (StringUtil.isEmpty((String)Application.get().getUser().getPassword())) {
            this.textPassword.setEnabled(false);
        }
        DocumentListener docListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ChangeUserPasswordDialog.this.compareNewPassword();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ChangeUserPasswordDialog.this.compareNewPassword();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        };
        this.textNewPassword.getDocument().addDocumentListener(docListener);
        this.textReplayPassword.getDocument().addDocumentListener(docListener);
        this.compareNewPassword();
        this.getRootPane().setDefaultButton(this.buttonOk);
        this.getRootPane().getInputMap(2).put(this.cmCancel.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmCancel);
        SwingUtil.centerWithinScreen((Window)this);
    }

    private void compareNewPassword() {
        String newPass = new String(this.textNewPassword.getPassword());
        String repPass = new String(this.textReplayPassword.getPassword());
        this.cmOk.setEnabled(newPass.equals(repPass));
    }

    private void initComponents() {
        this.cmOk = new Action();
        this.cmCancel = new Action();
        this.buttonOk = new JButton();
        this.buttonCancel = new JButton();
        this.iconPanel1 = new IconPanel();
        this.labelPassword = new JLabel();
        this.textPassword = new JPasswordField();
        this.jLabel3 = new JLabel();
        this.textNewPassword = new JPasswordField();
        this.jLabel4 = new JLabel();
        this.textReplayPassword = new JPasswordField();
        this.cmOk.setShortCut(KeyStroke.getKeyStroke(10, 0));
        this.cmOk.setText(stringManager.getString("cmOk-text"));
        this.cmOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChangeUserPasswordDialog.this.cmOkActionPerformed(evt);
            }
        });
        this.cmCancel.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmCancel.setText(stringManager.getString("cmCancel-text"));
        this.cmCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChangeUserPasswordDialog.this.cmCancelActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(stringManager.getString("ChangeUserPasswordDialog-title"));
        this.setModal(true);
        this.buttonOk.setAction((javax.swing.Action)this.cmOk);
        this.buttonOk.setMargin(new Insets(2, 2, 2, 2));
        this.buttonOk.setPreferredSize(new Dimension(85, 25));
        this.buttonCancel.setAction((javax.swing.Action)this.cmCancel);
        this.buttonCancel.setMargin(new Insets(2, 2, 2, 2));
        this.buttonCancel.setPreferredSize(new Dimension(85, 25));
        this.iconPanel1.setIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/login.gif"));
        GroupLayout iconPanel1Layout = new GroupLayout((Container)this.iconPanel1);
        this.iconPanel1.setLayout((LayoutManager)iconPanel1Layout);
        iconPanel1Layout.setHorizontalGroup(iconPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 48, Short.MAX_VALUE));
        iconPanel1Layout.setVerticalGroup(iconPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 48, Short.MAX_VALUE));
        this.labelPassword.setHorizontalAlignment(4);
        this.labelPassword.setText(stringManager.getString("ChangeUserPasswordDialog-old-password-dd"));
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(stringManager.getString("ChangeUserPasswordDialog-new-password-dd"));
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText(stringManager.getString("ChangeUserPasswordDialog-rewrite-password-dd"));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.labelPassword, -2, 99, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textPassword, -1, 174, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4, -2, 99, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textReplayPassword, -1, 174, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3, -2, 99, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textNewPassword, -1, 174, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.iconPanel1, -2, -1, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.buttonOk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelPassword).addComponent(this.textPassword, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.textNewPassword, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.textReplayPassword, -2, 22, -2))).addComponent((Component)this.iconPanel1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel, -2, -1, -2).addComponent(this.buttonOk, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void cmOkActionPerformed(ActionEvent evt) {
        String passwd = new String(this.textPassword.getPassword());
        if (passwd.equals(Application.get().getUser().getPassword())) {
            Application.get().getUser().setPassword(new String(this.textNewPassword.getPassword()));
            try {
                Application.get().getUser().applyUpdate();
                this.modalResult = 1;
                this.dispose();
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        } else {
            MessageBox.show((Component)this, (String)stringManager.getString("error"), (String)stringManager.getString("ChangeUserPasswordDialog-old-password-expected"), (int)1, (int)0);
        }
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        this.modalResult = 2;
        this.dispose();
    }
}

