/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import pl.mpak.orbada.Consts;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.DataTable;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ComboBox;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Command;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class ContentPanel
extends JPanel
implements ITabObjectInfo {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);
    protected IViewAccesibilities accesibilities;
    protected String currentCatalogName = "";
    protected String currentSchemaName = "";
    protected String currentTableName = "";
    private boolean requestRefresh = false;
    private boolean closing = false;
    private ToolButton buttonActions;
    private ToolButton buttonRecordCount;
    private ToolButton buttonRefresh;
    private ToolButton buttonSearch;
    private Action cmDeleteRecords;
    private Action cmRecordCount;
    private Action cmRefresh;
    private Action cmSearch;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JPopupMenu menuActions;
    private JMenuItem menuDeleteRecords;
    private JMenuItem menuRecordCount;
    private QueryTableStatusBar statusBarContent;
    private DataTable tableContent;
    private ComboBox textFilter;
    private JToolBar toolBarContent;

    public ContentPanel(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.textFilter.setModel(new DefaultComboBoxModel());
        this.tableContent.getQuery().setDatabase(this.getDatabase());
        SwingUtil.addAction((JComponent)((JTextField)this.textFilter.getEditor().getEditorComponent()), (javax.swing.Action)this.cmSearch);
        ((JTextField)this.textFilter.getEditor().getEditorComponent()).getComponentPopupMenu().addSeparator();
        ((JTextField)this.textFilter.getEditor().getEditorComponent()).getComponentPopupMenu().add((javax.swing.Action)this.cmSearch);
        new ComponentActionsAction(this.getDatabase(), (JComponent)((Object)this.tableContent), (JButton)this.buttonActions, this.menuActions, "orbada-content-actions");
    }

    protected Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    private String getFilterText() {
        return this.textFilter.getText();
    }

    private void setFilterText(String text) {
        this.textFilter.setText(text);
    }

    private void addTextToList(String text) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.textFilter.getModel();
        int index = model.getIndexOf(text);
        if (index != -1) {
            model.removeElementAt(index);
        }
        model.insertElementAt(text, 0);
        if (model.getSize() > 10) {
            model.removeElementAt(model.getSize() - 1);
        }
        this.setFilterText(text);
    }

    public String getTitle() {
        return stringManager.getString("ContentPanel-content");
    }

    public String getSqlText(String filter) {
        return null;
    }

    private void refreshTask() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ContentPanel.this.refresh();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void refresh() {
        try {
            block9: {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ContentPanel.this.cmRefresh.setEnabled(false);
                    }
                });
                this.requestRefresh = false;
                this.tableContent.getQuery().close();
                if (!StringUtil.equals((String)this.currentTableName, (String)"")) break block9;
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ContentPanel.this.cmRefresh.setEnabled(true);
                    }
                });
                return;
            }
            try {
                String sql = this.getSqlText(this.getFilterText());
                if (sql == null) {
                    this.tableContent.getQuery().setSqlText("select * from " + this.getDatabase().quoteName(this.currentCatalogName, this.currentSchemaName, this.currentTableName) + ("".equals(this.getFilterText()) ? "" : " WHERE " + this.getFilterText()));
                } else {
                    this.tableContent.getQuery().setSqlText(sql);
                }
                this.tableContent.getQuery().open();
                if (!this.tableContent.getQuery().isEmpty()) {
                    this.tableContent.changeSelection(0, 0);
                }
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
            throw throwable;
        }
        EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    @Override
    public void refresh(String catalogName, String schemaName, String objectName) {
        if (!StringUtil.equals((String)catalogName, (String)this.currentCatalogName) || !StringUtil.equals((String)schemaName, (String)this.currentSchemaName) || !this.currentTableName.equals(objectName) || this.requestRefresh) {
            this.currentCatalogName = catalogName;
            this.currentSchemaName = schemaName;
            this.currentTableName = objectName.trim();
            this.textFilter.setText("");
            if (this.isVisible()) {
                this.refresh();
            } else {
                this.requestRefresh = true;
            }
        }
    }

    public boolean canClose() {
        return true;
    }

    @Override
    public void close() throws IOException {
        this.closing = true;
        this.tableContent.getQuery().close();
        this.accesibilities = null;
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.menuActions = new JPopupMenu();
        this.menuRecordCount = new JMenuItem();
        this.menuDeleteRecords = new JMenuItem();
        this.cmRecordCount = new Action();
        this.cmDeleteRecords = new Action();
        this.cmSearch = new Action();
        this.statusBarContent = new QueryTableStatusBar();
        this.jScrollPane1 = new JScrollPane();
        this.tableContent = new DataTable();
        this.jPanel1 = new JPanel();
        this.toolBarContent = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonRecordCount = new ToolButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.textFilter = new ComboBox();
        this.buttonSearch = new ToolButton();
        this.buttonActions = new ToolButton();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ContentPanel.this.cmRefreshActionPerformed(evt);
            }
        });
        this.menuRecordCount.setAction((javax.swing.Action)this.cmRecordCount);
        this.menuActions.add(this.menuRecordCount);
        this.menuDeleteRecords.setAction((javax.swing.Action)this.cmDeleteRecords);
        this.menuActions.add(this.menuDeleteRecords);
        this.cmRecordCount.setActionCommandKey("cmRecordCount");
        this.cmRecordCount.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/counts.gif"));
        this.cmRecordCount.setText(stringManager.getString("ContentPanel-cmRecordCount-text"));
        this.cmRecordCount.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ContentPanel.this.cmRecordCountActionPerformed(evt);
            }
        });
        this.cmDeleteRecords.setActionCommandKey("cmDeleteRecords");
        this.cmDeleteRecords.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmDeleteRecords.setText(stringManager.getString("ContentPanel-cmDeleteRecords"));
        this.cmDeleteRecords.setTooltip(stringManager.getString("ContentPanel-cmDeleteRecords-hint"));
        this.cmDeleteRecords.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ContentPanel.this.cmDeleteRecordsActionPerformed(evt);
            }
        });
        this.cmSearch.setActionCommandKey("cmSearch");
        this.cmSearch.setShortCut(KeyStroke.getKeyStroke(10, 0));
        this.cmSearch.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/find_source.gif"));
        this.cmSearch.setText(stringManager.getString("cmSearch-text"));
        this.cmSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ContentPanel.this.cmSearchActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                ContentPanel.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.statusBarContent.setTable((QueryTable)this.tableContent);
        this.add((Component)this.statusBarContent, "Last");
        this.jScrollPane1.setViewportView((Component)((Object)this.tableContent));
        this.add((Component)this.jScrollPane1, "Center");
        this.jPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.toolBarContent.setFloatable(false);
        this.toolBarContent.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarContent.add((Component)this.buttonRefresh);
        this.buttonRecordCount.setAction((javax.swing.Action)this.cmRecordCount);
        this.buttonRecordCount.setHorizontalTextPosition(0);
        this.buttonRecordCount.setVerticalTextPosition(3);
        this.toolBarContent.add((Component)this.buttonRecordCount);
        this.toolBarContent.add(this.jSeparator1);
        this.jPanel2.setLayout(new FlowLayout(1, 2, 3));
        this.jLabel1.setText("WHERE ");
        this.jPanel2.add(this.jLabel1);
        this.textFilter.setEditable(true);
        this.textFilter.setPreferredSize(new Dimension(150, 22));
        this.jPanel2.add((Component)this.textFilter);
        this.toolBarContent.add(this.jPanel2);
        this.buttonSearch.setAction((javax.swing.Action)this.cmSearch);
        this.buttonSearch.setHorizontalTextPosition(0);
        this.buttonSearch.setVerticalTextPosition(3);
        this.toolBarContent.add((Component)this.buttonSearch);
        this.toolBarContent.add((Component)this.buttonActions);
        this.jPanel1.add(this.toolBarContent);
        this.add((Component)this.jPanel1, "North");
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    private void formComponentShown(ComponentEvent evt) {
        if (this.requestRefresh && !this.closing) {
            this.refreshTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cmRecordCountActionPerformed(ActionEvent evt) {
        Query query = this.getDatabase().createQuery();
        try {
            query.open("select count( 0 ) cnt from (" + this.tableContent.getQuery().getSqlText() + ") x");
            String sqlText = this.tableContent.getQuery().getSqlText();
            if (sqlText.length() > 200) {
                sqlText = sqlText.substring(0, 200) + "...";
            }
            MessageBox.show((Component)this, (String)stringManager.getString("ContentPanel-record-count"), (String)String.format(stringManager.getString("ContentPanel-record-count-info"), sqlText, query.fieldByName("cnt").getLong()), (int)1, (int)1);
        }
        catch (Exception ex) {
            MessageBox.show((Component)this, (String)stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
        }
        finally {
            query.close();
        }
    }

    private void cmDeleteRecordsActionPerformed(ActionEvent evt) {
        if (MessageBox.show((Component)this, (String)stringManager.getString("deleting"), (String)stringManager.getString("ContentPanel-delete-records-q"), (int[])ModalResult.YESNO) == 5) {
            Command command = this.getDatabase().createCommand();
            try {
                command.setSqlText("delete from " + this.getDatabase().quoteName(this.currentCatalogName, this.currentSchemaName, this.currentTableName) + ("".equals(this.getFilterText()) ? "" : " WHERE " + this.getFilterText()));
                command.execute();
                this.refresh();
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
                MessageBox.show((Component)this, (String)stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmSearchActionPerformed(ActionEvent evt) {
        if (!"".equals(this.getFilterText())) {
            this.addTextToList(this.getFilterText());
        }
        this.refreshTask();
    }
}

