/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.ArrayList;
import javax.swing.JComponent;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.plugins.PleaseWait;
import pl.mpak.orbada.plugins.providers.PleaseWaitRendererProvider;
import pl.mpak.util.timer.Timer;
import pl.mpak.util.timer.TimerManager;

public class GlassPane
extends JComponent {
    private int visibleCount;
    private final ArrayList<PleaseWait> waitList;
    private Timer waitTimer;
    private PleaseWaitRendererProvider[] pwrpa;
    private String waitRendererId;
    private boolean waitRendererOn = true;
    private PleaseWaitRendererProvider waitRenderer;
    private PleaseWait[] waitArray;
    private boolean repainting;

    public GlassPane() {
        this.setIgnoreRepaint(true);
        this.setBackground(Color.WHITE);
        this.setDoubleBuffered(true);
        this.setFont(new Font("Default", 1, 11));
        this.waitList = new ArrayList();
        this.pwrpa = (PleaseWaitRendererProvider[])Application.get().getServiceArray(PleaseWaitRendererProvider.class);
        if (this.pwrpa != null && this.pwrpa.length > 0) {
            for (PleaseWaitRendererProvider pwrp : this.pwrpa) {
                pwrp.setComponent((JComponent)this);
            }
        }
        this.waitTimer = new Timer(100L){
            {
                this.setEnabled(false);
            }

            public void run() {
                if (GlassPane.this.waitRendererOn) {
                    if (GlassPane.this.waitRenderer != null) {
                        GlassPane.this.waitRenderer.control();
                    }
                    if (!GlassPane.this.repainting) {
                        GlassPane.this.repainting = true;
                        EventQueue.invokeLater(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                try {
                                    if (GlassPane.this.waitRenderer != null) {
                                        Rectangle rect = GlassPane.this.waitRenderer.getRenderBounds();
                                        if (rect != null) {
                                            GlassPane.this.repaint(rect);
                                        } else {
                                            GlassPane.this.repaint();
                                        }
                                    } else {
                                        GlassPane.this.repaint();
                                    }
                                }
                                finally {
                                    GlassPane.this.repainting = false;
                                }
                            }
                        });
                    }
                }
            }
        };
        TimerManager.getGlobal().add(this.waitTimer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Toolkit.getDefaultToolkit().sync();
        ArrayList<PleaseWait> arrayList = this.waitList;
        synchronized (arrayList) {
            if (this.waitRendererOn) {
                boolean showWait = false;
                for (PleaseWait wait : this.waitList) {
                    if (!wait.isShowTime()) continue;
                    showWait = true;
                    break;
                }
                if (this.waitList.size() > 0 && showWait && this.waitRenderer != null) {
                    this.waitRenderer.render(g2, this.waitArray);
                }
            }
        }
        super.paintComponent(g);
    }

    @Override
    public void setVisible(boolean aFlag) {
        if (aFlag) {
            if (this.visibleCount == 0) {
                super.setVisible(true);
            }
            ++this.visibleCount;
        } else if (this.visibleCount > 0) {
            --this.visibleCount;
            if (this.visibleCount == 0) {
                super.setVisible(false);
            }
        }
    }

    public void addPleaseWait(PleaseWait wait) {
        this.addPleaseWait(wait, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPleaseWait(PleaseWait wait, String waitRendererId) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                GlassPane.this.setVisible(true);
            }
        });
        ArrayList<PleaseWait> arrayList = this.waitList;
        synchronized (arrayList) {
            if (this.waitList.indexOf(wait) == -1) {
                if (this.waitList.size() == 0) {
                    if (waitRendererId != null) {
                        this.waitRendererId = waitRendererId;
                        this.waitRendererOn = true;
                    } else {
                        this.waitRendererId = Application.get().getSettings().getValue("please-wait-renderer", "orbada-default-please-wait-renderer");
                        this.waitRendererOn = Application.get().getSettings().getValue("please-wait-renderer-on", Boolean.valueOf(true));
                    }
                    if (this.pwrpa != null && this.pwrpa.length > 0) {
                        this.waitRenderer = null;
                        for (PleaseWaitRendererProvider pwrp : this.pwrpa) {
                            if (!this.waitRendererId.equalsIgnoreCase(pwrp.getRendererId())) continue;
                            this.waitRenderer = pwrp;
                        }
                        if (this.waitRenderer == null) {
                            for (PleaseWaitRendererProvider pwrp : this.pwrpa) {
                                if (!"orbada-default-please-wait-renderer".equalsIgnoreCase(pwrp.getRendererId())) continue;
                                this.waitRenderer = pwrp;
                            }
                        }
                    }
                    if (this.waitRenderer != null) {
                        this.waitRenderer.beginProcess();
                    }
                }
                this.waitList.add(wait);
                this.waitArray = this.waitList.toArray(new PleaseWait[this.waitList.size()]);
            }
            this.waitTimer.setEnabled(this.waitList.size() > 0 && this.waitRendererOn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePleaseWait(PleaseWait wait) {
        ArrayList<PleaseWait> arrayList = this.waitList;
        synchronized (arrayList) {
            this.waitList.remove(wait);
            try {
                this.waitArray = this.waitList.size() > 0 ? this.waitList.toArray(new PleaseWait[this.waitList.size()]) : null;
                if (this.waitList.size() == 0 && this.waitRenderer != null) {
                    this.waitRenderer.endProcess();
                }
                this.waitTimer.setEnabled(this.waitList.size() > 0 && this.waitRendererOn);
            }
            catch (Throwable throwable) {
                this.waitTimer.setEnabled(this.waitList.size() > 0 && this.waitRendererOn);
                if (this.waitList.size() == 0) {
                    this.repaint();
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GlassPane.this.setVisible(false);
                        }
                    });
                }
                throw throwable;
            }
            if (this.waitList.size() == 0) {
                this.repaint();
                EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        }
    }

    @Override
    public boolean contains(int x, int y) {
        if (this.getMouseListeners().length == 0 && this.getMouseMotionListeners().length == 0 && this.getMouseWheelListeners().length == 0 && this.getCursor() == Cursor.getPredefinedCursor(0)) {
            return false;
        }
        return super.contains(x, y);
    }
}

