/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.Callable;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.Consts;
import pl.mpak.orbada.gui.LoginInfo;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.IconPanel;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class LoginDialog
extends JDialog {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);
    private int modalResult = 0;
    private JButton buttonCancel;
    private JButton buttonOk;
    private Action cmCancel;
    private Action cmOk;
    private IconPanel iconPanel1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPasswordField textPassword;
    private TextField textUserName;

    public LoginDialog(LoginInfo info, String title) {
        super(SwingUtil.getRootFrame());
        this.initComponents();
        this.init(info, title);
    }

    public static LoginInfo show(String userName, String password, String title) {
        return LoginDialog.show(new LoginInfo(userName, password), title);
    }

    public static LoginInfo show(final LoginInfo info, final String title) {
        LoginInfo li = (LoginInfo)SwingUtil.invokeAndWait((Callable)new Callable<LoginInfo>(){

            @Override
            public LoginInfo call() throws Exception {
                LoginDialog dialog = new LoginDialog(info, title);
                dialog.setVisible(true);
                if (dialog.modalResult == 1) {
                    return new LoginInfo(dialog.textUserName.getText(), new String(dialog.textPassword.getPassword()));
                }
                return null;
            }
        });
        return li;
    }

    private void init(LoginInfo info, String title) {
        if (title != null) {
            this.setTitle(title);
        }
        this.textUserName.setText(StringUtil.equals((String)info.getUserName(), (String)"") ? "" : info.getUserName());
        this.textPassword.setText(StringUtil.equals((String)info.getPassword(), (String)"") ? "" : info.getPassword());
        if (!StringUtil.equals((String)info.getUserName(), (String)"")) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LoginDialog.this.textPassword.requestFocusInWindow();
                }
            });
        }
        this.getRootPane().setDefaultButton(this.buttonOk);
        this.getRootPane().getInputMap(2).put(this.cmCancel.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmCancel);
        SwingUtil.centerWithinScreen((Window)this);
    }

    private void initComponents() {
        this.cmOk = new Action();
        this.cmCancel = new Action();
        this.iconPanel1 = new IconPanel();
        this.jLabel1 = new JLabel();
        this.textUserName = new TextField();
        this.jLabel2 = new JLabel();
        this.textPassword = new JPasswordField();
        this.buttonCancel = new JButton();
        this.buttonOk = new JButton();
        this.cmOk.setActionCommandKey("cmOk");
        this.cmOk.setShortCut(KeyStroke.getKeyStroke(10, 0));
        this.cmOk.setText(stringManager.getString("cmOk-text"));
        this.cmOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoginDialog.this.cmOkActionPerformed(evt);
            }
        });
        this.cmCancel.setActionCommandKey("cmCancel");
        this.cmCancel.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmCancel.setText(stringManager.getString("cmCancel-text"));
        this.cmCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoginDialog.this.cmCancelActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(stringManager.getString("LoginDialog-title"));
        this.setModal(true);
        this.setResizable(false);
        this.iconPanel1.setIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/login.gif"));
        GroupLayout iconPanel1Layout = new GroupLayout((Container)this.iconPanel1);
        this.iconPanel1.setLayout((LayoutManager)iconPanel1Layout);
        iconPanel1Layout.setHorizontalGroup(iconPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 48, Short.MAX_VALUE));
        iconPanel1Layout.setVerticalGroup(iconPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 48, Short.MAX_VALUE));
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText(stringManager.getString("LoginDialog-user-name-dd"));
        this.textUserName.setText("textField1");
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(stringManager.getString("LoginDialog-password-dd"));
        this.textPassword.setText("jPasswordField1");
        this.buttonCancel.setAction((javax.swing.Action)this.cmCancel);
        this.buttonCancel.setMargin(new Insets(2, 2, 2, 2));
        this.buttonCancel.setPreferredSize(new Dimension(85, 25));
        this.buttonOk.setAction((javax.swing.Action)this.cmOk);
        this.buttonOk.setMargin(new Insets(2, 2, 2, 2));
        this.buttonOk.setPreferredSize(new Dimension(85, 25));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -2, 99, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textUserName, -1, 135, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2, -2, 99, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textPassword, -1, 135, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.iconPanel1, -2, -1, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.buttonOk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent((Component)this.textUserName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.textPassword, -2, -1, -2))).addComponent((Component)this.iconPanel1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel, -2, -1, -2).addComponent(this.buttonOk, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void cmOkActionPerformed(ActionEvent evt) {
        this.modalResult = 1;
        this.dispose();
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        this.modalResult = 2;
        this.dispose();
    }
}

