/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import pl.mpak.orbada.Consts;
import pl.mpak.orbada.OrbadaCancelCloseException;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.db.InternalDatabase;
import pl.mpak.orbada.db.Perspective;
import pl.mpak.orbada.db.Schema;
import pl.mpak.orbada.db.Tool;
import pl.mpak.orbada.gui.AboutOrbadaDialog;
import pl.mpak.orbada.gui.ChangeUserPasswordDialog;
import pl.mpak.orbada.gui.ComponentActionMapDialog;
import pl.mpak.orbada.gui.GlassPane;
import pl.mpak.orbada.gui.OrbadaSettingsDialog;
import pl.mpak.orbada.gui.PerspectivePanel;
import pl.mpak.orbada.gui.PluginManagerDialog;
import pl.mpak.orbada.gui.PluginSettingsDialog;
import pl.mpak.orbada.gui.SelectPerspectiveDialog;
import pl.mpak.orbada.gui.SelectTabDialog;
import pl.mpak.orbada.gui.SelectViewDialog;
import pl.mpak.orbada.gui.UpdateInfoDialog;
import pl.mpak.orbada.gui.UserPropertiesDialog;
import pl.mpak.orbada.gui.ViewAccesibilities;
import pl.mpak.orbada.gui.ViewPropertiesDialog;
import pl.mpak.orbada.gui.admin.UserListDialog;
import pl.mpak.orbada.gui.cm.CreatePerspectiveAction;
import pl.mpak.orbada.gui.cm.CreatePerspectiveGadgetAction;
import pl.mpak.orbada.gui.cm.CreateViewAction;
import pl.mpak.orbada.gui.cm.MovePerspectiveLeftAction;
import pl.mpak.orbada.gui.cm.MovePerspectiveRightAction;
import pl.mpak.orbada.gui.cm.PerspectivePropertiesAction;
import pl.mpak.orbada.gui.comps.OrbadaJavaSyntaxDocument;
import pl.mpak.orbada.gui.comps.OrbadaSQLSyntaxDocument;
import pl.mpak.orbada.gui.comps.PerspectiveContextMenu;
import pl.mpak.orbada.gui.comps.table.DataTable;
import pl.mpak.orbada.gui.laf.services.CrossPlatformLookAndFeelService;
import pl.mpak.orbada.gui.laf.services.CrossPlatformLookAndFeelSettingsService;
import pl.mpak.orbada.gui.laf.services.MotifLookAndFeelService;
import pl.mpak.orbada.gui.laf.services.NimbusLookAndFeelService;
import pl.mpak.orbada.gui.laf.services.SystemLookAndFeelService;
import pl.mpak.orbada.gui.laf.services.WindowsLookAndFeelService;
import pl.mpak.orbada.gui.schemas.DriverListDialog;
import pl.mpak.orbada.gui.schemas.SchemaListDialog;
import pl.mpak.orbada.gui.services.GeneralSchemaSettingsService;
import pl.mpak.orbada.gui.services.TextFileViewService;
import pl.mpak.orbada.gui.templates.TemplateListDialog;
import pl.mpak.orbada.gui.tools.ToolListDialog;
import pl.mpak.orbada.gui.webapp.RequestProblemDialog;
import pl.mpak.orbada.gui.webapp.RequestSuggestionDialog;
import pl.mpak.orbada.plugins.IProcessMessagable;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.providers.DatabaseInfoProvider;
import pl.mpak.orbada.plugins.providers.GlobalActionProvider;
import pl.mpak.orbada.plugins.providers.GlobalFocusProvider;
import pl.mpak.orbada.plugins.providers.GlobalMenuProvider;
import pl.mpak.orbada.plugins.providers.GlobalToolBarProvider;
import pl.mpak.orbada.plugins.providers.IDatabaseProvider;
import pl.mpak.orbada.plugins.providers.ImportToolActionProvider;
import pl.mpak.orbada.plugins.providers.PerpectiveGadgetProvider;
import pl.mpak.orbada.plugins.providers.StatusBarProvider;
import pl.mpak.orbada.plugins.providers.ToolConfigurationActionProvider;
import pl.mpak.orbada.plugins.providers.ViewProvider;
import pl.mpak.orbada.plugins.queue.PluginMessage;
import pl.mpak.orbada.services.DefaultPleaseWaitRenderer;
import pl.mpak.orbada.services.TimeOrbadaFontPleaseWaitRenderer;
import pl.mpak.orbada.util.Utils;
import pl.mpak.orbada.util.tools.ToolAction;
import pl.mpak.sky.SkySetting;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.TabCloseComponent;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.sky.gui.swing.syntax.ApplySyntaxTextAreaEvent;
import pl.mpak.sky.gui.swing.syntax.SyntaxTextArea;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.util.DisplayChanger;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StreamUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.id.VersionID;
import pl.mpak.util.patt.Resolvers;
import pl.mpak.util.timer.Timer;
import pl.mpak.util.timer.TimerManager;
import pl.mpak.util.variant.Variant;

public class MainFrame
extends JFrame
implements IProcessMessagable {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);
    private PerspectivePanel activePerspective;
    private LinkedList<GlobalFocusProvider> globalFocusSerives;
    private PerspectivePanel toolsPerspective;
    private boolean cancelClose;
    private String oryginalTitle;
    private GlassPane glassPane;
    private JSONObject updateInfo;
    private long lastCheckUpdates;
    private boolean newVersionPresents;
    private DisplayChanger displayChanger = new DisplayChanger((Window)this);
    private boolean fullScreenMode = false;
    private PerspectivePropertiesAction cmPerspectiveProperties;
    private MovePerspectiveLeftAction cmMovePerspectiveLeft;
    private MovePerspectiveRightAction cmMovePerspectiveRight;
    private ToolButton buttonClosePerspective;
    private ToolButton buttonDatabaseInfo;
    private ToolButton buttonDbCommit;
    private ToolButton buttonDbRollback;
    private ToolButton buttonDonation;
    private ToolButton buttonGetUpdate;
    private ToolButton buttonMoveViewLeft;
    private ToolButton buttonMoveViewRight;
    private ToolButton buttonNewToolsPerspective;
    private ToolButton buttonSelectNewPerspective;
    private Action cmAboutOrbada;
    private Action cmChangeUserPassword;
    private Action cmClonePerspectiveViews;
    private Action cmCloseAllPerspectives;
    private Action cmClosePerspective;
    private Action cmCloseView;
    private Action cmComponentShortcut;
    private Action cmCustomizeConnection;
    private Action cmDBStartTransaction;
    private Action cmDatabaseInfo;
    private Action cmDbCommit;
    private Action cmDbDisconnect;
    private Action cmDbReconnect;
    private Action cmDbRollback;
    private Action cmDeletePerspective;
    private Action cmDocumentation;
    public Action cmDrivers;
    private Action cmExit;
    private Action cmFullScreen;
    private Action cmGetUpdate;
    private Action cmMaximizeSplitView;
    private Action cmMoveViewLeft;
    private Action cmMoveViewRight;
    public Action cmNewConnection;
    private Action cmNewPerspective;
    private Action cmOrbadaConfigFile;
    private Action cmOrbadaLastChanges;
    private Action cmOrbadaLog4jFile;
    private Action cmOrbadaLogErrorFile;
    private Action cmOrbadaLogFile;
    public Action cmOrbadaSettings;
    private Action cmPageDonations;
    private Action cmPageProjectHome;
    private Action cmPageReviews;
    private Action cmPluginManager;
    private Action cmPluginSettings;
    private Action cmProblemRequest;
    private Action cmResetPerspective;
    private Action cmSelectNewPerspective;
    private Action cmSelectPerspective;
    private Action cmSelectTab;
    private Action cmSelectView;
    private Action cmSpecialPerspective;
    private Action cmSuggestionRequest;
    private Action cmTemplateSettings;
    private Action cmToolsSettings;
    public Action cmUserGuide;
    private Action cmUserList;
    private Action cmUserProperties;
    private Action cmViewProperites;
    private JMenu jMenu1;
    private JMenuItem jMenuItem1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JSeparator jSeparator1;
    private JSeparator jSeparator10;
    private JSeparator jSeparator11;
    private JSeparator jSeparator12;
    private JSeparator jSeparator13;
    private JSeparator jSeparator14;
    private JSeparator jSeparator15;
    private JSeparator jSeparator16;
    private JSeparator jSeparator17;
    private JSeparator jSeparator18;
    private JPopupMenu.Separator jSeparator19;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JSeparator jSeparator6;
    private JSeparator jSeparator7;
    private JSeparator jSeparator8;
    private JSeparator jSeparator9;
    private JMenuItem menuAboutOrbada;
    private JMenuBar menuBarMain;
    private JMenuItem menuChangeUserPassword;
    private JMenuItem menuClonePerspectiveViews;
    private JMenuItem menuCloseAllPerspectives;
    private JMenuItem menuClosePerspective;
    private JMenuItem menuCloseView;
    private JMenuItem menuComponentShortcut;
    private JMenu menuConnection;
    private JMenuItem menuCustomizeConnection;
    private JMenuItem menuDBStartTransaction;
    private JMenuItem menuDatabaseInfo;
    private JMenuItem menuDbCommit;
    private JMenuItem menuDbDisconnect;
    private JMenuItem menuDbReconnect;
    private JMenuItem menuDbRollback;
    private JMenuItem menuDocumentation;
    private JMenuItem menuDrivers;
    private JMenu menuEdit;
    private JMenuItem menuExit;
    private JMenuItem menuFullScreen;
    private JMenuItem menuGetUpdates;
    private JMenu menuHelp;
    private JMenuItem menuLastChanges;
    private JMenuItem menuMaximizeSplitView;
    private JMenuItem menuMovePerspectiveLeft;
    private JMenuItem menuMovePerspectiveRight;
    private JMenuItem menuMoveViewLeft;
    private JMenuItem menuMoveViewRight;
    private JMenu menuNavigation;
    private JMenuItem menuNewConnection;
    private JMenuItem menuNewPerspective;
    private JMenuItem menuOrbadaConfigFile;
    private JMenuItem menuOrbadaLog4jFile;
    private JMenuItem menuOrbadaLogErrorFile;
    private JMenuItem menuOrbadaLogFile;
    private JMenuItem menuOrbadaSettings;
    private JMenuItem menuPageDonations;
    private JMenuItem menuPageProjectHome;
    private JMenuItem menuPageReviews;
    private JMenu menuPerspective;
    private JMenu menuPerspectiveGadgets;
    private JMenuItem menuPerspectiveProperties;
    private JMenu menuPerspectiveView;
    private JPopupMenu menuPerspectives;
    private JMenuItem menuPluginManager;
    private JMenuItem menuPluginSettings;
    private JMenuItem menuProblemRequest;
    private JMenu menuProgram;
    private JMenuItem menuResetPerspective;
    private JMenu menuSelectNewPerspective;
    private JMenuItem menuSelectPerspective;
    private JMenuItem menuSelectTab;
    private JMenuItem menuSelectView;
    private JMenu menuSettings;
    private JMenu menuSpecialFiles;
    private JMenuItem menuSuggestionRequest;
    private JMenuItem menuTemplatesSettings;
    private JMenu menuTools;
    private JMenuItem menuToolsPerspective;
    private JMenuItem menuUserGuide;
    private JMenuItem menuUserList;
    private JMenuItem menuUserProperties;
    private JPopupMenu menuViewPopup;
    private JMenuItem menuViewProperites;
    private JMenuItem menuWindowNewPerspective;
    private JPanel panelMain;
    private JPanel panelPerspectiveTools;
    private JPanel panelPerspectives;
    private JPanel panelStatus;
    private JPanel panelToolBars;
    private JPanel panelToolTip;
    private JMenuItem ppmCloseView;
    private JMenuItem ppmMoveViewLeft;
    private JMenuItem ppmMoveViewRight;
    private JMenuItem ppmViewProperties;
    private JSeparator sepMenuPerspective;
    private JSeparator sepMenuWindowPerspective;
    private JSeparator sepRequests;
    private JTabbedPane tabbedPerpectives;
    private ToolButton tbConnection;
    private JToolBar toolBarMain;
    private JToolBar toolBarTools;
    private JToolBar toolBarUpdates;
    private ToolButton toolButton1;

    public MainFrame() {
        this.displayChanger.setExclusiveMode(false);
        this.initComponents();
        this.init();
    }

    private void init() {
        this.buttonDonation.setVisible(false);
        Application.get().registerRequestMessager(this);
        this.menuSettings.setText(SwingUtil.setButtonText((AbstractButton)this.menuSettings, (String)stringManager.getString("mf-menuSettings-text")));
        this.menuSpecialFiles.setText(SwingUtil.setButtonText((AbstractButton)this.menuSpecialFiles, (String)stringManager.getString("mf-menuSpecialFiles-text")));
        this.menuSelectNewPerspective.setText(SwingUtil.setButtonText((AbstractButton)this.menuSelectNewPerspective, (String)stringManager.getString("mf-menuSelectNewPerspective-text")));
        this.menuPerspectiveGadgets.setText(SwingUtil.setButtonText((AbstractButton)this.menuPerspectiveGadgets, (String)stringManager.getString("mf-menuPerspectiveGadgets-text")));
        this.menuNavigation.setText(SwingUtil.setButtonText((AbstractButton)this.menuNavigation, (String)stringManager.getString("mf-menuNavigation-text")));
        this.menuDocumentation.setVisible(new File(Resolvers.expand((String)"$(user.dir)/doc/index.html")).exists());
        this.panelToolTip.setVisible(false);
        try {
            this.setIconImage(this.getToolkit().createImage(this.getClass().getResource("/res/icons/orbada32.png")));
        }
        catch (Throwable ex) {
            MessageBox.show((Component)this, (String)stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
        }
        this.tabbedPerpectives.setComponentPopupMenu((JPopupMenu)((Object)new PerspectiveContextMenu(this.tabbedPerpectives)));
        this.setSize(800, 600);
        this.setExtendedState(6);
        this.setActivePerspective(null);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.reloadToolsMenu();
            }
        });
        this.applySettings();
        this.cmUserList.setEnabled(Application.get().isUserAdmin());
        this.menuUserGuide.setVisible(false);
    }

    private void checkDonation() {
        if (Application.get().getLastVersion() != null && Application.get().getLastVersion().getBuild() < Consts.orbadaVersion.getBuild()) {
            this.buttonDonation.setVisible(true);
            TimerManager.getGlobal().add(new Timer(60000L, true){

                public void run() {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MainFrame.this.buttonDonation.setVisible(false);
                        }
                    });
                }
            });
        }
    }

    public void afterInit() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.checkDonation();
                MainFrame.this.checkUpdates();
                if (Application.get().getSettings().getValue("new-connection-at-startup", Boolean.valueOf(true)).booleanValue() && (!Application.get().isFirstRun() || Application.get().getPluginManager().getPluginByUniqueID("orbada-welcome-plugin") == null)) {
                    MainFrame.this.cmNewConnection.performe();
                }
            }
        });
    }

    public void checkUpdates() {
        this.lastCheckUpdates = System.currentTimeMillis();
        this.newVersionPresents = false;
        this.menuGetUpdates.setVisible(false);
        this.menuLastChanges.setVisible(false);
        this.buttonGetUpdate.setVisible(false);
        this.updateInfo = null;
        if (!this.getSettings().getValue("disable-check-updates", Boolean.valueOf(false)).booleanValue()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TimerManager.getGlobal().add(new Timer(1000L, true){

                        public void run() {
                            File ui;
                            String source;
                            block8: {
                                try {
                                    URL url = new URL("http://orbada.sourceforge.net/changes_json.php");
                                    source = StreamUtil.stream2String((InputStream)url.openStream());
                                    try {
                                        JSONObject lastVersion;
                                        MainFrame.this.updateInfo = new JSONObject(source);
                                        if (!MainFrame.this.updateInfo.has("lastVersion") || (lastVersion = MainFrame.this.updateInfo.getJSONObject("lastVersion")) == null) break block8;
                                        final String version = lastVersion.getString("version");
                                        final String released = lastVersion.getString("released");
                                        VersionID ver = new VersionID(version);
                                        if (ver.getBuild() > Consts.orbadaVersion.getBuild()) {
                                            MainFrame.this.newVersionPresents = true;
                                            EventQueue.invokeLater(new Runnable(){

                                                @Override
                                                public void run() {
                                                    MainFrame.this.menuGetUpdates.setVisible(true);
                                                    MainFrame.this.buttonGetUpdate.setVisible(true);
                                                    MainFrame.this.menuLastChanges.setVisible(false);
                                                    MainFrame.this.cmGetUpdate.setTooltip("<html>" + stringManager.getString("mf-cmGetUpdate-hint") + "<hr>" + stringManager.getString("version-dd") + " <b>" + version + "</b><br>" + stringManager.getString("released-dd") + " <b>" + released + "</b>");
                                                }
                                            });
                                            break block8;
                                        }
                                        MainFrame.this.menuLastChanges.setVisible(true);
                                    }
                                    catch (Exception ex) {
                                        Logger.getLogger("error-logger").error("Updates", ex);
                                    }
                                }
                                catch (Exception ex) {
                                    // empty catch block
                                }
                            }
                            if (MainFrame.this.updateInfo == null && (ui = new File("./doc/changes.json")).exists()) {
                                try {
                                    source = StreamUtil.stream2String((InputStream)new FileInputStream(ui));
                                    MainFrame.this.updateInfo = new JSONObject(source);
                                    MainFrame.this.menuLastChanges.setVisible(true);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                    });
                }
            });
        } else {
            this.cmGetUpdate.setEnabled(false);
        }
    }

    public void reloadToolsMenu() {
        ToolConfigurationActionProvider[] tcapa;
        JButton button;
        this.toolBarTools.removeAll();
        this.menuTools.removeAll();
        for (Tool tool : Application.get().getToolList().toArray()) {
            if (tool.isMenu()) {
                this.menuTools.add((Component)new JMenuItem((javax.swing.Action)((Object)new ToolAction(tool))), 0);
            }
            if (!tool.isToolButton()) continue;
            if (tool.getIcon() != null) {
                this.toolBarTools.add((Component)new ToolButton((javax.swing.Action)((Object)new ToolAction(tool))));
                continue;
            }
            JButton button2 = new JButton((javax.swing.Action)((Object)new ToolAction(tool)));
            button2.setFocusable(false);
            this.toolBarTools.add(button2);
        }
        this.menuTools.addSeparator();
        this.menuTools.add((javax.swing.Action)this.cmToolsSettings);
        this.menuTools.add((javax.swing.Action)this.cmTemplateSettings);
        ImportToolActionProvider[] itapa = (ImportToolActionProvider[])Application.get().getPluginManager().getServiceArray(ImportToolActionProvider.class);
        if (itapa != null && itapa.length > 0) {
            this.menuTools.addSeparator();
            JMenu im = new JMenu(stringManager.getString("import-menu"));
            this.menuTools.add(SwingUtil.updateMenuText((JMenu)im));
            for (ImportToolActionProvider itap : itapa) {
                im.add((javax.swing.Action)itap);
                if (!itap.isButton()) continue;
                if (itap.getSmallIcon() != null) {
                    this.toolBarTools.add((Component)new ToolButton((javax.swing.Action)itap));
                    continue;
                }
                button = new JButton((javax.swing.Action)itap);
                button.setFocusable(false);
                this.toolBarTools.add(button);
            }
        }
        if ((tcapa = (ToolConfigurationActionProvider[])Application.get().getPluginManager().getServiceArray(ToolConfigurationActionProvider.class)) != null && tcapa.length > 0) {
            this.menuTools.addSeparator();
            for (ToolConfigurationActionProvider tcap : tcapa) {
                this.menuTools.add((javax.swing.Action)tcap);
                if (!tcap.isButton()) continue;
                if (tcap.getSmallIcon() != null) {
                    this.toolBarTools.add((Component)new ToolButton((javax.swing.Action)tcap));
                    continue;
                }
                button = new JButton((javax.swing.Action)tcap);
                button.setFocusable(false);
                this.toolBarTools.add(button);
            }
        }
        this.toolBarTools.setVisible(this.toolBarTools.getComponentCount() > 0);
    }

    public void initGlobalServices() {
        GlobalActionProvider[] gap;
        GlobalToolBarProvider[] gtbp;
        GlobalMenuProvider[] gmp;
        Application.get().getPluginManager().addProvider(TimeOrbadaFontPleaseWaitRenderer.class);
        Application.get().getPluginManager().addProvider(DefaultPleaseWaitRenderer.class);
        Application.get().getPluginManager().addProvider(SystemLookAndFeelService.class);
        Application.get().getPluginManager().addProvider(WindowsLookAndFeelService.class);
        Application.get().getPluginManager().addProvider(NimbusLookAndFeelService.class);
        Application.get().getPluginManager().addProvider(CrossPlatformLookAndFeelService.class);
        Application.get().getPluginManager().addProvider(MotifLookAndFeelService.class);
        Application.get().getPluginManager().addProvider(CrossPlatformLookAndFeelSettingsService.class);
        Application.get().getPluginManager().addProvider(GeneralSchemaSettingsService.class);
        this.glassPane = new GlassPane();
        this.getRootPane().setGlassPane(this.glassPane);
        StatusBarProvider[] sbp = (StatusBarProvider[])Application.get().getPluginManager().getServiceArray(StatusBarProvider.class);
        if (sbp != null && sbp.length > 0) {
            for (int i = 0; i < sbp.length; ++i) {
                this.addStatusBar(sbp[i].getComponent());
            }
        }
        this.globalFocusSerives = new LinkedList();
        GlobalFocusProvider[] gfp = (GlobalFocusProvider[])Application.get().getServiceArray(GlobalFocusProvider.class);
        if (gfp != null && gfp.length > 0) {
            this.globalFocusSerives.addAll(Arrays.asList(gfp));
            FocusManager.getCurrentManager().addVetoableChangeListener(new VetoableChangeListener(){

                @Override
                public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                    if ("focusOwner".equals(evt.getPropertyName())) {
                        Iterator i;
                        if (evt.getOldValue() instanceof JComponent) {
                            i = MainFrame.this.globalFocusSerives.iterator();
                            while (i.hasNext()) {
                                ((GlobalFocusProvider)i.next()).focusLost((JComponent)evt.getOldValue());
                            }
                        }
                        if (evt.getNewValue() instanceof JComponent) {
                            i = MainFrame.this.globalFocusSerives.iterator();
                            while (i.hasNext()) {
                                ((GlobalFocusProvider)i.next()).focusGained((JComponent)evt.getNewValue());
                            }
                            if (!(evt.getNewValue() instanceof JRootPane)) {
                                MainFrame.this.menuEdit.removeAll();
                                MainFrame.this.menuEdit.setEnabled(false);
                            }
                            if (((JComponent)evt.getNewValue()).getComponentPopupMenu() != null) {
                                MainFrame.this.clonePopup(MainFrame.this.menuEdit, ((JComponent)evt.getNewValue()).getComponentPopupMenu());
                            }
                        }
                    }
                }
            });
        }
        if ((gmp = (GlobalMenuProvider[])Application.get().getServiceArray(GlobalMenuProvider.class)) != null && gmp.length > 0) {
            for (int i = 0; i < gmp.length; ++i) {
                JMenu menu = new JMenu();
                this.addMenu(menu);
                gmp[i].setMenu(menu);
                gmp[i].initialize();
            }
        }
        if ((gtbp = (GlobalToolBarProvider[])Application.get().getServiceArray(GlobalToolBarProvider.class)) != null && gtbp.length > 0) {
            for (int i = 0; i < gtbp.length; ++i) {
                JToolBar tb = new JToolBar();
                this.addToolBar(tb);
                gtbp[i].setToolBar(tb);
                gtbp[i].initialize();
            }
        }
        if ((gap = (GlobalActionProvider[])Application.get().getServiceArray(GlobalActionProvider.class)) != null && gap.length > 0) {
            for (int i = 0; i < gap.length; ++i) {
                this.addAction((Action)gap[i]);
            }
        }
    }

    private JMenu cloneMenu(JMenu intoMenu, JMenu menu) {
        intoMenu.removeAll();
        for (int i = 0; i < menu.getItemCount(); ++i) {
            JMenuItem c = menu.getItem(i);
            if (c instanceof JMenuItem && c.getAction() != null) {
                intoMenu.add(c.getAction());
                continue;
            }
            if (c instanceof JMenu) {
                intoMenu.add(this.cloneMenu(new JMenu(((JMenu)c).getText()), (JMenu)c));
                continue;
            }
            if (!(c instanceof JSeparator)) continue;
            intoMenu.addSeparator();
        }
        intoMenu.setEnabled(menu.isEnabled());
        return intoMenu;
    }

    private JMenu clonePopup(JMenu intoMenu, JPopupMenu menu) {
        intoMenu.removeAll();
        for (int i = 0; i < menu.getComponentCount(); ++i) {
            Component c = menu.getComponent(i);
            if (c instanceof JMenuItem && ((JMenuItem)c).getAction() != null) {
                intoMenu.add(((JMenuItem)c).getAction());
                continue;
            }
            if (c instanceof JMenu) {
                intoMenu.add(this.cloneMenu(new JMenu(((JMenu)c).getText()), (JMenu)c));
                continue;
            }
            if (!(c instanceof JSeparator)) continue;
            intoMenu.addSeparator();
        }
        intoMenu.setEnabled(true);
        intoMenu.revalidate();
        return intoMenu;
    }

    @Override
    public void setTitle(String title) {
        if (this.oryginalTitle == null) {
            this.oryginalTitle = title;
            super.setTitle(title);
            return;
        }
        StringBuilder sb = new StringBuilder(this.oryginalTitle);
        if (this.activePerspective != null && this.activePerspective.getTabComponent() != null) {
            sb.append(" [").append(this.activePerspective.getTabComponent().getTitle()).append("]");
        }
        if (!StringUtil.isEmpty((String)title)) {
            sb.append(" [").append(title).append("]");
        }
        if (Application.get().isSafeMode()) {
            sb.append(" ").append(stringManager.getString("mf-safe-mode"));
        }
        super.setTitle(sb.toString().replaceAll("<.*?>", ""));
    }

    public JSONObject getUpdateInfo() {
        return this.updateInfo;
    }

    private void updateStatusBar() {
        GridLayout gl = (GridLayout)this.panelStatus.getLayout();
        gl.setRows(this.panelStatus.getComponentCount());
    }

    public void addStatusBar(Component component) {
        if (component instanceof JComponent) {
            ((JComponent)component).setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getDefaults().getColor("controlShadow")));
        }
        this.panelStatus.add(component);
        this.updateStatusBar();
    }

    public void removeStatusBar(Component component) {
        this.panelStatus.remove(component);
        this.updateStatusBar();
    }

    public void addAction(Action action) {
        if (action == null) {
            this.toolBarMain.addSeparator();
        } else {
            this.toolBarMain.add((Component)new ToolButton((javax.swing.Action)action));
        }
    }

    public void removeAction(Action action) {
        for (int i = 0; i < this.toolBarMain.getComponentCount(); ++i) {
            Component c = this.toolBarMain.getComponent(i);
            if (!(c instanceof ToolButton) || !((ToolButton)c).getAction().equals(action)) continue;
            if (i > 0 && this.toolBarMain.getComponent(i - 1) instanceof JToolBar.Separator) {
                this.toolBarMain.remove(i - 1);
            }
            this.toolBarMain.remove(c);
            break;
        }
    }

    public void addMenu(JMenu menu) {
        if (menu != null) {
            this.menuBarMain.add((Component)menu, this.menuBarMain.getComponentIndex(this.menuTools));
        }
    }

    public void removeMenu(JMenu menu) {
        if (menu != null) {
            this.menuBarMain.remove(menu);
        }
    }

    public void addToolBar(JToolBar toolBar) {
        if (toolBar != null) {
            toolBar.setRollover(true);
            this.panelToolBars.add(toolBar);
        }
    }

    public void removeToolBar(JToolBar toolBar) {
        if (toolBar != null) {
            this.panelToolBars.remove(toolBar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openPerspectiveFor(Database database, Schema schema) {
        block13: {
            if (InternalDatabase.get() != null) {
                Query query = InternalDatabase.get().createQuery();
                try {
                    query.setSqlText("select pps_id, pps_default, pps_name from perspectives\n where pps_usr_id = :usr_id\n   and (pps_sch_id = :sch_id or (:sch_id is null and pps_sch_id is null))\n order by case when pps_default = 'T' then 0 else 1 end, pps_name");
                    query.paramByName("usr_id").setString(Application.get().getUserId());
                    if (schema != null) {
                        query.paramByName("sch_id").setString(schema.getSchId());
                    } else {
                        query.paramByName("sch_id").setString(null);
                    }
                    query.open();
                    if (!query.eof()) {
                        int count = 0;
                        while (!query.eof()) {
                            Perspective perspective;
                            if (StringUtil.toBoolean((String)query.fieldByName("pps_default").getString())) {
                                perspective = new Perspective(InternalDatabase.get(), query.fieldByName("pps_id").getString());
                                this.addPerspectiveQueue(database, schema, perspective);
                            } else {
                                if (count != 0) break block13;
                                perspective = new Perspective(InternalDatabase.get(), query.fieldByName("pps_id").getString());
                                this.addPerspectiveQueue(database, schema, perspective);
                            }
                            query.next();
                            ++count;
                        }
                        break block13;
                    }
                    this.newPerspectiveFor(database, schema);
                }
                catch (Exception ex) {
                    ExceptionUtil.processException((Throwable)ex);
                }
                finally {
                    query.close();
                }
            }
        }
    }

    public void newPerspectiveFor(Database database, Schema schema) {
        Perspective perspective = new Perspective(InternalDatabase.get());
        perspective.setUsrId(Application.get().getUserId());
        if (schema != null) {
            perspective.setSchId(schema.getSchId());
        }
        perspective.setName(database != null ? "$(public-name)" : stringManager.getString("mf-tools"));
        try {
            perspective.applyInsert();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        this.addPerspective(database, schema, perspective);
    }

    private void addPerspectiveQueue(final Database database, final Schema schema, final Perspective perspective) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.addPerspective(database, schema, perspective);
            }
        });
    }

    public void addPerspective(Database database, Schema schema, Perspective perspective) {
        PerspectivePanel panel = new PerspectivePanel(database, schema, perspective);
        String title = perspective.getDisplayName(database);
        Icon icon = schema != null ? schema.getIcon() : null;
        this.tabbedPerpectives.addTab(title, icon, panel);
        TabCloseComponent tabComponent = new TabCloseComponent(title, null, icon);
        this.tabbedPerpectives.setTabComponentAt(this.tabbedPerpectives.indexOfComponent(panel), (Component)tabComponent);
        this.tabbedPerpectives.setSelectedComponent(panel);
        panel.setTabComponent(tabComponent);
        if (database == null) {
            this.toolsPerspective = panel;
            this.cmSpecialPerspective.setEnabled(false);
        }
        panel.getTabbedViews().setComponentPopupMenu(this.menuViewPopup);
    }

    public void moveTabLeft() {
        Utils.moveTabLeft(this.tabbedPerpectives);
    }

    public void moveTabRight() {
        Utils.moveTabRight(this.tabbedPerpectives);
    }

    public PerspectivePanel getActivePerspective() {
        return this.activePerspective;
    }

    public PerspectivePanel getToolsPerspective() {
        return this.toolsPerspective;
    }

    public Database getActiveDatabase() {
        return this.activePerspective != null ? this.activePerspective.getDatabase() : null;
    }

    public void setTransactionActionEnabled() {
        try {
            boolean db = this.activePerspective != null && this.activePerspective.getDatabase() != null && this.activePerspective.getDatabase().isConnected();
            this.cmDbCommit.setEnabled(this.activePerspective != null && this.activePerspective != this.toolsPerspective && db && this.activePerspective.getDatabase().isStartTransaction());
            this.cmDbRollback.setEnabled(this.activePerspective != null && this.activePerspective != this.toolsPerspective && db && this.activePerspective.getDatabase().isStartTransaction());
            this.cmDBStartTransaction.setEnabled(this.activePerspective != null && this.activePerspective != this.toolsPerspective && db && this.activePerspective.getDatabase().startTransactionAvailable() && !this.activePerspective.getDatabase().isStartTransaction());
        }
        catch (SQLException ex) {
            this.cmDbCommit.setEnabled(this.activePerspective != null && this.activePerspective != this.toolsPerspective);
            this.cmDbRollback.setEnabled(this.activePerspective != null && this.activePerspective != this.toolsPerspective);
            this.cmDBStartTransaction.setEnabled(false);
        }
    }

    public void setActivePerspective(PerspectivePanel panel) {
        this.activePerspective = panel;
        this.cmClosePerspective.setEnabled(this.activePerspective != null);
        this.cmCustomizeConnection.setEnabled(this.activePerspective != null);
        this.cmResetPerspective.setEnabled(this.activePerspective != null);
        this.menuPerspectiveView.setEnabled(this.activePerspective != null);
        this.cmSelectNewPerspective.setEnabled(this.activePerspective != null && this.activePerspective != this.toolsPerspective);
        this.menuSelectNewPerspective.setEnabled(this.activePerspective != null && this.activePerspective != this.toolsPerspective);
        this.cmDbReconnect.setEnabled(this.activePerspective != null && this.activePerspective != this.toolsPerspective);
        this.cmDbDisconnect.setEnabled(this.activePerspective != null && this.activePerspective != this.toolsPerspective);
        this.cmSelectPerspective.setEnabled(this.tabbedPerpectives.getTabCount() > 1);
        this.cmSelectView.setEnabled(this.tabbedPerpectives.getTabCount() > 0);
        this.cmMaximizeSplitView.setEnabled(this.activePerspective != null);
        this.cmDatabaseInfo.setEnabled(this.activePerspective != null && this.activePerspective.getDatabase() != null);
        this.cmCustomizeConnection.setEnabled(this.activePerspective != null && this.activePerspective.getDatabase() != null);
        this.cmPerspectiveProperties.setEnabled(this.activePerspective != null);
        this.cmMovePerspectiveLeft.setEnabled(this.tabbedPerpectives.getTabCount() > 1);
        this.cmMovePerspectiveRight.setEnabled(this.tabbedPerpectives.getTabCount() > 1);
        this.cmDeletePerspective.setEnabled(this.activePerspective != null);
        if (this.activePerspective == null) {
            this.cmMoveViewRight.setEnabled(false);
            this.cmMoveViewLeft.setEnabled(false);
            this.cmViewProperites.setEnabled(false);
            this.cmCloseView.setEnabled(false);
        } else {
            this.cmMoveViewRight.setEnabled(this.activePerspective.getViewCount() > 1);
            this.cmMoveViewLeft.setEnabled(this.activePerspective.getViewCount() > 1);
            this.cmViewProperites.setEnabled(panel.getViewCount() > 1);
            this.cmCloseView.setEnabled(this.activePerspective.getViewCount() > 1);
        }
        this.setTransactionActionEnabled();
        this.cmUserProperties.setEnabled(InternalDatabase.get() != null);
        this.cmChangeUserPassword.setEnabled(InternalDatabase.get() != null);
        this.cmDrivers.setEnabled(InternalDatabase.get() != null);
        this.cmNewConnection.setEnabled(InternalDatabase.get() != null);
        this.menuPerspectiveGadgets.setEnabled(this.activePerspective != null && this.activePerspective.getGadgetServiceList().size() > 0);
        if (this.activePerspective == null) {
            this.setTitle(null);
        }
        if (!this.newVersionPresents && this.lastCheckUpdates > 0L && System.currentTimeMillis() - this.lastCheckUpdates > 86400000L) {
            this.checkUpdates();
        }
    }

    public void viewAdded(PerspectivePanel panel, ViewProvider view) {
        this.cmMoveViewRight.setEnabled(panel.getViewCount() > 1);
        this.cmMoveViewLeft.setEnabled(panel.getViewCount() > 1);
        this.cmSelectView.setEnabled(panel.getViewCount() > 1);
        this.cmViewProperites.setEnabled(panel.getViewCount() > 1);
    }

    public void viewClosed(PerspectivePanel panel) {
        this.cmMoveViewRight.setEnabled(panel.getViewCount() > 1);
        this.cmMoveViewLeft.setEnabled(panel.getViewCount() > 1);
        this.cmSelectView.setEnabled(panel.getViewCount() > 1);
        this.cmViewProperites.setEnabled(panel.getViewCount() > 1);
    }

    public int getDatabaseInUse(Database database) {
        int result = 0;
        for (int i = 0; i < this.tabbedPerpectives.getTabCount(); ++i) {
            Component c = this.tabbedPerpectives.getComponentAt(i);
            if (!(c instanceof PerspectivePanel) || ((PerspectivePanel)c).getDatabase() == null || !((PerspectivePanel)c).getDatabase().equals(database)) continue;
            ++result;
        }
        return result;
    }

    public JTabbedPane getTabbedPerpectives() {
        return this.tabbedPerpectives;
    }

    private ISettings getSettings() {
        return Application.get().getSettings();
    }

    public void applySettings() {
        if (StringUtil.equalsIgnoreCase((String)this.getSettings().getValue("proxy-settings", "system-proxy"), (String)"system-proxy")) {
            System.setProperty("java.net.useSystemProxies", "true");
        } else if (StringUtil.equalsIgnoreCase((String)this.getSettings().getValue("proxy-settings", "system-proxy"), (String)"manual-proxy")) {
            if (!"".equals(this.getSettings().getValue("proxy-http-address", ""))) {
                System.getProperties().put("http.proxyHost", this.getSettings().getValue("proxy-http-address", ""));
                if (!"".equals(this.getSettings().getValue("proxy-http-port", ""))) {
                    System.getProperties().put("http.proxyPort", this.getSettings().getValue("proxy-http-port", ""));
                }
            }
            if (this.getSettings().getValue("proxy-auth-needed", Boolean.valueOf(false)).booleanValue()) {
                System.getProperties().put("http.proxyUser", this.getSettings().getValue("proxy-auth-user", ""));
                System.getProperties().put("http.proxyPassword", this.getSettings().getValue("proxy-auth-password", ""));
            }
        }
        QueryTableCellRenderer.colorizedCells = this.getSettings().getValue("colorized-query-table", Boolean.valueOf(QueryTableCellRenderer.colorizedCells));
        QueryTableCellRenderer.nullValue = this.getSettings().getValue("query-table-null-value", QueryTableCellRenderer.nullValue);
        QueryTableCellRenderer.numberColor = this.getSettings().getValue("query-table-color-number", QueryTableCellRenderer.numberColor);
        QueryTableCellRenderer.stringColor = this.getSettings().getValue("query-table-color-string", QueryTableCellRenderer.stringColor);
        QueryTableCellRenderer.boolColor = this.getSettings().getValue("query-table-color-boolean", QueryTableCellRenderer.boolColor);
        QueryTableCellRenderer.dateColor = this.getSettings().getValue("query-table-color-date", QueryTableCellRenderer.dateColor);
        QueryTableCellRenderer.nullColor = this.getSettings().getValue("query-table-color-null", QueryTableCellRenderer.nullColor);
        QueryTableCellRenderer.nullColor = this.getSettings().getValue("query-table-color-null", QueryTableCellRenderer.nullColor);
        if (!this.getSettings().getValue("default-color-selected-table-row", Boolean.valueOf(false)).booleanValue()) {
            QueryTableCellRenderer.selectionBackground = this.getSettings().getValue("color-selected-table-row", new Color(140, 165, 200));
        }
        DataTable.dataFont = this.getSettings().getValue("query-table-data-font", DataTable.dataFont);
        UIManager.put("ColorizedTable.eventRowShift", this.getSettings().getValue("table-even-row-shift", Long.valueOf(15L)).intValue());
        UIManager.put("ColorizedTable.focusColumnShift", this.getSettings().getValue("table-focused-column-shift", Long.valueOf(30L)).intValue());
        SkySetting.setBoolean((String)"CmCopyEdit.as-html-too", (Boolean)this.getSettings().getValue("copy-syntax-highlight", Boolean.valueOf(true)));
        SkySetting.setBoolean((String)"CmTab.tab-move-selected", (Boolean)this.getSettings().getValue("editor-tab-moves-selected", Boolean.valueOf(true)));
        SkySetting.setBoolean((String)"CmTab.tab-as-spaces", (Boolean)this.getSettings().getValue("editor-tab-as-spaces", Boolean.valueOf(false)));
        SkySetting.setBoolean((String)"CmAutoComplete.auto-complete-dot", (Boolean)this.getSettings().getValue("editor-auto-complete-dot", Boolean.valueOf(true)));
        SkySetting.setString((String)"CmAutoComplete.auto-complete-active-chars", (String)this.getSettings().getValue("editor-auto-complete-activate-chars", "."));
        SkySetting.setString((String)"CmAutoComplete.auto-complete-inactive-chars", (String)this.getSettings().getValue("editor-auto-complete-inactivate-chars", ",;"));
        SkySetting.setBoolean((String)"AutoCompleteText.insertion-text", (Boolean)this.getSettings().getValue("editor-auto-complete-insertion", Boolean.valueOf(false)));
        SkySetting.setBoolean((String)"AutoCompleteText.automatic-single", (Boolean)this.getSettings().getValue("editor-auto-complete-insert-single", Boolean.valueOf(false)));
        SkySetting.setBoolean((String)"SyntaxEditor.structure-auto-complete", (Boolean)this.getSettings().getValue("editor-auto-complete-structure-parser", Boolean.valueOf(true)));
        SkySetting.setBoolean((String)"SyntaxEditor.structure-auto-complete-variables", (Boolean)this.getSettings().getValue("editor-auto-complete-structure-parser-variables", Boolean.valueOf(true)));
        SkySetting.setBoolean((String)"SyntaxEditor.current-text-trim-whitespaces", (Boolean)this.getSettings().getValue("editor-trim-whitespaces", Boolean.valueOf(false)));
        SkySetting.setBoolean((String)"SyntaxEditor.smart-end", (Boolean)this.getSettings().getValue("editor-smart-home-end", Boolean.valueOf(false)));
        SkySetting.setBoolean((String)"SyntaxEditor.smart-home", (Boolean)this.getSettings().getValue("editor-smart-home-end", Boolean.valueOf(false)));
        SkySetting.setInteger((String)"SyntaxEditor.tab-to-space-count", (Integer)this.getSettings().getValue("editor-tab-to-space-count", Long.valueOf(2L)).intValue());
        SkySetting.setBoolean((String)"SyntaxEditor.predefined-snippets", (Boolean)this.getSettings().getValue("editor-pre-defined-snippets", Boolean.valueOf(true)));
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.applySyntaxEditorSettings();
            }
        });
        if (!this.getSettings().getValue("data-format-date-default", Boolean.valueOf(true)).booleanValue()) {
            Variant.setDateFormat((String)this.getSettings().getValue("data-format-date-string", "yyyy-MM-dd hh:mm:ss"));
        } else {
            Variant.setDateFormat((String)null);
        }
        if (!this.getSettings().getValue("data-format-time-default", Boolean.valueOf(true)).booleanValue()) {
            Variant.setTimeFormat((String)this.getSettings().getValue("data-format-time-string", "hh:mm:ss"));
        } else {
            Variant.setTimeFormat((String)null);
        }
        if (!this.getSettings().getValue("data-format-timestamp-default", Boolean.valueOf(true)).booleanValue()) {
            Variant.setTimeStampFormat((String)this.getSettings().getValue("data-format-timestamp-string", "yyyy-MM-dd hh:mm:ss.SSS"));
        } else {
            Variant.setTimeStampFormat((String)null);
        }
        if (!this.getSettings().getValue("data-format-decimal-separator-default", Boolean.valueOf(true)).booleanValue()) {
            Variant.setDecimalSeparator((String)this.getSettings().getValue("data-format-decimal-separator", "."));
        } else {
            Variant.setDecimalSeparator((String)null);
        }
        if (!this.getSettings().getValue("data-format-numeric-default", Boolean.valueOf(true)).booleanValue()) {
            Variant.setDecimalFormat((String)this.getSettings().getValue("data-format-numeric-string", ",##0.####################"));
        } else {
            Variant.setDecimalFormat((String)null);
        }
        if (!this.getSettings().getValue("data-format-bigdecimal-default", Boolean.valueOf(true)).booleanValue()) {
            Variant.setBigDecimalFormat((String)this.getSettings().getValue("data-format-bigdecimal-string", ",##0.####################"));
        } else {
            Variant.setBigDecimalFormat((String)null);
        }
        Variant.setDefaultNumberFormatMaximumFractionDigits((int)20);
    }

    private void applySyntaxEditorSettings() {
        SyntaxTextArea.apply((ApplySyntaxTextAreaEvent)new ApplySyntaxTextAreaEvent(){

            public void apply(SyntaxTextArea editor) {
                editor.getEditorArea().setBackground(MainFrame.this.getSettings().getValue("syntax-editor-background-color", editor.getEditorArea().getBackground()));
                editor.getEditorArea().setFont(MainFrame.this.getSettings().getValue("syntax-editor-font", editor.getEditorArea().getFont()));
                if (editor.getDocument() instanceof OrbadaSQLSyntaxDocument) {
                    OrbadaSQLSyntaxDocument.loadSettings(editor.getDocument());
                    editor.repaint();
                } else if (editor.getDocument() instanceof OrbadaJavaSyntaxDocument) {
                    OrbadaJavaSyntaxDocument.loadSettings(editor.getDocument());
                    editor.repaint();
                }
            }
        });
    }

    public void shutDown(boolean fromX) {
        this.cancelClose = false;
        if (this.getSettings().getValue("app-close-warning", Boolean.valueOf(false)).booleanValue() && MessageBox.show((Component)this, (String)stringManager.getString("closing"), (String)stringManager.getString("closing-app-question"), (int[])ModalResult.YESNO, (int)3) == 6) {
            this.cancelClose = true;
        }
        if (!this.cancelClose) {
            this.cmCloseAllPerspectives.performe();
        }
        if (!this.cancelClose) {
            this.dispose();
            Application.get().shutDown();
        } else if (fromX) {
            throw new OrbadaCancelCloseException();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    public boolean closePerspective(PerspectivePanel panel) {
        if (!panel.canClose()) {
            this.cancelClose = true;
            return false;
        }
        this.tabbedPerpectives.remove(panel);
        try {
            panel.close();
        }
        catch (Throwable t) {
            ExceptionUtil.processException((Throwable)t);
        }
        if (panel.equals(this.toolsPerspective)) {
            this.toolsPerspective = null;
            this.cmSpecialPerspective.setEnabled(true);
        }
        return true;
    }

    @Override
    public GlassPane getGlassPane() {
        return this.glassPane;
    }

    public void processMessage(PluginMessage message) {
        if ("transaction-state-change".equals(message.getMessageId())) {
            this.setTransactionActionEnabled();
        }
    }

    private void initComponents() {
        this.cmExit = new Action();
        this.cmNewConnection = new Action();
        this.cmDrivers = new Action();
        this.cmNewPerspective = new Action();
        this.cmCustomizeConnection = new Action();
        this.cmResetPerspective = new Action();
        this.cmCloseAllPerspectives = new Action();
        this.cmClosePerspective = new Action();
        this.cmDbCommit = new Action();
        this.cmDbRollback = new Action();
        this.cmDbReconnect = new Action();
        this.cmDbDisconnect = new Action();
        this.cmSelectPerspective = new Action();
        this.cmSpecialPerspective = new Action();
        this.cmMoveViewRight = new Action();
        this.cmMoveViewLeft = new Action();
        this.cmOrbadaSettings = new Action();
        this.cmMaximizeSplitView = new Action();
        this.cmDatabaseInfo = new Action();
        this.cmPluginSettings = new Action();
        this.cmOrbadaConfigFile = new Action();
        this.cmToolsSettings = new Action();
        this.cmPluginManager = new Action();
        this.cmChangeUserPassword = new Action();
        this.cmUserProperties = new Action();
        this.cmOrbadaLogFile = new Action();
        this.cmOrbadaLogErrorFile = new Action();
        this.menuPerspectives = new JPopupMenu();
        this.menuNewPerspective = new JMenuItem();
        this.sepMenuPerspective = new JSeparator();
        this.cmSelectNewPerspective = new Action();
        this.cmDeletePerspective = new Action();
        this.cmSelectView = new Action();
        this.cmTemplateSettings = new Action();
        this.cmViewProperites = new Action();
        this.cmSelectTab = new Action();
        this.cmCloseView = new Action();
        this.menuViewPopup = new JPopupMenu();
        this.ppmViewProperties = new JMenuItem();
        this.ppmMoveViewLeft = new JMenuItem();
        this.ppmMoveViewRight = new JMenuItem();
        this.jSeparator15 = new JSeparator();
        this.ppmCloseView = new JMenuItem();
        this.cmSuggestionRequest = new Action();
        this.cmProblemRequest = new Action();
        this.cmComponentShortcut = new Action();
        this.cmUserGuide = new Action();
        this.cmGetUpdate = new Action();
        this.cmOrbadaLastChanges = new Action();
        this.cmUserList = new Action();
        this.cmAboutOrbada = new Action();
        this.cmOrbadaLog4jFile = new Action();
        this.cmDocumentation = new Action();
        this.cmPageProjectHome = new Action();
        this.cmPageReviews = new Action();
        this.cmPageDonations = new Action();
        this.cmFullScreen = new Action();
        this.cmDBStartTransaction = new Action();
        this.cmClonePerspectiveViews = new Action();
        this.panelMain = new JPanel();
        this.jPanel1 = new JPanel();
        this.panelPerspectiveTools = new JPanel();
        this.panelToolTip = new JPanel();
        this.buttonMoveViewLeft = new ToolButton();
        this.buttonMoveViewRight = new ToolButton();
        this.jSeparator8 = new JSeparator();
        this.buttonClosePerspective = new ToolButton();
        this.panelToolBars = new JPanel();
        this.toolBarMain = new JToolBar();
        this.tbConnection = new ToolButton();
        this.buttonSelectNewPerspective = new ToolButton();
        this.buttonNewToolsPerspective = new ToolButton();
        this.buttonDatabaseInfo = new ToolButton();
        this.jSeparator6 = new JSeparator();
        this.toolButton1 = new ToolButton();
        this.buttonDbCommit = new ToolButton();
        this.buttonDbRollback = new ToolButton();
        this.toolBarTools = new JToolBar();
        this.jPanel2 = new JPanel();
        this.toolBarUpdates = new JToolBar();
        this.buttonDonation = new ToolButton();
        this.buttonGetUpdate = new ToolButton();
        this.panelPerspectives = new JPanel();
        this.tabbedPerpectives = new JTabbedPane();
        this.panelStatus = new JPanel();
        this.menuBarMain = new JMenuBar();
        this.menuProgram = new JMenu();
        this.menuNewConnection = new JMenuItem();
        this.menuDrivers = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.menuSettings = new JMenu();
        this.menuOrbadaSettings = new JMenuItem();
        this.menuPluginSettings = new JMenuItem();
        this.menuPluginManager = new JMenuItem();
        this.jSeparator9 = new JSeparator();
        this.menuOrbadaConfigFile = new JMenuItem();
        this.menuOrbadaLog4jFile = new JMenuItem();
        this.menuSpecialFiles = new JMenu();
        this.menuOrbadaLogFile = new JMenuItem();
        this.menuOrbadaLogErrorFile = new JMenuItem();
        this.jSeparator18 = new JSeparator();
        this.menuFullScreen = new JMenuItem();
        this.jSeparator13 = new JSeparator();
        this.menuUserProperties = new JMenuItem();
        this.menuChangeUserPassword = new JMenuItem();
        this.menuUserList = new JMenuItem();
        this.sepRequests = new JSeparator();
        this.menuSuggestionRequest = new JMenuItem();
        this.menuProblemRequest = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.menuExit = new JMenuItem();
        this.menuConnection = new JMenu();
        this.menuDBStartTransaction = new JMenuItem();
        this.jSeparator19 = new JPopupMenu.Separator();
        this.menuDbCommit = new JMenuItem();
        this.menuDbRollback = new JMenuItem();
        this.jSeparator7 = new JSeparator();
        this.menuDbDisconnect = new JMenuItem();
        this.menuDbReconnect = new JMenuItem();
        this.jSeparator11 = new JSeparator();
        this.menuCustomizeConnection = new JMenuItem();
        this.menuDatabaseInfo = new JMenuItem();
        this.menuEdit = new JMenu();
        this.menuTools = new JMenu();
        this.jSeparator12 = new JSeparator();
        this.jMenuItem1 = new JMenuItem();
        this.menuTemplatesSettings = new JMenuItem();
        this.jMenu1 = new JMenu();
        this.menuPerspective = new JMenu();
        this.menuToolsPerspective = new JMenuItem();
        this.menuSelectNewPerspective = new JMenu();
        this.menuWindowNewPerspective = new JMenuItem();
        this.sepMenuWindowPerspective = new JSeparator();
        this.menuPerspectiveGadgets = new JMenu();
        this.jSeparator3 = new JSeparator();
        this.menuClosePerspective = new JMenuItem();
        this.menuCloseAllPerspectives = new JMenuItem();
        this.jSeparator5 = new JSeparator();
        this.menuResetPerspective = new JMenuItem();
        this.menuPerspectiveProperties = new JMenuItem();
        this.menuMovePerspectiveLeft = new JMenuItem();
        this.menuMovePerspectiveRight = new JMenuItem();
        this.menuClonePerspectiveViews = new JMenuItem();
        this.jSeparator4 = new JSeparator();
        this.menuViewProperites = new JMenuItem();
        this.menuMoveViewLeft = new JMenuItem();
        this.menuMoveViewRight = new JMenuItem();
        this.jSeparator10 = new JSeparator();
        this.menuCloseView = new JMenuItem();
        this.jSeparator14 = new JSeparator();
        this.menuMaximizeSplitView = new JMenuItem();
        this.menuNavigation = new JMenu();
        this.menuSelectPerspective = new JMenuItem();
        this.menuSelectView = new JMenuItem();
        this.menuSelectTab = new JMenuItem();
        this.menuPerspectiveView = new JMenu();
        this.menuHelp = new JMenu();
        this.menuUserGuide = new JMenuItem();
        this.menuComponentShortcut = new JMenuItem();
        this.menuDocumentation = new JMenuItem();
        this.jSeparator17 = new JSeparator();
        this.menuPageProjectHome = new JMenuItem();
        this.menuPageReviews = new JMenuItem();
        this.menuPageDonations = new JMenuItem();
        this.jSeparator16 = new JSeparator();
        this.menuLastChanges = new JMenuItem();
        this.menuGetUpdates = new JMenuItem();
        this.menuAboutOrbada = new JMenuItem();
        this.cmExit.setActionCommandKey("cmExit");
        this.cmExit.setShortCut(KeyStroke.getKeyStroke(115, 8));
        this.cmExit.setText(stringManager.getString("mf-cmexit-text"));
        this.cmExit.setTooltip(stringManager.getString("mf-cmexit-hint"));
        this.cmExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmExitActionPerformed(evt);
            }
        });
        this.cmNewConnection.setActionCommandKey("cmNewConnection");
        this.cmNewConnection.setShortCut(KeyStroke.getKeyStroke(78, 9));
        this.cmNewConnection.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/connection.gif"));
        this.cmNewConnection.setText(stringManager.getString("mf-cmNewConnection-text"));
        this.cmNewConnection.setTooltip(stringManager.getString("mf-cmNewConnection-hint"));
        this.cmNewConnection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmNewConnectionActionPerformed(evt);
            }
        });
        this.cmDrivers.setActionCommandKey("cmDrivers");
        this.cmDrivers.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/driverproperties.gif"));
        this.cmDrivers.setText(stringManager.getString("mf-cmDrivers-text"));
        this.cmDrivers.setTooltip(stringManager.getString("mf-cmDrivers-hint"));
        this.cmDrivers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmDriversActionPerformed(evt);
            }
        });
        this.cmNewPerspective.setActionCommandKey("cmNewPerspective");
        this.cmNewPerspective.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/new_window_perspective16.gif"));
        this.cmNewPerspective.setText(stringManager.getString("mf-cmNewPerspective-text"));
        this.cmNewPerspective.setTooltip(stringManager.getString("mf-cmNewPerspective-hint"));
        this.cmNewPerspective.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmNewPerspectiveActionPerformed(evt);
            }
        });
        this.cmCustomizeConnection.setActionCommandKey("cmCustomizeConnection");
        this.cmCustomizeConnection.setText(stringManager.getString("mf-cmCustomizeConnection-text"));
        this.cmCustomizeConnection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmCustomizeConnectionActionPerformed(evt);
            }
        });
        this.cmResetPerspective.setActionCommandKey("cmResetPerspective");
        this.cmResetPerspective.setText(stringManager.getString("mf-cmResetPerspective-text"));
        this.cmResetPerspective.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmResetPerspectiveActionPerformed(evt);
            }
        });
        this.cmCloseAllPerspectives.setActionCommandKey("cmCloseAllPerspectives");
        this.cmCloseAllPerspectives.setText(stringManager.getString("mf-cmCloseAllPerspectives-text"));
        this.cmCloseAllPerspectives.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmCloseAllPerspectivesActionPerformed(evt);
            }
        });
        this.cmClosePerspective.setActionCommandKey("cmClosePerspective");
        this.cmClosePerspective.setShortCut(KeyStroke.getKeyStroke(115, 3));
        this.cmClosePerspective.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/stop10.gif"));
        this.cmClosePerspective.setText(stringManager.getString("mf-cmClosePerspective-text"));
        this.cmClosePerspective.setTooltip(stringManager.getString("mf-cmClosePerspective-hint"));
        this.cmClosePerspective.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmClosePerspectiveActionPerformed(evt);
            }
        });
        this.cmDbCommit.setActionCommandKey("cmDbCommit");
        this.cmDbCommit.setEnabled(false);
        this.cmDbCommit.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/commit.gif"));
        this.cmDbCommit.setText(stringManager.getString("mf-cmDbCommit-text"));
        this.cmDbCommit.setTooltip(stringManager.getString("mf-cmDbCommit-hint"));
        this.cmDbCommit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmDbCommitActionPerformed(evt);
            }
        });
        this.cmDbRollback.setActionCommandKey("cmDbRollback");
        this.cmDbRollback.setEnabled(false);
        this.cmDbRollback.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/rollback.gif"));
        this.cmDbRollback.setText(stringManager.getString("mf-cmDbRollback-text"));
        this.cmDbRollback.setTooltip(stringManager.getString("mf-cmDbRollback-hint"));
        this.cmDbRollback.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmDbRollbackActionPerformed(evt);
            }
        });
        this.cmDbReconnect.setActionCommandKey("cmDbReconnect");
        this.cmDbReconnect.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/connect16.gif"));
        this.cmDbReconnect.setText(stringManager.getString("mf-cmDbReconnect-text"));
        this.cmDbReconnect.setTooltip(stringManager.getString("mf-cmDbReconnect-hint"));
        this.cmDbReconnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmDbReconnectActionPerformed(evt);
            }
        });
        this.cmDbDisconnect.setActionCommandKey("cmDbDisconnect");
        this.cmDbDisconnect.setText(stringManager.getString("mf-cmDbDisconnect-text"));
        this.cmDbDisconnect.setTooltip(stringManager.getString("mf-cmDbDisconnect-hint"));
        this.cmDbDisconnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmDbDisconnectActionPerformed(evt);
            }
        });
        this.cmSelectPerspective.setActionCommandKey("cmSelectPerspective");
        this.cmSelectPerspective.setShortCut(KeyStroke.getKeyStroke(48, 8));
        this.cmSelectPerspective.setText(stringManager.getString("mf-cmSelectPerspective-text"));
        this.cmSelectPerspective.setTooltip(stringManager.getString("mf-cmSelectPerspective-hint"));
        this.cmSelectPerspective.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmSelectPerspectiveActionPerformed(evt);
            }
        });
        this.cmSpecialPerspective.setActionCommandKey("cmSpecialPerspective");
        this.cmSpecialPerspective.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/new_tools_perspective16.gif"));
        this.cmSpecialPerspective.setText(stringManager.getString("mf-cmSpecialPerspective-text"));
        this.cmSpecialPerspective.setTooltip(stringManager.getString("mf-cmSpecialPerspective-hint"));
        this.cmSpecialPerspective.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmSpecialPerspectiveActionPerformed(evt);
            }
        });
        this.cmMoveViewRight.setActionCommandKey("cmMoveViewRight");
        this.cmMoveViewRight.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/right10.gif"));
        this.cmMoveViewRight.setText(stringManager.getString("mf-cmMoveViewRight-text"));
        this.cmMoveViewRight.setTooltip(stringManager.getString("mf-cmMoveViewRight-hint"));
        this.cmMoveViewRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmMoveViewRightActionPerformed(evt);
            }
        });
        this.cmMoveViewLeft.setActionCommandKey("cmMoveViewLeft");
        this.cmMoveViewLeft.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/left10.gif"));
        this.cmMoveViewLeft.setText(stringManager.getString("mf-cmMoveViewLeft-text"));
        this.cmMoveViewLeft.setTooltip(stringManager.getString("mf-cmMoveViewLeft-hint"));
        this.cmMoveViewLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmMoveViewLeftActionPerformed(evt);
            }
        });
        this.cmOrbadaSettings.setActionCommandKey("cmOrbadaSettings");
        this.cmOrbadaSettings.setText(stringManager.getString("mf-cmOrbadaSettings-text"));
        this.cmOrbadaSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmOrbadaSettingsActionPerformed(evt);
            }
        });
        this.cmMaximizeSplitView.setActionCommandKey("cmMaximizeSplitView");
        this.cmMaximizeSplitView.setShortCut(KeyStroke.getKeyStroke(113, 2));
        this.cmMaximizeSplitView.setText(stringManager.getString("mf-cmMaximizeSplitView-text"));
        this.cmMaximizeSplitView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmMaximizeSplitViewActionPerformed(evt);
            }
        });
        this.cmDatabaseInfo.setActionCommandKey("cmDatabaseInfo");
        this.cmDatabaseInfo.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/db_info16.gif"));
        this.cmDatabaseInfo.setText(stringManager.getString("mf-cmDatabaseInfo-text"));
        this.cmDatabaseInfo.setTooltip(stringManager.getString("mf-cmDatabaseInfo-hint"));
        this.cmDatabaseInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmDatabaseInfoActionPerformed(evt);
            }
        });
        this.cmPluginSettings.setActionCommandKey("cmPluginSettings");
        this.cmPluginSettings.setText(stringManager.getString("mf-cmPluginSettings-text"));
        this.cmPluginSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmPluginSettingsActionPerformed(evt);
            }
        });
        this.cmOrbadaConfigFile.setActionCommandKey("cmOrbadaConfigFile");
        this.cmOrbadaConfigFile.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/save16.gif"));
        this.cmOrbadaConfigFile.setText(stringManager.getString("mf-cmOrbadaConfigFile-text"));
        this.cmOrbadaConfigFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmOrbadaConfigFileActionPerformed(evt);
            }
        });
        this.cmToolsSettings.setActionCommandKey("cmToolsSettings");
        this.cmToolsSettings.setText(stringManager.getString("mf-cmToolsSettings-text"));
        this.cmToolsSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmToolsSettingsActionPerformed(evt);
            }
        });
        this.cmPluginManager.setActionCommandKey("cmPluginManager");
        this.cmPluginManager.setText(stringManager.getString("mf-cmPluginManager-text"));
        this.cmPluginManager.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmPluginManagerActionPerformed(evt);
            }
        });
        this.cmChangeUserPassword.setActionCommandKey("cmChangeUserPassword");
        this.cmChangeUserPassword.setText(stringManager.getString("mf-cmChangeUserPassword-text"));
        this.cmChangeUserPassword.setTooltip(stringManager.getString("mf-cmChangeUserPassword-hint"));
        this.cmChangeUserPassword.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmChangeUserPasswordActionPerformed(evt);
            }
        });
        this.cmUserProperties.setActionCommandKey("cmUserProperties");
        this.cmUserProperties.setText(stringManager.getString("mf-cmUserProperties-text"));
        this.cmUserProperties.setTooltip(stringManager.getString("mf-cmUserProperties-hint"));
        this.cmUserProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmUserPropertiesActionPerformed(evt);
            }
        });
        this.cmOrbadaLogFile.setActionCommandKey("cmOrbadaLogFile");
        this.cmOrbadaLogFile.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/save16.gif"));
        this.cmOrbadaLogFile.setText(stringManager.getString("mf-cmOrbadaLogFile-text"));
        this.cmOrbadaLogFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmOrbadaLogFileActionPerformed(evt);
            }
        });
        this.cmOrbadaLogErrorFile.setActionCommandKey("cmOrbadaLogErrorFile");
        this.cmOrbadaLogErrorFile.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/save16.gif"));
        this.cmOrbadaLogErrorFile.setText(stringManager.getString("mf-cmOrbadaLogErrorFile-text"));
        this.cmOrbadaLogErrorFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmOrbadaLogErrorFileActionPerformed(evt);
            }
        });
        this.menuPerspectives.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                MainFrame.this.menuPerspectivesPopupMenuWillBecomeVisible(evt);
            }
        });
        this.menuNewPerspective.setAction((javax.swing.Action)this.cmNewPerspective);
        this.menuPerspectives.add(this.menuNewPerspective);
        this.menuPerspectives.add(this.sepMenuPerspective);
        this.cmSelectNewPerspective.setActionCommandKey("cmSelectNewPerspective");
        this.cmSelectNewPerspective.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/new_window_perspective16.gif"));
        this.cmSelectNewPerspective.setText(stringManager.getString("mf-cmSelectNewPerspective-text"));
        this.cmSelectNewPerspective.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmSelectNewPerspectiveActionPerformed(evt);
            }
        });
        this.cmDeletePerspective.setActionCommandKey("cmDeletePerspective");
        this.cmDeletePerspective.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmDeletePerspective.setText(stringManager.getString("mf-cmDeletePerspective-text"));
        this.cmDeletePerspective.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmDeletePerspectiveActionPerformed(evt);
            }
        });
        this.cmSelectView.setActionCommandKey("cmSelectView");
        this.cmSelectView.setShortCut(KeyStroke.getKeyStroke(45, 8));
        this.cmSelectView.setText(stringManager.getString("mf-cmSelectView-text"));
        this.cmSelectView.setTooltip(stringManager.getString("mf-cmSelectView-hint"));
        this.cmSelectView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmSelectViewActionPerformed(evt);
            }
        });
        this.cmTemplateSettings.setActionCommandKey("cmTemplateSettings");
        this.cmTemplateSettings.setShortCut(KeyStroke.getKeyStroke(119, 8));
        this.cmTemplateSettings.setText(stringManager.getString("mf-cmTemplateSettings-text"));
        this.cmTemplateSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmTemplateSettingsActionPerformed(evt);
            }
        });
        this.cmViewProperites.setActionCommandKey("cmViewProperites");
        this.cmViewProperites.setText(stringManager.getString("mf-cmViewProperites-text"));
        this.cmViewProperites.setTooltip(stringManager.getString("mf-cmViewProperites-hint"));
        this.cmViewProperites.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmViewProperitesActionPerformed(evt);
            }
        });
        this.cmSelectTab.setActionCommandKey("cmSelectTab");
        this.cmSelectTab.setShortCut(KeyStroke.getKeyStroke(61, 8));
        this.cmSelectTab.setText(stringManager.getString("mf-cmSelectTab-text"));
        this.cmSelectTab.setTooltip(stringManager.getString("mf-cmSelectTab-hint"));
        this.cmSelectTab.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmSelectTabActionPerformed(evt);
            }
        });
        this.cmCloseView.setActionCommandKey("cmCloseView");
        this.cmCloseView.setShortCut(KeyStroke.getKeyStroke(115, 2));
        this.cmCloseView.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/close10.gif"));
        this.cmCloseView.setText(stringManager.getString("mf-cmCloseView-text"));
        this.cmCloseView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmCloseViewActionPerformed(evt);
            }
        });
        this.ppmViewProperties.setAction((javax.swing.Action)this.cmViewProperites);
        this.menuViewPopup.add(this.ppmViewProperties);
        this.ppmMoveViewLeft.setAction((javax.swing.Action)this.cmMoveViewLeft);
        this.menuViewPopup.add(this.ppmMoveViewLeft);
        this.ppmMoveViewRight.setAction((javax.swing.Action)this.cmMoveViewRight);
        this.menuViewPopup.add(this.ppmMoveViewRight);
        this.menuViewPopup.add(this.jSeparator15);
        this.ppmCloseView.setAction((javax.swing.Action)this.cmCloseView);
        this.menuViewPopup.add(this.ppmCloseView);
        this.cmSuggestionRequest.setActionCommandKey("cmSuggestionRequest");
        this.cmSuggestionRequest.setText(stringManager.getString("mf-cmSuggestionRequest-text"));
        this.cmSuggestionRequest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmSuggestionRequestActionPerformed(evt);
            }
        });
        this.cmProblemRequest.setActionCommandKey("cmProblemRequest");
        this.cmProblemRequest.setText(stringManager.getString("mf-cmProblemRequest-text"));
        this.cmProblemRequest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmProblemRequestActionPerformed(evt);
            }
        });
        this.cmComponentShortcut.setActionCommandKey("cmComponentShortcut");
        this.cmComponentShortcut.setShortCut(KeyStroke.getKeyStroke(112, 1));
        this.cmComponentShortcut.setText(stringManager.getString("mf-cmComponentShortcut-text"));
        this.cmComponentShortcut.setTooltip(stringManager.getString("mf-cmComponentShortcut-hint"));
        this.cmComponentShortcut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmComponentShortcutActionPerformed(evt);
            }
        });
        this.cmUserGuide.setActionCommandKey("cmUserGuide");
        this.cmUserGuide.setShortCut(KeyStroke.getKeyStroke(112, 0));
        this.cmUserGuide.setText(stringManager.getString("mf-cmUserGuide-text"));
        this.cmUserGuide.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmUserGuideActionPerformed(evt);
            }
        });
        this.cmGetUpdate.setActionCommandKey("cmGenUpdate");
        this.cmGetUpdate.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/search-commercial.png"));
        this.cmGetUpdate.setText(stringManager.getString("mf-cmGetUpdate-text"));
        this.cmGetUpdate.setTooltip(stringManager.getString("mf-cmGetUpdate-hint"));
        this.cmGetUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmGetUpdateActionPerformed(evt);
            }
        });
        this.cmOrbadaLastChanges.setActionCommandKey("cmOrbadaLastChanges");
        this.cmOrbadaLastChanges.setText(stringManager.getString("mf-cmOrbadaLastChanges-text"));
        this.cmOrbadaLastChanges.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmOrbadaLastChangesActionPerformed(evt);
            }
        });
        this.cmUserList.setActionCommandKey("cmUserList");
        this.cmUserList.setText(stringManager.getString("mf-cmUserList-text"));
        this.cmUserList.setTooltip(stringManager.getString("mf-cmUserList-hint"));
        this.cmUserList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmUserListActionPerformed(evt);
            }
        });
        this.cmAboutOrbada.setActionCommandKey("cmAboutOrbada");
        this.cmAboutOrbada.setText(stringManager.getString("mf-cmAboutOrbada-text"));
        this.cmAboutOrbada.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmAboutOrbadaActionPerformed(evt);
            }
        });
        this.cmOrbadaLog4jFile.setActionCommandKey("cmOrbadaLog4jFile");
        this.cmOrbadaLog4jFile.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/save16.gif"));
        this.cmOrbadaLog4jFile.setText(stringManager.getString("mf-cmOrbadaLog4jFile-text"));
        this.cmOrbadaLog4jFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmOrbadaLog4jFileActionPerformed(evt);
            }
        });
        this.cmDocumentation.setActionCommandKey("cmDocumentation");
        this.cmDocumentation.setText(stringManager.getString("mf-cmDocumentation-text"));
        this.cmDocumentation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmDocumentationActionPerformed(evt);
            }
        });
        this.cmPageProjectHome.setActionCommandKey("cmPageProjectHome");
        this.cmPageProjectHome.setText(stringManager.getString("cmPageProjectHome-text"));
        this.cmPageProjectHome.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmPageProjectHomeActionPerformed(evt);
            }
        });
        this.cmPageReviews.setActionCommandKey("cmPageReviews");
        this.cmPageReviews.setText(stringManager.getString("cmPageReviews-text"));
        this.cmPageReviews.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmPageReviewsActionPerformed(evt);
            }
        });
        this.cmPageDonations.setActionCommandKey("cmPageDonations");
        this.cmPageDonations.setText(stringManager.getString("cmPageDonations-text"));
        this.cmPageDonations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmPageDonationsActionPerformed(evt);
            }
        });
        this.cmFullScreen.setActionCommandKey("cmFullScreen");
        this.cmFullScreen.setShortCut(KeyStroke.getKeyStroke(122, 0));
        this.cmFullScreen.setText(stringManager.getString("cmFullScreen-text"));
        this.cmFullScreen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmFullScreenActionPerformed(evt);
            }
        });
        this.cmDBStartTransaction.setActionCommandKey("cmDBStartTransaction");
        this.cmDBStartTransaction.setEnabled(false);
        this.cmDBStartTransaction.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/start_transaction.gif"));
        this.cmDBStartTransaction.setText(stringManager.getString("cmDBStartTransaction-text"));
        this.cmDBStartTransaction.setTooltip(stringManager.getString("cmDBStartTransaction-hint"));
        this.cmDBStartTransaction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmDBStartTransactionActionPerformed(evt);
            }
        });
        this.cmClonePerspectiveViews.setText(stringManager.getString("main-cmClonePerspectiveViews-text"));
        this.cmClonePerspectiveViews.setTooltip(stringManager.getString("main-cmClonePerspectiveViews-hint"));
        this.cmClonePerspectiveViews.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmClonePerspectiveViewsActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(0);
        this.setTitle(stringManager.getString("MainFrame-title"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                MainFrame.this.formWindowClosing(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                MainFrame.this.formComponentShown(evt);
            }
        });
        this.panelMain.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new BorderLayout());
        this.panelPerspectiveTools.setLayout(new FlowLayout(1, 2, 5));
        this.panelToolTip.setLayout(new FlowLayout(1, 0, 0));
        this.panelPerspectiveTools.add(this.panelToolTip);
        this.buttonMoveViewLeft.setAction((javax.swing.Action)this.cmMoveViewLeft);
        this.buttonMoveViewLeft.setPreferredSize(new Dimension(18, 18));
        this.panelPerspectiveTools.add((Component)this.buttonMoveViewLeft);
        this.buttonMoveViewRight.setAction((javax.swing.Action)this.cmMoveViewRight);
        this.buttonMoveViewRight.setPreferredSize(new Dimension(18, 18));
        this.panelPerspectiveTools.add((Component)this.buttonMoveViewRight);
        this.jSeparator8.setOrientation(1);
        this.jSeparator8.setPreferredSize(new Dimension(4, 0));
        this.panelPerspectiveTools.add(this.jSeparator8);
        this.buttonClosePerspective.setAction((javax.swing.Action)this.cmClosePerspective);
        this.buttonClosePerspective.setPreferredSize(new Dimension(18, 18));
        this.panelPerspectiveTools.add((Component)this.buttonClosePerspective);
        this.jPanel1.add((Component)this.panelPerspectiveTools, "East");
        this.panelToolBars.setLayout(new FlowLayout(0, 0, 0));
        this.toolBarMain.setFloatable(false);
        this.toolBarMain.setRollover(true);
        this.tbConnection.setAction((javax.swing.Action)this.cmNewConnection);
        this.toolBarMain.add((Component)this.tbConnection);
        this.buttonSelectNewPerspective.setAction((javax.swing.Action)this.cmSelectNewPerspective);
        this.buttonSelectNewPerspective.setHorizontalTextPosition(0);
        this.buttonSelectNewPerspective.setVerticalTextPosition(3);
        this.toolBarMain.add((Component)this.buttonSelectNewPerspective);
        this.buttonNewToolsPerspective.setAction((javax.swing.Action)this.cmSpecialPerspective);
        this.buttonNewToolsPerspective.setHorizontalTextPosition(0);
        this.buttonNewToolsPerspective.setVerticalTextPosition(3);
        this.toolBarMain.add((Component)this.buttonNewToolsPerspective);
        this.buttonDatabaseInfo.setAction((javax.swing.Action)this.cmDatabaseInfo);
        this.buttonDatabaseInfo.setHorizontalTextPosition(0);
        this.buttonDatabaseInfo.setVerticalTextPosition(3);
        this.toolBarMain.add((Component)this.buttonDatabaseInfo);
        this.jSeparator6.setOrientation(1);
        this.toolBarMain.add(this.jSeparator6);
        this.toolButton1.setAction((javax.swing.Action)this.cmDBStartTransaction);
        this.toolButton1.setHorizontalTextPosition(0);
        this.toolBarMain.add((Component)this.toolButton1);
        this.buttonDbCommit.setAction((javax.swing.Action)this.cmDbCommit);
        this.buttonDbCommit.setHorizontalTextPosition(0);
        this.buttonDbCommit.setVerticalTextPosition(3);
        this.toolBarMain.add((Component)this.buttonDbCommit);
        this.buttonDbRollback.setAction((javax.swing.Action)this.cmDbRollback);
        this.buttonDbRollback.setHorizontalTextPosition(0);
        this.buttonDbRollback.setVerticalTextPosition(3);
        this.toolBarMain.add((Component)this.buttonDbRollback);
        this.panelToolBars.add(this.toolBarMain);
        this.toolBarTools.setRollover(true);
        this.panelToolBars.add(this.toolBarTools);
        this.jPanel1.add((Component)this.panelToolBars, "West");
        this.jPanel2.setLayout(new FlowLayout(2, 0, 0));
        this.toolBarUpdates.setFloatable(false);
        this.toolBarUpdates.setRollover(true);
        this.buttonDonation.setAction((javax.swing.Action)this.cmPageDonations);
        this.buttonDonation.setFont(new Font("Tahoma", 1, 12));
        this.buttonDonation.setHideActionText(false);
        this.buttonDonation.setHorizontalTextPosition(0);
        this.buttonDonation.setMaximumSize(new Dimension(140, 26));
        this.buttonDonation.setPreferredSize(new Dimension(140, 26));
        this.buttonDonation.setVerticalTextPosition(3);
        this.toolBarUpdates.add((Component)this.buttonDonation);
        this.buttonGetUpdate.setAction((javax.swing.Action)this.cmGetUpdate);
        this.buttonGetUpdate.setForeground(Color.red);
        this.buttonGetUpdate.setFont(new Font("Tahoma", 0, 10));
        this.buttonGetUpdate.setHideActionText(false);
        this.buttonGetUpdate.setHorizontalTextPosition(4);
        this.buttonGetUpdate.setMaximumSize(new Dimension(120, 26));
        this.buttonGetUpdate.setPreferredSize(new Dimension(120, 26));
        this.toolBarUpdates.add((Component)this.buttonGetUpdate);
        this.jPanel2.add(this.toolBarUpdates);
        this.jPanel1.add((Component)this.jPanel2, "Center");
        this.panelMain.add((Component)this.jPanel1, "First");
        this.panelPerspectives.setLayout(new BorderLayout());
        this.tabbedPerpectives.setTabPlacement(3);
        this.tabbedPerpectives.setFocusable(false);
        this.panelPerspectives.add((Component)this.tabbedPerpectives, "Center");
        this.panelMain.add((Component)this.panelPerspectives, "Center");
        this.getContentPane().add((Component)this.panelMain, "Center");
        this.panelStatus.setLayout(new GridLayout(1, 0));
        this.getContentPane().add((Component)this.panelStatus, "South");
        this.menuBarMain.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getDefaults().getColor("Button.shadow")));
        this.menuBarMain.setFocusable(false);
        this.menuProgram.setMnemonic('P');
        this.menuProgram.setText(stringManager.getString("mf-menuProgram-text"));
        this.menuProgram.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent evt) {
            }

            @Override
            public void menuDeselected(MenuEvent evt) {
            }

            @Override
            public void menuSelected(MenuEvent evt) {
                MainFrame.this.menuProgramMenuSelected(evt);
            }
        });
        this.menuNewConnection.setAction((javax.swing.Action)this.cmNewConnection);
        this.menuProgram.add(this.menuNewConnection);
        this.menuDrivers.setAction((javax.swing.Action)this.cmDrivers);
        this.menuProgram.add(this.menuDrivers);
        this.menuProgram.add(this.jSeparator1);
        this.menuSettings.setText("Ustawienia");
        this.menuOrbadaSettings.setAction((javax.swing.Action)this.cmOrbadaSettings);
        this.menuSettings.add(this.menuOrbadaSettings);
        this.menuPluginSettings.setAction((javax.swing.Action)this.cmPluginSettings);
        this.menuSettings.add(this.menuPluginSettings);
        this.menuPluginManager.setAction((javax.swing.Action)this.cmPluginManager);
        this.menuSettings.add(this.menuPluginManager);
        this.menuSettings.add(this.jSeparator9);
        this.menuOrbadaConfigFile.setAction((javax.swing.Action)this.cmOrbadaConfigFile);
        this.menuSettings.add(this.menuOrbadaConfigFile);
        this.menuOrbadaLog4jFile.setAction((javax.swing.Action)this.cmOrbadaLog4jFile);
        this.menuSettings.add(this.menuOrbadaLog4jFile);
        this.menuProgram.add(this.menuSettings);
        this.menuSpecialFiles.setText("Specjalne pliki");
        this.menuOrbadaLogFile.setAction((javax.swing.Action)this.cmOrbadaLogFile);
        this.menuSpecialFiles.add(this.menuOrbadaLogFile);
        this.menuOrbadaLogErrorFile.setAction((javax.swing.Action)this.cmOrbadaLogErrorFile);
        this.menuSpecialFiles.add(this.menuOrbadaLogErrorFile);
        this.menuProgram.add(this.menuSpecialFiles);
        this.menuProgram.add(this.jSeparator18);
        this.menuFullScreen.setAction((javax.swing.Action)this.cmFullScreen);
        this.menuProgram.add(this.menuFullScreen);
        this.menuProgram.add(this.jSeparator13);
        this.menuUserProperties.setAction((javax.swing.Action)this.cmUserProperties);
        this.menuProgram.add(this.menuUserProperties);
        this.menuChangeUserPassword.setAction((javax.swing.Action)this.cmChangeUserPassword);
        this.menuProgram.add(this.menuChangeUserPassword);
        this.menuUserList.setAction((javax.swing.Action)this.cmUserList);
        this.menuProgram.add(this.menuUserList);
        this.menuProgram.add(this.sepRequests);
        this.menuSuggestionRequest.setAction((javax.swing.Action)this.cmSuggestionRequest);
        this.menuProgram.add(this.menuSuggestionRequest);
        this.menuProblemRequest.setAction((javax.swing.Action)this.cmProblemRequest);
        this.menuProgram.add(this.menuProblemRequest);
        this.menuProgram.add(this.jSeparator2);
        this.menuExit.setAction((javax.swing.Action)this.cmExit);
        this.menuProgram.add(this.menuExit);
        this.menuBarMain.add(this.menuProgram);
        this.menuConnection.setMnemonic('O');
        this.menuConnection.setText(stringManager.getString("mf-menuConnection-text"));
        this.menuDBStartTransaction.setAction((javax.swing.Action)this.cmDBStartTransaction);
        this.menuConnection.add(this.menuDBStartTransaction);
        this.menuConnection.add(this.jSeparator19);
        this.menuDbCommit.setAction((javax.swing.Action)this.cmDbCommit);
        this.menuConnection.add(this.menuDbCommit);
        this.menuDbRollback.setAction((javax.swing.Action)this.cmDbRollback);
        this.menuConnection.add(this.menuDbRollback);
        this.menuConnection.add(this.jSeparator7);
        this.menuDbDisconnect.setAction((javax.swing.Action)this.cmDbDisconnect);
        this.menuConnection.add(this.menuDbDisconnect);
        this.menuDbReconnect.setAction((javax.swing.Action)this.cmDbReconnect);
        this.menuConnection.add(this.menuDbReconnect);
        this.menuConnection.add(this.jSeparator11);
        this.menuCustomizeConnection.setAction((javax.swing.Action)this.cmCustomizeConnection);
        this.menuConnection.add(this.menuCustomizeConnection);
        this.menuDatabaseInfo.setAction((javax.swing.Action)this.cmDatabaseInfo);
        this.menuConnection.add(this.menuDatabaseInfo);
        this.menuBarMain.add(this.menuConnection);
        this.menuEdit.setMnemonic('E');
        this.menuEdit.setText(stringManager.getString("mf-menuEdit-text"));
        this.menuBarMain.add(this.menuEdit);
        this.menuTools.setMnemonic('N');
        this.menuTools.setText(stringManager.getString("mf-menuTools-text"));
        this.menuTools.add(this.jSeparator12);
        this.jMenuItem1.setAction((javax.swing.Action)this.cmToolsSettings);
        this.menuTools.add(this.jMenuItem1);
        this.menuTemplatesSettings.setAction((javax.swing.Action)this.cmTemplateSettings);
        this.menuTools.add(this.menuTemplatesSettings);
        this.jMenu1.setText("jMenu1");
        this.menuTools.add(this.jMenu1);
        this.menuBarMain.add(this.menuTools);
        this.menuPerspective.setMnemonic('K');
        this.menuPerspective.setText(stringManager.getString("mf-menuPerspective-text"));
        this.menuToolsPerspective.setAction((javax.swing.Action)this.cmSpecialPerspective);
        this.menuPerspective.add(this.menuToolsPerspective);
        this.menuSelectNewPerspective.setText("Choose a new perspective for the connection");
        this.menuSelectNewPerspective.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent evt) {
            }

            @Override
            public void menuDeselected(MenuEvent evt) {
            }

            @Override
            public void menuSelected(MenuEvent evt) {
                MainFrame.this.menuSelectNewPerspectiveMenuSelected(evt);
            }
        });
        this.menuWindowNewPerspective.setAction((javax.swing.Action)this.cmNewPerspective);
        this.menuSelectNewPerspective.add(this.menuWindowNewPerspective);
        this.menuSelectNewPerspective.add(this.sepMenuWindowPerspective);
        this.menuPerspective.add(this.menuSelectNewPerspective);
        this.menuPerspectiveGadgets.setText("Narz\u0119dzia perspektywy");
        this.menuPerspectiveGadgets.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent evt) {
            }

            @Override
            public void menuDeselected(MenuEvent evt) {
            }

            @Override
            public void menuSelected(MenuEvent evt) {
                MainFrame.this.menuPerspectiveGadgetsMenuSelected(evt);
            }
        });
        this.menuPerspective.add(this.menuPerspectiveGadgets);
        this.menuPerspective.add(this.jSeparator3);
        this.menuClosePerspective.setAction((javax.swing.Action)this.cmClosePerspective);
        this.menuPerspective.add(this.menuClosePerspective);
        this.menuCloseAllPerspectives.setAction((javax.swing.Action)this.cmCloseAllPerspectives);
        this.menuPerspective.add(this.menuCloseAllPerspectives);
        this.menuPerspective.add(this.jSeparator5);
        this.menuResetPerspective.setAction((javax.swing.Action)this.cmResetPerspective);
        this.menuPerspective.add(this.menuResetPerspective);
        this.menuPerspectiveProperties.setText("! w\u0142a\u015bciwo\u015bci perspektywy");
        this.cmPerspectiveProperties = new PerspectivePropertiesAction();
        this.menuPerspectiveProperties.setAction((javax.swing.Action)((Object)this.cmPerspectiveProperties));
        this.menuPerspective.add(this.menuPerspectiveProperties);
        this.menuMovePerspectiveLeft.setText("! przesu\u0144 w lewo");
        this.cmMovePerspectiveLeft = new MovePerspectiveLeftAction();
        this.menuMovePerspectiveLeft.setAction((javax.swing.Action)((Object)this.cmMovePerspectiveLeft));
        this.menuPerspective.add(this.menuMovePerspectiveLeft);
        this.menuMovePerspectiveRight.setText("! przesu\u0144 w prawo");
        this.cmMovePerspectiveRight = new MovePerspectiveRightAction();
        this.menuMovePerspectiveRight.setAction((javax.swing.Action)((Object)this.cmMovePerspectiveRight));
        this.menuPerspective.add(this.menuMovePerspectiveRight);
        this.menuClonePerspectiveViews.setAction((javax.swing.Action)this.cmClonePerspectiveViews);
        this.menuPerspective.add(this.menuClonePerspectiveViews);
        this.menuPerspective.add(this.jSeparator4);
        this.menuViewProperites.setAction((javax.swing.Action)this.cmViewProperites);
        this.menuPerspective.add(this.menuViewProperites);
        this.menuMoveViewLeft.setAction((javax.swing.Action)this.cmMoveViewLeft);
        this.menuPerspective.add(this.menuMoveViewLeft);
        this.menuMoveViewRight.setAction((javax.swing.Action)this.cmMoveViewRight);
        this.menuPerspective.add(this.menuMoveViewRight);
        this.menuPerspective.add(this.jSeparator10);
        this.menuCloseView.setAction((javax.swing.Action)this.cmCloseView);
        this.menuPerspective.add(this.menuCloseView);
        this.menuPerspective.add(this.jSeparator14);
        this.menuMaximizeSplitView.setAction((javax.swing.Action)this.cmMaximizeSplitView);
        this.menuPerspective.add(this.menuMaximizeSplitView);
        this.menuNavigation.setText("Navigation");
        this.menuSelectPerspective.setAction((javax.swing.Action)this.cmSelectPerspective);
        this.menuNavigation.add(this.menuSelectPerspective);
        this.menuSelectView.setAction((javax.swing.Action)this.cmSelectView);
        this.menuNavigation.add(this.menuSelectView);
        this.menuSelectTab.setAction((javax.swing.Action)this.cmSelectTab);
        this.menuNavigation.add(this.menuSelectTab);
        this.menuPerspective.add(this.menuNavigation);
        this.menuBarMain.add(this.menuPerspective);
        this.menuPerspectiveView.setMnemonic('W');
        this.menuPerspectiveView.setText(stringManager.getString("mf-menuPerspectiveView-text"));
        this.menuPerspectiveView.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent evt) {
            }

            @Override
            public void menuDeselected(MenuEvent evt) {
            }

            @Override
            public void menuSelected(MenuEvent evt) {
                MainFrame.this.menuPerspectiveViewMenuSelected(evt);
            }
        });
        this.menuBarMain.add(this.menuPerspectiveView);
        this.menuHelp.setText(stringManager.getString("mf-menuHelp-text"));
        this.menuUserGuide.setAction((javax.swing.Action)this.cmUserGuide);
        this.menuHelp.add(this.menuUserGuide);
        this.menuComponentShortcut.setAction((javax.swing.Action)this.cmComponentShortcut);
        this.menuHelp.add(this.menuComponentShortcut);
        this.menuDocumentation.setAction((javax.swing.Action)this.cmDocumentation);
        this.menuHelp.add(this.menuDocumentation);
        this.menuHelp.add(this.jSeparator17);
        this.menuPageProjectHome.setAction((javax.swing.Action)this.cmPageProjectHome);
        this.menuHelp.add(this.menuPageProjectHome);
        this.menuPageReviews.setAction((javax.swing.Action)this.cmPageReviews);
        this.menuHelp.add(this.menuPageReviews);
        this.menuPageDonations.setAction((javax.swing.Action)this.cmPageDonations);
        this.menuHelp.add(this.menuPageDonations);
        this.menuHelp.add(this.jSeparator16);
        this.menuLastChanges.setAction((javax.swing.Action)this.cmOrbadaLastChanges);
        this.menuHelp.add(this.menuLastChanges);
        this.menuGetUpdates.setAction((javax.swing.Action)this.cmGetUpdate);
        this.menuGetUpdates.setText("Pobierz aktualizacje...");
        this.menuHelp.add(this.menuGetUpdates);
        this.menuAboutOrbada.setAction((javax.swing.Action)this.cmAboutOrbada);
        this.menuHelp.add(this.menuAboutOrbada);
        this.menuBarMain.add(this.menuHelp);
        this.setJMenuBar(this.menuBarMain);
        this.pack();
    }

    private void cmDatabaseInfoActionPerformed(ActionEvent evt) {
        if (this.activePerspective != null && this.activePerspective.getDatabase() != null) {
            boolean found = false;
            DatabaseInfoProvider[] dip = (DatabaseInfoProvider[])Application.get().getServiceArray(DatabaseInfoProvider.class);
            if (dip != null && dip.length > 0) {
                for (int i = 0; i < dip.length; ++i) {
                    if (!dip[i].isForDatabase(this.activePerspective.getDatabase())) continue;
                    found = true;
                    MessageBox.show((Component)this, (String)stringManager.getString("mf-database-info"), (String)dip[i].getBanner(this.activePerspective.getDatabase()), (int)1);
                    break;
                }
            }
            if (!found) {
                try {
                    StringBuilder message = new StringBuilder();
                    message.append(stringManager.getString("mf-database-dd")).append(" ").append(this.activePerspective.getDatabase().getMetaData().getDatabaseProductName()).append(", ").append(this.activePerspective.getDatabase().getMetaData().getDatabaseProductVersion()).append("\n");
                    message.append(stringManager.getString("mf-driver-dd")).append(" ").append(this.activePerspective.getDatabase().getMetaData().getDriverName()).append(", ").append(this.activePerspective.getDatabase().getMetaData().getDriverVersion());
                    MessageBox.show((Component)this, (String)stringManager.getString("mf-database-info"), (String)message.toString(), (int)1);
                }
                catch (Exception ex) {
                    ExceptionUtil.processException((Throwable)ex);
                }
            }
        }
    }

    private void cmMaximizeSplitViewActionPerformed(ActionEvent evt) {
        JSplitPane split;
        Component comp = FocusManager.getCurrentManager().getFocusOwner();
        if (comp != null && (split = (JSplitPane)SwingUtil.getOwnerComponent(JSplitPane.class, (Component)comp)) != null) {
            int maxSize = split.getWidth();
            if (split.getOrientation() == 0) {
                maxSize = split.getHeight();
            }
            if (SwingUtil.isComponentOn((Component)split.getLeftComponent(), (Component)comp)) {
                if (split.getDividerLocation() < maxSize - 100) {
                    split.setDividerLocation(1.0);
                } else {
                    split.setDividerLocation(split.getLastDividerLocation());
                }
            }
            if (SwingUtil.isComponentOn((Component)split.getRightComponent(), (Component)comp)) {
                if (split.getDividerLocation() > 100) {
                    split.setDividerLocation(0.0);
                } else {
                    split.setDividerLocation(split.getLastDividerLocation());
                }
            }
        }
    }

    private void cmOrbadaSettingsActionPerformed(ActionEvent evt) {
        OrbadaSettingsDialog.showDialog();
    }

    private void cmMoveViewLeftActionPerformed(ActionEvent evt) {
        if (this.activePerspective != null) {
            this.activePerspective.moveViewLeft();
        }
    }

    private void cmMoveViewRightActionPerformed(ActionEvent evt) {
        if (this.activePerspective != null) {
            this.activePerspective.moveViewRight();
        }
    }

    private void cmSpecialPerspectiveActionPerformed(ActionEvent evt) {
        this.openPerspectiveFor(null, null);
    }

    private void cmSelectPerspectiveActionPerformed(ActionEvent evt) {
        PerspectivePanel c = SelectPerspectiveDialog.show(this.tabbedPerpectives, this.activePerspective);
        if (c != null) {
            this.setActivePerspective(c);
            this.tabbedPerpectives.setSelectedComponent(c);
        }
    }

    private void cmCloseAllPerspectivesActionPerformed(ActionEvent evt) {
        int i = 0;
        while (i < this.tabbedPerpectives.getTabCount()) {
            Component c = this.tabbedPerpectives.getComponentAt(i);
            if (c instanceof PerspectivePanel) {
                if (!this.closePerspective((PerspectivePanel)c)) {
                    ++i;
                }
            } else {
                ++i;
            }
            if (!this.cancelClose) continue;
            break;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.setActivePerspective((PerspectivePanel)MainFrame.this.tabbedPerpectives.getSelectedComponent());
            }
        });
    }

    private void cmDbReconnectActionPerformed(ActionEvent evt) {
        if (this.activePerspective != null && this.activePerspective.getDatabase() != null) {
            if (this.activePerspective.getDatabase().isConnected() && MessageBox.show((Component)this, (String)stringManager.getString("mf-connection"), (String)stringManager.getString("mf-reconnect-q"), (int[])ModalResult.YESNO, (int)3) == 6) {
                return;
            }
            try {
                this.activePerspective.getDatabase().close();
            }
            catch (Throwable ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
            try {
                IDatabaseProvider[] dpa;
                this.activePerspective.getDatabase().connect();
                for (IDatabaseProvider dp : dpa = (IDatabaseProvider[])Application.get().getServiceArray(IDatabaseProvider.class)) {
                    if (!dp.isForDatabase(this.activePerspective.getDatabase())) continue;
                    dp.afterConnection(this.activePerspective.getDatabase());
                }
            }
            catch (SQLException ex) {
                MessageBox.show((Component)this, (String)stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void menuPerspectiveViewMenuSelected(MenuEvent evt) {
        this.menuPerspectiveView.removeAll();
        if (this.activePerspective != null) {
            if (this.activePerspective.getGadgetServiceList().size() > 0) {
                JMenu menuGadgets = new JMenu(stringManager.getString("mf-perspective-tools"));
                for (PerpectiveGadgetProvider pg : this.activePerspective.getGadgetServiceList()) {
                    menuGadgets.add((Component)new JMenuItem((javax.swing.Action)((Object)new CreatePerspectiveGadgetAction(pg, this.activePerspective))), 0);
                }
                this.menuPerspectiveView.add(menuGadgets);
                this.menuPerspectiveView.addSeparator();
            }
            ViewProvider[] viewList = Utils.sortViewList((ViewProvider[])Application.get().getServiceArray(ViewProvider.class));
            boolean added = false;
            boolean defaultAdded = false;
            if (viewList != null && viewList.length > 0) {
                String groupName = "";
                for (ViewProvider vp : viewList) {
                    if (!vp.isForDatabase(this.activePerspective.getDatabase())) continue;
                    if (!groupName.equals(vp.getGroupName()) && added) {
                        this.menuPerspectiveView.addSeparator();
                    }
                    if (vp.isDefaultView()) {
                        if (!defaultAdded) {
                            this.menuPerspectiveView.insertSeparator(0);
                            defaultAdded = true;
                        }
                        this.menuPerspectiveView.insert((javax.swing.Action)((Object)new CreateViewAction(vp, this.activePerspective)), 0);
                    }
                    if (vp.getSubmenu() != null) {
                        for (String title : vp.getSubmenu()) {
                            if (title == null) {
                                if (vp.isDefaultView()) continue;
                                this.menuPerspectiveView.add((javax.swing.Action)((Object)new CreateViewAction(vp, this.activePerspective)));
                                continue;
                            }
                            JMenu submenu = null;
                            for (int i = 0; i < this.menuPerspectiveView.getItemCount(); ++i) {
                                Component c = this.menuPerspectiveView.getMenuComponent(i);
                                if (!(c instanceof JMenu) || !title.equals(((JMenu)c).getText())) continue;
                                submenu = (JMenu)c;
                                break;
                            }
                            if (submenu == null) {
                                submenu = new JMenu(title);
                                this.menuPerspectiveView.add(submenu);
                            }
                            submenu.add((javax.swing.Action)((Object)new CreateViewAction(vp, this.activePerspective)));
                        }
                    } else if (!vp.isDefaultView()) {
                        this.menuPerspectiveView.add((javax.swing.Action)((Object)new CreateViewAction(vp, this.activePerspective)));
                    }
                    groupName = vp.getGroupName() != null ? vp.getGroupName() : "";
                    added = true;
                }
            }
            this.menuPerspectiveView.addSeparator();
            this.menuPerspectiveView.add((javax.swing.Action)this.cmSelectView);
        }
    }

    private void cmNewPerspectiveActionPerformed(ActionEvent evt) {
        if (this.activePerspective != null) {
            this.newPerspectiveFor(this.activePerspective.getDatabase(), this.activePerspective.getSchema());
        }
    }

    private void cmClosePerspectiveActionPerformed(ActionEvent evt) {
        if (this.activePerspective != null && this.closePerspective(this.activePerspective)) {
            this.setActivePerspective(null);
        }
    }

    private void cmDriversActionPerformed(ActionEvent evt) {
        DriverListDialog.showDialog();
    }

    private void cmNewConnectionActionPerformed(ActionEvent evt) {
        SchemaListDialog.showDialog();
    }

    private void cmExitActionPerformed(ActionEvent evt) {
        this.shutDown(false);
    }

    private void cmPluginSettingsActionPerformed(ActionEvent evt) {
        PluginSettingsDialog.showDialog();
    }

    private void formComponentShown(ComponentEvent evt) {
        Application.get().postPluginMessage(new PluginMessage("orbada-system-plugin", "status-text", (Object)stringManager.getString("mf-orbada-started")));
        Application.get().postPluginMessage(new PluginMessage(null, "orbada-started", null));
    }

    private void cmCustomizeConnectionActionPerformed(ActionEvent evt) {
        if (this.activePerspective != null && this.activePerspective.getDatabase() != null) {
            PluginSettingsDialog.showDialog(this.activePerspective.getDatabase());
        }
    }

    private void cmDbRollbackActionPerformed(ActionEvent evt) {
        if (this.activePerspective != null && this.activePerspective.getDatabase() != null) {
            try {
                this.activePerspective.getDatabase().rollback();
            }
            catch (SQLException ex) {
                MessageBox.show((Component)SwingUtil.getRootFrame(), (String)stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmDbCommitActionPerformed(ActionEvent evt) {
        if (this.activePerspective != null && this.activePerspective.getDatabase() != null) {
            try {
                this.activePerspective.getDatabase().commit();
            }
            catch (SQLException ex) {
                MessageBox.show((Component)SwingUtil.getRootFrame(), (String)stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmOrbadaConfigFileActionPerformed(ActionEvent evt) {
        if (this.getToolsPerspective() == null) {
            this.openPerspectiveFor(null, null);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.tabbedPerpectives.setSelectedComponent(MainFrame.this.getToolsPerspective());
                MainFrame.this.getToolsPerspective().createView(new TextFileViewService(new File(Application.get().getConfigPath() + "/orbada.properties")), false, false);
            }
        });
    }

    private void cmToolsSettingsActionPerformed(ActionEvent evt) {
        ToolListDialog.showDialog();
        Application.get().getToolList().reload();
        this.reloadToolsMenu();
    }

    private void cmPluginManagerActionPerformed(ActionEvent evt) {
        PluginManagerDialog.showDialog();
    }

    private void cmChangeUserPasswordActionPerformed(ActionEvent evt) {
        ChangeUserPasswordDialog.showDialog();
    }

    private void cmUserPropertiesActionPerformed(ActionEvent evt) {
        UserPropertiesDialog.showDialog();
    }

    private void menuProgramMenuSelected(MenuEvent evt) {
        this.cmUserProperties.setText(String.format(stringManager.getString("mf-user-properties"), Application.get().getUserName()));
    }

    private void cmOrbadaLogFileActionPerformed(ActionEvent evt) {
        if (this.getToolsPerspective() == null) {
            this.openPerspectiveFor(null, null);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Enumeration e = Logger.getLogger("orbada").getAllAppenders();
                while (e.hasMoreElements()) {
                    final Object o = e.nextElement();
                    if (!(o instanceof FileAppender)) continue;
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MainFrame.this.tabbedPerpectives.setSelectedComponent(MainFrame.this.getToolsPerspective());
                            MainFrame.this.getToolsPerspective().createView(new TextFileViewService(new File(((FileAppender)o).getFile())), false, false);
                        }
                    });
                }
            }
        });
    }

    private void cmOrbadaLogErrorFileActionPerformed(ActionEvent evt) {
        if (this.getToolsPerspective() == null) {
            this.openPerspectiveFor(null, null);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Enumeration e = Logger.getLogger("error-logger").getAllAppenders();
                while (e.hasMoreElements()) {
                    final Object o = e.nextElement();
                    if (!(o instanceof FileAppender)) continue;
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MainFrame.this.tabbedPerpectives.setSelectedComponent(MainFrame.this.getToolsPerspective());
                            MainFrame.this.getToolsPerspective().createView(new TextFileViewService(new File(((FileAppender)o).getFile())), false, false);
                        }
                    });
                }
            }
        });
    }

    private void cmSelectNewPerspectiveActionPerformed(ActionEvent evt) {
        this.menuPerspectives.show((Component)this.buttonSelectNewPerspective, 0, this.buttonSelectNewPerspective.getHeight());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void menuPerspectivesPopupMenuWillBecomeVisible(PopupMenuEvent evt) {
        this.menuPerspectives.removeAll();
        if (this.activePerspective != null) {
            this.menuPerspectives.add((javax.swing.Action)this.cmNewPerspective);
            this.menuPerspectives.addSeparator();
            boolean added = false;
            Query query = InternalDatabase.get().createQuery();
            try {
                query.setSqlText("select * from perspectives where pps_usr_id = :usr_id and pps_sch_id = :sch_id order by pps_id");
                query.paramByName("usr_id").setString(Application.get().getUserId());
                query.paramByName("sch_id").setString(this.activePerspective.getSchema().getSchId());
                query.open();
                while (!query.eof()) {
                    Perspective perspective = new Perspective(InternalDatabase.get());
                    perspective.updateFrom(query);
                    JMenuItem item = this.menuPerspectives.add((javax.swing.Action)((Object)new CreatePerspectiveAction(perspective, this.activePerspective.getDatabase(), this.activePerspective.getSchema())));
                    if (perspective.getPpsId().equals(this.activePerspective.getPerspective().getPpsId())) {
                        Font font = item.getFont();
                        item.setFont(new Font(font.getName(), 1, font.getSize()));
                    }
                    added = true;
                    query.next();
                }
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
            finally {
                query.close();
            }
            if (added) {
                this.menuPerspectives.addSeparator();
            }
            this.menuPerspectives.add((javax.swing.Action)this.cmDeletePerspective);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void menuSelectNewPerspectiveMenuSelected(MenuEvent evt) {
        this.menuSelectNewPerspective.removeAll();
        if (this.activePerspective != null) {
            this.menuSelectNewPerspective.add((javax.swing.Action)this.cmNewPerspective);
            this.menuSelectNewPerspective.addSeparator();
            boolean added = false;
            Query query = InternalDatabase.get().createQuery();
            try {
                query.setSqlText("select * from perspectives where pps_usr_id = :usr_id and (pps_sch_id = :sch_id or (:sch_id is null and pps_sch_id is null)) order by pps_id");
                query.paramByName("usr_id").setString(Application.get().getUserId());
                if (this.activePerspective.getSchema() != null) {
                    query.paramByName("sch_id").setString(this.activePerspective.getSchema().getSchId());
                }
                query.open();
                while (!query.eof()) {
                    Perspective perspective = new Perspective(InternalDatabase.get());
                    perspective.updateFrom(query);
                    JMenuItem item = this.menuSelectNewPerspective.add((javax.swing.Action)((Object)new CreatePerspectiveAction(perspective, this.activePerspective.getDatabase(), this.activePerspective.getSchema())));
                    if (perspective.getPpsId().equals(this.activePerspective.getPerspective().getPpsId())) {
                        Font font = item.getFont();
                        item.setFont(new Font(font.getName(), 1, font.getSize()));
                    }
                    added = true;
                    query.next();
                }
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
            finally {
                query.close();
            }
            if (added) {
                this.menuSelectNewPerspective.addSeparator();
            }
            this.menuSelectNewPerspective.add((javax.swing.Action)this.cmDeletePerspective);
        }
    }

    private void cmDeletePerspectiveActionPerformed(ActionEvent evt) {
        if (this.activePerspective != null) {
            Perspective perspective = this.activePerspective.getPerspective();
            if (MessageBox.show((Component)this, (String)stringManager.getString("mf-perspective"), (String)String.format(stringManager.getString("mf-delete-current-perspective-q"), perspective.getName()), (int[])ModalResult.YESNO, (int)3) == 5) {
                this.cmClosePerspective.performe();
                try {
                    perspective.applyDelete();
                }
                catch (Exception ex) {
                    MessageBox.show((Component)this, (String)stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
                }
            }
        }
    }

    private void cmResetPerspectiveActionPerformed(ActionEvent evt) {
    }

    private void cmSelectViewActionPerformed(ActionEvent evt) {
        ViewAccesibilities va = SelectViewDialog.show(this.activePerspective);
        if (va != null) {
            this.activePerspective.getTabbedViews().setSelectedComponent(va.getViewComponent());
        }
    }

    private void cmTemplateSettingsActionPerformed(ActionEvent evt) {
        TemplateListDialog.showDialog();
    }

    private void cmViewProperitesActionPerformed(ActionEvent evt) {
        if (this.activePerspective != null && this.activePerspective.getTabbedViews().getSelectedComponent() != null) {
            ViewAccesibilities va = this.activePerspective.getViewAccesibilities(this.activePerspective.getTabbedViews().getSelectedComponent());
            ViewPropertiesDialog.showDialog(va);
        }
    }

    private void menuPerspectiveGadgetsMenuSelected(MenuEvent evt) {
        this.menuPerspectiveGadgets.removeAll();
        if (this.activePerspective != null) {
            for (PerpectiveGadgetProvider pg : this.activePerspective.getGadgetServiceList()) {
                this.menuPerspectiveGadgets.add((Component)new JMenuItem((javax.swing.Action)((Object)new CreatePerspectiveGadgetAction(pg, this.activePerspective))), 0);
            }
        }
    }

    private void cmSelectTabActionPerformed(ActionEvent evt) {
        SelectTabDialog.show(FocusManager.getCurrentManager().getFocusOwner());
    }

    private void cmCloseViewActionPerformed(ActionEvent evt) {
        if (this.activePerspective != null) {
            this.activePerspective.closeCurrentView();
        }
    }

    private void cmSuggestionRequestActionPerformed(ActionEvent evt) {
        RequestSuggestionDialog.showDialog();
    }

    private void cmProblemRequestActionPerformed(ActionEvent evt) {
        RequestProblemDialog.showDialog();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.shutDown(true);
    }

    private void cmComponentShortcutActionPerformed(ActionEvent evt) {
        ComponentActionMapDialog.showDialog();
    }

    private void cmUserGuideActionPerformed(ActionEvent evt) {
        Utils.gotoHelp();
    }

    private void cmGetUpdateActionPerformed(ActionEvent evt) {
        UpdateInfoDialog.showDialog();
    }

    private void cmOrbadaLastChangesActionPerformed(ActionEvent evt) {
        UpdateInfoDialog.showDialog();
    }

    private void cmDbDisconnectActionPerformed(ActionEvent evt) {
        if (MessageBox.show((Component)this, (String)stringManager.getString("mf-connection"), (String)stringManager.getString("mf-close-connection-with-database-q"), (int[])ModalResult.YESNO, (int)3) == 6) {
            return;
        }
        if (this.activePerspective != null && this.activePerspective.getDatabase() != null) {
            try {
                this.activePerspective.getDatabase().close();
            }
            catch (Throwable ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }

    private void cmUserListActionPerformed(ActionEvent evt) {
        UserListDialog.showDialog();
    }

    private void cmAboutOrbadaActionPerformed(ActionEvent evt) {
        AboutOrbadaDialog.showDialog();
    }

    private void cmOrbadaLog4jFileActionPerformed(ActionEvent evt) {
        if (this.getToolsPerspective() == null) {
            this.openPerspectiveFor(null, null);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.tabbedPerpectives.setSelectedComponent(MainFrame.this.getToolsPerspective());
                MainFrame.this.getToolsPerspective().createView(new TextFileViewService(new File(Application.get().getConfigPath() + "/log4j.xml")), false, false);
            }
        });
    }

    private void cmDocumentationActionPerformed(ActionEvent evt) {
        try {
            Desktop.getDesktop().browse(new URI("http://orbada.sourceforge.net/"));
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmPageProjectHomeActionPerformed(ActionEvent evt) {
        try {
            Desktop.getDesktop().browse(new URI("http://orbada.sourceforge.net/"));
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmPageReviewsActionPerformed(ActionEvent evt) {
        try {
            Desktop.getDesktop().browse(new URI("http://sourceforge.net/projects/orbada/reviews/"));
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmPageDonationsActionPerformed(ActionEvent evt) {
        try {
            Desktop.getDesktop().browse(new URI("http://sourceforge.net/project/project_donations.php?group_id=361699"));
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmFullScreenActionPerformed(ActionEvent evt) {
        WindowListener[] wl;
        for (WindowListener w : wl = this.getWindowListeners()) {
            this.removeWindowListener(w);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.fullScreenMode = !MainFrame.this.fullScreenMode;
                MainFrame.this.displayChanger.setDisplayMode(MainFrame.this.fullScreenMode);
                MainFrame.this.repaint();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        for (WindowListener w : wl) {
                            MainFrame.this.addWindowListener(w);
                        }
                    }
                });
            }
        });
    }

    private void cmDBStartTransactionActionPerformed(ActionEvent evt) {
        if (this.activePerspective != null && this.activePerspective.getDatabase() != null) {
            try {
                this.activePerspective.getDatabase().startTransaction();
            }
            catch (SQLException ex) {
                MessageBox.show((Component)SwingUtil.getRootFrame(), (String)stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmClonePerspectiveViewsActionPerformed(ActionEvent evt) {
        PerspectivePanel panel = SelectPerspectiveDialog.show(this.tabbedPerpectives, this.activePerspective, true);
        if (panel != null) {
            this.activePerspective.createPerspectiveViews(panel);
        }
    }
}

