/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pl.mpak.orbada.Consts;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.gui.comps.OrbadaJavaSyntaxDocument;
import pl.mpak.orbada.gui.comps.OrbadaSQLSyntaxDocument;
import pl.mpak.orbada.gui.comps.table.DataTable;
import pl.mpak.orbada.gui.util.FontChooser;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.PleaseWait;
import pl.mpak.orbada.plugins.providers.LookAndFeelProvider;
import pl.mpak.orbada.plugins.providers.PleaseWaitRendererProvider;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ComboBox;
import pl.mpak.sky.gui.swing.comp.HtmlEditorPane;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.sky.gui.swing.syntax.JavaSyntaxDocument;
import pl.mpak.sky.gui.swing.syntax.SQLSyntaxDocument;
import pl.mpak.sky.gui.swing.syntax.SyntaxDocument;
import pl.mpak.sky.gui.swing.syntax.SyntaxStyle;
import pl.mpak.sky.gui.swing.syntax.SyntaxTextArea;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class OrbadaSettingsDialog
extends JDialog {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);
    private ISettings settings;
    private SQLSyntaxDocument sqlDocument;
    private JavaSyntaxDocument javaDocument;
    private boolean updatingSyntaxControls;
    private PleaseWaitRendererProvider[] pwrpa;
    private LookAndFeelProvider[] lafpa;
    private PleaseWait waitTest;
    private ButtonGroup autoCompleteInsertion;
    private JButton buttonCancel;
    private JButton buttonOk;
    private JButton buttonSelect1;
    private JButton buttonSelect2;
    private JButton buttonSelect3;
    private JButton buttonSelect4;
    private JButton buttonSelect5;
    private JButton buttonSelect6;
    private JButton buttonSelect7;
    private JButton buttonSelect8;
    private JButton buttonTableDataFontChange;
    private JButton buttonTableDataFontChange1;
    private JButton buttonWaitTest;
    private JCheckBox checkAutoCompleteDot;
    private JCheckBox checkAutoCompleteInsertSingle;
    private JRadioButton checkAutoCompleteInsertion;
    private JRadioButton checkAutoCompleteReplace;
    private JCheckBox checkAutoCompleteStructureParser;
    private JCheckBox checkAutoCompleteStructureParserVariables;
    private JCheckBox checkAutoFitColumnWidth;
    private JCheckBox checkAutoSaveColumnWidths;
    private JCheckBox checkBigDecimalFormatDefault;
    private JCheckBox checkCloseWarning;
    private JCheckBox checkColorizedQueryTable;
    private JCheckBox checkCopySyntaxHighlight;
    private JCheckBox checkDateFormatDefault;
    private JCheckBox checkDecimalFormatDefault;
    private JCheckBox checkDecimalSeparatorDefault;
    private JCheckBox checkDefaultColorSelectedTableRow;
    private JCheckBox checkDefaultLookAndFeel;
    private JCheckBox checkDisableCheckUpdates;
    private JCheckBox checkDisableLoadSqlSyntaxInfo;
    private JCheckBox checkEditorBold;
    private JCheckBox checkEditorEnabled;
    private JCheckBox checkEditorItalic;
    private JCheckBox checkEditorTrimWhitespaces;
    private JCheckBox checkEditorUnderline;
    private JCheckBox checkNoRollbackOnClose;
    private JCheckBox checkNoViewTabPictures;
    private JCheckBox checkNoViewTabTitles;
    private JCheckBox checkOpenNewConnectionAtStartup;
    private JCheckBox checkPleaseWaitOn;
    private JCheckBox checkPredefinedSnippets;
    private JCheckBox checkProxyAuthNedded;
    private JCheckBox checkSmartHomeEnd;
    private JCheckBox checkTabAsSpaces;
    private JCheckBox checkTabMovesSelected;
    private JCheckBox checkTimeFormatDefault;
    private JCheckBox checkTimeStampFormatDefault;
    private Action cmCancel;
    private Action cmColorBool;
    private Action cmColorDate;
    private Action cmColorNull;
    private Action cmColorNumber;
    private Action cmColorSelectedRow;
    private Action cmColorString;
    private Action cmOk;
    private Action cmPleaseWaitTest;
    private Action cmSyntaxBackgroundColor;
    private Action cmSyntaxFontChange;
    private Action cmSyntaxForegroundColor;
    private Action cmSyntaxRestoreSettings;
    private Action cmTableDataFontChange;
    private ComboBox comboLookAndFeelService;
    private ComboBox comboPleaseWaitService;
    private ComboBox comboSyntaxes;
    private HtmlEditorPane htmlDateTimeFormatInfo;
    private HtmlEditorPane htmlDecimalFormatInfo;
    private JButton jButton8;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel10;
    private JPanel jPanel11;
    private JPanel jPanel12;
    private JPanel jPanel13;
    private JPanel jPanel14;
    private JPanel jPanel15;
    private JPanel jPanel16;
    private JPanel jPanel17;
    private JPanel jPanel2;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel9;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JSeparator jSeparator1;
    private JTabbedPane jTabbedPane2;
    private JLabel labelBigDecimalFormat;
    private JLabel labelBigDecimalFormatSample;
    private JLabel labelDateFormat;
    private JLabel labelDateFormatSample;
    private JLabel labelDecimalFormat;
    private JLabel labelDecimalFormatSample;
    private JLabel labelDecimalSeparator;
    private JLabel labelHttpProxyAddress;
    private JLabel labelHttpProxyPort;
    private JLabel labelLookAndFeel;
    private JLabel labelLookAndFeelInfo;
    private JLabel labelProxyAuthPassword;
    private JLabel labelProxyAuthUser;
    private JLabel labelSyntaxFont;
    private JLabel labelTableDataFont;
    private JLabel labelTimeFormat;
    private JLabel labelTimeFormatSample;
    private JLabel labelTimeStampFormat;
    private JLabel labelTimeStampFormatSample;
    private JLabel labeloPleaseWaitService;
    private JList listSyntaxElements;
    private JPanel panelApperance;
    private JPanel panelAutoIndent;
    private JPanel panelColorBool;
    private JPanel panelColorDate;
    private JPanel panelColorNull;
    private JPanel panelColorNumber;
    private JPanel panelColorSelectedTableRow;
    private JPanel panelColorString;
    private JPanel panelDataFormat;
    private JPanel panelDataList;
    private JPanel panelEditor;
    private JPanel panelEditorBackgroundColor;
    private JPanel panelEditorForegroundColor;
    private JPanel panelGeneral;
    private JPanel panelHighlight;
    private JPanel panelProxy;
    private JPanel panelTableDataFont;
    private JPanel panelTableDataFont1;
    private ButtonGroup proxyGroup;
    private JRadioButton radioManulProxy;
    private JRadioButton radioNoProxy;
    private JRadioButton radioUseSystemProxy;
    private JSpinner spinEvenRowShift;
    private JSpinner spinFocusedShift;
    private JSpinner spinTabToSpace;
    private JTabbedPane tabSettings;
    private TextField textAutoCompleteActivate;
    private TextField textAutoCompleteInactivate;
    private TextField textBigDecimalFormat;
    private TextField textDateFormat;
    private TextField textDecimalFormat;
    private TextField textDecimalSeparator;
    private SyntaxTextArea textEditorPreview;
    private TextField textHttpProxyAddress;
    private TextField textHttpProxyPort;
    private TextField textNullValue;
    private JPasswordField textProxyAuthPassword;
    private TextField textProxyAuthUser;
    private TextField textTimeFormat;
    private TextField textTimeStampFormat;

    public OrbadaSettingsDialog() {
        super(SwingUtil.getRootFrame());
        this.initComponents();
        this.init();
    }

    public static void showDialog() {
        OrbadaSettingsDialog dialog = new OrbadaSettingsDialog();
        dialog.setVisible(true);
    }

    public static void showDialog(Tab tab) {
        OrbadaSettingsDialog dialog = new OrbadaSettingsDialog();
        switch (tab) {
            case tabGeneral: {
                break;
            }
            case tabProxy: {
                dialog.tabSettings.setSelectedComponent(dialog.panelProxy);
                break;
            }
            case tabApperance: {
                dialog.tabSettings.setSelectedComponent(dialog.panelApperance);
                break;
            }
            case tabDataLists: {
                dialog.tabSettings.setSelectedComponent(dialog.panelDataList);
                break;
            }
            case tabDataFormat: {
                dialog.tabSettings.setSelectedComponent(dialog.panelDataFormat);
                break;
            }
            case tabSyntaxHighlighting: {
                dialog.tabSettings.setSelectedComponent(dialog.panelHighlight);
                break;
            }
            case tabEditor: {
                dialog.tabSettings.setSelectedComponent(dialog.panelEditor);
            }
        }
        dialog.setVisible(true);
    }

    private ListCellRenderer getSyntaxCellRenderer() {
        return new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof SyntaxStyle) {
                    this.setText(((SyntaxStyle)value).getName());
                }
                return this;
            }
        };
    }

    private void init() {
        this.prepareSyntaxes();
        this.spinEvenRowShift.setModel(new SpinnerNumberModel(15, -255, 255, 1));
        this.spinFocusedShift.setModel(new SpinnerNumberModel(30, -255, 255, 1));
        this.spinTabToSpace.setModel(new SpinnerNumberModel(2, 1, 20, 1));
        this.comboPleaseWaitService.setModel(new DefaultComboBoxModel());
        DefaultComboBoxModel mwModel = (DefaultComboBoxModel)this.comboPleaseWaitService.getModel();
        for (PleaseWaitRendererProvider pwrp : this.pwrpa = (PleaseWaitRendererProvider[])Application.get().getServiceArray(PleaseWaitRendererProvider.class)) {
            mwModel.addElement(pwrp.getDescription());
        }
        DefaultComboBoxModel lafModel = (DefaultComboBoxModel)this.comboLookAndFeelService.getModel();
        for (LookAndFeelProvider lafp : this.lafpa = (LookAndFeelProvider[])Application.get().getServiceArray(LookAndFeelProvider.class)) {
            lafModel.addElement(lafp.getDescription());
        }
        this.getRootPane().setDefaultButton(this.buttonOk);
        this.getRootPane().getInputMap(2).put(this.cmCancel.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmCancel);
        this.settings = Application.get().getSettings();
        this.settingsToDialog();
        this.comboSyntaxes.addItem((Object)this.sqlDocument);
        this.comboSyntaxes.addItem((Object)this.javaDocument);
        this.panelEditorBackgroundColor.setBackground(this.textEditorPreview.getEditorArea().getBackground());
        this.labelSyntaxFont.setFont(this.textEditorPreview.getEditorArea().getFont());
        StringBuilder sb = new StringBuilder();
        sb.append(stringManager.getString("OrbadaSettingsDialog-ed-data-types")).append("\n");
        sb.append(stringManager.getString("OrbadaSettingsDialog-ed-sql-functions")).append("\n");
        sb.append(stringManager.getString("OrbadaSettingsDialog-ed-identifiers")).append("\n");
        sb.append(stringManager.getString("OrbadaSettingsDialog-ed-keywords")).append("\n");
        sb.append(stringManager.getString("OrbadaSettingsDialog-ed-numbers")).append("\n");
        sb.append(stringManager.getString("OrbadaSettingsDialog-ed-strings")).append("\n");
        sb.append(stringManager.getString("OrbadaSettingsDialog-ed-symbols")).append("\n");
        sb.append(stringManager.getString("OrbadaSettingsDialog-ed-tables")).append("\n");
        sb.append(stringManager.getString("OrbadaSettingsDialog-ed-exceptions")).append("\n");
        sb.append(stringManager.getString("OrbadaSettingsDialog-ed-user-functions")).append("\n");
        sb.append(stringManager.getString("OrbadaSettingsDialog-ed-command-parameters")).append("\n");
        sb.append(stringManager.getString("OrbadaSettingsDialog-ed-doc-keys")).append("\n");
        sb.append(stringManager.getString("OrbadaSettingsDialog-ed-html-tags")).append("\n");
        sb.append(stringManager.getString("OrbadaSettingsDialog-ed-hints-or-java-doc")).append("\n");
        sb.append(stringManager.getString("OrbadaSettingsDialog-ed-one-line-comment")).append("\n");
        sb.append(stringManager.getString("OrbadaSettingsDialog-ed-annotations"));
        this.textEditorPreview.setText(sb.toString());
        SwingUtil.setButtonSizesTheSame((AbstractButton[])new AbstractButton[]{this.buttonOk, this.buttonCancel});
        SwingUtil.setButtonSizesTheSame((AbstractButton[])new AbstractButton[]{this.buttonWaitTest}, (int)this.comboPleaseWaitService.getHeight());
        SwingUtil.setButtonSizesTheSame((AbstractButton[])new AbstractButton[]{this.buttonSelect1, this.buttonSelect2, this.buttonSelect3, this.buttonSelect4, this.buttonSelect5, this.buttonSelect6, this.buttonSelect7, this.buttonSelect8});
        this.pack();
        SwingUtil.centerWithinScreen((Window)this);
    }

    @Override
    public void dispose() {
        if (this.waitTest != null) {
            this.cmPleaseWaitTest.performe();
        }
        super.dispose();
    }

    private void prepareSyntaxes() {
        this.comboSyntaxes.setModel(new DefaultComboBoxModel());
        this.sqlDocument = new SQLSyntaxDocument();
        this.sqlDocument.addKeyWord("CHARACTER,DATE,INTEGER", 10);
        this.sqlDocument.addKeyWord("UPPER,LOWER,MAX,AVG", 8);
        this.sqlDocument.addKeyWord("POLE,NAZWA", 12);
        this.sqlDocument.addKeyWord("SELECT,FROM,WHERE,NULL", 1);
        this.sqlDocument.addKeyWord("CUSTOM,ADDRS", 4);
        this.sqlDocument.addKeyWord("NO_DATA_FOUND", 7);
        this.sqlDocument.addKeyWord("GETSYSTEMDATE", 9);
        this.javaDocument = new JavaSyntaxDocument();
        this.javaDocument.addKeyWord("CHARACTER,DATE,INTEGER", 10);
        this.javaDocument.addKeyWord("@Column", 11);
        this.javaDocument.addKeyWord("POLE,NAZWA", 8);
        this.javaDocument.addKeyWord("SELECT,FROM,WHERE,NULL", 1);
        this.javaDocument.addKeyWord("CUSTOM,ADDRS", 2);
        this.javaDocument.addKeyWord("NO_DATA_FOUND", 7);
        this.listSyntaxElements.setCellRenderer(this.getSyntaxCellRenderer());
    }

    private void settingsToDialog() {
        this.checkOpenNewConnectionAtStartup.setSelected(this.settings.getValue("new-connection-at-startup", Boolean.valueOf(true)));
        this.checkAutoFitColumnWidth.setSelected(this.settings.getValue("data-table-auto-fit-width", Boolean.valueOf(true)));
        this.textNullValue.setText(this.settings.getValue("query-table-null-value", QueryTableCellRenderer.nullValue));
        this.checkDisableLoadSqlSyntaxInfo.setSelected(this.settings.getValue("disable-load-sql-syntax-info", Boolean.valueOf(false)));
        this.checkDisableCheckUpdates.setSelected(this.settings.getValue("disable-check-updates", Boolean.valueOf(false)));
        this.checkNoRollbackOnClose.setSelected(this.settings.getValue("no-rollback-on-close", Boolean.valueOf(false)));
        this.checkCloseWarning.setSelected(this.settings.getValue("app-close-warning", Boolean.valueOf(false)));
        if (StringUtil.equalsIgnoreCase((String)this.settings.getValue("proxy-settings", "system-proxy"), (String)"no-proxy")) {
            this.radioNoProxy.setSelected(true);
        } else if (StringUtil.equalsIgnoreCase((String)this.settings.getValue("proxy-settings", "system-proxy"), (String)"system-proxy")) {
            this.radioUseSystemProxy.setSelected(true);
        } else if (StringUtil.equalsIgnoreCase((String)this.settings.getValue("proxy-settings", "system-proxy"), (String)"manual-proxy")) {
            this.radioManulProxy.setSelected(true);
        }
        this.textHttpProxyAddress.setText(this.settings.getValue("proxy-http-address", ""));
        this.textHttpProxyPort.setText(this.settings.getValue("proxy-http-port", ""));
        this.checkProxyAuthNedded.setSelected(this.settings.getValue("proxy-auth-needed", Boolean.valueOf(false)));
        this.textProxyAuthUser.setText(this.settings.getValue("proxy-auth-user", ""));
        this.textProxyAuthPassword.setText(this.settings.getValue("proxy-auth-password", ""));
        this.checkColorizedQueryTable.setSelected(this.settings.getValue("colorized-query-table", Boolean.valueOf(QueryTableCellRenderer.colorizedCells)));
        this.panelColorNumber.setBackground(this.settings.getValue("query-table-color-number", QueryTableCellRenderer.numberColor));
        this.panelColorString.setBackground(this.settings.getValue("query-table-color-string", QueryTableCellRenderer.stringColor));
        this.panelColorBool.setBackground(this.settings.getValue("query-table-color-boolean", QueryTableCellRenderer.boolColor));
        this.panelColorDate.setBackground(this.settings.getValue("query-table-color-date", QueryTableCellRenderer.dateColor));
        this.panelColorNull.setBackground(this.settings.getValue("query-table-color-null", QueryTableCellRenderer.nullColor));
        this.panelColorSelectedTableRow.setBackground(this.settings.getValue("color-selected-table-row", QueryTableCellRenderer.selectionBackground));
        this.checkDefaultColorSelectedTableRow.setSelected(this.settings.getValue("default-color-selected-table-row", Boolean.valueOf(false)));
        this.spinEvenRowShift.setValue(this.settings.getValue("table-even-row-shift", Long.valueOf(15L)).intValue());
        this.spinFocusedShift.setValue(this.settings.getValue("table-focused-column-shift", Long.valueOf(30L)).intValue());
        this.labelTableDataFont.setFont(this.settings.getValue("query-table-data-font", DataTable.dataFont));
        this.checkNoViewTabPictures.setSelected(this.settings.getValue("no-view-tab-pictures", Boolean.valueOf(false)));
        this.checkNoViewTabTitles.setSelected(this.settings.getValue("no-view-tab-titles", Boolean.valueOf(false)));
        this.checkAutoSaveColumnWidths.setSelected(this.settings.getValue("auto-save-column-widths", Boolean.valueOf(true)));
        OrbadaSQLSyntaxDocument.loadSettings((SyntaxDocument)this.sqlDocument);
        OrbadaJavaSyntaxDocument.loadSettings((SyntaxDocument)this.javaDocument);
        this.textEditorPreview.getEditorArea().setBackground(this.settings.getValue("syntax-editor-background-color", this.textEditorPreview.getEditorArea().getBackground()));
        this.textEditorPreview.getEditorArea().setFont(this.settings.getValue("syntax-editor-font", this.textEditorPreview.getEditorArea().getFont()));
        String pwId = this.settings.getValue("please-wait-renderer", "orbada-default-please-wait-renderer");
        for (int i = 0; i < this.pwrpa.length; ++i) {
            if (!pwId.equalsIgnoreCase(this.pwrpa[i].getRendererId())) continue;
            this.comboPleaseWaitService.setSelectedIndex(i);
            break;
        }
        if (this.comboPleaseWaitService.getSelectedIndex() == -1) {
            this.comboPleaseWaitService.setSelectedIndex(0);
        }
        this.checkPleaseWaitOn.setSelected(this.settings.getValue("please-wait-renderer-on", Boolean.valueOf(true)));
        String lafId = this.settings.getValue("look-and-feel", "");
        for (int i = 0; i < this.lafpa.length; ++i) {
            if (!lafId.equalsIgnoreCase(this.lafpa[i].getLookAndFeelId())) continue;
            this.comboLookAndFeelService.setSelectedIndex(i);
            break;
        }
        if (this.comboLookAndFeelService.getSelectedIndex() == -1) {
            this.comboLookAndFeelService.setSelectedIndex(0);
        }
        this.checkDefaultLookAndFeel.setSelected(this.settings.getValue("look-and-feel-default", Boolean.valueOf(true)));
        this.checkTabMovesSelected.setSelected(this.settings.getValue("editor-tab-moves-selected", Boolean.valueOf(true)));
        this.checkCopySyntaxHighlight.setSelected(this.settings.getValue("copy-syntax-highlight", Boolean.valueOf(true)));
        this.checkEditorTrimWhitespaces.setSelected(this.settings.getValue("editor-trim-whitespaces", Boolean.valueOf(false)));
        this.checkSmartHomeEnd.setSelected(this.settings.getValue("editor-smart-home-end", Boolean.valueOf(false)));
        this.checkPredefinedSnippets.setSelected(this.settings.getValue("editor-pre-defined-snippets", Boolean.valueOf(true)));
        this.checkAutoCompleteDot.setSelected(this.settings.getValue("editor-auto-complete-dot", Boolean.valueOf(true)));
        this.textAutoCompleteActivate.setText(this.settings.getValue("editor-auto-complete-activate-chars", "."));
        this.textAutoCompleteInactivate.setText(this.settings.getValue("editor-auto-complete-inactivate-chars", ",;"));
        this.checkAutoCompleteInsertion.setSelected(this.settings.getValue("editor-auto-complete-insertion", Boolean.valueOf(false)));
        this.checkAutoCompleteReplace.setSelected(this.settings.getValue("editor-auto-complete-insertion", Boolean.valueOf(false)) == false);
        this.checkAutoCompleteInsertSingle.setSelected(this.settings.getValue("editor-auto-complete-insert-single", Boolean.valueOf(false)));
        this.checkAutoCompleteStructureParser.setSelected(this.settings.getValue("editor-auto-complete-structure-parser", Boolean.valueOf(true)));
        this.checkAutoCompleteStructureParserVariables.setSelected(this.settings.getValue("editor-tab-to-space-count", Boolean.valueOf(true)));
        this.spinTabToSpace.setValue(this.settings.getValue("editor-tab-to-space-count", Long.valueOf(2L)).intValue());
        this.checkTabAsSpaces.setSelected(this.settings.getValue("editor-tab-as-spaces", Boolean.valueOf(false)));
        this.checkDateFormatDefault.setSelected(this.settings.getValue("data-format-date-default", Boolean.valueOf(true)));
        this.textDateFormat.setText(this.settings.getValue("data-format-date-string", "yyyy-MM-dd hh:mm:ss"));
        this.checkTimeFormatDefault.setSelected(this.settings.getValue("data-format-time-default", Boolean.valueOf(true)));
        this.textTimeFormat.setText(this.settings.getValue("data-format-time-string", "hh:mm:ss"));
        this.checkTimeStampFormatDefault.setSelected(this.settings.getValue("data-format-timestamp-default", Boolean.valueOf(true)));
        this.textTimeStampFormat.setText(this.settings.getValue("data-format-timestamp-string", "yyyy-MM-dd hh:mm:ss.SSS"));
        this.checkDecimalFormatDefault.setSelected(this.settings.getValue("data-format-numeric-default", Boolean.valueOf(true)));
        this.textDecimalFormat.setText(this.settings.getValue("data-format-numeric-string", ",##0.####################"));
        this.checkBigDecimalFormatDefault.setSelected(this.settings.getValue("data-format-bigdecimal-default", Boolean.valueOf(true)));
        this.textBigDecimalFormat.setText(this.settings.getValue("data-format-bigdecimal-string", ",##0.####################"));
        this.checkDecimalSeparatorDefault.setSelected(this.settings.getValue("data-format-decimal-separator-default", Boolean.valueOf(false)));
        this.textDecimalSeparator.setText(this.settings.getValue("data-format-decimal-separator", "."));
        this.setLookAndFeelEnabled();
        this.setDataTypeEnabled();
        this.setPleaseWaitEnabled();
        this.setProxyEnabled();
        this.updateSampleDateTimeFormat();
        this.updateSampleDecimalFormat();
    }

    private void dialogToSettings() {
        String lastLafClass = null;
        this.settings.setValue("new-connection-at-startup", Boolean.valueOf(this.checkOpenNewConnectionAtStartup.isSelected()));
        this.settings.setValue("data-table-auto-fit-width", Boolean.valueOf(this.checkAutoFitColumnWidth.isSelected()));
        this.settings.setValue("query-table-null-value", this.textNullValue.getText());
        this.settings.setValue("disable-load-sql-syntax-info", Boolean.valueOf(this.checkDisableLoadSqlSyntaxInfo.isSelected()));
        this.settings.setValue("disable-check-updates", Boolean.valueOf(this.checkDisableCheckUpdates.isSelected()));
        this.settings.setValue("no-rollback-on-close", Boolean.valueOf(this.checkNoRollbackOnClose.isSelected()));
        this.settings.setValue("app-close-warning", Boolean.valueOf(this.checkCloseWarning.isSelected()));
        if (this.radioNoProxy.isSelected()) {
            this.settings.setValue("proxy-settings", "no-proxy");
        } else if (this.radioUseSystemProxy.isSelected()) {
            this.settings.setValue("proxy-settings", "system-proxy");
        } else if (this.radioManulProxy.isSelected()) {
            this.settings.setValue("proxy-settings", "manual-proxy");
        }
        this.settings.setValue("proxy-http-address", this.textHttpProxyAddress.getText());
        this.settings.setValue("proxy-http-port", this.textHttpProxyPort.getText());
        this.settings.setValue("proxy-auth-needed", Boolean.valueOf(this.checkProxyAuthNedded.isSelected()));
        this.settings.setValue("proxy-auth-user", this.textProxyAuthUser.getText());
        this.settings.setValue("proxy-auth-password", new String(this.textProxyAuthPassword.getPassword()));
        this.settings.setValue("colorized-query-table", Boolean.valueOf(this.checkColorizedQueryTable.isSelected()));
        this.settings.setValue("query-table-color-number", this.panelColorNumber.getBackground());
        this.settings.setValue("query-table-color-string", this.panelColorString.getBackground());
        this.settings.setValue("query-table-color-boolean", this.panelColorBool.getBackground());
        this.settings.setValue("query-table-color-date", this.panelColorDate.getBackground());
        this.settings.setValue("query-table-color-null", this.panelColorNull.getBackground());
        this.settings.setValue("color-selected-table-row", this.panelColorSelectedTableRow.getBackground());
        this.settings.setValue("default-color-selected-table-row", Boolean.valueOf(this.checkDefaultColorSelectedTableRow.isSelected()));
        this.settings.setValue("table-even-row-shift", Long.valueOf(((Integer)this.spinEvenRowShift.getValue()).intValue()));
        this.settings.setValue("table-focused-column-shift", Long.valueOf(((Integer)this.spinFocusedShift.getValue()).intValue()));
        this.settings.setValue("query-table-data-font", this.labelTableDataFont.getFont());
        this.settings.setValue("no-view-tab-pictures", Boolean.valueOf(this.checkNoViewTabPictures.isSelected()));
        this.settings.setValue("no-view-tab-titles", Boolean.valueOf(this.checkNoViewTabTitles.isSelected()));
        this.settings.getValue("auto-save-column-widths", Boolean.valueOf(this.checkAutoSaveColumnWidths.isSelected()));
        OrbadaSQLSyntaxDocument.storeSettings((SyntaxDocument)this.sqlDocument);
        OrbadaJavaSyntaxDocument.storeSettings((SyntaxDocument)this.javaDocument);
        this.settings.setValue("syntax-editor-background-color", this.textEditorPreview.getEditorArea().getBackground());
        this.settings.setValue("syntax-editor-font", this.textEditorPreview.getEditorArea().getFont());
        this.settings.setValue("please-wait-renderer", this.pwrpa[this.comboPleaseWaitService.getSelectedIndex()].getRendererId());
        this.settings.setValue("please-wait-renderer-on", Boolean.valueOf(this.checkPleaseWaitOn.isSelected()));
        if (this.comboLookAndFeelService.getSelectedIndex() >= 0) {
            this.settings.setValue("look-and-feel", this.lafpa[this.comboLookAndFeelService.getSelectedIndex()].getLookAndFeelId());
        } else {
            this.settings.setValue("look-and-feel", (String)null);
        }
        this.settings.setValue("look-and-feel-default", Boolean.valueOf(this.checkDefaultLookAndFeel.isSelected()));
        if (!this.checkDefaultLookAndFeel.isSelected() && this.comboLookAndFeelService.getSelectedIndex() >= 0) {
            lastLafClass = Application.get().localProperties.getProperty("orbada.laf.class");
            Application.get().localProperties.setProperty("orbada.laf.class", this.lafpa[this.comboLookAndFeelService.getSelectedIndex()].getLookAndFeelClass().getName());
        } else {
            Application.get().localProperties.keySet().remove("orbada.laf.class");
        }
        this.settings.setValue("editor-tab-moves-selected", Boolean.valueOf(this.checkTabMovesSelected.isSelected()));
        this.settings.setValue("copy-syntax-highlight", Boolean.valueOf(this.checkCopySyntaxHighlight.isSelected()));
        this.settings.setValue("editor-trim-whitespaces", Boolean.valueOf(this.checkEditorTrimWhitespaces.isSelected()));
        this.settings.setValue("editor-smart-home-end", Boolean.valueOf(this.checkSmartHomeEnd.isSelected()));
        this.settings.setValue("editor-pre-defined-snippets", Boolean.valueOf(this.checkPredefinedSnippets.isSelected()));
        this.settings.setValue("editor-auto-complete-dot", Boolean.valueOf(this.checkAutoCompleteDot.isSelected()));
        this.settings.setValue("editor-auto-complete-activate-chars", this.textAutoCompleteActivate.getText());
        this.settings.setValue("editor-auto-complete-inactivate-chars", this.textAutoCompleteInactivate.getText());
        this.settings.setValue("editor-auto-complete-insertion", Boolean.valueOf(this.checkAutoCompleteInsertion.isSelected()));
        this.settings.setValue("editor-auto-complete-insert-single", Boolean.valueOf(this.checkAutoCompleteInsertSingle.isSelected()));
        this.settings.setValue("editor-auto-complete-structure-parser", Boolean.valueOf(this.checkAutoCompleteStructureParser.isSelected()));
        this.settings.setValue("editor-auto-complete-structure-parser-variables", Boolean.valueOf(this.checkAutoCompleteStructureParserVariables.isSelected()));
        this.settings.setValue("editor-tab-to-space-count", Long.valueOf(((Integer)this.spinTabToSpace.getValue()).intValue()));
        this.settings.setValue("editor-tab-as-spaces", Boolean.valueOf(this.checkTabAsSpaces.isSelected()));
        this.settings.setValue("data-format-date-default", Boolean.valueOf(this.checkDateFormatDefault.isSelected()));
        this.settings.setValue("data-format-date-string", this.textDateFormat.getText());
        this.settings.setValue("data-format-time-default", Boolean.valueOf(this.checkTimeFormatDefault.isSelected()));
        this.settings.setValue("data-format-time-string", this.textTimeFormat.getText());
        this.settings.setValue("data-format-timestamp-default", Boolean.valueOf(this.checkTimeStampFormatDefault.isSelected()));
        this.settings.setValue("data-format-timestamp-string", this.textTimeStampFormat.getText());
        this.settings.setValue("data-format-numeric-default", Boolean.valueOf(this.checkDecimalFormatDefault.isSelected()));
        this.settings.setValue("data-format-numeric-string", this.textDecimalFormat.getText());
        this.settings.setValue("data-format-bigdecimal-default", Boolean.valueOf(this.checkBigDecimalFormatDefault.isSelected()));
        this.settings.setValue("data-format-bigdecimal-string", this.textBigDecimalFormat.getText());
        this.settings.setValue("data-format-decimal-separator-default", Boolean.valueOf(this.checkDecimalSeparatorDefault.isSelected()));
        this.settings.setValue("data-format-decimal-separator", this.textDecimalSeparator.getText());
        this.settings.store();
        Application.get().getMainFrame().applySettings();
        if (!StringUtil.equals((String)lastLafClass, (String)Application.get().localProperties.getProperty("orbada.laf.class"))) {
            Application.get().updateLAF();
        }
    }

    private void changeDataColor(JPanel panel) {
        Color color = JColorChooser.showDialog(this, stringManager.getString("OrbadaSettingsDialog-select-color"), panel.getBackground());
        if (color != null) {
            panel.setBackground(color);
        }
    }

    private void listToSyntaxDocument(SyntaxDocument doc) {
        SyntaxStyle[] styles = new SyntaxStyle[doc.getStyleMap().size()];
        DefaultListModel<SyntaxStyle> model = new DefaultListModel<SyntaxStyle>();
        int index = 0;
        Iterator i$ = doc.getStyleMap().values().iterator();
        while (i$.hasNext()) {
            SyntaxStyle style;
            styles[index] = style = (SyntaxStyle)i$.next();
            ++index;
        }
        Arrays.sort(styles, new Comparator<SyntaxStyle>(){

            @Override
            public int compare(SyntaxStyle o1, SyntaxStyle o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (SyntaxStyle style : styles) {
            model.addElement(style);
        }
        this.listSyntaxElements.setModel(model);
        this.listSyntaxElements.setSelectedIndex(0);
    }

    private void syntaxDocumentToList(SyntaxDocument doc) {
    }

    private void updateSyntaxStyle() {
        if (!this.updatingSyntaxControls && this.comboSyntaxes.getSelectedItem() instanceof SyntaxDocument) {
            SyntaxDocument doc = (SyntaxDocument)this.comboSyntaxes.getSelectedItem();
            if (this.listSyntaxElements.getSelectedValue() instanceof SyntaxStyle) {
                SyntaxStyle style = (SyntaxStyle)this.listSyntaxElements.getSelectedValue();
                style.setForeground(this.panelEditorForegroundColor.getBackground());
                style.setBold(this.checkEditorBold.isSelected());
                style.setItalic(this.checkEditorItalic.isSelected());
                style.setUnderline(this.checkEditorUnderline.isSelected());
                style.setEnabled(this.checkEditorEnabled.isSelected());
                this.textEditorPreview.repaint();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateListSyntaxElement() {
        this.updatingSyntaxControls = true;
        try {
            this.listSyntaxElements.setEnabled(this.comboSyntaxes.getSelectedItem() instanceof SyntaxDocument);
            this.cmSyntaxForegroundColor.setEnabled(this.listSyntaxElements.getSelectedValue() instanceof SyntaxStyle);
            this.checkEditorBold.setEnabled(this.listSyntaxElements.getSelectedValue() instanceof SyntaxStyle);
            this.checkEditorItalic.setEnabled(this.listSyntaxElements.getSelectedValue() instanceof SyntaxStyle);
            this.checkEditorUnderline.setEnabled(this.listSyntaxElements.getSelectedValue() instanceof SyntaxStyle);
            this.checkEditorEnabled.setEnabled(this.listSyntaxElements.getSelectedValue() instanceof SyntaxStyle);
            if (this.comboSyntaxes.getSelectedItem() instanceof SyntaxDocument) {
                SyntaxDocument doc = (SyntaxDocument)this.comboSyntaxes.getSelectedItem();
                if (this.listSyntaxElements.getSelectedValue() instanceof SyntaxStyle) {
                    SyntaxStyle style = (SyntaxStyle)this.listSyntaxElements.getSelectedValue();
                    this.panelEditorForegroundColor.setBackground(style.getForeground());
                    this.checkEditorBold.setSelected(style.isBold());
                    this.checkEditorItalic.setSelected(style.isItalic());
                    this.checkEditorUnderline.setSelected(style.isUnderline());
                    this.checkEditorEnabled.setSelected(style.isEnabled());
                }
            }
        }
        finally {
            this.updatingSyntaxControls = false;
        }
    }

    private void setLookAndFeelEnabled() {
        this.labelLookAndFeel.setEnabled(!this.checkDefaultLookAndFeel.isSelected());
        this.comboLookAndFeelService.setEnabled(!this.checkDefaultLookAndFeel.isSelected());
    }

    private void setDataTypeEnabled() {
        this.labelDateFormat.setEnabled(!this.checkDateFormatDefault.isSelected());
        this.textDateFormat.setEnabled(!this.checkDateFormatDefault.isSelected());
        this.labelTimeFormat.setEnabled(!this.checkTimeFormatDefault.isSelected());
        this.textTimeFormat.setEnabled(!this.checkTimeFormatDefault.isSelected());
        this.labelTimeStampFormat.setEnabled(!this.checkTimeStampFormatDefault.isSelected());
        this.textTimeStampFormat.setEnabled(!this.checkTimeStampFormatDefault.isSelected());
        this.labelDecimalFormat.setEnabled(!this.checkDecimalFormatDefault.isSelected());
        this.textDecimalFormat.setEnabled(!this.checkDecimalFormatDefault.isSelected());
        this.labelBigDecimalFormat.setEnabled(!this.checkBigDecimalFormatDefault.isSelected());
        this.textBigDecimalFormat.setEnabled(!this.checkBigDecimalFormatDefault.isSelected());
        this.labelDecimalSeparator.setEnabled(!this.checkDecimalSeparatorDefault.isSelected());
        this.textDecimalSeparator.setEnabled(!this.checkDecimalSeparatorDefault.isSelected());
    }

    private void setPleaseWaitEnabled() {
        this.labeloPleaseWaitService.setEnabled(this.checkPleaseWaitOn.isSelected());
        this.comboPleaseWaitService.setEnabled(this.checkPleaseWaitOn.isSelected());
    }

    private void setProxyEnabled() {
        boolean manual = this.radioManulProxy.isSelected();
        this.labelHttpProxyAddress.setEnabled(manual);
        this.textHttpProxyAddress.setEnabled(manual);
        this.labelHttpProxyPort.setEnabled(manual);
        this.textHttpProxyPort.setEnabled(manual);
        this.checkProxyAuthNedded.setEnabled(manual);
        this.labelProxyAuthUser.setEnabled(manual && this.checkProxyAuthNedded.isSelected());
        this.textProxyAuthUser.setEnabled(manual && this.checkProxyAuthNedded.isSelected());
        this.labelProxyAuthPassword.setEnabled(manual && this.checkProxyAuthNedded.isSelected());
        this.textProxyAuthPassword.setEnabled(manual && this.checkProxyAuthNedded.isSelected());
    }

    private void updateSampleDateTimeFormat() {
        if (this.checkDateFormatDefault.isSelected()) {
            this.labelDateFormatSample.setText(DateFormat.getDateTimeInstance().format(new Date()));
        } else {
            try {
                this.labelDateFormatSample.setText(new SimpleDateFormat(this.textDateFormat.getText()).format(new Date()));
            }
            catch (IllegalArgumentException ex) {
                this.labelDateFormatSample.setText(ex.getMessage());
            }
        }
        if (this.checkTimeFormatDefault.isSelected()) {
            this.labelTimeFormatSample.setText(DateFormat.getTimeInstance().format(new Date()));
        } else {
            try {
                this.labelTimeFormatSample.setText(new SimpleDateFormat(this.textTimeFormat.getText()).format(new Date()));
            }
            catch (IllegalArgumentException ex) {
                this.labelTimeFormatSample.setText(ex.getMessage());
            }
        }
        if (this.checkTimeStampFormatDefault.isSelected()) {
            this.labelTimeStampFormatSample.setText(DateFormat.getDateTimeInstance().format(new Date()));
        } else {
            try {
                this.labelTimeStampFormatSample.setText(new SimpleDateFormat(this.textTimeStampFormat.getText()).format(new Date()));
            }
            catch (IllegalArgumentException ex) {
                this.labelTimeStampFormatSample.setText(ex.getMessage());
            }
        }
    }

    private void updateSampleDecimalFormat() {
        NumberFormat df;
        DecimalFormatSymbols unusualSymbols = null;
        if (!this.checkDecimalSeparatorDefault.isSelected() && !StringUtil.isEmpty((String)this.textDecimalSeparator.getText())) {
            unusualSymbols = new DecimalFormatSymbols();
            unusualSymbols.setDecimalSeparator(this.textDecimalSeparator.getText().charAt(0));
        }
        if (this.checkDecimalFormatDefault.isSelected()) {
            df = DecimalFormat.getNumberInstance();
            df.setMaximumFractionDigits(20);
            this.labelDecimalFormatSample.setText(df.format(1.2345678901234567E9));
        } else {
            try {
                if (unusualSymbols != null) {
                    this.labelDecimalFormatSample.setText(new DecimalFormat(this.textDecimalFormat.getText(), unusualSymbols).format(1.2345678901234567E9));
                } else {
                    this.labelDecimalFormatSample.setText(new DecimalFormat(this.textDecimalFormat.getText()).format(1.2345678901234567E9));
                }
            }
            catch (IllegalArgumentException ex) {
                this.labelDecimalFormatSample.setText(ex.getMessage());
            }
        }
        if (this.checkBigDecimalFormatDefault.isSelected()) {
            df = DecimalFormat.getNumberInstance();
            df.setMaximumFractionDigits(20);
            this.labelBigDecimalFormatSample.setText(df.format(new BigDecimal("1234567890.1234567890")));
        } else {
            try {
                if (unusualSymbols != null) {
                    this.labelBigDecimalFormatSample.setText(new DecimalFormat(this.textBigDecimalFormat.getText(), unusualSymbols).format(new BigDecimal("1234567890.1234567890")));
                } else {
                    this.labelBigDecimalFormatSample.setText(new DecimalFormat(this.textBigDecimalFormat.getText()).format(new BigDecimal("1234567890.1234567890")));
                }
            }
            catch (IllegalArgumentException ex) {
                this.labelBigDecimalFormatSample.setText(ex.getMessage());
            }
        }
    }

    private void initComponents() {
        this.cmOk = new Action();
        this.cmCancel = new Action();
        this.cmColorNumber = new Action();
        this.cmColorString = new Action();
        this.cmColorDate = new Action();
        this.cmColorBool = new Action();
        this.cmColorNull = new Action();
        this.cmTableDataFontChange = new Action();
        this.cmSyntaxBackgroundColor = new Action();
        this.cmSyntaxForegroundColor = new Action();
        this.cmSyntaxRestoreSettings = new Action();
        this.cmSyntaxFontChange = new Action();
        this.cmColorSelectedRow = new Action();
        this.autoCompleteInsertion = new ButtonGroup();
        this.proxyGroup = new ButtonGroup();
        this.cmPleaseWaitTest = new Action();
        this.tabSettings = new JTabbedPane();
        this.panelGeneral = new JPanel();
        this.checkOpenNewConnectionAtStartup = new JCheckBox();
        this.checkDisableLoadSqlSyntaxInfo = new JCheckBox();
        this.checkAutoSaveColumnWidths = new JCheckBox();
        this.checkDisableCheckUpdates = new JCheckBox();
        this.checkNoRollbackOnClose = new JCheckBox();
        this.checkCloseWarning = new JCheckBox();
        this.panelProxy = new JPanel();
        this.radioNoProxy = new JRadioButton();
        this.radioUseSystemProxy = new JRadioButton();
        this.radioManulProxy = new JRadioButton();
        this.labelHttpProxyAddress = new JLabel();
        this.textHttpProxyAddress = new TextField();
        this.labelHttpProxyPort = new JLabel();
        this.textHttpProxyPort = new TextField();
        this.checkProxyAuthNedded = new JCheckBox();
        this.labelProxyAuthUser = new JLabel();
        this.textProxyAuthUser = new TextField();
        this.labelProxyAuthPassword = new JLabel();
        this.textProxyAuthPassword = new JPasswordField();
        this.jLabel11 = new JLabel();
        this.jLabel21 = new JLabel();
        this.panelApperance = new JPanel();
        this.checkNoViewTabPictures = new JCheckBox();
        this.checkNoViewTabTitles = new JCheckBox();
        this.jPanel6 = new JPanel();
        this.labeloPleaseWaitService = new JLabel();
        this.comboPleaseWaitService = new ComboBox();
        this.jLabel12 = new JLabel();
        this.checkPleaseWaitOn = new JCheckBox();
        this.buttonWaitTest = new JButton();
        this.jPanel17 = new JPanel();
        this.labelLookAndFeel = new JLabel();
        this.comboLookAndFeelService = new ComboBox();
        this.labelLookAndFeelInfo = new JLabel();
        this.checkDefaultLookAndFeel = new JCheckBox();
        this.panelDataList = new JPanel();
        this.checkColorizedQueryTable = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.panelColorNumber = new JPanel();
        this.buttonSelect1 = new JButton();
        this.jLabel2 = new JLabel();
        this.panelColorString = new JPanel();
        this.buttonSelect2 = new JButton();
        this.jLabel3 = new JLabel();
        this.panelColorDate = new JPanel();
        this.buttonSelect3 = new JButton();
        this.jLabel4 = new JLabel();
        this.panelColorBool = new JPanel();
        this.buttonSelect4 = new JButton();
        this.jLabel5 = new JLabel();
        this.panelColorNull = new JPanel();
        this.buttonSelect5 = new JButton();
        this.jLabel6 = new JLabel();
        this.textNullValue = new TextField();
        this.checkAutoFitColumnWidth = new JCheckBox();
        this.panelTableDataFont = new JPanel();
        this.buttonTableDataFontChange = new JButton();
        this.labelTableDataFont = new JLabel();
        this.jLabel10 = new JLabel();
        this.panelColorSelectedTableRow = new JPanel();
        this.buttonSelect6 = new JButton();
        this.checkDefaultColorSelectedTableRow = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.jLabel13 = new JLabel();
        this.spinEvenRowShift = new JSpinner();
        this.jLabel14 = new JLabel();
        this.jLabel15 = new JLabel();
        this.spinFocusedShift = new JSpinner();
        this.jLabel16 = new JLabel();
        this.panelDataFormat = new JPanel();
        this.jTabbedPane2 = new JTabbedPane();
        this.jPanel9 = new JPanel();
        this.jPanel11 = new JPanel();
        this.checkDateFormatDefault = new JCheckBox();
        this.labelDateFormat = new JLabel();
        this.textDateFormat = new TextField();
        this.labelDateFormatSample = new JLabel();
        this.jPanel12 = new JPanel();
        this.checkTimeFormatDefault = new JCheckBox();
        this.labelTimeFormat = new JLabel();
        this.textTimeFormat = new TextField();
        this.labelTimeFormatSample = new JLabel();
        this.jPanel13 = new JPanel();
        this.checkTimeStampFormatDefault = new JCheckBox();
        this.labelTimeStampFormat = new JLabel();
        this.textTimeStampFormat = new TextField();
        this.labelTimeStampFormatSample = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.htmlDateTimeFormatInfo = new HtmlEditorPane();
        this.jPanel10 = new JPanel();
        this.jPanel14 = new JPanel();
        this.checkDecimalFormatDefault = new JCheckBox();
        this.labelDecimalFormat = new JLabel();
        this.textDecimalFormat = new TextField();
        this.labelDecimalFormatSample = new JLabel();
        this.jPanel15 = new JPanel();
        this.checkBigDecimalFormatDefault = new JCheckBox();
        this.labelBigDecimalFormat = new JLabel();
        this.textBigDecimalFormat = new TextField();
        this.labelBigDecimalFormatSample = new JLabel();
        this.jPanel16 = new JPanel();
        this.checkDecimalSeparatorDefault = new JCheckBox();
        this.labelDecimalSeparator = new JLabel();
        this.textDecimalSeparator = new TextField();
        this.jScrollPane3 = new JScrollPane();
        this.htmlDecimalFormatInfo = new HtmlEditorPane();
        this.panelHighlight = new JPanel();
        this.jLabel7 = new JLabel();
        this.panelEditorBackgroundColor = new JPanel();
        this.buttonSelect7 = new JButton();
        this.jLabel8 = new JLabel();
        this.comboSyntaxes = new ComboBox();
        this.jPanel5 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.listSyntaxElements = new JList();
        this.jLabel9 = new JLabel();
        this.panelEditorForegroundColor = new JPanel();
        this.buttonSelect8 = new JButton();
        this.checkEditorBold = new JCheckBox();
        this.checkEditorItalic = new JCheckBox();
        this.checkEditorUnderline = new JCheckBox();
        this.checkEditorEnabled = new JCheckBox();
        this.textEditorPreview = new SyntaxTextArea();
        this.jButton8 = new JButton();
        this.panelTableDataFont1 = new JPanel();
        this.buttonTableDataFontChange1 = new JButton();
        this.labelSyntaxFont = new JLabel();
        this.panelEditor = new JPanel();
        this.checkTabMovesSelected = new JCheckBox();
        this.panelAutoIndent = new JPanel();
        this.checkAutoCompleteDot = new JCheckBox();
        this.jLabel17 = new JLabel();
        this.checkAutoCompleteInsertion = new JRadioButton();
        this.checkAutoCompleteReplace = new JRadioButton();
        this.checkAutoCompleteInsertSingle = new JCheckBox();
        this.checkAutoCompleteStructureParser = new JCheckBox();
        this.checkAutoCompleteStructureParserVariables = new JCheckBox();
        this.jLabel18 = new JLabel();
        this.textAutoCompleteActivate = new TextField();
        this.jLabel19 = new JLabel();
        this.textAutoCompleteInactivate = new TextField();
        this.checkCopySyntaxHighlight = new JCheckBox();
        this.checkEditorTrimWhitespaces = new JCheckBox();
        this.checkSmartHomeEnd = new JCheckBox();
        this.jLabel20 = new JLabel();
        this.spinTabToSpace = new JSpinner();
        this.checkPredefinedSnippets = new JCheckBox();
        this.checkTabAsSpaces = new JCheckBox();
        this.buttonOk = new JButton();
        this.buttonCancel = new JButton();
        this.cmOk.setActionCommandKey("cmOk");
        this.cmOk.setShortCut(KeyStroke.getKeyStroke(10, 0));
        this.cmOk.setText(stringManager.getString("cmOk-text"));
        this.cmOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrbadaSettingsDialog.this.cmOkActionPerformed(evt);
            }
        });
        this.cmCancel.setActionCommandKey("cmCancel");
        this.cmCancel.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmCancel.setText(stringManager.getString("cmCancel-text"));
        this.cmCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrbadaSettingsDialog.this.cmCancelActionPerformed(evt);
            }
        });
        this.cmColorNumber.setText(stringManager.getString("OrbadaSettingsDialog-select"));
        this.cmColorNumber.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrbadaSettingsDialog.this.cmColorNumberActionPerformed(evt);
            }
        });
        this.cmColorString.setText(stringManager.getString("OrbadaSettingsDialog-select"));
        this.cmColorString.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrbadaSettingsDialog.this.cmColorStringActionPerformed(evt);
            }
        });
        this.cmColorDate.setText(stringManager.getString("OrbadaSettingsDialog-select"));
        this.cmColorDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrbadaSettingsDialog.this.cmColorDateActionPerformed(evt);
            }
        });
        this.cmColorBool.setText(stringManager.getString("OrbadaSettingsDialog-select"));
        this.cmColorBool.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrbadaSettingsDialog.this.cmColorBoolActionPerformed(evt);
            }
        });
        this.cmColorNull.setText(stringManager.getString("OrbadaSettingsDialog-select"));
        this.cmColorNull.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrbadaSettingsDialog.this.cmColorNullActionPerformed(evt);
            }
        });
        this.cmTableDataFontChange.setActionCommandKey("cmTableDataFontChange");
        this.cmTableDataFontChange.setText(stringManager.getString("OrbadaSettingsDialog-change"));
        this.cmTableDataFontChange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrbadaSettingsDialog.this.cmTableDataFontChangeActionPerformed(evt);
            }
        });
        this.cmSyntaxBackgroundColor.setActionCommandKey("cmSyntaxBackgroundColor");
        this.cmSyntaxBackgroundColor.setText(stringManager.getString("OrbadaSettingsDialog-select"));
        this.cmSyntaxBackgroundColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrbadaSettingsDialog.this.cmSyntaxBackgroundColorActionPerformed(evt);
            }
        });
        this.cmSyntaxForegroundColor.setActionCommandKey("cmSyntaxForegroundColor");
        this.cmSyntaxForegroundColor.setText(stringManager.getString("OrbadaSettingsDialog-select"));
        this.cmSyntaxForegroundColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrbadaSettingsDialog.this.cmSyntaxForegroundColorActionPerformed(evt);
            }
        });
        this.cmSyntaxRestoreSettings.setActionCommandKey("cmSyntaxRestoreSettings");
        this.cmSyntaxRestoreSettings.setText(stringManager.getString("OrbadaSettingsDialog-cmSyntaxRestoreSettings-text"));
        this.cmSyntaxRestoreSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrbadaSettingsDialog.this.cmSyntaxRestoreSettingsActionPerformed(evt);
            }
        });
        this.cmSyntaxFontChange.setActionCommandKey("cmSyntaxFontChange");
        this.cmSyntaxFontChange.setText(stringManager.getString("OrbadaSettingsDialog-change"));
        this.cmSyntaxFontChange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrbadaSettingsDialog.this.cmSyntaxFontChangeActionPerformed(evt);
            }
        });
        this.cmColorSelectedRow.setActionCommandKey("cmColorSelectedRow");
        this.cmColorSelectedRow.setText(stringManager.getString("OrbadaSettingsDialog-select"));
        this.cmColorSelectedRow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrbadaSettingsDialog.this.cmColorSelectedRowActionPerformed(evt);
            }
        });
        this.cmPleaseWaitTest.setText(stringManager.getString("cmPleaseWaitTest-test-text"));
        this.cmPleaseWaitTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrbadaSettingsDialog.this.cmPleaseWaitTestActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(stringManager.getString("OrbadaSettingsDialog-title"));
        this.setModal(true);
        this.tabSettings.setFocusable(false);
        this.checkOpenNewConnectionAtStartup.setText(stringManager.getString("OrbadaSettingsDialog-checkOpenNewConnectionAtStartup-text"));
        this.checkDisableLoadSqlSyntaxInfo.setText(stringManager.getString("OrbadaSettingsDialog-checkDisableLoadSqlSyntaxInfo-text"));
        this.checkDisableLoadSqlSyntaxInfo.setToolTipText(stringManager.getString("OrbadaSettingsDialog-checkDisableLoadSqlSyntaxInfo-hint"));
        this.checkAutoSaveColumnWidths.setText(stringManager.getString("OrbadaSettingsDialog-checkAutoSaveColumnWidths-text"));
        this.checkDisableCheckUpdates.setText(stringManager.getString("OrbadaSettingsDialog-checkDisableCheckUpdates-text"));
        this.checkNoRollbackOnClose.setText(stringManager.getString("OrbadaSettingsDialog-checkNoRollbackOnClose-text"));
        this.checkCloseWarning.setText(stringManager.getString("OrbadaSettingsDialog-checkCloseWarning-text"));
        GroupLayout panelGeneralLayout = new GroupLayout(this.panelGeneral);
        this.panelGeneral.setLayout(panelGeneralLayout);
        panelGeneralLayout.setHorizontalGroup(panelGeneralLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelGeneralLayout.createSequentialGroup().addContainerGap().addGroup(panelGeneralLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkDisableCheckUpdates).addComponent(this.checkOpenNewConnectionAtStartup).addComponent(this.checkDisableLoadSqlSyntaxInfo).addComponent(this.checkAutoSaveColumnWidths).addComponent(this.checkNoRollbackOnClose).addComponent(this.checkCloseWarning)).addContainerGap(29, Short.MAX_VALUE)));
        panelGeneralLayout.setVerticalGroup(panelGeneralLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelGeneralLayout.createSequentialGroup().addContainerGap().addComponent(this.checkOpenNewConnectionAtStartup).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkDisableLoadSqlSyntaxInfo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkAutoSaveColumnWidths).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkDisableCheckUpdates).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkNoRollbackOnClose).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkCloseWarning).addContainerGap(338, Short.MAX_VALUE)));
        this.tabSettings.addTab(stringManager.getString("OrbadaSettingsDialog-general"), this.panelGeneral);
        this.proxyGroup.add(this.radioNoProxy);
        this.radioNoProxy.setText(stringManager.getString("radioNoProxy-text"));
        this.radioNoProxy.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                OrbadaSettingsDialog.this.radioNoProxyItemStateChanged(evt);
            }
        });
        this.proxyGroup.add(this.radioUseSystemProxy);
        this.radioUseSystemProxy.setText(stringManager.getString("radioUseSystemProxy-text"));
        this.radioUseSystemProxy.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                OrbadaSettingsDialog.this.radioUseSystemProxyItemStateChanged(evt);
            }
        });
        this.proxyGroup.add(this.radioManulProxy);
        this.radioManulProxy.setText(stringManager.getString("radioManulProxy-text"));
        this.radioManulProxy.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                OrbadaSettingsDialog.this.radioManulProxyItemStateChanged(evt);
            }
        });
        this.labelHttpProxyAddress.setHorizontalAlignment(11);
        this.labelHttpProxyAddress.setText(stringManager.getString("http-proxy-address-dd"));
        this.labelHttpProxyPort.setText(stringManager.getString("http-proxy-port-dd"));
        this.checkProxyAuthNedded.setText(stringManager.getString("checkProxyAuthNedded-text"));
        this.checkProxyAuthNedded.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                OrbadaSettingsDialog.this.checkProxyAuthNeddedItemStateChanged(evt);
            }
        });
        this.labelProxyAuthUser.setHorizontalAlignment(11);
        this.labelProxyAuthUser.setText(stringManager.getString("proxy-auth-user-dd"));
        this.labelProxyAuthPassword.setHorizontalAlignment(11);
        this.labelProxyAuthPassword.setText(stringManager.getString("proxy-auth-password-dd"));
        this.jLabel11.setText(stringManager.getString("proxy-settings-info"));
        this.jLabel21.setText(stringManager.getString("poxy-settings-for"));
        GroupLayout panelProxyLayout = new GroupLayout(this.panelProxy);
        this.panelProxy.setLayout(panelProxyLayout);
        panelProxyLayout.setHorizontalGroup(panelProxyLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelProxyLayout.createSequentialGroup().addGroup(panelProxyLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelProxyLayout.createSequentialGroup().addContainerGap().addGroup(panelProxyLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.labelProxyAuthUser, GroupLayout.Alignment.TRAILING, -1, 93, Short.MAX_VALUE).addComponent(this.labelProxyAuthPassword, GroupLayout.Alignment.TRAILING, -1, 93, Short.MAX_VALUE).addComponent(this.labelHttpProxyAddress, GroupLayout.Alignment.TRAILING, -2, 93, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelProxyLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, panelProxyLayout.createSequentialGroup().addComponent((Component)this.textHttpProxyAddress, -1, 319, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelHttpProxyPort).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textHttpProxyPort, -2, 56, -2)).addComponent((Component)this.textProxyAuthUser, -1, 407, Short.MAX_VALUE).addComponent(this.textProxyAuthPassword, -1, 407, Short.MAX_VALUE))).addGroup(panelProxyLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.checkProxyAuthNedded)).addGroup(panelProxyLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.radioManulProxy)).addGroup(panelProxyLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.radioUseSystemProxy)).addGroup(panelProxyLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.radioNoProxy)).addGroup(panelProxyLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel11, -1, 504, Short.MAX_VALUE)).addGroup(panelProxyLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel21, -1, 504, Short.MAX_VALUE))).addContainerGap()));
        panelProxyLayout.setVerticalGroup(panelProxyLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelProxyLayout.createSequentialGroup().addContainerGap().addComponent(this.radioNoProxy).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioUseSystemProxy).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioManulProxy).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelProxyLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelHttpProxyAddress).addComponent((Component)this.textHttpProxyAddress, -2, -1, -2).addComponent((Component)this.textHttpProxyPort, -2, -1, -2).addComponent(this.labelHttpProxyPort)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkProxyAuthNedded).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelProxyLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelProxyAuthUser).addComponent((Component)this.textProxyAuthUser, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelProxyLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelProxyAuthPassword).addComponent(this.textProxyAuthPassword, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 225, Short.MAX_VALUE).addComponent(this.jLabel21, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel11).addContainerGap()));
        this.tabSettings.addTab(stringManager.getString("tab-proxy-settings"), this.panelProxy);
        this.checkNoViewTabPictures.setText(stringManager.getString("OrbadaSettingsDialog-checkNoViewTabPictures-text"));
        this.checkNoViewTabTitles.setText(stringManager.getString("OrbadaSettingsDialog-checkNoViewTabTitles-text"));
        this.jPanel6.setBorder(BorderFactory.createTitledBorder(stringManager.getString("OrbadaSettingsDialog-wait-renderer-border-title")));
        this.labeloPleaseWaitService.setText(stringManager.getString("OrbadaSettingsDialog-select-wait-renderer-dd"));
        this.jLabel12.setText(stringManager.getString("OrbadaSettingsDialog-wait-renderer-info"));
        this.checkPleaseWaitOn.setText(stringManager.getString("OrbadaSettingsDialog-checkPleaseWaitOn-text"));
        this.checkPleaseWaitOn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrbadaSettingsDialog.this.checkPleaseWaitOnActionPerformed(evt);
            }
        });
        this.buttonWaitTest.setAction((javax.swing.Action)this.cmPleaseWaitTest);
        this.buttonWaitTest.setMargin(new Insets(2, 2, 2, 2));
        this.buttonWaitTest.setPreferredSize(new Dimension(85, 25));
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel12, GroupLayout.Alignment.LEADING, -1, 472, Short.MAX_VALUE).addComponent(this.checkPleaseWaitOn, GroupLayout.Alignment.LEADING).addComponent(this.labeloPleaseWaitService, GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addComponent((Component)this.comboPleaseWaitService, -1, 381, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonWaitTest, -2, -1, -2))).addContainerGap()));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.checkPleaseWaitOn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labeloPleaseWaitService).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.comboPleaseWaitService, -2, -1, -2).addComponent(this.buttonWaitTest, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel12).addContainerGap()));
        this.jPanel17.setBorder(BorderFactory.createTitledBorder(stringManager.getString("OrbadaSettingsDialog-lookandfeel-border-title")));
        this.labelLookAndFeel.setText(stringManager.getString("OrbadaSettingsDialog-select-lookandfeel-dd"));
        this.labelLookAndFeelInfo.setText(stringManager.getString("OrbadaSettingsDialog-lookandfeel-info"));
        this.checkDefaultLookAndFeel.setText(stringManager.getString("OrbadaSettingsDialog-checkDefaultLookAndFeel-text"));
        this.checkDefaultLookAndFeel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrbadaSettingsDialog.this.checkDefaultLookAndFeelActionPerformed(evt);
            }
        });
        GroupLayout jPanel17Layout = new GroupLayout(this.jPanel17);
        this.jPanel17.setLayout(jPanel17Layout);
        jPanel17Layout.setHorizontalGroup(jPanel17Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel17Layout.createSequentialGroup().addContainerGap().addGroup(jPanel17Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.labelLookAndFeelInfo, GroupLayout.Alignment.LEADING, -1, 472, Short.MAX_VALUE).addComponent(this.checkDefaultLookAndFeel, GroupLayout.Alignment.LEADING).addComponent(this.labelLookAndFeel, GroupLayout.Alignment.LEADING).addComponent((Component)this.comboLookAndFeelService, GroupLayout.Alignment.LEADING, -1, 472, Short.MAX_VALUE)).addContainerGap()));
        jPanel17Layout.setVerticalGroup(jPanel17Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel17Layout.createSequentialGroup().addComponent(this.checkDefaultLookAndFeel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelLookAndFeel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.comboLookAndFeelService, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelLookAndFeelInfo, -1, 34, Short.MAX_VALUE).addContainerGap()));
        GroupLayout panelApperanceLayout = new GroupLayout(this.panelApperance);
        this.panelApperance.setLayout(panelApperanceLayout);
        panelApperanceLayout.setHorizontalGroup(panelApperanceLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, panelApperanceLayout.createSequentialGroup().addContainerGap().addGroup(panelApperanceLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel17, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel6, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.checkNoViewTabPictures, GroupLayout.Alignment.LEADING).addComponent(this.checkNoViewTabTitles, GroupLayout.Alignment.LEADING)).addContainerGap()));
        panelApperanceLayout.setVerticalGroup(panelApperanceLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelApperanceLayout.createSequentialGroup().addContainerGap().addComponent(this.checkNoViewTabPictures).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkNoViewTabTitles).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel6, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel17, -2, -1, -2).addContainerGap(151, Short.MAX_VALUE)));
        this.tabSettings.addTab(stringManager.getString("OrbadaSettingsDialog-look"), this.panelApperance);
        this.checkColorizedQueryTable.setText(stringManager.getString("OrbadaSettingsDialog-checkColorizedQueryTable-text"));
        this.checkColorizedQueryTable.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.checkColorizedQueryTable.setMargin(new Insets(0, 0, 0, 0));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(stringManager.getString("OrbadaSettingsDialog-data-types-border-title")));
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText(stringManager.getString("OrbadaSettingsDialog-number-color-dd"));
        this.panelColorNumber.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("controlShadow"), 2));
        GroupLayout panelColorNumberLayout = new GroupLayout(this.panelColorNumber);
        this.panelColorNumber.setLayout(panelColorNumberLayout);
        panelColorNumberLayout.setHorizontalGroup(panelColorNumberLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 202, Short.MAX_VALUE));
        panelColorNumberLayout.setVerticalGroup(panelColorNumberLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 19, Short.MAX_VALUE));
        this.buttonSelect1.setAction((javax.swing.Action)this.cmColorNumber);
        this.buttonSelect1.setMargin(new Insets(2, 2, 2, 2));
        this.buttonSelect1.setPreferredSize(new Dimension(75, 23));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(stringManager.getString("OrbadaSettingsDialog-string-color-dd"));
        this.panelColorString.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("controlShadow"), 2));
        GroupLayout panelColorStringLayout = new GroupLayout(this.panelColorString);
        this.panelColorString.setLayout(panelColorStringLayout);
        panelColorStringLayout.setHorizontalGroup(panelColorStringLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 202, Short.MAX_VALUE));
        panelColorStringLayout.setVerticalGroup(panelColorStringLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 19, Short.MAX_VALUE));
        this.buttonSelect2.setAction((javax.swing.Action)this.cmColorString);
        this.buttonSelect2.setMargin(new Insets(2, 2, 2, 2));
        this.buttonSelect2.setPreferredSize(new Dimension(75, 23));
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(stringManager.getString("OrbadaSettingsDialog-datetime-color-dd"));
        this.panelColorDate.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("controlShadow"), 2));
        GroupLayout panelColorDateLayout = new GroupLayout(this.panelColorDate);
        this.panelColorDate.setLayout(panelColorDateLayout);
        panelColorDateLayout.setHorizontalGroup(panelColorDateLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 202, Short.MAX_VALUE));
        panelColorDateLayout.setVerticalGroup(panelColorDateLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 19, Short.MAX_VALUE));
        this.buttonSelect3.setAction((javax.swing.Action)this.cmColorDate);
        this.buttonSelect3.setMargin(new Insets(2, 2, 2, 2));
        this.buttonSelect3.setPreferredSize(new Dimension(75, 23));
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText(stringManager.getString("OrbadaSettingsDialog-bool-color-dd"));
        this.panelColorBool.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("controlShadow"), 2));
        GroupLayout panelColorBoolLayout = new GroupLayout(this.panelColorBool);
        this.panelColorBool.setLayout(panelColorBoolLayout);
        panelColorBoolLayout.setHorizontalGroup(panelColorBoolLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 202, Short.MAX_VALUE));
        panelColorBoolLayout.setVerticalGroup(panelColorBoolLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 19, Short.MAX_VALUE));
        this.buttonSelect4.setAction((javax.swing.Action)this.cmColorBool);
        this.buttonSelect4.setMargin(new Insets(2, 2, 2, 2));
        this.buttonSelect4.setPreferredSize(new Dimension(75, 23));
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText(stringManager.getString("OrbadaSettingsDialog-null-color-dd"));
        this.panelColorNull.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("controlShadow"), 2));
        GroupLayout panelColorNullLayout = new GroupLayout(this.panelColorNull);
        this.panelColorNull.setLayout(panelColorNullLayout);
        panelColorNullLayout.setHorizontalGroup(panelColorNullLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 202, Short.MAX_VALUE));
        panelColorNullLayout.setVerticalGroup(panelColorNullLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 19, Short.MAX_VALUE));
        this.buttonSelect5.setAction((javax.swing.Action)this.cmColorNull);
        this.buttonSelect5.setMargin(new Insets(2, 2, 2, 2));
        this.buttonSelect5.setPreferredSize(new Dimension(75, 23));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.jLabel1, -2, 181, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelColorNumber, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonSelect1, -2, -1, -2)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel2, -2, 181, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelColorString, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonSelect2, -2, -1, -2)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel3, -2, 181, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelColorDate, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonSelect3, -2, -1, -2)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel4, -2, 181, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelColorBool, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonSelect4, -2, -1, -2)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel5, -2, 181, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelColorNull, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonSelect5, -2, -1, -2))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.buttonSelect1, -1, -1, Short.MAX_VALUE).addComponent(this.panelColorNumber, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.buttonSelect2, -1, -1, Short.MAX_VALUE).addComponent(this.panelColorString, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.buttonSelect3, -1, -1, Short.MAX_VALUE).addComponent(this.panelColorDate, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.buttonSelect4, -1, -1, Short.MAX_VALUE).addComponent(this.panelColorBool, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel4, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.buttonSelect5, -1, -1, Short.MAX_VALUE).addComponent(this.panelColorNull, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel5, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel6.setText(stringManager.getString("OrbadaSettingsDialog-text-value-null-dd"));
        this.textNullValue.setText("textField1");
        this.checkAutoFitColumnWidth.setText(stringManager.getString("OrbadaSettingsDialog-checkAutoFitColumnWidth-text"));
        this.checkAutoFitColumnWidth.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.checkAutoFitColumnWidth.setMargin(new Insets(0, 0, 0, 0));
        this.panelTableDataFont.setBorder(BorderFactory.createTitledBorder(stringManager.getString("OrbadaSettingsDialog-panelTableDataFont-border-title")));
        this.buttonTableDataFontChange.setAction((javax.swing.Action)this.cmTableDataFontChange);
        this.buttonTableDataFontChange.setMargin(new Insets(2, 2, 2, 2));
        this.buttonTableDataFontChange.setPreferredSize(new Dimension(85, 25));
        this.labelTableDataFont.setHorizontalAlignment(0);
        this.labelTableDataFont.setText(stringManager.getString("OrbadaSettingsDialog-OrbadaText-text"));
        GroupLayout panelTableDataFontLayout = new GroupLayout(this.panelTableDataFont);
        this.panelTableDataFont.setLayout(panelTableDataFontLayout);
        panelTableDataFontLayout.setHorizontalGroup(panelTableDataFontLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, panelTableDataFontLayout.createSequentialGroup().addContainerGap().addComponent(this.labelTableDataFont, -1, 383, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonTableDataFontChange, -2, -1, -2).addContainerGap()));
        panelTableDataFontLayout.setVerticalGroup(panelTableDataFontLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, panelTableDataFontLayout.createSequentialGroup().addGroup(panelTableDataFontLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.labelTableDataFont, GroupLayout.Alignment.LEADING, -1, 73, Short.MAX_VALUE).addGroup(panelTableDataFontLayout.createSequentialGroup().addContainerGap(48, Short.MAX_VALUE).addComponent(this.buttonTableDataFontChange, -2, -1, -2))).addContainerGap()));
        this.jLabel10.setHorizontalAlignment(4);
        this.jLabel10.setText(stringManager.getString("OrbadaSettingsDialog-selected-row-color-dd"));
        this.panelColorSelectedTableRow.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("controlShadow"), 2));
        GroupLayout panelColorSelectedTableRowLayout = new GroupLayout(this.panelColorSelectedTableRow);
        this.panelColorSelectedTableRow.setLayout(panelColorSelectedTableRowLayout);
        panelColorSelectedTableRowLayout.setHorizontalGroup(panelColorSelectedTableRowLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 171, Short.MAX_VALUE));
        panelColorSelectedTableRowLayout.setVerticalGroup(panelColorSelectedTableRowLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 19, Short.MAX_VALUE));
        this.buttonSelect6.setAction((javax.swing.Action)this.cmColorSelectedRow);
        this.buttonSelect6.setMargin(new Insets(2, 2, 2, 2));
        this.buttonSelect6.setPreferredSize(new Dimension(75, 23));
        this.checkDefaultColorSelectedTableRow.setText(stringManager.getString("OrbadaSettingsDialog-default"));
        this.jLabel13.setText(stringManager.getString("OrbadaSettingsDialog-even-row-shift-dd"));
        this.jLabel14.setText(stringManager.getString("OrbadaSettingsDialog-even-row-shift-info"));
        this.jLabel15.setText(stringManager.getString("OrbadaSettingsDialog-selected-row-exnhanced-dd"));
        this.jLabel16.setText(stringManager.getString("OrbadaSettingsDialog-selected-row-enhance-info"));
        GroupLayout panelDataListLayout = new GroupLayout(this.panelDataList);
        this.panelDataList.setLayout(panelDataListLayout);
        panelDataListLayout.setHorizontalGroup(panelDataListLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelDataListLayout.createSequentialGroup().addContainerGap().addGroup(panelDataListLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, -1, 504, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.checkColorizedQueryTable).addGroup(panelDataListLayout.createSequentialGroup().addComponent(this.jLabel10, -2, 181, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelColorSelectedTableRow, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonSelect6, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkDefaultColorSelectedTableRow)).addComponent(this.panelTableDataFont, -1, -1, Short.MAX_VALUE).addGroup(panelDataListLayout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textNullValue, -2, 95, -2)).addComponent(this.checkAutoFitColumnWidth).addGroup(panelDataListLayout.createSequentialGroup().addComponent(this.jLabel13).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinEvenRowShift, -2, 61, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel14)).addGroup(panelDataListLayout.createSequentialGroup().addComponent(this.jLabel15).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinFocusedShift, -2, 61, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel16))).addContainerGap()));
        panelDataListLayout.setVerticalGroup(panelDataListLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelDataListLayout.createSequentialGroup().addContainerGap().addComponent(this.checkColorizedQueryTable).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelDataListLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.panelColorSelectedTableRow, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel10, -1, 23, Short.MAX_VALUE).addGroup(panelDataListLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkDefaultColorSelectedTableRow).addComponent(this.buttonSelect6, -1, -1, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelDataListLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent((Component)this.textNullValue, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkAutoFitColumnWidth).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelTableDataFont, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelDataListLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel13).addComponent(this.spinEvenRowShift, -2, -1, -2).addComponent(this.jLabel14)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelDataListLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel15).addComponent(this.spinFocusedShift, -2, -1, -2).addComponent(this.jLabel16)).addGap(21, 21, 21)));
        this.tabSettings.addTab(stringManager.getString("OrbadaSettingsDialog-data-list"), this.panelDataList);
        this.jTabbedPane2.setFocusable(false);
        this.jPanel11.setBorder(BorderFactory.createTitledBorder(stringManager.getString("OrbadaSettingsDialog-date-format")));
        this.checkDateFormatDefault.setText(stringManager.getString("OrbadaSettingsDialog-checkFormatDefault-text"));
        this.checkDateFormatDefault.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                OrbadaSettingsDialog.this.checkDateFormatDefaultItemStateChanged(evt);
            }
        });
        this.checkDateFormatDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrbadaSettingsDialog.this.checkDateFormatDefaultActionPerformed(evt);
            }
        });
        this.labelDateFormat.setText(stringManager.getString("OrbadaSettingsDialog-date-format-label"));
        this.textDateFormat.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                OrbadaSettingsDialog.this.textDateFormatFocusLost(evt);
            }
        });
        this.labelDateFormatSample.setText("labelDateFormatSample");
        GroupLayout jPanel11Layout = new GroupLayout(this.jPanel11);
        this.jPanel11.setLayout(jPanel11Layout);
        jPanel11Layout.setHorizontalGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel11Layout.createSequentialGroup().addContainerGap().addGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel11Layout.createSequentialGroup().addComponent(this.labelDateFormat).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textDateFormat, -2, 188, -2)).addGroup(jPanel11Layout.createSequentialGroup().addComponent(this.checkDateFormatDefault).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 197, Short.MAX_VALUE).addComponent(this.labelDateFormatSample))).addContainerGap()));
        jPanel11Layout.setVerticalGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel11Layout.createSequentialGroup().addGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkDateFormatDefault).addComponent(this.labelDateFormatSample)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelDateFormat).addComponent((Component)this.textDateFormat, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel12.setBorder(BorderFactory.createTitledBorder(stringManager.getString("OrbadaSettingsDialog-time-format")));
        this.checkTimeFormatDefault.setText(stringManager.getString("OrbadaSettingsDialog-checkFormatDefault-text"));
        this.checkTimeFormatDefault.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                OrbadaSettingsDialog.this.checkTimeFormatDefaultItemStateChanged(evt);
            }
        });
        this.checkTimeFormatDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrbadaSettingsDialog.this.checkTimeFormatDefaultActionPerformed(evt);
            }
        });
        this.labelTimeFormat.setText(stringManager.getString("OrbadaSettingsDialog-time-format-label"));
        this.textTimeFormat.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                OrbadaSettingsDialog.this.textTimeFormatFocusLost(evt);
            }
        });
        this.labelTimeFormatSample.setText("labelTimeFormatSample");
        GroupLayout jPanel12Layout = new GroupLayout(this.jPanel12);
        this.jPanel12.setLayout(jPanel12Layout);
        jPanel12Layout.setHorizontalGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel12Layout.createSequentialGroup().addContainerGap().addGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel12Layout.createSequentialGroup().addComponent(this.labelTimeFormat).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textTimeFormat, -2, 188, -2)).addGroup(jPanel12Layout.createSequentialGroup().addComponent(this.checkTimeFormatDefault).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 198, Short.MAX_VALUE).addComponent(this.labelTimeFormatSample))).addContainerGap()));
        jPanel12Layout.setVerticalGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel12Layout.createSequentialGroup().addGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkTimeFormatDefault).addComponent(this.labelTimeFormatSample)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelTimeFormat).addComponent((Component)this.textTimeFormat, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel13.setBorder(BorderFactory.createTitledBorder(stringManager.getString("OrbadaSettingsDialog-timestamp-format")));
        this.checkTimeStampFormatDefault.setText(stringManager.getString("OrbadaSettingsDialog-checkFormatDefault-text"));
        this.checkTimeStampFormatDefault.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                OrbadaSettingsDialog.this.checkTimeStampFormatDefaultItemStateChanged(evt);
            }
        });
        this.checkTimeStampFormatDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrbadaSettingsDialog.this.checkTimeStampFormatDefaultActionPerformed(evt);
            }
        });
        this.labelTimeStampFormat.setText(stringManager.getString("OrbadaSettingsDialog-timestamp-format-label"));
        this.textTimeStampFormat.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                OrbadaSettingsDialog.this.textTimeStampFormatFocusLost(evt);
            }
        });
        this.labelTimeStampFormatSample.setText("labelTimeStampFormatSample");
        GroupLayout jPanel13Layout = new GroupLayout(this.jPanel13);
        this.jPanel13.setLayout(jPanel13Layout);
        jPanel13Layout.setHorizontalGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel13Layout.createSequentialGroup().addContainerGap().addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel13Layout.createSequentialGroup().addComponent(this.labelTimeStampFormat).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textTimeStampFormat, -2, 188, -2)).addGroup(jPanel13Layout.createSequentialGroup().addComponent(this.checkTimeStampFormatDefault).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 168, Short.MAX_VALUE).addComponent(this.labelTimeStampFormatSample))).addContainerGap()));
        jPanel13Layout.setVerticalGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel13Layout.createSequentialGroup().addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkTimeStampFormatDefault).addComponent(this.labelTimeStampFormatSample)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelTimeStampFormat).addComponent((Component)this.textTimeStampFormat, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jScrollPane2.setBorder(null);
        this.htmlDateTimeFormatInfo.setBackground(UIManager.getDefaults().getColor("Button.background"));
        this.htmlDateTimeFormatInfo.setBorder(null);
        this.htmlDateTimeFormatInfo.setText("<html>\r\n  <head>\r\n\r\n  </head>\r\n  <body>\r\n<table border=0 cellspacing=1 cellpadding=1>\n     <tr>\n         <th>Letter\n         <th>Date or Time Component\n         <th>Presentation\n         <th>Examples\n     <tr>\n         <td><code>G</code>\n         <td>Era designator\n         <td>Text\n         <td><code>AD</code>\n     <tr>\n         <td><code>y</code>\n         <td>Year\n         <td>Year\n         <td><code>1996</code>; <code>96</code>\n     <tr>\n         <td><code>M</code>\n         <td>Month in year\n         <td>Month\n         <td><code>July</code>; <code>Jul</code>; <code>07</code>\n     <tr>\n         <td><code>w</code>\n         <td>Week in year\n         <td>Number\n         <td><code>27</code>\n     <tr>\n         <td><code>W</code>\n         <td>Week in month\n         <td>Number\n         <td><code>2</code>\n     <tr>\n         <td><code>D</code>\n         <td>Day in year\n         <td>Number\n         <td><code>189</code>\n     <tr>\n         <td><code>d</code>\n         <td>Day in month\n         <td>Number\n         <td><code>10</code>\n     <tr>\n         <td><code>F</code>\n         <td>Day of week in month\n         <td>Number\n         <td><code>2</code>\n     <tr>\n         <td><code>E</code>\n         <td>Day in week\n         <td>Text\n         <td><code>Tuesday</code>; <code>Tue</code>\n     <tr>\n         <td><code>a</code>\n         <td>Am/pm marker\n         <td>Text\n         <td><code>PM</code>\n     <tr>\n         <td><code>H</code>\n         <td>Hour in day (0-23)\n         <td>Number\n         <td><code>0</code>\n     <tr>\n         <td><code>k</code>\n         <td>Hour in day (1-24)\n         <td>Number\n         <td><code>24</code>\n     <tr>\n         <td><code>K</code>\n         <td>Hour in am/pm (0-11)\n         <td>Number\n         <td><code>0</code>\n     <tr>\n         <td><code>h</code>\n         <td>Hour in am/pm (1-12)\n         <td>Number\n         <td><code>12</code>\n     <tr>\n         <td><code>m</code>\n         <td>Minute in hour\n         <td>Number\n         <td><code>30</code>\n     <tr>\n         <td><code>s</code>\n         <td>Second in minute\n         <td>Number\n         <td><code>55</code>\n     <tr>\n         <td><code>S</code>\n         <td>Millisecond\n         <td>Number\n         <td><code>978</code>\n     <tr>\n         <td><code>z</code>\n         <td>Time zone\n         <td>General time zone\n         <td><code>Pacific Standard Time</code>; <code>PST</code>; <code>GMT-08:00</code>\n     <tr>\n         <td><code>Z</code>\n         <td>Time zone\n         <td>RFC 822 time zone\n         <td><code>-0800</code>\n </table>\n  </body>\r\n</html>\r\n");
        this.jScrollPane2.setViewportView((Component)this.htmlDateTimeFormatInfo);
        GroupLayout jPanel9Layout = new GroupLayout(this.jPanel9);
        this.jPanel9.setLayout(jPanel9Layout);
        jPanel9Layout.setHorizontalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel9Layout.createSequentialGroup().addContainerGap().addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane2, GroupLayout.Alignment.LEADING, -1, 479, Short.MAX_VALUE).addComponent(this.jPanel11, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel12, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel13, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel9Layout.setVerticalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel9Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel11, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel12, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel13, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 144, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane2.addTab(stringManager.getString("OrbadaSettingsDialog-date-time-format"), this.jPanel9);
        this.jPanel14.setBorder(BorderFactory.createTitledBorder(stringManager.getString("OrbadaSettingsDialog-decimal-format")));
        this.checkDecimalFormatDefault.setText(stringManager.getString("OrbadaSettingsDialog-checkFormatDefault-text"));
        this.checkDecimalFormatDefault.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                OrbadaSettingsDialog.this.checkDecimalFormatDefaultItemStateChanged(evt);
            }
        });
        this.checkDecimalFormatDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrbadaSettingsDialog.this.checkDecimalFormatDefaultActionPerformed(evt);
            }
        });
        this.labelDecimalFormat.setText(stringManager.getString("OrbadaSettingsDialog-decimal-format-label"));
        this.textDecimalFormat.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                OrbadaSettingsDialog.this.textDecimalFormatFocusLost(evt);
            }
        });
        this.labelDecimalFormatSample.setText("labelDecimalFormatSample");
        GroupLayout jPanel14Layout = new GroupLayout(this.jPanel14);
        this.jPanel14.setLayout(jPanel14Layout);
        jPanel14Layout.setHorizontalGroup(jPanel14Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel14Layout.createSequentialGroup().addContainerGap().addGroup(jPanel14Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel14Layout.createSequentialGroup().addComponent(this.labelDecimalFormat).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textDecimalFormat, -2, 188, -2)).addGroup(jPanel14Layout.createSequentialGroup().addComponent(this.checkDecimalFormatDefault).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 184, Short.MAX_VALUE).addComponent(this.labelDecimalFormatSample))).addContainerGap()));
        jPanel14Layout.setVerticalGroup(jPanel14Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel14Layout.createSequentialGroup().addGroup(jPanel14Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkDecimalFormatDefault).addComponent(this.labelDecimalFormatSample)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel14Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelDecimalFormat).addComponent((Component)this.textDecimalFormat, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel15.setBorder(BorderFactory.createTitledBorder(stringManager.getString("OrbadaSettingsDialog-bigdecimal-format")));
        this.checkBigDecimalFormatDefault.setText(stringManager.getString("OrbadaSettingsDialog-checkFormatDefault-text"));
        this.checkBigDecimalFormatDefault.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                OrbadaSettingsDialog.this.checkBigDecimalFormatDefaultItemStateChanged(evt);
            }
        });
        this.checkBigDecimalFormatDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrbadaSettingsDialog.this.checkBigDecimalFormatDefaultActionPerformed(evt);
            }
        });
        this.labelBigDecimalFormat.setText(stringManager.getString("OrbadaSettingsDialog-bigdecimal-format-label"));
        this.textBigDecimalFormat.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                OrbadaSettingsDialog.this.textBigDecimalFormatFocusLost(evt);
            }
        });
        this.labelBigDecimalFormatSample.setText("labelBigDecimalFormatSample");
        GroupLayout jPanel15Layout = new GroupLayout(this.jPanel15);
        this.jPanel15.setLayout(jPanel15Layout);
        jPanel15Layout.setHorizontalGroup(jPanel15Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel15Layout.createSequentialGroup().addContainerGap().addGroup(jPanel15Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel15Layout.createSequentialGroup().addComponent(this.labelBigDecimalFormat).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textBigDecimalFormat, -2, 188, -2)).addGroup(jPanel15Layout.createSequentialGroup().addComponent(this.checkBigDecimalFormatDefault).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 170, Short.MAX_VALUE).addComponent(this.labelBigDecimalFormatSample))).addContainerGap()));
        jPanel15Layout.setVerticalGroup(jPanel15Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel15Layout.createSequentialGroup().addGroup(jPanel15Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkBigDecimalFormatDefault).addComponent(this.labelBigDecimalFormatSample)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel15Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelBigDecimalFormat).addComponent((Component)this.textBigDecimalFormat, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel16.setBorder(BorderFactory.createTitledBorder(stringManager.getString("OrbadaSettingsDialog-format-separators")));
        this.checkDecimalSeparatorDefault.setText(stringManager.getString("OrbadaSettingsDialog-checkFormatDefault-text"));
        this.checkDecimalSeparatorDefault.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                OrbadaSettingsDialog.this.checkDecimalSeparatorDefaultItemStateChanged(evt);
            }
        });
        this.checkDecimalSeparatorDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrbadaSettingsDialog.this.checkDecimalSeparatorDefaultActionPerformed(evt);
            }
        });
        this.labelDecimalSeparator.setText(stringManager.getString("OrbadaSettingsDialog-decimal-separator-label"));
        this.textDecimalSeparator.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                OrbadaSettingsDialog.this.textDecimalSeparatorFocusLost(evt);
            }
        });
        GroupLayout jPanel16Layout = new GroupLayout(this.jPanel16);
        this.jPanel16.setLayout(jPanel16Layout);
        jPanel16Layout.setHorizontalGroup(jPanel16Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel16Layout.createSequentialGroup().addContainerGap().addGroup(jPanel16Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel16Layout.createSequentialGroup().addComponent(this.labelDecimalSeparator).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textDecimalSeparator, -2, 54, -2)).addComponent(this.checkDecimalSeparatorDefault)).addContainerGap(309, Short.MAX_VALUE)));
        jPanel16Layout.setVerticalGroup(jPanel16Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel16Layout.createSequentialGroup().addComponent(this.checkDecimalSeparatorDefault).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel16Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelDecimalSeparator).addComponent((Component)this.textDecimalSeparator, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jScrollPane3.setBorder(null);
        this.htmlDecimalFormatInfo.setBackground(UIManager.getDefaults().getColor("Button.background"));
        this.htmlDecimalFormatInfo.setBorder(null);
        this.htmlDecimalFormatInfo.setText("<html>\r\n  <head>\r\n\r\n  </head>\r\n  <body>\r\n<table border=0 cellspacing=1 cellpadding=1>\n     <tr>\n          <th align=left>Symbol\n          <th align=left>Location\n          <th align=left>Localized?\n          <th align=left>Meaning\n     <tr valign=top>\n          <td><code>0</code>\n          <td>Number\n          <td>Yes\n          <td>Digit\n     <tr valign=top>\n          <td><code>#</code>\n          <td>Number\n          <td>Yes\n          <td>Digit, zero shows as absent\n     <tr valign=top>\n          <td><code>.</code>\n          <td>Number\n          <td>Yes\n          <td>Decimal separator or monetary decimal separator\n     <tr valign=top>\n          <td><code>-</code>\n          <td>Number\n          <td>Yes\n          <td>Minus sign\n     <tr valign=top>\n          <td><code>,</code>\n          <td>Number\n          <td>Yes\n          <td>Grouping separator\n     <tr valign=top>\n          <td><code>E</code>\n          <td>Number\n          <td>Yes\n          <td>Separates mantissa and exponent in scientific notation.\n              <em>Need not be quoted in prefix or suffix.</em>\n     <tr valign=top>\n          <td><code>;</code>\n          <td>Subpattern boundary\n          <td>Yes\n          <td>Separates positive and negative subpatterns\n     <tr valign=top>\n          <td><code>%</code>\n          <td>Prefix or suffix\n          <td>Yes\n          <td>Multiply by 100 and show as percentage\n     <tr valign=top>\n          <td><code>&#92;u2030</code>\n          <td>Prefix or suffix\n          <td>Yes\n          <td>Multiply by 1000 and show as per mille\n     <tr valign=top>\n          <td><code>&#164;</code> (<code>&#92;u00A4</code>)\n          <td>Prefix or suffix\n          <td>No\n          <td>Currency sign, replaced by currency symbol.  If\n              doubled, replaced by international currency symbol.\n              If present in a pattern, the monetary decimal separator\n              is used instead of the decimal separator.\n     <tr valign=top>\n          <td><code>'</code>\n          <td>Prefix or suffix\n          <td>No\n          <td>Used to quote special characters in a prefix or suffix,\n              for example, <code>\"'#'#\"</code> formats 123 to\n              <code>\"#123\"</code>.  To create a single quote\n              itself, use two in a row: <code>\"# o''clock\"</code>.\n </table>\n  </body>\r\n</html>\r\n");
        this.jScrollPane3.setViewportView((Component)this.htmlDecimalFormatInfo);
        GroupLayout jPanel10Layout = new GroupLayout(this.jPanel10);
        this.jPanel10.setLayout(jPanel10Layout);
        jPanel10Layout.setHorizontalGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel10Layout.createSequentialGroup().addContainerGap().addGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane3, GroupLayout.Alignment.LEADING, -1, 479, Short.MAX_VALUE).addComponent(this.jPanel16, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel15, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel14, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel10Layout.setVerticalGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel10Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel14, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel15, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel16, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -1, 144, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane2.addTab(stringManager.getString("OrbadaSettingsDialog-numeric-format"), this.jPanel10);
        GroupLayout panelDataFormatLayout = new GroupLayout(this.panelDataFormat);
        this.panelDataFormat.setLayout(panelDataFormatLayout);
        panelDataFormatLayout.setHorizontalGroup(panelDataFormatLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelDataFormatLayout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane2, -1, 504, Short.MAX_VALUE).addContainerGap()));
        panelDataFormatLayout.setVerticalGroup(panelDataFormatLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelDataFormatLayout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane2, -1, 461, Short.MAX_VALUE).addContainerGap()));
        this.tabSettings.addTab(stringManager.getString("OrbadaSettingsDialog-data-format"), this.panelDataFormat);
        this.jLabel7.setHorizontalAlignment(4);
        this.jLabel7.setText(stringManager.getString("OrbadaSettingsDialog-background-color-dd"));
        this.panelEditorBackgroundColor.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("controlShadow"), 2));
        GroupLayout panelEditorBackgroundColorLayout = new GroupLayout(this.panelEditorBackgroundColor);
        this.panelEditorBackgroundColor.setLayout(panelEditorBackgroundColorLayout);
        panelEditorBackgroundColorLayout.setHorizontalGroup(panelEditorBackgroundColorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 274, Short.MAX_VALUE));
        panelEditorBackgroundColorLayout.setVerticalGroup(panelEditorBackgroundColorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 19, Short.MAX_VALUE));
        this.buttonSelect7.setAction((javax.swing.Action)this.cmSyntaxBackgroundColor);
        this.buttonSelect7.setMargin(new Insets(2, 2, 2, 2));
        this.buttonSelect7.setPreferredSize(new Dimension(75, 23));
        this.jLabel8.setHorizontalAlignment(4);
        this.jLabel8.setText(stringManager.getString("OrbadaSettingsDialog-syntax-dd"));
        this.comboSyntaxes.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.comboSyntaxes.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                OrbadaSettingsDialog.this.comboSyntaxesItemStateChanged(evt);
            }
        });
        this.jPanel5.setBorder(BorderFactory.createTitledBorder(stringManager.getString("OrbadaSettingsDialog-syntax-el-border-title")));
        this.listSyntaxElements.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                OrbadaSettingsDialog.this.listSyntaxElementsValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.listSyntaxElements);
        this.jLabel9.setText(stringManager.getString("OrbadaSettingsDialog-color-dd"));
        this.panelEditorForegroundColor.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("controlShadow"), 2));
        GroupLayout panelEditorForegroundColorLayout = new GroupLayout(this.panelEditorForegroundColor);
        this.panelEditorForegroundColor.setLayout(panelEditorForegroundColorLayout);
        panelEditorForegroundColorLayout.setHorizontalGroup(panelEditorForegroundColorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 124, Short.MAX_VALUE));
        panelEditorForegroundColorLayout.setVerticalGroup(panelEditorForegroundColorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 19, Short.MAX_VALUE));
        this.buttonSelect8.setAction((javax.swing.Action)this.cmSyntaxForegroundColor);
        this.buttonSelect8.setMargin(new Insets(2, 2, 2, 2));
        this.buttonSelect8.setPreferredSize(new Dimension(75, 23));
        this.checkEditorBold.setText(stringManager.getString("OrbadaSettingsDialog-checkEditorBold-text"));
        this.checkEditorBold.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                OrbadaSettingsDialog.this.checkEditorBoldItemStateChanged(evt);
            }
        });
        this.checkEditorItalic.setText(stringManager.getString("OrbadaSettingsDialog-checkEditorItalic-text"));
        this.checkEditorItalic.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                OrbadaSettingsDialog.this.checkEditorItalicItemStateChanged(evt);
            }
        });
        this.checkEditorUnderline.setText(stringManager.getString("OrbadaSettingsDialog-checkEditorUnderline-text"));
        this.checkEditorUnderline.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                OrbadaSettingsDialog.this.checkEditorUnderlineItemStateChanged(evt);
            }
        });
        this.checkEditorEnabled.setText(stringManager.getString("OrbadaSettingsDialog-checkEditorEnabled-text"));
        this.checkEditorEnabled.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                OrbadaSettingsDialog.this.checkEditorEnabledItemStateChanged(evt);
            }
        });
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 215, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.checkEditorBold).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkEditorItalic)).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelEditorForegroundColor, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonSelect8, -2, 86, -2)).addComponent(this.checkEditorEnabled).addComponent(this.checkEditorUnderline)).addContainerGap()));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 96, Short.MAX_VALUE).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.checkEditorEnabled).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.buttonSelect8, -1, 23, Short.MAX_VALUE).addComponent(this.jLabel9, -1, 23, Short.MAX_VALUE).addComponent(this.panelEditorForegroundColor, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkEditorBold).addComponent(this.checkEditorItalic)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkEditorUnderline))).addContainerGap()));
        this.jButton8.setAction((javax.swing.Action)this.cmSyntaxRestoreSettings);
        this.jButton8.setMargin(new Insets(2, 2, 2, 2));
        this.jButton8.setPreferredSize(new Dimension(85, 25));
        this.panelTableDataFont1.setBorder(BorderFactory.createTitledBorder(stringManager.getString("OrbadaSettingsDialog-panelEditorFont-border-title")));
        this.buttonTableDataFontChange1.setAction((javax.swing.Action)this.cmSyntaxFontChange);
        this.buttonTableDataFontChange1.setMargin(new Insets(2, 2, 2, 2));
        this.buttonTableDataFontChange1.setPreferredSize(new Dimension(85, 25));
        this.labelSyntaxFont.setHorizontalAlignment(0);
        this.labelSyntaxFont.setText(stringManager.getString("OrbadaSettingsDialog-OrbadaText-text"));
        GroupLayout panelTableDataFont1Layout = new GroupLayout(this.panelTableDataFont1);
        this.panelTableDataFont1.setLayout(panelTableDataFont1Layout);
        panelTableDataFont1Layout.setHorizontalGroup(panelTableDataFont1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, panelTableDataFont1Layout.createSequentialGroup().addContainerGap().addComponent(this.labelSyntaxFont, -1, 383, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonTableDataFontChange1, -2, -1, -2).addContainerGap()));
        panelTableDataFont1Layout.setVerticalGroup(panelTableDataFont1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, panelTableDataFont1Layout.createSequentialGroup().addGroup(panelTableDataFont1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.labelSyntaxFont, GroupLayout.Alignment.LEADING, -1, 36, Short.MAX_VALUE).addGroup(panelTableDataFont1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.buttonTableDataFontChange1, -2, -1, -2))).addContainerGap()));
        GroupLayout panelHighlightLayout = new GroupLayout(this.panelHighlight);
        this.panelHighlight.setLayout(panelHighlightLayout);
        panelHighlightLayout.setHorizontalGroup(panelHighlightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelHighlightLayout.createSequentialGroup().addContainerGap().addGroup(panelHighlightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.textEditorPreview, -1, 504, Short.MAX_VALUE).addComponent(this.jPanel5, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, panelHighlightLayout.createSequentialGroup().addGroup(panelHighlightLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel8, -1, 110, Short.MAX_VALUE).addComponent(this.jLabel7, GroupLayout.Alignment.TRAILING, -1, 110, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelHighlightLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(panelHighlightLayout.createSequentialGroup().addComponent(this.panelEditorBackgroundColor, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonSelect7, -2, 106, -2)).addComponent((Component)this.comboSyntaxes, GroupLayout.Alignment.LEADING, -1, 390, Short.MAX_VALUE))).addComponent(this.panelTableDataFont1, -1, -1, Short.MAX_VALUE).addComponent(this.jButton8, -2, -1, -2)).addContainerGap()));
        panelHighlightLayout.setVerticalGroup(panelHighlightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelHighlightLayout.createSequentialGroup().addContainerGap().addGroup(panelHighlightLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.comboSyntaxes, -2, -1, -2).addComponent(this.jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelHighlightLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel7, -1, -1, Short.MAX_VALUE).addComponent(this.panelEditorBackgroundColor, -1, -1, Short.MAX_VALUE).addComponent(this.buttonSelect7, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textEditorPreview, -1, 155, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelTableDataFont1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton8, -2, -1, -2).addContainerGap()));
        this.tabSettings.addTab(stringManager.getString("OrbadaSettingsDialog-editor-highlights"), this.panelHighlight);
        this.checkTabMovesSelected.setText(stringManager.getString("OrbadaSettingsDialog-checkTabMovesSelected-text"));
        this.panelAutoIndent.setBorder(BorderFactory.createTitledBorder(stringManager.getString("OrbadaSettingsDialog-panelAutoIndent-border-text")));
        this.checkAutoCompleteDot.setText(stringManager.getString("OrbadaSettingsDialog-checkAutoCompleteDot-text"));
        this.jLabel17.setText(stringManager.getString("OrbadaSettingsDialog-selected-list-el-dd"));
        this.autoCompleteInsertion.add(this.checkAutoCompleteInsertion);
        this.checkAutoCompleteInsertion.setText(stringManager.getString("OrbadaSettingsDialog-checkAutoCompleteInsertion-text"));
        this.autoCompleteInsertion.add(this.checkAutoCompleteReplace);
        this.checkAutoCompleteReplace.setText(stringManager.getString("OrbadaSettingsDialog-checkAutoCompleteReplace-text"));
        this.checkAutoCompleteInsertSingle.setText(stringManager.getString("OrbadaSettingsDialog-checkAutoCompleteInsertSingle-text"));
        this.checkAutoCompleteStructureParser.setText(stringManager.getString("OrbadaSettingsDialog-checkAutoCompleteStructureParser-text"));
        this.checkAutoCompleteStructureParserVariables.setText(stringManager.getString("OrbadaSettingsDialog-checkAutoCompleteStructureParserVariables-text"));
        this.jLabel18.setText(stringManager.getString("OrbadaSettingsDialog-open-after-dd"));
        this.jLabel19.setText(stringManager.getString("OrbadaSettingsDialog-close-after-dd"));
        GroupLayout panelAutoIndentLayout = new GroupLayout(this.panelAutoIndent);
        this.panelAutoIndent.setLayout(panelAutoIndentLayout);
        panelAutoIndentLayout.setHorizontalGroup(panelAutoIndentLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelAutoIndentLayout.createSequentialGroup().addContainerGap().addGroup(panelAutoIndentLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelAutoIndentLayout.createSequentialGroup().addGroup(panelAutoIndentLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkAutoCompleteStructureParserVariables, -1, 476, Short.MAX_VALUE).addComponent(this.checkAutoCompleteInsertSingle).addComponent(this.jLabel17).addGroup(panelAutoIndentLayout.createSequentialGroup().addComponent(this.checkAutoCompleteInsertion).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.checkAutoCompleteReplace)).addComponent(this.checkAutoCompleteStructureParser, -1, 476, Short.MAX_VALUE)).addContainerGap()).addComponent(this.checkAutoCompleteDot).addGroup(panelAutoIndentLayout.createSequentialGroup().addGap(21, 21, 21).addGroup(panelAutoIndentLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(panelAutoIndentLayout.createSequentialGroup().addComponent(this.jLabel19).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textAutoCompleteInactivate, -2, 63, -2)).addGroup(panelAutoIndentLayout.createSequentialGroup().addComponent(this.jLabel18).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textAutoCompleteActivate, -1, -1, Short.MAX_VALUE))).addGap(205, 205, 205)))));
        panelAutoIndentLayout.setVerticalGroup(panelAutoIndentLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelAutoIndentLayout.createSequentialGroup().addComponent(this.checkAutoCompleteDot).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelAutoIndentLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel18).addComponent((Component)this.textAutoCompleteActivate, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelAutoIndentLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel19).addComponent((Component)this.textAutoCompleteInactivate, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkAutoCompleteInsertSingle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel17).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelAutoIndentLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkAutoCompleteInsertion).addComponent(this.checkAutoCompleteReplace)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkAutoCompleteStructureParser, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkAutoCompleteStructureParserVariables, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.checkCopySyntaxHighlight.setText(stringManager.getString("OrbadaSettingsDialog-checkCopySyntaxHighlight-text"));
        this.checkEditorTrimWhitespaces.setText(stringManager.getString("OrbadaSettingsDialog-checkEditorTrimWhitespaces-text"));
        this.checkSmartHomeEnd.setText(stringManager.getString("OrbadaSettingsDialog-checkSmartHomeEnd-text"));
        this.jLabel20.setText(stringManager.getString("OrbadaSettingsDialog-tab-replace-spaces-dd"));
        this.checkPredefinedSnippets.setText(stringManager.getString("OrbadaSettingsDialog-checkPredefinedSnippets"));
        this.checkTabAsSpaces.setText(stringManager.getString("checkTabAsSpaces-text"));
        GroupLayout panelEditorLayout = new GroupLayout(this.panelEditor);
        this.panelEditor.setLayout(panelEditorLayout);
        panelEditorLayout.setHorizontalGroup(panelEditorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelEditorLayout.createSequentialGroup().addContainerGap().addGroup(panelEditorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkTabAsSpaces).addComponent(this.checkPredefinedSnippets).addComponent(this.checkTabMovesSelected).addComponent(this.checkEditorTrimWhitespaces, -1, 504, Short.MAX_VALUE).addComponent(this.checkCopySyntaxHighlight, -1, 504, Short.MAX_VALUE).addComponent(this.checkSmartHomeEnd, -1, 504, Short.MAX_VALUE).addGroup(panelEditorLayout.createSequentialGroup().addComponent(this.jLabel20).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinTabToSpace, -2, 61, -2)).addComponent(this.panelAutoIndent, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        panelEditorLayout.setVerticalGroup(panelEditorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelEditorLayout.createSequentialGroup().addContainerGap().addComponent(this.checkTabMovesSelected).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkCopySyntaxHighlight, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkEditorTrimWhitespaces, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkSmartHomeEnd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkPredefinedSnippets).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkTabAsSpaces).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelEditorLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel20).addComponent(this.spinTabToSpace, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelAutoIndent, -2, -1, -2).addContainerGap(51, Short.MAX_VALUE)));
        this.tabSettings.addTab(stringManager.getString("OrbadaSettingsDialog-editor"), this.panelEditor);
        this.buttonOk.setAction((javax.swing.Action)this.cmOk);
        this.buttonOk.setPreferredSize(new Dimension(85, 25));
        this.buttonCancel.setAction((javax.swing.Action)this.cmCancel);
        this.buttonCancel.setPreferredSize(new Dimension(85, 25));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.tabSettings, GroupLayout.Alignment.LEADING, -1, 529, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.buttonOk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.tabSettings, -1, 511, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel, -2, -1, -2).addComponent(this.buttonOk, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void cmTableDataFontChangeActionPerformed(ActionEvent evt) {
        Font font = FontChooser.showDialog(stringManager.getString("OrbadaSettingsDialog-select-font"), this.labelTableDataFont.getFont());
        if (font != null) {
            this.labelTableDataFont.setFont(font);
        }
    }

    private void cmColorNullActionPerformed(ActionEvent evt) {
        this.changeDataColor(this.panelColorNull);
    }

    private void cmColorBoolActionPerformed(ActionEvent evt) {
        this.changeDataColor(this.panelColorBool);
    }

    private void cmColorDateActionPerformed(ActionEvent evt) {
        this.changeDataColor(this.panelColorDate);
    }

    private void cmColorStringActionPerformed(ActionEvent evt) {
        this.changeDataColor(this.panelColorString);
    }

    private void cmColorNumberActionPerformed(ActionEvent evt) {
        this.changeDataColor(this.panelColorNumber);
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void cmOkActionPerformed(ActionEvent evt) {
        this.dialogToSettings();
        this.dispose();
    }

    private void comboSyntaxesItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 2) {
            if (evt.getItem() instanceof SyntaxDocument) {
                this.syntaxDocumentToList((SyntaxDocument)evt.getItem());
            }
        } else if (evt.getStateChange() == 1 && evt.getItem() instanceof SyntaxDocument) {
            this.listToSyntaxDocument((SyntaxDocument)evt.getItem());
            String text = this.textEditorPreview.getText();
            this.textEditorPreview.setDocument((SyntaxDocument)evt.getItem());
            this.textEditorPreview.setText(text);
        }
    }

    private void cmSyntaxBackgroundColorActionPerformed(ActionEvent evt) {
        this.changeDataColor(this.panelEditorBackgroundColor);
        this.textEditorPreview.getEditorArea().setBackground(this.panelEditorBackgroundColor.getBackground());
        this.textEditorPreview.repaint();
    }

    private void cmSyntaxForegroundColorActionPerformed(ActionEvent evt) {
        this.changeDataColor(this.panelEditorForegroundColor);
        this.updateSyntaxStyle();
    }

    private void listSyntaxElementsValueChanged(ListSelectionEvent evt) {
        this.updateListSyntaxElement();
    }

    private void checkEditorEnabledItemStateChanged(ItemEvent evt) {
        this.updateSyntaxStyle();
    }

    private void checkEditorBoldItemStateChanged(ItemEvent evt) {
        this.updateSyntaxStyle();
    }

    private void checkEditorItalicItemStateChanged(ItemEvent evt) {
        this.updateSyntaxStyle();
    }

    private void checkEditorUnderlineItemStateChanged(ItemEvent evt) {
        this.updateSyntaxStyle();
    }

    private void cmSyntaxRestoreSettingsActionPerformed(ActionEvent evt) {
        this.prepareSyntaxes();
        this.comboSyntaxes.addItem((Object)this.sqlDocument);
        this.comboSyntaxes.addItem((Object)this.javaDocument);
    }

    private void cmSyntaxFontChangeActionPerformed(ActionEvent evt) {
        Font font = FontChooser.showDialog(stringManager.getString("OrbadaSettingsDialog-select-font"), this.labelSyntaxFont.getFont());
        if (font != null) {
            this.labelSyntaxFont.setFont(font);
            this.textEditorPreview.getEditorArea().setFont(font);
            this.textEditorPreview.repaint();
        }
    }

    private void cmColorSelectedRowActionPerformed(ActionEvent evt) {
        this.changeDataColor(this.panelColorSelectedTableRow);
    }

    private void checkDefaultLookAndFeelActionPerformed(ActionEvent evt) {
        this.setLookAndFeelEnabled();
    }

    private void checkDateFormatDefaultActionPerformed(ActionEvent evt) {
        this.setDataTypeEnabled();
    }

    private void checkTimeFormatDefaultActionPerformed(ActionEvent evt) {
        this.setDataTypeEnabled();
    }

    private void checkTimeStampFormatDefaultActionPerformed(ActionEvent evt) {
        this.setDataTypeEnabled();
    }

    private void checkDecimalFormatDefaultActionPerformed(ActionEvent evt) {
        this.setDataTypeEnabled();
    }

    private void checkBigDecimalFormatDefaultActionPerformed(ActionEvent evt) {
        this.setDataTypeEnabled();
    }

    private void checkDecimalSeparatorDefaultActionPerformed(ActionEvent evt) {
        this.setDataTypeEnabled();
    }

    private void checkPleaseWaitOnActionPerformed(ActionEvent evt) {
        this.setPleaseWaitEnabled();
    }

    private void checkDateFormatDefaultItemStateChanged(ItemEvent evt) {
        this.updateSampleDateTimeFormat();
    }

    private void textDateFormatFocusLost(FocusEvent evt) {
        this.updateSampleDateTimeFormat();
    }

    private void checkTimeFormatDefaultItemStateChanged(ItemEvent evt) {
        this.updateSampleDateTimeFormat();
    }

    private void textTimeFormatFocusLost(FocusEvent evt) {
        this.updateSampleDateTimeFormat();
    }

    private void checkTimeStampFormatDefaultItemStateChanged(ItemEvent evt) {
        this.updateSampleDateTimeFormat();
    }

    private void textTimeStampFormatFocusLost(FocusEvent evt) {
        this.updateSampleDateTimeFormat();
    }

    private void checkDecimalFormatDefaultItemStateChanged(ItemEvent evt) {
        this.updateSampleDecimalFormat();
    }

    private void textDecimalFormatFocusLost(FocusEvent evt) {
        this.updateSampleDecimalFormat();
    }

    private void checkBigDecimalFormatDefaultItemStateChanged(ItemEvent evt) {
        this.updateSampleDecimalFormat();
    }

    private void textBigDecimalFormatFocusLost(FocusEvent evt) {
        this.updateSampleDecimalFormat();
    }

    private void checkDecimalSeparatorDefaultItemStateChanged(ItemEvent evt) {
        this.updateSampleDecimalFormat();
    }

    private void textDecimalSeparatorFocusLost(FocusEvent evt) {
        this.updateSampleDecimalFormat();
    }

    private void radioNoProxyItemStateChanged(ItemEvent evt) {
        this.setProxyEnabled();
    }

    private void radioUseSystemProxyItemStateChanged(ItemEvent evt) {
        this.setProxyEnabled();
    }

    private void radioManulProxyItemStateChanged(ItemEvent evt) {
        this.setProxyEnabled();
    }

    private void checkProxyAuthNeddedItemStateChanged(ItemEvent evt) {
        this.setProxyEnabled();
    }

    private void cmPleaseWaitTestActionPerformed(ActionEvent evt) {
        if (this.waitTest == null) {
            this.waitTest = new PleaseWait(ImageManager.getImage((String)"/res/orbada48.png"), stringManager.getString("please-wait-test-message"));
            this.cmPleaseWaitTest.setText(stringManager.getString("cmPleaseWaitTest-stop-text"));
            Application.get().getMainFrame().getGlassPane().addPleaseWait(this.waitTest, this.pwrpa[this.comboPleaseWaitService.getSelectedIndex()].getRendererId());
        } else {
            Application.get().getMainFrame().getGlassPane().removePleaseWait(this.waitTest);
            this.waitTest = null;
            this.cmPleaseWaitTest.setText(stringManager.getString("cmPleaseWaitTest-test-text"));
        }
    }

    public static enum Tab {
        tabGeneral,
        tabProxy,
        tabApperance,
        tabDataLists,
        tabDataFormat,
        tabSyntaxHighlighting,
        tabEditor;

    }
}

