/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui;

import java.awt.Component;
import java.awt.EventQueue;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JTabbedPane;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.ITabObjectUserData;
import pl.mpak.sky.gui.swing.TabCloseComponent;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.CloseAbilitable;
import pl.mpak.util.Titleable;
import pl.mpak.util.variant.Variant;

public class OrbadaTabbedPane
extends JTabbedPane
implements ITabObjectInfo,
ITabObjectUserData {
    private String objectType;
    private String catalogName;
    private String schemaName;
    private String objectName;

    public OrbadaTabbedPane(String objectType, final Component[] components) {
        this.objectType = objectType;
        this.setFocusable(false);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (components != null) {
                    for (Component component : components) {
                        OrbadaTabbedPane.this.addInfoPanel(component);
                    }
                }
            }
        });
    }

    public OrbadaTabbedPane(Component[] components) {
        this(null, components);
    }

    public void refreshImmediate() {
        for (int i = 0; i < this.getTabCount(); ++i) {
            Component c = this.getComponentAt(i);
            if (!(c instanceof ITabObjectInfo) || !c.isVisible()) continue;
            ((ITabObjectInfo)((Object)c)).refresh();
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void userData(HashMap<String, Variant> values) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            Component c = this.getComponentAt(i);
            if (!(c instanceof ITabObjectUserData)) continue;
            ((ITabObjectUserData)((Object)c)).userData(values);
        }
    }

    @Override
    public void refresh() {
        for (int i = 0; i < this.getTabCount(); ++i) {
            Component c = this.getComponentAt(i);
            if (!(c instanceof ITabObjectInfo)) continue;
            ((ITabObjectInfo)((Object)c)).refresh(this.catalogName, this.schemaName, this.objectName);
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void refresh(String catalogName, String schemaName, String objectName) {
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.objectName = objectName;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                OrbadaTabbedPane.this.refresh();
            }
        });
    }

    public String getTitle() {
        return SQLUtil.createSqlName((String)this.catalogName, (String)this.schemaName, (String)this.objectName);
    }

    protected void addInfoPanel(Component panel) {
        if (panel != null) {
            this.addTab(((Titleable)panel).getTitle(), panel);
            this.setTabComponentAt(this.indexOfComponent(panel), (Component)new TabCloseComponent(((Titleable)panel).getTitle()));
        }
    }

    @Override
    public void close() throws IOException {
        int i = 0;
        while (i < this.getTabCount()) {
            Component c = this.getComponentAt(i);
            if (c instanceof Closeable) {
                try {
                    ((Closeable)((Object)c)).close();
                }
                catch (IOException iOException) {}
            } else {
                ++i;
            }
            this.remove(c);
        }
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public Component getComponent(Class<? extends Component> clazz) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (!clazz.isInstance(this.getComponent(i))) continue;
            return this.getComponent(i);
        }
        return null;
    }

    public Component[] getComponents(Class<?> clazz) {
        ArrayList<Component> list = new ArrayList<Component>();
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (!clazz.isInstance(this.getComponent(i))) continue;
            list.add(this.getComponent(i));
        }
        return list.toArray(new Component[list.size()]);
    }

    public boolean canClose() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (!(this.getComponent(i) instanceof CloseAbilitable) || ((CloseAbilitable)this.getComponent(i)).canClose()) continue;
            return false;
        }
        return true;
    }
}

