/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JToolBar;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.gui.PerspectivePanel;
import pl.mpak.orbada.plugins.IApplication;
import pl.mpak.orbada.plugins.IPerspectiveAccesibilities;
import pl.mpak.orbada.plugins.providers.PerspectiveProvider;
import pl.mpak.orbada.plugins.providers.ViewProvider;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;

public class PerspectiveAccesibilities
implements IPerspectiveAccesibilities,
ComponentListener {
    private ArrayList<JMenu> menuList;
    private JToolBar toolBar;
    private ArrayList<JComponent> statusList;
    private PerspectivePanel perspective;
    private ArrayList<PerspectiveProvider> serviceList;
    private ArrayList<JToolBar> toolBarList;

    public PerspectiveAccesibilities(PerspectivePanel perspective) {
        this.perspective = perspective;
        this.init();
    }

    private void init() {
        this.serviceList = new ArrayList();
    }

    public void close() {
        if (this.menuList != null) {
            for (JMenu menu : this.menuList) {
                Application.get().getMainFrame().removeMenu(menu);
            }
            this.menuList.clear();
        }
        if (this.toolBar != null) {
            Application.get().getMainFrame().removeToolBar(this.toolBar);
            this.toolBar = null;
        }
        if (this.statusList != null) {
            for (JComponent statusBar : this.statusList) {
                this.perspective.removeStatusBar(statusBar);
            }
            this.statusList.clear();
        }
        if (this.toolBarList != null) {
            for (JToolBar tb : this.toolBarList) {
                Application.get().getMainFrame().removeToolBar(tb);
            }
            this.toolBarList.clear();
        }
        for (PerspectiveProvider pp : this.serviceList) {
            pp.perspectiveClose();
        }
        this.serviceList.clear();
        this.perspective = null;
    }

    public void addSerivce(PerspectiveProvider serivce) {
        this.serviceList.add(serivce);
    }

    public Database getDatabase() {
        return this.perspective.getDatabase();
    }

    public IApplication getApplication() {
        return Application.get();
    }

    public void addMenu(final JMenu menu) {
        if (menu != null) {
            if (this.menuList == null) {
                this.menuList = new ArrayList();
            }
            this.menuList.add(menu);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Application.get().getMainFrame().addMenu(menu);
                }
            });
        }
    }

    public void addAction(pl.mpak.sky.gui.swing.Action action) {
        if (action != null) {
            if (this.toolBar == null) {
                this.toolBar = new JToolBar();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Application.get().getMainFrame().addToolBar(PerspectiveAccesibilities.this.toolBar);
                    }
                });
            }
            this.toolBar.add((Component)new ToolButton((Action)action));
        }
    }

    public void addStatusBar(JComponent statusBar) {
        if (statusBar != null) {
            if (this.statusList == null) {
                this.statusList = new ArrayList();
            }
            this.statusList.add(statusBar);
            this.perspective.addStatusBar(statusBar);
        }
    }

    public void addToolBar(final JToolBar toolBar) {
        if (toolBar != null) {
            if (this.toolBarList == null) {
                this.toolBarList = new ArrayList();
            }
            this.toolBarList.add(toolBar);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Application.get().getMainFrame().addToolBar(toolBar);
                }
            });
        }
    }

    public Component getViewComponent(ViewProvider view) {
        return this.perspective.getViewComponent(view);
    }

    public Component createView(ViewProvider view) {
        return this.perspective.createView(view, false, false);
    }

    public void closeView(Component component) {
        this.perspective.closeView(component);
    }

    public void setSelectedView(Component c) {
        this.perspective.setSelectedView(c);
    }

    public void componentShow() {
        if (this.menuList != null) {
            for (JMenu menu : this.menuList) {
                menu.setVisible(true);
            }
        }
        if (this.toolBar != null) {
            this.toolBar.setVisible(true);
        }
        if (this.toolBarList != null) {
            for (JToolBar tb : this.toolBarList) {
                tb.setVisible(true);
            }
        }
        for (PerspectiveProvider pp : this.serviceList) {
            pp.perspectiveShow();
        }
    }

    public void componentHide() {
        if (this.menuList != null) {
            for (JMenu menu : this.menuList) {
                menu.setVisible(false);
            }
        }
        if (this.toolBar != null) {
            this.toolBar.setVisible(false);
        }
        if (this.toolBarList != null) {
            for (JToolBar tb : this.toolBarList) {
                tb.setVisible(false);
            }
        }
        for (PerspectiveProvider pp : this.serviceList) {
            pp.perspectiveHide();
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.componentShow();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        this.componentHide();
    }

    public String getPerspectiveId() {
        return this.perspective.getPerspective().getPpsId();
    }
}

