/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.Closeable;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import pl.mpak.orbada.Consts;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.db.Gadget;
import pl.mpak.orbada.db.InternalDatabase;
import pl.mpak.orbada.db.Perspective;
import pl.mpak.orbada.db.Schema;
import pl.mpak.orbada.db.View;
import pl.mpak.orbada.gui.PerspectiveAccesibilities;
import pl.mpak.orbada.gui.ViewAccesibilities;
import pl.mpak.orbada.gui.gadgets.GadgetPanel;
import pl.mpak.orbada.plugins.IPerspectiveAccesibilities;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.plugins.providers.PerpectiveGadgetProvider;
import pl.mpak.orbada.plugins.providers.PerspectiveProvider;
import pl.mpak.orbada.plugins.providers.ViewProvider;
import pl.mpak.orbada.plugins.queue.PluginMessage;
import pl.mpak.orbada.util.Utils;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.TabCloseComponent;
import pl.mpak.sky.gui.swing.VerticalFlowLayout;
import pl.mpak.usedb.core.Command;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.CloseAbilitable;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class PerspectivePanel
extends JPanel
implements Closeable {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);
    private Database database;
    private LinkedList<ViewAccesibilities> viewList = new LinkedList();
    private Schema schema;
    private Perspective perspective;
    private TabCloseComponent tabComponent;
    private int splitMouseX;
    PerspectiveAccesibilities perspectiveAccesibilities;
    private ArrayList<PerpectiveGadgetProvider> gadgetServiceList = new ArrayList();
    private JSplitPane gadgetsSpliter;
    private ArrayList<GadgetPanel> gadgetList = new ArrayList();
    private boolean updatingAllGadgets = false;
    private JScrollPane jScrollPane1;
    private JPanel panelGadgets;
    private JPanel panelPerspectiveGadgets;
    private JPanel panelRoot;
    private JPanel panelStatus;
    private JTabbedPane tabbedViews;

    public PerspectivePanel() {
        this(null, null);
    }

    public PerspectivePanel(Database database, Schema schema) {
        this.database = database;
        this.schema = schema;
        this.initComponents();
        this.init();
    }

    public PerspectivePanel(Database database, Schema schema, Perspective perspective) {
        this.database = database;
        this.schema = schema;
        this.perspective = perspective;
        this.initComponents();
        this.init();
    }

    public Database getDatabase() {
        return this.database;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public TabCloseComponent getTabComponent() {
        return this.tabComponent;
    }

    public void setTabComponent(TabCloseComponent tabComponent) {
        this.tabComponent = tabComponent;
    }

    public Perspective getPerspective() {
        return this.perspective;
    }

    public PerspectiveAccesibilities getPerspectiveAccesibilities() {
        return this.perspectiveAccesibilities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void init() {
        PerpectiveGadgetProvider[] pgp;
        this.panelPerspectiveGadgets.setVisible(false);
        this.perspectiveAccesibilities = new PerspectiveAccesibilities(this);
        ViewProvider[] vps = (ViewProvider[])Application.get().getServiceArray(ViewProvider.class);
        int count = Application.get().getMainFrame().getDatabaseInUse(this.database);
        int viewCount = 0;
        try {
            viewCount = this.createPerspectiveViews(this.perspective.fieldByName("pps_id").getString());
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        this.addComponentListener(this.perspectiveAccesibilities);
        PerspectiveProvider[] pps = (PerspectiveProvider[])Application.get().getServiceArray(PerspectiveProvider.class);
        if (pps != null && pps.length > 0) {
            for (PerspectiveProvider perspectiveProvider : pps) {
                if (!perspectiveProvider.isForDatabase(this.getDatabase())) continue;
                perspectiveProvider.setAccesibilities((IPerspectiveAccesibilities)this.perspectiveAccesibilities);
                perspectiveProvider.initialize();
                this.perspectiveAccesibilities.addSerivce(perspectiveProvider);
            }
        }
        if (count == 0 && viewCount == 0 && vps != null && vps.length > 0) {
            for (PerspectiveProvider perspectiveProvider : vps) {
                if (!perspectiveProvider.isForDatabase(this.getDatabase()) || !perspectiveProvider.isDefaultView()) continue;
                this.createView((ViewProvider)perspectiveProvider, false, false);
            }
        }
        if ((pgp = (PerpectiveGadgetProvider[])Application.get().getServiceArray(PerpectiveGadgetProvider.class)) != null && pgp.length > 0) {
            void var8_16;
            PerpectiveGadgetProvider[] arr$ = pgp;
            int len$ = arr$.length;
            boolean bl = false;
            while (var8_16 < len$) {
                PerpectiveGadgetProvider pg = arr$[var8_16];
                if (pg.isForDatabase(this.getDatabase())) {
                    this.gadgetServiceList.add(pg);
                }
                ++var8_16;
            }
        }
        int gadgetCount = 0;
        Query gadgets = InternalDatabase.get().createQuery();
        this.updatingAllGadgets = true;
        try {
            gadgets.setSqlText("select gdg_name, gdg_minimized, gdg_height from gadgets where gdg_pps_id = :pps_id order by gdg_order");
            gadgets.paramByName("pps_id").setString(this.perspective.fieldByName("pps_id").getString());
            gadgets.open();
            while (!gadgets.eof()) {
                String string = gadgets.fieldByName("gdg_name").getString();
                for (PerpectiveGadgetProvider pg : this.gadgetServiceList) {
                    if (!string.equals(pg.getGadgetId())) continue;
                    GadgetPanel gp = this.createGadget(pg, gadgets.fieldByName("gdg_height").getInteger());
                    gp.setMinimized(StringUtil.toBoolean((String)gadgets.fieldByName("gdg_minimized").getString()));
                    ++gadgetCount;
                    break;
                }
                gadgets.next();
            }
        }
        catch (Exception exception) {
            ExceptionUtil.processException((Throwable)exception);
        }
        finally {
            this.updatingAllGadgets = false;
            this.updateGadgetPanel();
            gadgets.close();
        }
        if (gadgetCount > 0) {
            this.panelPerspectiveGadgets.setPreferredSize(new Dimension(Math.max(this.perspective.getGadgetsWidth(), 20), 0));
        }
        Application.get().postPluginMessage(new PluginMessage(null, "perspective-opened", (Object)this));
    }

    public boolean canClose() {
        block9: {
            for (int i = 0; i < this.tabbedViews.getTabCount(); ++i) {
                Component c = this.tabbedViews.getComponentAt(i);
                if (!(c instanceof CloseAbilitable) || ((CloseAbilitable)c).canClose()) continue;
                return false;
            }
            if (this.getDatabase() != null && this.getDatabase().getMetaData() != null && Application.get().getMainFrame().getDatabaseInUse(this.getDatabase()) == 1) {
                try {
                    if (!this.getDatabase().getMetaData().supportsTransactions() || this.getDatabase().getConnection().getAutoCommit()) break block9;
                    switch (MessageBox.show((Component)this, (String)stringManager.getString("PerspectivePanel-database"), (String)String.format(stringManager.getString("PerspectivePanel-close-connection-q"), this.getDatabase().getUrl()), (int[])new int[]{5, 6, 2}, (int)3)) {
                        case 5: {
                            this.getDatabase().commit();
                            break;
                        }
                        case 6: {
                            if (!Application.get().getSettings().getValue("no-rollback-on-close", Boolean.valueOf(false)).booleanValue()) {
                                this.getDatabase().rollback();
                            }
                            break;
                        }
                        default: {
                            return false;
                        }
                    }
                }
                catch (SQLException ex) {
                    ExceptionUtil.processException((Throwable)ex);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createPerspectiveViews(String apps_id) {
        ViewProvider[] vps = (ViewProvider[])Application.get().getServiceArray(ViewProvider.class);
        int viewCount = 0;
        Query views = InternalDatabase.get().createQuery();
        try {
            views.setSqlText("select vws_name, vws_hide_title, vws_hide_icon from views where vws_pps_id = :pps_id order by vws_order");
            views.paramByName("pps_id").setString(apps_id);
            views.open();
            while (!views.eof()) {
                String viewId = views.fieldByName("vws_name").getString();
                for (ViewProvider vp : vps) {
                    if (!vp.isForDatabase(this.getDatabase()) || !viewId.equals(vp.getViewId())) continue;
                    ++viewCount;
                    this.createView(vp, "T".equalsIgnoreCase(views.fieldByName("vws_hide_title").getString()), "T".equalsIgnoreCase(views.fieldByName("vws_hide_icon").getString()));
                    break;
                }
                views.next();
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            views.close();
        }
        return viewCount;
    }

    public void createPerspectiveViews(PerspectivePanel panelFrom) {
        this.closeAllViews();
        for (ViewAccesibilities va : panelFrom.viewList) {
            this.createView(va.getViewProvider(), va.isHideTitle(), va.isHideIcon());
        }
    }

    public void closeAllViews() {
        while (this.tabbedViews.getTabCount() > 0) {
            this.closeView(this.tabbedViews.getComponentAt(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        int i;
        Command command = InternalDatabase.get().createCommand();
        try {
            command.setSqlText("delete from views where vws_pps_id = :pps_id");
            command.paramByName("pps_id").setString(this.perspective.fieldByName("pps_id").getString());
            command.execute();
            int viewCount = 0;
            for (i = 0; i < this.tabbedViews.getTabCount(); ++i) {
                Component c = this.tabbedViews.getComponentAt(i);
                ViewAccesibilities va = this.getViewAccesibilities(c);
                if (va == null || va.getViewProvider().getViewId() == null) continue;
                View v = new View(InternalDatabase.get());
                v.setPpsId(this.perspective.fieldByName("pps_id").getString());
                v.setName(va.getViewProvider().getViewId());
                v.setOrder(Integer.valueOf(viewCount));
                v.setHideTitle(va.isHideTitle());
                v.setHideIcon(va.isHideIcon());
                v.applyInsert();
                ++viewCount;
            }
            this.perspective.setViewCount(viewCount);
            this.perspective.applyUpdate();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        this.closeAllViews();
        this.updatingAllGadgets = true;
        try {
            command.setSqlText("delete from gadgets where gdg_pps_id = :pps_id");
            command.paramByName("pps_id").setString(this.perspective.fieldByName("pps_id").getString());
            command.execute();
            int gadgetCount = 0;
            for (i = 0; i < this.gadgetList.size(); ++i) {
                GadgetPanel gp = this.gadgetList.get(i);
                Gadget g = new Gadget(InternalDatabase.get());
                g.setPpsId(this.perspective.fieldByName("pps_id").getString());
                g.setName(gp.getProvider().getGadgetId());
                g.setOrder(Integer.valueOf(gadgetCount));
                JSplitPane split = (JSplitPane)SwingUtil.getOwnerComponent(JSplitPane.class, (Component)gp);
                if (split != null) {
                    g.setHeight(Integer.valueOf(split.getDividerLocation()));
                } else {
                    g.setHeight(Integer.valueOf(gp.getPreferredSize().height));
                }
                g.setMinimized(gp.isMinimized());
                g.applyInsert();
                ++gadgetCount;
            }
            this.perspective.setGadgetCount(gadgetCount);
            if (gadgetCount > 0) {
                this.perspective.setGadgetsWidth(this.tabbedViews.getWidth());
            }
            this.perspective.applyUpdate();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        this.updatingAllGadgets = true;
        try {
            while (this.gadgetList.size() > 0) {
                this.closeGadget(this.gadgetList.get(0));
            }
        }
        finally {
            this.updatingAllGadgets = false;
            this.updateGadgetPanel();
        }
        if (this.getDatabase() != null && Application.get().getMainFrame().getDatabaseInUse(this.getDatabase()) == 0) {
            this.getDatabase().close();
        }
        this.tabbedViews.removeAll();
        this.perspectiveAccesibilities.close();
        this.removeComponentListener(this.perspectiveAccesibilities);
        this.perspectiveAccesibilities = null;
        this.viewList = null;
        this.tabComponent = null;
        Application.get().postPluginMessage(new PluginMessage(null, "perspective-closed", (Object)this));
    }

    private boolean canClose(Component component) {
        if (component instanceof CloseAbilitable) {
            return ((CloseAbilitable)component).canClose();
        }
        return true;
    }

    public void closeView(Component component) {
        ViewAccesibilities va;
        if (component instanceof Closeable) {
            try {
                ((Closeable)((Object)component)).close();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        if ((va = this.getViewAccesibilities(component)) != null) {
            va.close();
            this.viewList.remove(va);
        }
        this.tabbedViews.remove(component);
        Application.get().getMainFrame().viewClosed(this);
        Application.get().postPluginMessage(new PluginMessage(null, "view-closed", (Object)component));
    }

    private GadgetPanel findGadget(JComponent onComponent, PerpectiveGadgetProvider provider) {
        GadgetPanel gp = null;
        for (int i = 0; i < onComponent.getComponentCount(); ++i) {
            GadgetPanel component;
            if (onComponent.getComponent(i) instanceof GadgetPanel) {
                gp = (GadgetPanel)onComponent.getComponent(i);
                if (!gp.getProvider().getClass().equals(provider.getClass())) continue;
                return gp;
            }
            if (!(onComponent.getComponent(i) instanceof JComponent) || (component = this.findGadget((JComponent)onComponent.getComponent(i), provider)) == null) continue;
            return component;
        }
        return null;
    }

    private void updateGadgetPanel() {
        this.panelGadgets.removeAll();
        if (this.gadgetList.isEmpty()) {
            this.panelPerspectiveGadgets.setVisible(false);
            this.removePerspectiveSpliter();
        } else {
            Component owner = this.gadgetList.get(0);
            for (int i = 1; i < this.gadgetList.size(); ++i) {
                JSplitPane split = this.createSpliter(0);
                split.setTopComponent(owner);
                split.setBottomComponent(this.gadgetList.get(i));
                if (owner instanceof GadgetPanel) {
                    if (((GadgetPanel)owner).getInitialHeight() > 0) {
                        split.setDividerLocation(((GadgetPanel)owner).getInitialHeight());
                    } else {
                        split.setDividerLocation(0.9f);
                    }
                }
                owner = split;
            }
            this.panelGadgets.add(owner);
            this.panelPerspectiveGadgets.setVisible(true);
            this.panelPerspectiveGadgets.validate();
            this.createPerspectiveSpliter();
        }
        this.panelGadgets.revalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeGadget(GadgetPanel gp) {
        try {
            if (gp instanceof GadgetPanel) {
                gp.close();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.gadgetList.remove(gp);
        }
        if (!this.updatingAllGadgets) {
            this.updateGadgetPanel();
        }
    }

    public GadgetPanel createGadget(PerpectiveGadgetProvider provider, int height) {
        GadgetPanel gp = this.findGadget(this.panelGadgets, provider);
        if (gp != null) {
            return gp;
        }
        gp = new GadgetPanel(this, provider, height);
        this.gadgetList.add(gp);
        if (!this.updatingAllGadgets) {
            this.updateGadgetPanel();
        }
        return gp;
    }

    public ArrayList<PerpectiveGadgetProvider> getGadgetServiceList() {
        return this.gadgetServiceList;
    }

    private void createViewQueue(final ViewProvider view, final boolean hideTitle, final boolean hideIcon) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                PerspectivePanel.this.createView(view, hideTitle, hideIcon);
            }
        });
    }

    public Component createView(ViewProvider view, boolean hideTitle, boolean hideIcon) {
        Icon icon = view.getIcon();
        TabCloseComponent tabClose = new TabCloseComponent(view.getPublicName(), icon);
        ViewAccesibilities va = new ViewAccesibilities(this.getDatabase(), tabClose, this, view);
        final Component c = view.createView((IViewAccesibilities)va);
        if (c != null) {
            va.setViewComponent(c);
            va.setHideTitle(hideTitle);
            va.setHideIcon(hideIcon);
            tabClose.getAction().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PerspectivePanel.this.canClose(c)) {
                        PerspectivePanel.this.closeView(c);
                    }
                }
            });
            this.tabbedViews.addTab(view.getPublicName(), null, c, "<html><b>" + view.getPublicName() + "</b><br>&nbsp;" + view.getDescription());
            this.tabbedViews.setTabComponentAt(this.tabbedViews.indexOfComponent(c), (Component)tabClose);
            this.tabbedViews.setSelectedComponent(c);
            this.viewList.add(va);
            Application.get().getMainFrame().viewAdded(this, view);
            Application.get().postPluginMessage(new PluginMessage(null, "view-opened", (Object)c));
        }
        return c;
    }

    public void closeCurrentView() {
        for (int i = 0; i < this.tabbedViews.getTabCount(); ++i) {
            if (!this.tabbedViews.getComponentAt(i).isVisible()) continue;
            if (!this.canClose(this.tabbedViews.getComponentAt(i))) break;
            this.closeView(this.tabbedViews.getComponentAt(i));
            break;
        }
    }

    public void setSelectedView(Component view) {
        this.tabbedViews.setSelectedComponent(view);
    }

    public int getViewCount() {
        return this.tabbedViews.getTabCount();
    }

    public Component getViewComponent(ViewProvider view) {
        for (ViewAccesibilities va : this.viewList) {
            if (va.getViewProvider().getViewId() == null || !va.getViewProvider().getViewId().equals(view.getViewId())) continue;
            return va.getViewComponent();
        }
        return null;
    }

    public Component[] getViewComponentList(ViewProvider view) {
        ArrayList<Component> list = new ArrayList<Component>();
        for (ViewAccesibilities va : this.viewList) {
            if (va.getViewProvider().getViewId() == null || !va.getViewProvider().getViewId().equals(view.getViewId())) continue;
            list.add(va.getViewComponent());
        }
        return list.toArray(new Component[list.size()]);
    }

    protected ViewAccesibilities getViewAccesibilities(Component view) {
        for (ViewAccesibilities va : this.viewList) {
            if (!va.getViewComponent().equals(view)) continue;
            return va;
        }
        return null;
    }

    public boolean isViewCreated(Class<? extends ViewProvider> provider) {
        for (ViewAccesibilities va : this.viewList) {
            if (va.getViewProvider().getClass() != provider) continue;
            return true;
        }
        return false;
    }

    public IViewAccesibilities getViewAccesibilitiesForChild(Component child) {
        while (child != null && !this.equals(child)) {
            for (ViewAccesibilities va : this.viewList) {
                if (!va.getViewComponent().equals(child)) continue;
                return va;
            }
            child = child.getParent();
        }
        return null;
    }

    public void moveViewRight() {
        Utils.moveTabRight(this.tabbedViews);
    }

    public void moveViewLeft() {
        Utils.moveTabLeft(this.tabbedViews);
    }

    private void updateStatusBar() {
        GridLayout gl = (GridLayout)this.panelStatus.getLayout();
        gl.setRows(this.panelStatus.getComponentCount());
    }

    public void addStatusBar(Component component) {
        if (component instanceof JComponent) {
            ((JComponent)component).setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getDefaults().getColor("controlShadow")));
        }
        this.panelStatus.add(component);
        this.updateStatusBar();
    }

    public void removeStatusBar(Component component) {
        this.panelStatus.remove(component);
        this.updateStatusBar();
    }

    public JTabbedPane getTabbedViews() {
        return this.tabbedViews;
    }

    private JSplitPane createSpliter(int orientation) {
        JSplitPane split = new JSplitPane(orientation);
        split.setBorder(null);
        split.setContinuousLayout(true);
        split.setOneTouchExpandable(true);
        return split;
    }

    private JSplitPane createPerspectiveSpliter() {
        if (this.gadgetsSpliter == null) {
            this.gadgetsSpliter = this.createSpliter(1);
            this.gadgetsSpliter.setLeftComponent(this.tabbedViews);
            this.gadgetsSpliter.setRightComponent(this.panelPerspectiveGadgets);
            this.gadgetsSpliter.setResizeWeight(1.0);
            this.panelRoot.remove(this.tabbedViews);
            this.panelRoot.remove(this.panelPerspectiveGadgets);
            this.panelRoot.add((Component)this.gadgetsSpliter, "Center");
            if (this.perspective.getGadgetsWidth() > 50) {
                this.gadgetsSpliter.setDividerLocation(this.perspective.getGadgetsWidth());
            } else {
                this.gadgetsSpliter.setDividerLocation(0.5);
            }
        }
        return this.gadgetsSpliter;
    }

    private void removePerspectiveSpliter() {
        if (this.gadgetsSpliter != null) {
            this.perspective.setGadgetsWidth(this.gadgetsSpliter.getDividerLocation());
            this.panelRoot.remove(this.gadgetsSpliter);
            this.panelRoot.add((Component)this.tabbedViews, "Center");
            this.panelRoot.add((Component)this.panelPerspectiveGadgets, "East");
            this.gadgetsSpliter = null;
        }
    }

    private void initComponents() {
        this.panelStatus = new JPanel();
        this.panelRoot = new JPanel();
        this.tabbedViews = new JTabbedPane();
        this.panelPerspectiveGadgets = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.panelGadgets = new JPanel();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent evt) {
                PerspectivePanel.this.formComponentHidden(evt);
            }

            @Override
            public void componentShown(ComponentEvent evt) {
                PerspectivePanel.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.panelStatus.setLayout(new GridLayout(1, 0));
        this.add((Component)this.panelStatus, "South");
        this.panelRoot.setLayout(new BorderLayout());
        this.tabbedViews.setFocusable(false);
        this.panelRoot.add((Component)this.tabbedViews, "Center");
        this.panelPerspectiveGadgets.setLayout(new BorderLayout());
        this.jScrollPane1.setBorder(null);
        VerticalFlowLayout verticalFlowLayout1 = new VerticalFlowLayout();
        verticalFlowLayout1.setHgap(1);
        verticalFlowLayout1.setVgap(1);
        verticalFlowLayout1.setAlignment(1);
        verticalFlowLayout1.setVerticalFill(true);
        this.panelGadgets.setLayout((LayoutManager)verticalFlowLayout1);
        this.jScrollPane1.setViewportView(this.panelGadgets);
        this.panelPerspectiveGadgets.add((Component)this.jScrollPane1, "Center");
        this.panelRoot.add((Component)this.panelPerspectiveGadgets, "East");
        this.add((Component)this.panelRoot, "Center");
    }

    private void formComponentShown(ComponentEvent evt) {
        Application.get().getMainFrame().setActivePerspective(this);
        if (this.tabbedViews.getSelectedComponent() != null) {
            ViewAccesibilities va = this.getViewAccesibilities(this.tabbedViews.getSelectedComponent());
            va.componentShow();
        }
    }

    private void formComponentHidden(ComponentEvent evt) {
        if (this.tabbedViews.getSelectedComponent() != null) {
            ViewAccesibilities va = this.getViewAccesibilities(this.tabbedViews.getSelectedComponent());
            va.componentHide();
        }
        Application.get().getMainFrame().setActivePerspective(null);
    }
}

