/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.IntrospectionException;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.Consts;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.gui.PerspectivePanel;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.br.BufferedRecord;
import pl.mpak.usedb.gui.FieldLinkType;
import pl.mpak.usedb.gui.RecordLink;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class PerspectivePropertiesDialog
extends JDialog {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);
    private RecordLink perspectiveLink;
    private PerspectivePanel perspective;
    private JButton buttonCancel;
    private JButton buttonOk;
    private JCheckBox checkDefault;
    private Action cmCancel;
    private Action cmOk;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private TextField textDescription;
    private TextField textName;

    public PerspectivePropertiesDialog(PerspectivePanel perspective) throws IntrospectionException, UseDBException {
        super(SwingUtil.getRootFrame());
        this.perspective = perspective;
        this.initComponents();
        this.init();
    }

    public static void showDialog(final PerspectivePanel perspective) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    PerspectivePropertiesDialog dialog = new PerspectivePropertiesDialog(perspective);
                    dialog.setVisible(true);
                }
                catch (Exception ex) {
                    ExceptionUtil.processException((Throwable)ex);
                    MessageBox.show(null, (String)"B\u0142\u0105d", (String)ex.getMessage(), (int)1, (int)0);
                }
            }
        });
    }

    private void init() throws IntrospectionException, UseDBException {
        this.checkDefault.setEnabled(this.perspective != Application.get().getMainFrame().getToolsPerspective());
        this.perspectiveLink = new RecordLink();
        this.perspectiveLink.add("PPS_NAME", (Component)this.textName);
        this.perspectiveLink.add("PPS_DESCRIPTION", (Component)this.textDescription);
        this.perspectiveLink.add("PPS_DEFAULT", (Component)this.checkDefault, "selected", FieldLinkType.Boolean_TF);
        this.perspectiveLink.updateComponents((BufferedRecord)this.perspective.getPerspective());
        this.getRootPane().setDefaultButton(this.buttonOk);
        this.getRootPane().getInputMap(2).put(this.cmCancel.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmCancel);
        SwingUtil.centerWithinScreen((Window)this);
    }

    private void initComponents() {
        this.cmOk = new Action();
        this.cmCancel = new Action();
        this.buttonOk = new JButton();
        this.buttonCancel = new JButton();
        this.jLabel1 = new JLabel();
        this.textName = new TextField();
        this.jLabel2 = new JLabel();
        this.textDescription = new TextField();
        this.checkDefault = new JCheckBox();
        this.cmOk.setShortCut(KeyStroke.getKeyStroke(10, 0));
        this.cmOk.setText(stringManager.getString("cmOk-text"));
        this.cmOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PerspectivePropertiesDialog.this.cmOkActionPerformed(evt);
            }
        });
        this.cmCancel.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmCancel.setText(stringManager.getString("cmCancel-text"));
        this.cmCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PerspectivePropertiesDialog.this.cmCancelActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(stringManager.getString("PerspectivePropertiesDialog-title"));
        this.setModal(true);
        this.buttonOk.setAction((javax.swing.Action)this.cmOk);
        this.buttonOk.setMargin(new Insets(2, 2, 2, 2));
        this.buttonOk.setPreferredSize(new Dimension(85, 25));
        this.buttonCancel.setAction((javax.swing.Action)this.cmCancel);
        this.buttonCancel.setMargin(new Insets(2, 2, 2, 2));
        this.buttonCancel.setPreferredSize(new Dimension(85, 25));
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText(stringManager.getString("PerspectivePropertiesDialog-perspective-name-dd"));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(stringManager.getString("PerspectivePropertiesDialog-description-dd"));
        this.checkDefault.setText(stringManager.getString("PerspectivePropertiesDialog-checkDefault-text"));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.buttonOk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -2, 123, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textName, -1, 341, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2, -2, 123, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkDefault).addComponent((Component)this.textDescription, -1, 341, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent((Component)this.textName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent((Component)this.textDescription, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkDefault).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel, -2, -1, -2).addComponent(this.buttonOk, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void cmOkActionPerformed(ActionEvent evt) {
        try {
            this.perspectiveLink.updateRecord((BufferedRecord)this.perspective.getPerspective());
            this.perspective.getPerspective().applyUpdate();
            this.perspective.getTabComponent().setTitle(this.perspective.getPerspective().getDisplayName(this.perspective.getDatabase()));
            this.dispose();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            MessageBox.show((Component)this, (String)"B\u0142\u0105d", (String)ex.getMessage(), (int)1, (int)0);
        }
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

