/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.Consts;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.db.InternalDatabase;
import pl.mpak.orbada.gui.comps.table.Table;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.plugins.Plugin;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StreamUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.patt.Resolvers;

public class PluginManagerDialog
extends JDialog {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);
    private ISettings settings;
    private InstalledTableModel installedModel;
    private Package[] packageArray;
    private JButton buttonDeactivate;
    private Action cmClose;
    private Action cmSwitchActive;
    private JButton jButton1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JTabbedPane jTabbedPane1;
    private JTabbedPane jTabbedPane2;
    private JSplitPane splitInstalled;
    private Table tableInstalled;
    private Table tablePackages;
    private JEditorPane textDescription;
    private JTextPane textLicense;

    public PluginManagerDialog() {
        super(SwingUtil.getRootFrame());
        this.initComponents();
        this.init();
    }

    public static void showDialog() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                PluginManagerDialog dialog = new PluginManagerDialog();
                dialog.setVisible(true);
            }
        });
    }

    private void init() {
        this.settings = Application.get().getSettings("plugin-manager-dialog");
        try {
            this.setBounds(0, 0, this.settings.getValue("width", Long.valueOf(this.getWidth())).intValue(), this.settings.getValue("height", Long.valueOf(this.getHeight())).intValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.splitInstalled.setDividerLocation(this.settings.getValue("split-installed-divider", Long.valueOf(this.splitInstalled.getDividerLocation())).intValue());
        this.getRootPane().getInputMap(2).put(this.cmClose.getShortCut(), "cmClose");
        this.getRootPane().getActionMap().put("cmClose", (javax.swing.Action)this.cmClose);
        this.tableInstalled.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PluginManagerDialog.this.updateInstalledInfo();
            }
        });
        this.tableInstalled.setSelectionMode(0);
        this.installedModel = new InstalledTableModel();
        this.tableInstalled.setModel(this.installedModel);
        this.tableInstalled.addColumn((TableColumn)new pl.mpak.sky.gui.swing.comp.TableColumn(0, 200, stringManager.getString("PluginManagerDialog-name")));
        this.tableInstalled.addColumn((TableColumn)new pl.mpak.sky.gui.swing.comp.TableColumn(1, 100, stringManager.getString("PluginManagerDialog-categories")));
        this.tableInstalled.addColumn((TableColumn)new pl.mpak.sky.gui.swing.comp.TableColumn(2, 25, stringManager.getString("PluginManagerDialog-active")));
        this.tableInstalled.addColumn((TableColumn)new pl.mpak.sky.gui.swing.comp.TableColumn(3, 25, stringManager.getString("PluginManagerDialog-loaded")));
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                PluginManagerDialog.this.preparePluginList();
            }
        });
        this.packageArray = Package.getPackages();
        Arrays.sort(this.packageArray, new Comparator<Package>(){

            @Override
            public int compare(Package o1, Package o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        this.tablePackages.setModel(new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return PluginManagerDialog.this.packageArray.length;
            }

            @Override
            public int getColumnCount() {
                return 0;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return PluginManagerDialog.this.packageArray[rowIndex].getName();
                    }
                    case 1: {
                        return PluginManagerDialog.this.packageArray[rowIndex].getSpecificationTitle();
                    }
                    case 2: {
                        return PluginManagerDialog.this.packageArray[rowIndex].getSpecificationVendor();
                    }
                    case 3: {
                        return PluginManagerDialog.this.packageArray[rowIndex].getSpecificationVersion();
                    }
                    case 4: {
                        return PluginManagerDialog.this.packageArray[rowIndex].getImplementationTitle();
                    }
                    case 5: {
                        return PluginManagerDialog.this.packageArray[rowIndex].getImplementationVendor();
                    }
                    case 6: {
                        return PluginManagerDialog.this.packageArray[rowIndex].getImplementationVersion();
                    }
                }
                return null;
            }
        });
        this.tablePackages.setSelectionMode(0);
        this.tablePackages.addColumn((TableColumn)new pl.mpak.sky.gui.swing.comp.TableColumn(0, 150, stringManager.getString("PluginManagerDialog-name")));
        this.tablePackages.addColumn((TableColumn)new pl.mpak.sky.gui.swing.comp.TableColumn(1, 150, stringManager.getString("PluginManagerDialog-spec-title")));
        this.tablePackages.addColumn((TableColumn)new pl.mpak.sky.gui.swing.comp.TableColumn(2, 150, stringManager.getString("PluginManagerDialog-spec-producer")));
        this.tablePackages.addColumn((TableColumn)new pl.mpak.sky.gui.swing.comp.TableColumn(3, 70, stringManager.getString("PluginManagerDialog-spec-version")));
        this.tablePackages.addColumn((TableColumn)new pl.mpak.sky.gui.swing.comp.TableColumn(4, 150, stringManager.getString("PluginManagerDialog-impl-title")));
        this.tablePackages.addColumn((TableColumn)new pl.mpak.sky.gui.swing.comp.TableColumn(5, 150, stringManager.getString("PluginManagerDialog-impl-producer")));
        this.tablePackages.addColumn((TableColumn)new pl.mpak.sky.gui.swing.comp.TableColumn(6, 70, stringManager.getString("PluginManagerDialog-impl-version")));
        SwingUtil.centerWithinScreen((Window)this);
    }

    @Override
    public void dispose() {
        this.settings.setValue("split-installed-divider", Long.valueOf(this.splitInstalled.getDividerLocation()));
        this.settings.setValue("width", Long.valueOf(this.getWidth()));
        this.settings.setValue("height", Long.valueOf(this.getHeight()));
        this.settings.store();
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preparePluginList() {
        Query query = InternalDatabase.get().createQuery();
        try {
            query.setSqlText("select * from plugins where plg_usr_id = :plg_usr_id order by plg_id");
            query.paramByName("plg_usr_id").setString(Application.get().getUserId());
            query.open();
            while (!query.eof()) {
                Plugin plugin = Application.get().getPluginManager().getPluginByUniqueID(query.fieldByName("plg_id").getString());
                if (plugin != null) {
                    this.installedModel.pluginList.add(new InstalledPlugin(query.fieldByName("plg_id").getString(), query.fieldByName("plg_description").getString(), StringUtil.toBoolean((String)query.fieldByName("plg_enabled").getString()), StringUtil.toBoolean((String)query.fieldByName("plg_loaded").getString()), plugin));
                } else {
                    this.installedModel.pluginList.add(new InstalledPlugin(query.fieldByName("plg_id").getString(), query.fieldByName("plg_description").getString(), StringUtil.toBoolean((String)query.fieldByName("plg_enabled").getString()), StringUtil.toBoolean((String)query.fieldByName("plg_loaded").getString()), plugin));
                }
                query.next();
            }
        }
        catch (Exception ex) {
            MessageBox.show((Component)this, (String)stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
        }
        finally {
            query.close();
        }
        this.tableInstalled.revalidate();
    }

    private void updateInstalledInfo() {
        if (this.tableInstalled.getSelectedRow() != -1) {
            InstalledPlugin ip = this.installedModel.pluginList.get(this.tableInstalled.getSelectedRow());
            StringBuffer sb = new StringBuffer();
            sb.append("<html>");
            sb.append("<style>");
            sb.append("  body { font-family: Tahoma, Arial, serif; font-size: 9px; }");
            sb.append("</style>");
            sb.append("<head></head>");
            sb.append("<body>");
            if (ip.plugin != null) {
                sb.append("<font size=\"+1\">").append(ip.plugin.getDescriptiveName()).append("</font><br>");
                sb.append("<b>").append(stringManager.getString("PluginManagerDialog-unique-id-dd")).append(" </b>").append(ip.plugin.getUniqueID()).append("<br><hr>");
                sb.append("<b>").append(stringManager.getString("PluginManagerDialog-categories-dd")).append(" </b>").append(ip.plugin.getCategory()).append("<br>");
                sb.append("<b>").append(stringManager.getString("PluginManagerDialog-version-dd")).append(" </b>").append(ip.plugin.getVersion()).append("<br>");
                sb.append("<b>").append(stringManager.getString("PluginManagerDialog-author-dd")).append(" </b>").append(ip.plugin.getAuthor()).append("<br>");
                String webPage = ip.plugin.getWebSite() == null ? Application.get().getProperty("orbada.web.page", "") : ip.plugin.getWebSite();
                String updatePage = ip.plugin.getUpdateSite() == null ? Application.get().getProperty("orbada.update.page", "") : ip.plugin.getUpdateSite();
                sb.append("<b>").append(stringManager.getString("PluginManagerDialog-property-rights-dd")).append(" </b>").append(ip.plugin.getCopyrights()).append("<br>");
                sb.append("<b>").append(stringManager.getString("PluginManagerDialog-root-page-dd")).append(" </b><a href=\"").append(webPage).append("\">").append(webPage).append("</a><br>");
                sb.append("<b>").append(stringManager.getString("PluginManagerDialog-update-page-dd")).append(" </b><a href=\"").append(updatePage).append("\">").append(updatePage).append("</a><br>");
                sb.append("<br><b>").append(stringManager.getString("PluginManagerDialog-description-dd")).append("</b><br>").append(ip.plugin.getDescription());
                String licence = ip.plugin.getLicence();
                if (StringUtil.isEmpty((String)licence)) {
                    File file = new File(Resolvers.expand((String)"$(user.dir)/doc/licences/orbada-licence.txt"));
                    if (file.exists()) {
                        try {
                            FileInputStream stream = new FileInputStream(file);
                            licence = StreamUtil.stream2String((InputStream)stream);
                            this.textLicense.setText(licence);
                        }
                        catch (Exception ex) {
                            this.textLicense.setText(ex.getMessage());
                            ExceptionUtil.processException((Throwable)ex);
                        }
                    } else {
                        this.textLicense.setText(stringManager.getString("PluginManagerDialog-no-licence"));
                    }
                } else {
                    this.textLicense.setText(licence);
                }
            } else {
                sb.append("<font size=\"+1\">").append(ip.name).append("</font><br>");
                sb.append("<b>").append(stringManager.getString("PluginManagerDialog-unique-id-dd")).append(" </b>").append(ip.uniqueId).append("<br><hr>");
                this.textLicense.setText("");
            }
            sb.append("</body>");
            sb.append("</html>");
            this.textDescription.setText(sb.toString());
            this.textLicense.setCaretPosition(0);
            this.textDescription.setCaretPosition(0);
        }
    }

    private void initComponents() {
        this.cmClose = new Action();
        this.cmSwitchActive = new Action();
        this.jTabbedPane1 = new JTabbedPane();
        this.splitInstalled = new JSplitPane();
        this.jPanel3 = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.tableInstalled = new Table();
        this.buttonDeactivate = new JButton();
        this.jPanel1 = new JPanel();
        this.jTabbedPane2 = new JTabbedPane();
        this.jScrollPane1 = new JScrollPane();
        this.textDescription = new JEditorPane();
        this.jScrollPane4 = new JScrollPane();
        this.textLicense = new JTextPane();
        this.jPanel2 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.tablePackages = new Table();
        this.jButton1 = new JButton();
        this.cmClose.setActionCommandKey("cmClose");
        this.cmClose.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmClose.setText(stringManager.getString("cmClose-text"));
        this.cmClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PluginManagerDialog.this.cmCloseActionPerformed(evt);
            }
        });
        this.cmSwitchActive.setActionCommandKey("cmSwitchActive");
        this.cmSwitchActive.setText(stringManager.getString("PluginManagerDialog-cmSwitchActive-text"));
        this.cmSwitchActive.setTooltip(stringManager.getString("PluginManagerDialog-cmSwitchActive-hint"));
        this.cmSwitchActive.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PluginManagerDialog.this.cmSwitchActiveActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(stringManager.getString("PluginManagerDialog-title"));
        this.setModal(true);
        this.jTabbedPane1.setFocusable(false);
        this.splitInstalled.setBorder(null);
        this.splitInstalled.setDividerLocation(350);
        this.splitInstalled.setContinuousLayout(true);
        this.splitInstalled.setOneTouchExpandable(true);
        this.tableInstalled.setShowHorizontalLines(false);
        this.jScrollPane3.setViewportView(this.tableInstalled);
        this.buttonDeactivate.setAction((javax.swing.Action)this.cmSwitchActive);
        this.buttonDeactivate.setMargin(new Insets(2, 2, 2, 2));
        this.buttonDeactivate.setPreferredSize(new Dimension(85, 25));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3, -1, 276, Short.MAX_VALUE).addComponent(this.buttonDeactivate, -2, -1, -2)).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane3, -1, 411, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonDeactivate, -2, -1, -2).addContainerGap()));
        this.splitInstalled.setLeftComponent(this.jPanel3);
        this.jPanel1.setLayout(new BorderLayout());
        this.jTabbedPane2.setFocusable(false);
        this.textDescription.setContentType("text/html");
        this.textDescription.setEditable(false);
        this.textDescription.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent evt) {
                PluginManagerDialog.this.textDescriptionHyperlinkUpdate(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.textDescription);
        this.jTabbedPane2.addTab(stringManager.getString("PluginManagerDialog-plugin-description"), this.jScrollPane1);
        this.textLicense.setEditable(false);
        this.textLicense.setFont(new Font("Courier New", 0, 12));
        this.jScrollPane4.setViewportView(this.textLicense);
        this.jTabbedPane2.addTab(stringManager.getString("PluginManagerDialog-licence"), this.jScrollPane4);
        this.jPanel1.add((Component)this.jTabbedPane2, "Center");
        this.splitInstalled.setRightComponent(this.jPanel1);
        this.jTabbedPane1.addTab(stringManager.getString("PluginManagerDialog-installed"), this.splitInstalled);
        this.tablePackages.setAutoResizeMode(0);
        this.jScrollPane2.setViewportView(this.tablePackages);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -1, 651, Short.MAX_VALUE).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -1, 442, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab(stringManager.getString("PluginManagerDialog-loaded-packages"), this.jPanel2);
        this.jButton1.setAction((javax.swing.Action)this.cmClose);
        this.jButton1.setMargin(new Insets(2, 2, 2, 2));
        this.jButton1.setPreferredSize(new Dimension(85, 25));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton1, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.jTabbedPane1, -1, 676, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane1, -1, 492, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void cmCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void cmSwitchActiveActionPerformed(ActionEvent evt) {
        if (this.tableInstalled.getSelectedRow() != -1) {
            InstalledPlugin ip = this.installedModel.pluginList.get(this.tableInstalled.getSelectedRow());
            Application.get().getPluginManager().setEnabled(ip.uniqueId, !ip.enabled);
            ip.enabled = !ip.enabled;
            this.tableInstalled.repaint();
        }
    }

    private void textDescriptionHyperlinkUpdate(HyperlinkEvent evt) {
        try {
            if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                Desktop.getDesktop().browse(evt.getURL().toURI());
            }
        }
        catch (Exception ex) {
            MessageBox.show((Component)this, (String)stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
        }
    }

    class InstalledTableModel
    extends AbstractTableModel {
        ArrayList<InstalledPlugin> pluginList = new ArrayList();
        Icon greenDot = ImageManager.getImage((String)"/pl/mpak/res/icons/green_sdot.png");
        Icon redDot = ImageManager.getImage((String)"/pl/mpak/res/icons/red_sdot.png");

        @Override
        public int getRowCount() {
            return this.pluginList.size();
        }

        @Override
        public int getColumnCount() {
            return 0;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return Icon.class;
                }
                case 3: {
                    return Icon.class;
                }
            }
            return null;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            InstalledPlugin ip = this.pluginList.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return ip.plugin != null ? ip.plugin.getDescriptiveName() : ip.name;
                }
                case 1: {
                    return ip.plugin != null ? ip.plugin.getCategory() : "???";
                }
                case 2: {
                    return ip.enabled ? this.greenDot : this.redDot;
                }
                case 3: {
                    return ip.loaded ? this.greenDot : this.redDot;
                }
            }
            return null;
        }
    }

    class InstalledPlugin {
        String uniqueId;
        String name;
        boolean loaded;
        boolean enabled;
        Plugin plugin;

        public InstalledPlugin(String uniqueId, String name, boolean enabled, boolean loaded, Plugin plugin) {
            this.uniqueId = uniqueId;
            this.name = name;
            this.loaded = loaded;
            this.enabled = enabled;
            this.plugin = plugin;
        }
    }
}

