/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import pl.mpak.orbada.Consts;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.gui.SettingsProviderTreeNode;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.providers.PerspectiveSettingsProvider;
import pl.mpak.orbada.plugins.providers.SettingsProvider;
import pl.mpak.orbada.plugins.providers.abs.AbstractSettingsProvider;
import pl.mpak.orbada.util.Utils;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.IconPanel;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.variant.Variant;

public class PluginSettingsDialog
extends JDialog {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);
    private SettingsProviderTreeNode currentNode;
    private Database database;
    private ISettings settings;
    private JButton buttonApply;
    private JButton buttonCancel;
    private JButton buttonOk;
    private JButton buttonRollback;
    private Action cmApplySettings;
    private Action cmCancel;
    private Action cmHelp;
    private Action cmOk;
    private Action cmRestoreSettings;
    private IconPanel iconSettings;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JSplitPane jSplitPane1;
    private JLabel labelDescription;
    private JPanel panelSetting;
    private JTree treeSettings;

    public PluginSettingsDialog(Database database) {
        super(SwingUtil.getRootFrame());
        this.database = database;
        this.initComponents();
        this.init();
    }

    public PluginSettingsDialog() {
        this((Database)null);
    }

    public static void showDialog(Database database) {
        PluginSettingsDialog dialog = new PluginSettingsDialog(database);
        dialog.setVisible(true);
    }

    public static void showDialog() {
        PluginSettingsDialog dialog = new PluginSettingsDialog();
        dialog.setVisible(true);
    }

    private void init() {
        this.setTitle(this.database == null ? stringManager.getString("PluginSettingsDialog-plugin-settings") : stringManager.getString("PluginSettingsDialog-perspective-settings"));
        this.settings = Application.get().getSettings("orbada-settings-dialog");
        try {
            this.setBounds(0, 0, this.settings.getValue("width", new Variant(this.getWidth())).getInteger(), this.settings.getValue("height", new Variant(this.getHeight())).getInteger());
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.getRootPane().setDefaultButton(this.buttonOk);
        this.getRootPane().getInputMap(2).put(this.cmCancel.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmCancel);
        this.treeSettings.getSelectionModel().setSelectionMode(1);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("root");
        if (this.database == null) {
            SettingsProvider[] spa = (SettingsProvider[])Application.get().getServiceArray(SettingsProvider.class);
            if (spa != null) {
                for (SettingsProvider sp : spa) {
                    this.addSettings(root, (AbstractSettingsProvider)sp);
                }
            }
        } else {
            PerspectiveSettingsProvider[] pspa = (PerspectiveSettingsProvider[])Application.get().getServiceArray(PerspectiveSettingsProvider.class);
            if (pspa != null) {
                for (PerspectiveSettingsProvider sp : pspa) {
                    if (!sp.isForDatabase(this.database)) continue;
                    this.addSettings(root, (AbstractSettingsProvider)sp);
                }
            }
        }
        this.treeSettings.setModel(new DefaultTreeModel(root));
        if (root.getChildCount() > 0) {
            this.treeSettings.setSelectionInterval(0, 0);
        } else {
            this.setCurrentNode(null);
        }
        this.treeSettings.expandRow(0);
        SwingUtil.addAction((JDialog)this, (String)this.cmHelp.getActionCommandKey(), (javax.swing.Action)this.cmHelp);
        SwingUtil.setButtonSizesTheSame((AbstractButton[])new AbstractButton[]{this.buttonOk, this.buttonCancel, this.buttonRollback, this.buttonApply});
        SwingUtil.centerWithinScreen((Window)this);
    }

    private void addSettings(DefaultMutableTreeNode root, AbstractSettingsProvider sp) {
        DefaultMutableTreeNode node = root;
        StringTokenizer st = new StringTokenizer(sp.getSettingsPath(), "/\\");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            boolean found = false;
            for (int i = 0; i < node.getChildCount(); ++i) {
                SettingsProviderTreeNode n = (SettingsProviderTreeNode)node.getChildAt(i);
                if (!token.equals(n.getUserObject().toString())) continue;
                node = n;
                found = true;
                break;
            }
            if (found) continue;
            SettingsProviderTreeNode newNode = new SettingsProviderTreeNode(null, this.database, token);
            node.add(newNode);
            node = newNode;
        }
        ((SettingsProviderTreeNode)node).setService(sp);
    }

    private void setCurrentNode(SettingsProviderTreeNode node) {
        if (this.currentNode != null && this.currentNode.getComponent() != null) {
            this.panelSetting.remove(this.currentNode.getComponent());
        }
        this.currentNode = node;
        this.labelDescription.setText("<html><b>");
        if (this.currentNode != null && this.currentNode.getComponent() != null) {
            this.panelSetting.add(this.currentNode.getComponent());
            this.labelDescription.setText(this.labelDescription.getText() + this.currentNode.getDescription());
            this.iconSettings.setIcon(this.currentNode.getIcon());
            this.iconSettings.setVisible(this.currentNode.getIcon() != null);
        } else if (this.currentNode != null) {
            this.labelDescription.setText(this.labelDescription.getText() + this.currentNode.toString());
            this.iconSettings.setIcon(this.currentNode.getIcon());
            this.iconSettings.setVisible(this.currentNode.getIcon() != null);
        } else {
            this.labelDescription.setText(this.labelDescription.getText() + stringManager.getString("PluginSettingsDialog-no-settings"));
            this.iconSettings.setIcon(null);
            this.iconSettings.setVisible(false);
        }
        this.labelDescription.setText(this.labelDescription.getText() + "</b>");
        if (this.database != null) {
            this.labelDescription.setText(this.labelDescription.getText() + "<br>" + stringManager.getString("PluginSettingsDialog-for") + " <b>" + this.database.getDriverType() + "</b><br>" + this.database.getUrl());
        }
        this.cmApplySettings.setEnabled(this.currentNode != null && this.currentNode.getComponent() != null);
        this.cmRestoreSettings.setEnabled(this.currentNode != null && this.currentNode.getComponent() != null);
        this.panelSetting.revalidate();
        this.panelSetting.repaint();
    }

    private void applySettings(DefaultMutableTreeNode node) {
        if (node == null) {
            return;
        }
        if (node instanceof SettingsProviderTreeNode && ((SettingsProviderTreeNode)node).isShowed()) {
            ((SettingsProviderTreeNode)node).applySettings();
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.applySettings((DefaultMutableTreeNode)node.getChildAt(i));
        }
    }

    private void cancelSettings(DefaultMutableTreeNode node) {
        if (node == null) {
            return;
        }
        if (node instanceof SettingsProviderTreeNode && ((SettingsProviderTreeNode)node).isShowed()) {
            ((SettingsProviderTreeNode)node).cancelSettings();
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.cancelSettings((DefaultMutableTreeNode)node.getChildAt(i));
        }
    }

    private void close(DefaultMutableTreeNode node) {
        if (node == null) {
            return;
        }
        if (node instanceof SettingsProviderTreeNode && ((SettingsProviderTreeNode)node).isShowed()) {
            ((SettingsProviderTreeNode)node).close();
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.close((DefaultMutableTreeNode)node.getChildAt(i));
        }
    }

    @Override
    public void dispose() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.treeSettings.getModel().getRoot();
        this.close(root);
        this.settings.setValue("width", new Variant(this.getWidth()));
        this.settings.setValue("height", new Variant(this.getHeight()));
        this.settings.store();
        super.dispose();
    }

    private void initComponents() {
        this.cmOk = new Action();
        this.cmCancel = new Action();
        this.cmApplySettings = new Action();
        this.cmRestoreSettings = new Action();
        this.cmHelp = new Action();
        this.buttonOk = new JButton();
        this.buttonCancel = new JButton();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.treeSettings = new JTree();
        this.panelSetting = new JPanel();
        this.jPanel1 = new JPanel();
        this.iconSettings = new IconPanel();
        this.labelDescription = new JLabel();
        this.jPanel2 = new JPanel();
        this.buttonRollback = new JButton();
        this.buttonApply = new JButton();
        this.cmOk.setActionCommandKey("cmOk");
        this.cmOk.setShortCut(KeyStroke.getKeyStroke(10, 0));
        this.cmOk.setText(stringManager.getString("cmOk-text"));
        this.cmOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PluginSettingsDialog.this.cmOkActionPerformed(evt);
            }
        });
        this.cmCancel.setActionCommandKey("cmCancel");
        this.cmCancel.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmCancel.setText(stringManager.getString("cmCancel-text"));
        this.cmCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PluginSettingsDialog.this.cmCancelActionPerformed(evt);
            }
        });
        this.cmApplySettings.setActionCommandKey("cmApplySettings");
        this.cmApplySettings.setText(stringManager.getString("cmApply-text"));
        this.cmApplySettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PluginSettingsDialog.this.cmApplySettingsActionPerformed(evt);
            }
        });
        this.cmRestoreSettings.setActionCommandKey("cmRestoreSettings");
        this.cmRestoreSettings.setText(stringManager.getString("cmRestore-text"));
        this.cmRestoreSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PluginSettingsDialog.this.cmRestoreSettingsActionPerformed(evt);
            }
        });
        this.cmHelp.setActionCommandKey("cmHelp");
        this.cmHelp.setShortCut(KeyStroke.getKeyStroke(112, 0));
        this.cmHelp.setText(stringManager.getString("cmHelp-text"));
        this.cmHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PluginSettingsDialog.this.cmHelpActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.buttonOk.setAction((javax.swing.Action)this.cmOk);
        this.buttonOk.setMargin(new Insets(2, 2, 2, 2));
        this.buttonOk.setPreferredSize(new Dimension(85, 25));
        this.buttonCancel.setAction((javax.swing.Action)this.cmCancel);
        this.buttonCancel.setMargin(new Insets(2, 2, 2, 2));
        this.buttonCancel.setPreferredSize(new Dimension(85, 25));
        this.jSplitPane1.setBorder(null);
        this.jSplitPane1.setDividerLocation(200);
        this.jSplitPane1.setContinuousLayout(true);
        this.jSplitPane1.setOneTouchExpandable(true);
        this.jScrollPane1.setPreferredSize(new Dimension(200, 324));
        this.treeSettings.setRootVisible(false);
        this.treeSettings.setShowsRootHandles(true);
        this.treeSettings.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                PluginSettingsDialog.this.treeSettingsValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.treeSettings);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.panelSetting.setLayout(new BorderLayout());
        this.jPanel1.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getDefaults().getColor("controlShadow")));
        this.jPanel1.setLayout(new FlowLayout(0));
        this.iconSettings.setMinimumSize(new Dimension(24, 24));
        this.iconSettings.setPreferredSize(new Dimension(32, 32));
        GroupLayout iconSettingsLayout = new GroupLayout((Container)this.iconSettings);
        this.iconSettings.setLayout((LayoutManager)iconSettingsLayout);
        iconSettingsLayout.setHorizontalGroup(iconSettingsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 32, Short.MAX_VALUE));
        iconSettingsLayout.setVerticalGroup(iconSettingsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 32, Short.MAX_VALUE));
        this.jPanel1.add((Component)this.iconSettings);
        this.labelDescription.setText("labelDescription");
        this.jPanel1.add(this.labelDescription);
        this.panelSetting.add((Component)this.jPanel1, "First");
        this.jPanel2.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getDefaults().getColor("controlShadow")));
        this.jPanel2.setLayout(new FlowLayout(2));
        this.buttonRollback.setAction((javax.swing.Action)this.cmRestoreSettings);
        this.buttonRollback.setMargin(new Insets(2, 2, 2, 2));
        this.buttonRollback.setPreferredSize(new Dimension(85, 25));
        this.jPanel2.add(this.buttonRollback);
        this.buttonApply.setAction((javax.swing.Action)this.cmApplySettings);
        this.buttonApply.setMargin(new Insets(2, 2, 2, 2));
        this.buttonApply.setPreferredSize(new Dimension(85, 25));
        this.jPanel2.add(this.buttonApply);
        this.panelSetting.add((Component)this.jPanel2, "Last");
        this.jSplitPane1.setRightComponent(this.panelSetting);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.buttonOk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2)).addComponent(this.jSplitPane1, -1, 677, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jSplitPane1, -1, 414, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel, -2, -1, -2).addComponent(this.buttonOk, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void cmOkActionPerformed(ActionEvent evt) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.treeSettings.getModel().getRoot();
        this.applySettings(root);
        this.dispose();
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.treeSettings.getModel().getRoot();
        this.cancelSettings(root);
        this.dispose();
    }

    private void treeSettingsValueChanged(TreeSelectionEvent evt) {
        SettingsProviderTreeNode node = (SettingsProviderTreeNode)this.treeSettings.getLastSelectedPathComponent();
        this.setCurrentNode(node);
    }

    private void cmApplySettingsActionPerformed(ActionEvent evt) {
        if (this.currentNode != null) {
            this.currentNode.applySettings();
        }
    }

    private void cmRestoreSettingsActionPerformed(ActionEvent evt) {
        if (this.currentNode != null) {
            this.currentNode.restoreSettings();
        }
    }

    private void cmHelpActionPerformed(ActionEvent evt) {
        if (this.currentNode != null && this.currentNode.getComponent() != null) {
            Utils.gotoHelp(this.currentNode.getComponent());
        }
    }
}

