/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pl.mpak.orbada.Consts;
import pl.mpak.orbada.gui.PerspectivePanel;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class SelectPerspectiveDialog
extends JDialog {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);
    private int modalResult = 0;
    private PerspectivePanel perspective;
    private JTabbedPane tabPerspectives;
    private boolean sameDriverType;
    private JButton buttonCancel;
    private JButton buttonOk;
    private Action cmCancel;
    private Action cmSelect;
    private JScrollPane jScrollPane1;
    private JList listPerspectives;

    public SelectPerspectiveDialog(JTabbedPane tabPerspectives, PerspectivePanel perspective, boolean sameDriverType) {
        super(SwingUtil.getRootFrame());
        this.tabPerspectives = tabPerspectives;
        this.perspective = perspective;
        this.sameDriverType = sameDriverType;
        this.initComponents();
        this.init();
    }

    public static PerspectivePanel show(JTabbedPane tabPerspectives, PerspectivePanel perspective) {
        return SelectPerspectiveDialog.show(tabPerspectives, perspective, false);
    }

    public static PerspectivePanel show(JTabbedPane tabPerspectives, PerspectivePanel perspective, boolean sameDriverType) {
        SelectPerspectiveDialog dialog = new SelectPerspectiveDialog(tabPerspectives, perspective, sameDriverType);
        dialog.setVisible(true);
        if (dialog.modalResult == 1) {
            return (PerspectivePanel)dialog.listPerspectives.getSelectedValue();
        }
        return null;
    }

    private void init() {
        this.listPerspectives.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof PerspectivePanel) {
                    PerspectivePanel panel = (PerspectivePanel)value;
                    String text = "<html>";
                    text = text + "<b>" + panel.getPerspective().getDisplayName(panel.getDatabase()) + "</b>";
                    if (panel.getDatabase() != null) {
                        text = text + " - " + panel.getDatabase().getUrl() + " as " + panel.getDatabase().getUserName();
                    }
                    if (panel.getSchema() != null) {
                        label.setIcon(panel.getSchema().getIcon());
                    }
                    label.setText(text);
                    label.setVerticalAlignment(1);
                }
                return label;
            }
        });
        this.listPerspectives.removeAll();
        this.listPerspectives.setModel(new DefaultListModel());
        for (int i = 0; i < this.tabPerspectives.getTabCount(); ++i) {
            Component c = this.tabPerspectives.getComponentAt(i);
            if (!(c instanceof PerspectivePanel)) continue;
            PerspectivePanel panel = (PerspectivePanel)c;
            if (this.sameDriverType && (this.perspective == panel || panel.getDatabase() != null && this.perspective.getDatabase() == null || panel.getDatabase() != null && this.perspective.getDatabase() != null && !panel.getDatabase().getDriverType().equals(this.perspective.getDatabase().getDriverType()))) continue;
            ((DefaultListModel)this.listPerspectives.getModel()).addElement(panel);
        }
        this.cmSelect.setEnabled(false);
        this.listPerspectives.setSelectedValue(this.perspective, true);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SelectPerspectiveDialog.this.listPerspectives.requestFocus();
            }
        });
        this.getRootPane().getInputMap(2).put(this.cmCancel.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmCancel);
        this.getRootPane().setDefaultButton(this.buttonOk);
        SwingUtil.setButtonSizesTheSame((AbstractButton[])new AbstractButton[]{this.buttonOk, this.buttonCancel});
        this.pack();
        SwingUtil.centerWithinScreen((Window)this);
    }

    private void initComponents() {
        this.cmCancel = new Action();
        this.cmSelect = new Action();
        this.jScrollPane1 = new JScrollPane();
        this.listPerspectives = new JList();
        this.buttonOk = new JButton();
        this.buttonCancel = new JButton();
        this.cmCancel.setActionCommandKey("cmCancel");
        this.cmCancel.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmCancel.setText(stringManager.getString("cmCancel-text"));
        this.cmCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectPerspectiveDialog.this.cmCancelActionPerformed(evt);
            }
        });
        this.cmSelect.setActionCommandKey("cmSelect");
        this.cmSelect.setText(stringManager.getString("cmSelect-text"));
        this.cmSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectPerspectiveDialog.this.cmSelectActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(stringManager.getString("SelectPerspectiveDialog-title"));
        this.setModal(true);
        this.listPerspectives.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                SelectPerspectiveDialog.this.listPerspectivesValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.listPerspectives);
        this.buttonOk.setAction((javax.swing.Action)this.cmSelect);
        this.buttonOk.setMargin(new Insets(2, 2, 2, 2));
        this.buttonOk.setPreferredSize(new Dimension(85, 25));
        this.buttonCancel.setAction((javax.swing.Action)this.cmCancel);
        this.buttonCancel.setMargin(new Insets(2, 2, 2, 2));
        this.buttonCancel.setPreferredSize(new Dimension(85, 25));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 446, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.buttonOk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 198, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.buttonCancel, -2, -1, -2).addComponent(this.buttonOk, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void listPerspectivesValueChanged(ListSelectionEvent evt) {
        this.cmSelect.setEnabled(this.listPerspectives.getSelectedIndex() != -1);
    }

    private void cmSelectActionPerformed(ActionEvent evt) {
        this.modalResult = 1;
        this.dispose();
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        this.modalResult = 2;
        this.dispose();
    }
}

