/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pl.mpak.orbada.Consts;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class SelectTabDialog
extends JDialog {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);
    private int modalResult = 0;
    private JTabbedPane pane;
    private JButton buttonCancel;
    private JButton buttonOk;
    private Action cmCancel;
    private Action cmSelect;
    private JScrollPane jScrollPane1;
    private JList listViews;

    public SelectTabDialog(JTabbedPane pane) {
        super(SwingUtil.getRootFrame());
        this.pane = pane;
        this.initComponents();
        this.init();
    }

    public static Component show(Component component) {
        JTabbedPane pane = (JTabbedPane)SwingUtil.getOwnerComponent(JTabbedPane.class, (Component)component);
        if (pane != null) {
            SelectTabDialog dialog = new SelectTabDialog(pane);
            dialog.setVisible(true);
            if (dialog.modalResult == 1) {
                pane.setSelectedComponent(pane.getComponentAt(dialog.listViews.getSelectedIndex()));
                return pane.getComponentAt(dialog.listViews.getSelectedIndex());
            }
        }
        return null;
    }

    private void init() {
        int selectedTab = -1;
        this.listViews.removeAll();
        this.listViews.setModel(new DefaultListModel());
        if (this.pane != null) {
            for (int i = 0; i < this.pane.getTabCount(); ++i) {
                Component c = this.pane.getComponentAt(i);
                String text = this.pane.getTitleAt(i);
                if (c.isVisible()) {
                    selectedTab = i;
                }
                ((DefaultListModel)this.listViews.getModel()).addElement(text);
            }
        }
        this.cmSelect.setEnabled(false);
        if (selectedTab != -1) {
            this.listViews.setSelectedIndex(selectedTab);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SelectTabDialog.this.listViews.requestFocus();
            }
        });
        this.getRootPane().getInputMap(2).put(this.cmCancel.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmCancel);
        this.getRootPane().setDefaultButton(this.buttonOk);
        SwingUtil.setButtonSizesTheSame((AbstractButton[])new AbstractButton[]{this.buttonOk, this.buttonCancel});
        this.pack();
        SwingUtil.centerWithinScreen((Window)this);
    }

    private void initComponents() {
        this.cmCancel = new Action();
        this.cmSelect = new Action();
        this.jScrollPane1 = new JScrollPane();
        this.listViews = new JList();
        this.buttonOk = new JButton();
        this.buttonCancel = new JButton();
        this.cmCancel.setActionCommandKey("cmCancel");
        this.cmCancel.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmCancel.setText(stringManager.getString("cmCancel-text"));
        this.cmCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectTabDialog.this.cmCancelActionPerformed(evt);
            }
        });
        this.cmSelect.setActionCommandKey("cmOk");
        this.cmSelect.setText(stringManager.getString("cmSelect-text"));
        this.cmSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectTabDialog.this.cmSelectActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(stringManager.getString("SelectTabDialog-title"));
        this.setModal(true);
        this.listViews.setFixedCellHeight(20);
        this.listViews.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                SelectTabDialog.this.listViewsValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.listViews);
        this.buttonOk.setAction((javax.swing.Action)this.cmSelect);
        this.buttonOk.setMargin(new Insets(2, 2, 2, 2));
        this.buttonOk.setPreferredSize(new Dimension(85, 25));
        this.buttonCancel.setAction((javax.swing.Action)this.cmCancel);
        this.buttonCancel.setMargin(new Insets(2, 2, 2, 2));
        this.buttonCancel.setPreferredSize(new Dimension(85, 25));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 350, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.buttonOk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 207, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.buttonCancel, -2, -1, -2).addComponent(this.buttonOk, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void listViewsValueChanged(ListSelectionEvent evt) {
        this.cmSelect.setEnabled(this.listViews.getSelectedIndex() != -1);
    }

    private void cmSelectActionPerformed(ActionEvent evt) {
        this.modalResult = 1;
        this.dispose();
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        this.modalResult = 2;
        this.dispose();
    }
}

