/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pl.mpak.orbada.Consts;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.gui.PerspectivePanel;
import pl.mpak.orbada.gui.ViewAccesibilities;
import pl.mpak.orbada.plugins.providers.ViewProvider;
import pl.mpak.orbada.util.Utils;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ListRowChangeKeyListener;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class SelectViewDialog
extends JDialog {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);
    private int modalResult = 0;
    private PerspectivePanel perspective;
    private ArrayList<ViewListElement> viewList;
    private Color selectedColor = UIManager.getColor("Table.selectionBackground");
    private JButton buttonCancel;
    private JButton buttonCloseView;
    private JButton buttonOk;
    private Action cmCancel;
    private Action cmCloseView;
    private Action cmSelect;
    private TextField editFiltr;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JList listViews;

    public SelectViewDialog(PerspectivePanel perspective) {
        super(SwingUtil.getRootFrame());
        this.perspective = perspective;
        this.viewList = new ArrayList();
        this.initComponents();
        this.init();
    }

    public static ViewAccesibilities show(PerspectivePanel perspective) {
        SelectViewDialog dialog = new SelectViewDialog(perspective);
        dialog.setVisible(true);
        if (dialog.modalResult == 1) {
            ViewListElement item = (ViewListElement)dialog.listViews.getSelectedValue();
            if (item.accessibilities != null) {
                return item.accessibilities;
            }
            Component component = perspective.createView(item.provider, false, false);
            if (component != null) {
                return perspective.getViewAccesibilities(component);
            }
        }
        return null;
    }

    private void init() {
        this.listViews.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof ViewListElement) {
                    ViewListElement view = (ViewListElement)value;
                    String text = SelectViewDialog.this.getViewText(view);
                    if (view.accessibilities != null && view.accessibilities.getViewComponent().isVisible() && !isSelected) {
                        label.setBackground(SelectViewDialog.this.selectedColor);
                    }
                    label.setIcon(view.provider.getIcon());
                    label.setText(text);
                    label.setVerticalAlignment(1);
                }
                return label;
            }
        });
        ViewListElement selectedView = null;
        this.listViews.setModel(new DefaultListModel());
        for (int i = 0; i < this.perspective.getTabbedViews().getTabCount(); ++i) {
            Component c = this.perspective.getTabbedViews().getComponentAt(i);
            ViewAccesibilities va = this.perspective.getViewAccesibilities(c);
            ViewListElement el = new ViewListElement(va.getViewProvider(), va);
            if (c.isVisible()) {
                selectedView = el;
            }
            this.viewList.add(el);
        }
        ViewProvider[] wpa = Utils.sortViewList((ViewProvider[])Application.get().getServiceArray(ViewProvider.class));
        if (wpa != null && wpa.length > 0) {
            for (ViewProvider vp : wpa) {
                if (!vp.isForDatabase(this.perspective.getDatabase()) || this.perspective.getViewComponent(vp) != null) continue;
                ViewListElement el = new ViewListElement(vp, null);
                this.viewList.add(el);
            }
        }
        this.cmSelect.setEnabled(false);
        this.refreshList(selectedView);
        this.editFiltr.addKeyListener((KeyListener)new ListRowChangeKeyListener(this.listViews));
        this.editFiltr.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SelectViewDialog.this.refreshList(null);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SelectViewDialog.this.refreshList(null);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SelectViewDialog.this.editFiltr.requestFocus();
            }
        });
        this.getRootPane().getInputMap(2).put(this.cmCancel.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmCancel);
        this.getRootPane().setDefaultButton(this.buttonOk);
        SwingUtil.setButtonSizesTheSame((AbstractButton[])new AbstractButton[]{this.buttonOk, this.buttonCancel, this.buttonCloseView});
        this.pack();
        SwingUtil.centerWithinScreen((Window)this);
    }

    private String getViewText(ViewListElement view) {
        String text = "<html>";
        text = view.accessibilities != null ? text + "<b>" + view.accessibilities.getTabTitle() + "</b>" : text + view.provider.getPublicName();
        if (view.accessibilities != null && view.accessibilities.getTabExtTooltip() != null) {
            text = text + " - " + view.accessibilities.getTabExtTooltip();
        } else if (view.provider.getDescription() != null) {
            text = text + " - " + view.provider.getDescription();
        }
        return text;
    }

    private void refreshList(Object selected) {
        DefaultListModel model = (DefaultListModel)this.listViews.getModel();
        if (selected == null) {
            selected = this.listViews.getSelectedValue();
        }
        model.clear();
        for (ViewListElement item : this.viewList) {
            if (!"".equals(this.editFiltr.getText())) {
                String text = this.getViewText(item);
                if (text != null && text.toUpperCase().indexOf(this.editFiltr.getText().toUpperCase()) >= 0) {
                    model.addElement(item);
                    continue;
                }
                if (item.provider.getPublicName().toUpperCase().indexOf(this.editFiltr.getText().toUpperCase()) < 0) continue;
                model.addElement(item);
                continue;
            }
            model.addElement(item);
        }
        this.listViews.setSelectedValue(selected, true);
        if (this.listViews.getSelectedIndex() == -1 && model.size() > 0) {
            this.listViews.setSelectedIndex(0);
        }
    }

    private void initComponents() {
        this.cmCancel = new Action();
        this.cmSelect = new Action();
        this.cmCloseView = new Action();
        this.jScrollPane1 = new JScrollPane();
        this.listViews = new JList();
        this.buttonOk = new JButton();
        this.buttonCancel = new JButton();
        this.buttonCloseView = new JButton();
        this.jLabel1 = new JLabel();
        this.editFiltr = new TextField();
        this.cmCancel.setActionCommandKey("cmCancel");
        this.cmCancel.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmCancel.setText(stringManager.getString("cmCancel-text"));
        this.cmCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectViewDialog.this.cmCancelActionPerformed(evt);
            }
        });
        this.cmSelect.setActionCommandKey("cmOk");
        this.cmSelect.setText(stringManager.getString("cmSelect-text"));
        this.cmSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectViewDialog.this.cmSelectActionPerformed(evt);
            }
        });
        this.cmCloseView.setActionCommandKey("cmCloseView");
        this.cmCloseView.setText(stringManager.getString("cmClose-text"));
        this.cmCloseView.setTooltip(stringManager.getString("SelectViewDialog-cmCloseView-hiny"));
        this.cmCloseView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectViewDialog.this.cmCloseViewActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(stringManager.getString("SelectViewDialog-title"));
        this.setModal(true);
        this.listViews.setFixedCellHeight(20);
        this.listViews.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                SelectViewDialog.this.listViewsValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.listViews);
        this.buttonOk.setAction((javax.swing.Action)this.cmSelect);
        this.buttonOk.setMargin(new Insets(2, 2, 2, 2));
        this.buttonOk.setPreferredSize(new Dimension(85, 25));
        this.buttonCancel.setAction((javax.swing.Action)this.cmCancel);
        this.buttonCancel.setMargin(new Insets(2, 2, 2, 2));
        this.buttonCancel.setPreferredSize(new Dimension(85, 25));
        this.buttonCloseView.setAction((javax.swing.Action)this.cmCloseView);
        this.buttonCloseView.setMargin(new Insets(2, 2, 2, 2));
        this.buttonCloseView.setPreferredSize(new Dimension(85, 25));
        this.jLabel1.setText(stringManager.getString("SelectViewDialog-filter-dd"));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 530, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.buttonCloseView, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 269, Short.MAX_VALUE).addComponent(this.buttonOk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.editFiltr, -1, 504, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent((Component)this.editFiltr, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 262, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.buttonCancel, -2, -1, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonOk, -2, -1, -2).addComponent(this.buttonCloseView, -2, -1, -2))).addContainerGap()));
        this.pack();
    }

    private void listViewsValueChanged(ListSelectionEvent evt) {
        this.cmSelect.setEnabled(this.listViews.getSelectedIndex() != -1);
        if (this.listViews.getSelectedValue() instanceof ViewListElement) {
            ViewListElement view = (ViewListElement)this.listViews.getSelectedValue();
            this.cmCloseView.setEnabled(view.accessibilities != null);
        } else {
            this.cmCloseView.setEnabled(false);
        }
    }

    private void cmSelectActionPerformed(ActionEvent evt) {
        this.modalResult = 1;
        this.dispose();
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        this.modalResult = 2;
        this.dispose();
    }

    private void cmCloseViewActionPerformed(ActionEvent evt) {
        int index = this.listViews.getSelectedIndex() - 1;
        ViewListElement item = (ViewListElement)this.listViews.getSelectedValue();
        this.viewList.remove(item);
        ((DefaultListModel)this.listViews.getModel()).removeElementAt(this.listViews.getSelectedIndex());
        if (item.accessibilities != null) {
            item.accessibilities.getPerspectiveAccesibilities().closeView(item.accessibilities.getViewComponent());
            if (index < ((DefaultListModel)this.listViews.getModel()).getSize() && index >= 0) {
                this.listViews.setSelectedIndex(index);
            }
        }
        this.listViews.requestFocusInWindow();
    }

    private static class ViewListElement {
        ViewProvider provider;
        ViewAccesibilities accessibilities;

        public ViewListElement(ViewProvider provider, ViewAccesibilities accessibilities) {
            this.provider = provider;
            this.accessibilities = accessibilities;
        }
    }
}

