/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui;

import java.awt.Component;
import java.io.Closeable;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import pl.mpak.orbada.plugins.ISettingsComponent;
import pl.mpak.orbada.plugins.providers.PerspectiveSettingsProvider;
import pl.mpak.orbada.plugins.providers.SettingsProvider;
import pl.mpak.orbada.plugins.providers.abs.AbstractSettingsProvider;
import pl.mpak.orbada.plugins.providers.abs.IOrbadaPluginProvider;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.ExceptionUtil;

public class SettingsProviderTreeNode
extends DefaultMutableTreeNode
implements ISettingsComponent {
    private Database database;
    private AbstractSettingsProvider service;
    private Component component;

    public SettingsProviderTreeNode(AbstractSettingsProvider serivce, Database database, String name) {
        super(name);
        this.service = serivce;
        this.database = database;
    }

    public SettingsProviderTreeNode(String name) {
        this(null, null, name);
    }

    public boolean isShowed() {
        return this.component != null;
    }

    public Component getComponent() {
        if (this.component == null) {
            if (this.service instanceof SettingsProvider) {
                this.component = ((SettingsProvider)this.service).getSettingsComponent();
            } else if (this.service instanceof PerspectiveSettingsProvider) {
                this.component = ((PerspectiveSettingsProvider)this.service).getSettingsComponent(this.database);
            }
        }
        return this.component;
    }

    public Icon getIcon() {
        if (this.service != null) {
            return this.service.getIcon();
        }
        return null;
    }

    public String getDescription() {
        return this.service.getDescription();
    }

    public IOrbadaPluginProvider getSerivce() {
        return this.service;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    public void setService(AbstractSettingsProvider service) {
        this.service = service;
    }

    public void restoreSettings() {
        if (this.component instanceof ISettingsComponent) {
            ((ISettingsComponent)this.component).restoreSettings();
        }
    }

    public void applySettings() {
        if (this.component instanceof ISettingsComponent) {
            ((ISettingsComponent)this.component).applySettings();
        }
    }

    public void cancelSettings() {
        if (this.component instanceof ISettingsComponent) {
            ((ISettingsComponent)this.component).cancelSettings();
        }
    }

    public void close() {
        if (this.component instanceof Closeable) {
            try {
                ((Closeable)((Object)this.component)).close();
            }
            catch (IOException ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }
}

