/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import pl.mpak.orbada.Consts;
import pl.mpak.orbada.gui.editor.EditorPopupMenu;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.sky.gui.swing.syntax.SyntaxTextArea;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class TextFileViewPanel
extends JPanel {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);
    private IViewAccesibilities accesibilities;
    private File file;
    private Action cmSave;
    private JPanel jPanel1;
    private JToolBar jToolBar1;
    private SyntaxTextArea textContent;
    private ToolButton toolButton1;

    public TextFileViewPanel(IViewAccesibilities accesibilities, File file) {
        this.accesibilities = accesibilities;
        this.file = file;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.textContent.getEditorArea().setComponentPopupMenu((JPopupMenu)((Object)new EditorPopupMenu(this.textContent)));
        try {
            this.textContent.loadFromFile(this.file);
            this.textContent.setChanged(false);
            this.textContent.getEditorArea().getUndoManager().discardAllEdits();
        }
        catch (IOException ex) {
            MessageBox.show((Component)this, (String)stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
        }
    }

    private void initComponents() {
        this.cmSave = new Action();
        this.jPanel1 = new JPanel();
        this.jToolBar1 = new JToolBar();
        this.toolButton1 = new ToolButton();
        this.textContent = new SyntaxTextArea();
        this.cmSave.setActionCommandKey("cmSave");
        this.cmSave.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/save16.gif"));
        this.cmSave.setText(stringManager.getString("cmSave-text"));
        this.cmSave.setTooltip(stringManager.getString("TextFileViewPanel-cmSave-hint"));
        this.cmSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextFileViewPanel.this.cmSaveActionPerformed(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.toolButton1.setAction((javax.swing.Action)this.cmSave);
        this.toolButton1.setHorizontalTextPosition(0);
        this.toolButton1.setVerticalTextPosition(3);
        this.jToolBar1.add((Component)this.toolButton1);
        this.jPanel1.add(this.jToolBar1);
        this.add((Component)this.jPanel1, "First");
        this.add((Component)this.textContent, "Center");
    }

    private void cmSaveActionPerformed(ActionEvent evt) {
        try {
            this.textContent.saveToFile(this.file);
            this.textContent.setChanged(false);
        }
        catch (IOException ex) {
            MessageBox.show((Component)this, (String)stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
        }
    }
}

