/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import pl.mpak.orbada.Consts;
import pl.mpak.orbada.core.Application;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.HtmlEditorPane;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.id.VersionID;

public class UpdateInfoDialog
extends JDialog {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);
    private JSONObject updateInfo;
    private JButton buttonCancel;
    private JButton buttonDownload;
    private Action cmClose;
    private Action cmDownload;
    private JScrollPane jScrollPane1;
    private JLabel labelDownload;
    private HtmlEditorPane textInfo;

    public UpdateInfoDialog(JSONObject updateInfo) {
        super(SwingUtil.getRootFrame());
        this.updateInfo = updateInfo;
        this.initComponents();
        this.init();
    }

    public static void showDialog() {
        final JSONObject updateInfo = Application.get().getMainFrame().getUpdateInfo();
        if (updateInfo != null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UpdateInfoDialog dialog = new UpdateInfoDialog(updateInfo);
                    dialog.setVisible(true);
                }
            });
        }
    }

    private void init() {
        this.textInfo.setFont(new Font("Monospaced", 0, this.textInfo.getFont().getSize()));
        this.produceHtml();
        this.getRootPane().getInputMap(2).put(this.cmClose.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmClose);
        SwingUtil.setButtonSizesTheSame((AbstractButton[])new AbstractButton[]{this.buttonDownload, this.buttonCancel});
        SwingUtil.centerWithinScreen((Window)this);
    }

    private void produceHtml() {
        try {
            JSONObject lastVersion = this.updateInfo.getJSONObject("lastVersion");
            if (lastVersion != null) {
                VersionID ver = new VersionID(lastVersion.getString("version"));
                this.cmDownload.setEnabled(ver.getBuild() > Consts.orbadaVersion.getBuild());
            }
            StringBuffer sb = new StringBuffer();
            sb.append("<html>");
            sb.append("<head>");
            sb.append("<style>");
            sb.append("  body { font-family: Tahoma, Arial, serif; font-size: 10px; padding: 5px; }");
            sb.append("</style>");
            sb.append("</head>");
            sb.append("<body>");
            JSONArray versions = this.updateInfo.getJSONArray("versions");
            for (int v = 0; v < versions.length(); ++v) {
                if (v > 0) {
                    sb.append("<hr>");
                }
                JSONObject ver = versions.getJSONObject(v);
                sb.append("<h2>").append(stringManager.getString("version-dd")).append(" ").append(ver.getString("version")).append(", ").append(stringManager.getString("released-dd")).append(" ").append(ver.getString("released")).append("</h2>");
                JSONArray details = ver.getJSONArray("details");
                String type = null;
                for (int d = 0; d < details.length(); ++d) {
                    JSONObject det = details.getJSONObject(d);
                    if (!StringUtil.equals(type, (String)det.getString("type"))) {
                        type = det.getString("type");
                        if (d > 0) {
                            sb.append("</table>");
                        }
                        sb.append("<p>").append(type).append("</p>");
                        sb.append("<table>");
                    }
                    sb.append("<tr>");
                    String title = det.getString("title");
                    String request = "&nbsp;";
                    if (title.startsWith("#") && title.indexOf(45) > 0) {
                        request = title.substring(0, title.indexOf(45) - 1).trim();
                        title = title.substring(title.indexOf(45) + 1);
                    }
                    sb.append("<td>").append(request).append("</td>");
                    sb.append("<td>").append(title).append("</td>");
                    sb.append("</tr>");
                }
                if (type == null) continue;
                sb.append("</table>");
            }
            sb.append("</body>");
            sb.append("</html>");
            this.textInfo.setText(sb.toString());
        }
        catch (JSONException ex) {
            this.textInfo.setText(ex.getMessage());
        }
    }

    private void initComponents() {
        this.cmClose = new Action();
        this.cmDownload = new Action();
        this.buttonCancel = new JButton();
        this.buttonDownload = new JButton();
        this.labelDownload = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.textInfo = new HtmlEditorPane();
        this.cmClose.setActionCommandKey("cmCancel");
        this.cmClose.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmClose.setText(stringManager.getString("cmClose-text"));
        this.cmClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdateInfoDialog.this.cmCloseActionPerformed(evt);
            }
        });
        this.cmDownload.setText(stringManager.getString("cmDownload-text"));
        this.cmDownload.setTooltip(stringManager.getString("cmDownload-hint"));
        this.cmDownload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdateInfoDialog.this.cmDownloadActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(stringManager.getString("UpdateInfoDialog-title"));
        this.setModal(true);
        this.buttonCancel.setAction((javax.swing.Action)this.cmClose);
        this.buttonCancel.setMargin(new Insets(2, 2, 2, 2));
        this.buttonCancel.setPreferredSize(new Dimension(85, 25));
        this.buttonDownload.setAction((javax.swing.Action)this.cmDownload);
        this.buttonDownload.setMargin(new Insets(2, 2, 2, 2));
        this.buttonDownload.setPreferredSize(new Dimension(85, 25));
        this.labelDownload.setText(" ");
        this.textInfo.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent evt) {
                UpdateInfoDialog.this.textInfoHyperlinkUpdate(evt);
            }
        });
        this.jScrollPane1.setViewportView((Component)this.textInfo);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 601, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.buttonDownload, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelDownload).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 424, Short.MAX_VALUE).addComponent(this.buttonCancel, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 399, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel, -2, -1, -2).addComponent(this.buttonDownload, -2, -1, -2).addComponent(this.labelDownload)).addContainerGap()));
        this.pack();
    }

    private void cmCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void cmDownloadActionPerformed(ActionEvent evt) {
        try {
            JSONObject lastVersion;
            if (this.updateInfo.has("lastVersion") && (lastVersion = this.updateInfo.getJSONObject("lastVersion")).has("downloadPage")) {
                try {
                    Desktop.getDesktop().browse(new URL((String)lastVersion.get("downloadPage")).toURI());
                }
                catch (Exception ex) {
                    ExceptionUtil.processException((Throwable)ex);
                }
            }
        }
        catch (JSONException ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void textInfoHyperlinkUpdate(HyperlinkEvent evt) {
        if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                Desktop.getDesktop().browse(evt.getURL().toURI());
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }
}

