/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.IntrospectionException;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.Consts;
import pl.mpak.orbada.core.Application;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.br.BufferedRecord;
import pl.mpak.usedb.gui.RecordLink;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.timer.Timer;

public class UserPropertiesDialog
extends JDialog {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);
    private int modalResult = 0;
    private RecordLink userLink;
    private Timer timerRegisterOrbada;
    private JButton buttonCancel;
    private JButton buttonOk;
    private JButton buttonRegisterOrbada;
    private Action cmCancel;
    private Action cmOk;
    private Action cmRegisterOrbada;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private TextField textUserDescription;
    private TextField textUserId;
    private TextField textUserName;

    public UserPropertiesDialog() throws IntrospectionException, UseDBException {
        super(SwingUtil.getRootFrame());
        this.initComponents();
        this.init();
    }

    public static void showDialog() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UserPropertiesDialog dialog = new UserPropertiesDialog();
                    dialog.setVisible(true);
                }
                catch (Exception ex) {
                    ExceptionUtil.processException((Throwable)ex);
                    MessageBox.show(null, (String)stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
                }
            }
        });
    }

    private void init() throws IntrospectionException, UseDBException {
        this.textUserName.setEditable(Application.get().isUserAdmin());
        this.userLink = new RecordLink();
        this.userLink.add("USR_ID", (Component)this.textUserId);
        this.userLink.add("USR_NAME", (Component)this.textUserName);
        this.userLink.add("USR_DESCRIPTION", (Component)this.textUserDescription);
        this.buttonRegisterOrbada.setVisible(false);
        this.cmRegisterOrbada.setEnabled(false);
        this.userLink.updateComponents((BufferedRecord)Application.get().getUser());
        SwingUtil.setButtonSizesTheSame((AbstractButton[])new AbstractButton[]{this.buttonRegisterOrbada});
        SwingUtil.setButtonSizesTheSame((AbstractButton[])new AbstractButton[]{this.buttonOk, this.buttonCancel});
        this.getRootPane().setDefaultButton(this.buttonOk);
        this.getRootPane().getInputMap(2).put(this.cmCancel.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmCancel);
        SwingUtil.centerWithinScreen((Window)this);
    }

    @Override
    public void dispose() {
        if (this.timerRegisterOrbada != null) {
            this.timerRegisterOrbada.cancel();
        }
        super.dispose();
    }

    private void updateRecord() throws Exception {
        this.userLink.updateRecord((BufferedRecord)Application.get().getUser());
        Application.get().getUser().applyUpdate();
    }

    private void initComponents() {
        this.cmOk = new Action();
        this.cmCancel = new Action();
        this.cmRegisterOrbada = new Action();
        this.buttonOk = new JButton();
        this.buttonCancel = new JButton();
        this.jLabel1 = new JLabel();
        this.textUserName = new TextField();
        this.jLabel3 = new JLabel();
        this.textUserId = new TextField();
        this.buttonRegisterOrbada = new JButton();
        this.jLabel2 = new JLabel();
        this.textUserDescription = new TextField();
        this.cmOk.setShortCut(KeyStroke.getKeyStroke(10, 0));
        this.cmOk.setText(stringManager.getString("cmOk-text"));
        this.cmOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserPropertiesDialog.this.cmOkActionPerformed(evt);
            }
        });
        this.cmCancel.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmCancel.setText(stringManager.getString("cmCancel-text"));
        this.cmCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserPropertiesDialog.this.cmCancelActionPerformed(evt);
            }
        });
        this.cmRegisterOrbada.setActionCommandKey("cmRegisterOrbada");
        this.cmRegisterOrbada.setText(stringManager.getString("UserPropertiesDialog-cmRegisterOrbada-text"));
        this.cmRegisterOrbada.setTooltip(stringManager.getString("UserPropertiesDialog-cmRegisterOrbada-hint"));
        this.cmRegisterOrbada.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserPropertiesDialog.this.cmRegisterOrbadaActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(stringManager.getString("UserPropertiesDialog-title"));
        this.setModal(true);
        this.buttonOk.setAction((javax.swing.Action)this.cmOk);
        this.buttonOk.setMargin(new Insets(2, 2, 2, 2));
        this.buttonOk.setMinimumSize(new Dimension(75, 23));
        this.buttonOk.setPreferredSize(new Dimension(85, 25));
        this.buttonCancel.setAction((javax.swing.Action)this.cmCancel);
        this.buttonCancel.setMargin(new Insets(2, 2, 2, 2));
        this.buttonCancel.setPreferredSize(new Dimension(85, 25));
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText(stringManager.getString("UserPropertiesDialog-email-addr-dd"));
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(stringManager.getString("UserPropertiesDialog-user-id-dd"));
        this.textUserId.setEditable(false);
        this.buttonRegisterOrbada.setAction((javax.swing.Action)this.cmRegisterOrbada);
        this.buttonRegisterOrbada.setMargin(new Insets(2, 2, 2, 2));
        this.buttonRegisterOrbada.setPreferredSize(new Dimension(85, 25));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(stringManager.getString("UserPropertiesDialog-description-dd"));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -2, 123, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textUserName, -1, 319, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3, -2, 123, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textUserId, -1, 319, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.buttonRegisterOrbada, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 185, Short.MAX_VALUE).addComponent(this.buttonOk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2, -2, 123, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textUserDescription, -1, 319, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent((Component)this.textUserId, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent((Component)this.textUserName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent((Component)this.textUserDescription, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel, -2, -1, -2).addComponent(this.buttonOk, -2, -1, -2).addComponent(this.buttonRegisterOrbada, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void cmOkActionPerformed(ActionEvent evt) {
        try {
            this.updateRecord();
            this.modalResult = 1;
            this.dispose();
        }
        catch (Exception ex) {
            MessageBox.show((Component)this, (String)stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
        }
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        this.modalResult = 2;
        this.dispose();
    }

    private void cmRegisterOrbadaActionPerformed(ActionEvent evt) {
    }
}

