/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JToolBar;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.gui.PerspectivePanel;
import pl.mpak.orbada.plugins.IApplication;
import pl.mpak.orbada.plugins.IPerspectiveAccesibilities;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.plugins.providers.ViewProvider;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.TabCloseComponent;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;

public class ViewAccesibilities
implements IViewAccesibilities,
ComponentListener {
    private TabCloseComponent tabClose;
    private Database database;
    private Component viewComponent;
    private ArrayList<JMenu> menuList;
    private JToolBar toolBarView;
    private ViewProvider viewProvider;
    private PerspectivePanel perspective;
    private boolean hideTitle;
    private boolean hideIcon;
    private String orgTabTooltip;
    private String tabExtTooltip;

    public ViewAccesibilities(Database database, TabCloseComponent tabClose, PerspectivePanel perspective, ViewProvider viewProvider) {
        this.tabClose = tabClose;
        this.database = database;
        this.perspective = perspective;
        this.viewProvider = viewProvider;
        this.init();
    }

    private void init() {
    }

    public void close() {
        Application.get().getMainFrame().setTitle(null);
        if (this.menuList != null) {
            for (int i = 0; i < this.menuList.size(); ++i) {
                Application.get().getMainFrame().removeMenu(this.menuList.get(i));
            }
            this.menuList.clear();
        }
        if (this.toolBarView != null) {
            Application.get().getMainFrame().removeToolBar(this.toolBarView);
            this.toolBarView = null;
        }
        this.viewProvider.viewClose();
        this.setViewComponent(null);
        this.database = null;
        this.perspective = null;
        this.viewProvider = null;
        this.tabClose = null;
    }

    public Database getDatabase() {
        return this.database;
    }

    public IApplication getApplication() {
        return Application.get();
    }

    public IPerspectiveAccesibilities getPerspectiveAccesibilities() {
        return this.perspective.perspectiveAccesibilities;
    }

    public Component getViewComponent() {
        return this.viewComponent;
    }

    public void setViewComponent(Component view) {
        if (this.viewComponent != null) {
            this.viewComponent.removeComponentListener(this);
        }
        this.viewComponent = view;
        if (this.viewComponent != null) {
            this.viewComponent.addComponentListener(this);
        }
    }

    public ViewProvider getViewProvider() {
        return this.viewProvider;
    }

    public boolean isHideIcon() {
        return this.hideIcon;
    }

    public void setHideIcon(boolean hideIcon) {
        this.hideIcon = hideIcon;
        this.tabClose.getIconLabel().setVisible(!hideIcon && Application.get().getSettings().getValue("no-view-tab-pictures", Boolean.valueOf(false)) == false);
    }

    public boolean isHideTitle() {
        return this.hideTitle;
    }

    public void setHideTitle(boolean hideTitle) {
        this.hideTitle = hideTitle;
        if (!this.viewComponent.isVisible()) {
            this.tabClose.getLabel().setVisible(!hideTitle && Application.get().getSettings().getValue("no-view-tab-titles", Boolean.valueOf(false)) == false || this.tabClose.getIconLabel().getIcon() == null);
        } else {
            this.tabClose.getLabel().setVisible(true);
        }
    }

    public void addMenu(final JMenu menu) {
        if (menu != null) {
            if (this.menuList == null) {
                this.menuList = new ArrayList();
            }
            this.menuList.add(menu);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Application.get().getMainFrame().addMenu(menu);
                }
            });
        }
    }

    public void addAction(Action action) {
        if (action != null) {
            if (this.toolBarView == null) {
                this.toolBarView = new JToolBar();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Application.get().getMainFrame().addToolBar(ViewAccesibilities.this.toolBarView);
                    }
                });
            }
            ToolButton tb = new ToolButton((javax.swing.Action)action);
            tb.setPreferredSize(new Dimension(28, 28));
            this.toolBarView.add((Component)tb);
        }
    }

    public Component getViewComponent(ViewProvider view) {
        return this.perspective.getViewComponent(view);
    }

    public Component[] getViewComponentList(ViewProvider view) {
        return this.perspective.getViewComponentList(view);
    }

    public Component createView(ViewProvider view) {
        return this.perspective.createView(view, false, false);
    }

    public void componentShow() {
        if (this.menuList != null) {
            for (int i = 0; i < this.menuList.size(); ++i) {
                this.menuList.get(i).setVisible(true);
            }
        }
        if (this.toolBarView != null) {
            this.toolBarView.setVisible(true);
        }
        this.tabClose.getButton().setVisible(true);
        this.tabClose.getLabel().setVisible(true);
        this.viewProvider.viewShow();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Application.get().getMainFrame().setTitle(ViewAccesibilities.this.tabClose.getTitle());
            }
        });
    }

    public void componentHide() {
        Application.get().getMainFrame().setTitle(null);
        this.tabClose.getButton().setVisible(false);
        this.tabClose.getLabel().setVisible(!this.hideTitle && Application.get().getSettings().getValue("no-view-tab-titles", Boolean.valueOf(false)) == false || this.tabClose.getIconLabel().getIcon() == null);
        if (this.menuList != null) {
            for (int i = 0; i < this.menuList.size(); ++i) {
                this.menuList.get(i).setVisible(false);
            }
        }
        if (this.toolBarView != null) {
            this.toolBarView.setVisible(false);
        }
        this.viewProvider.viewHide();
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.componentShow();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        this.componentHide();
    }

    public JLabel getTabLabel() {
        return this.tabClose.getLabel();
    }

    public Action getCloseAction() {
        return this.tabClose.getAction();
    }

    public void setTabTitle(String title) {
        this.tabClose.getLabel().setText(title);
    }

    public String getTabTitle() {
        return this.tabClose.getLabel().getText();
    }

    public void setTabExtTooltip(String tooltip) {
        int index = this.perspective.getTabbedViews().indexOfComponent(this.viewComponent);
        if (this.orgTabTooltip == null) {
            this.orgTabTooltip = this.perspective.getTabbedViews().getToolTipTextAt(index);
        }
        this.tabExtTooltip = tooltip;
        this.perspective.getTabbedViews().setToolTipTextAt(index, this.orgTabTooltip + (this.tabExtTooltip != null ? "<hr>" + this.tabExtTooltip : ""));
    }

    public String getTabExtTooltip() {
        return this.tabExtTooltip;
    }

    public void setCloseEnabled(boolean enabled) {
        this.tabClose.getAction().setEnabled(enabled);
    }

    public boolean isCloseEnabled() {
        return this.tabClose.getAction().isEnabled();
    }
}

