/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.Consts;
import pl.mpak.orbada.gui.ViewAccesibilities;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class ViewPropertiesDialog
extends JDialog {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);
    private ViewAccesibilities accessibilities;
    private JButton buttonCancel;
    private JButton buttonOk;
    private JCheckBox checkHideIcon;
    private JCheckBox checkHideTitle;
    private Action cmCancel;
    private Action cmOk;

    public ViewPropertiesDialog(ViewAccesibilities accessibilities) {
        super(SwingUtil.getRootFrame());
        this.accessibilities = accessibilities;
        this.initComponents();
        this.init();
    }

    public static void showDialog(final ViewAccesibilities accessibilities) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ViewPropertiesDialog dialog = new ViewPropertiesDialog(accessibilities);
                dialog.setVisible(true);
            }
        });
    }

    private void init() {
        this.checkHideTitle.setSelected(this.accessibilities.isHideTitle());
        this.checkHideIcon.setSelected(this.accessibilities.isHideIcon());
        this.getRootPane().setDefaultButton(this.buttonOk);
        this.getRootPane().getInputMap(2).put(this.cmCancel.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmCancel);
        SwingUtil.centerWithinScreen((Window)this);
    }

    private void initComponents() {
        this.cmOk = new Action();
        this.cmCancel = new Action();
        this.buttonOk = new JButton();
        this.buttonCancel = new JButton();
        this.checkHideTitle = new JCheckBox();
        this.checkHideIcon = new JCheckBox();
        this.cmOk.setShortCut(KeyStroke.getKeyStroke(10, 0));
        this.cmOk.setText(stringManager.getString("cmOk-text"));
        this.cmOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewPropertiesDialog.this.cmOkActionPerformed(evt);
            }
        });
        this.cmCancel.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmCancel.setText(stringManager.getString("cmCancel-text"));
        this.cmCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewPropertiesDialog.this.cmCancelActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(stringManager.getString("ViewPropertiesDialog-title"));
        this.setModal(true);
        this.buttonOk.setAction((javax.swing.Action)this.cmOk);
        this.buttonOk.setMargin(new Insets(2, 2, 2, 2));
        this.buttonOk.setPreferredSize(new Dimension(85, 25));
        this.buttonCancel.setAction((javax.swing.Action)this.cmCancel);
        this.buttonCancel.setMargin(new Insets(2, 2, 2, 2));
        this.buttonCancel.setPreferredSize(new Dimension(85, 25));
        this.checkHideTitle.setText(stringManager.getString("ViewPropertiesDialog-checkHideTitle-text"));
        this.checkHideIcon.setText(stringManager.getString("ViewPropertiesDialog-checkHideIcon-text"));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.checkHideTitle).addContainerGap(127, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(184, Short.MAX_VALUE).addComponent(this.buttonOk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2).addContainerGap()).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.checkHideIcon).addContainerGap(251, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.checkHideTitle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkHideIcon).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel, -2, -1, -2).addComponent(this.buttonOk, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void cmOkActionPerformed(ActionEvent evt) {
        this.accessibilities.setHideTitle(this.checkHideTitle.isSelected());
        this.accessibilities.setHideIcon(this.checkHideIcon.isSelected());
        this.dispose();
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

