/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui.admin;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.IntrospectionException;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.Consts;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.db.User;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.br.BufferedRecord;
import pl.mpak.usedb.gui.FieldLinkType;
import pl.mpak.usedb.gui.RecordLink;
import pl.mpak.usedb.gui.linkreq.FieldRequeiredNotNull;
import pl.mpak.usedb.gui.linkreq.IFieldRequires;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.id.UniqueID;

public class UserEditDialog
extends JDialog {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);
    private String usr_id;
    private int modalResult = 0;
    private User user;
    private RecordLink link;
    private JButton buttonCancel;
    private JButton buttonOk;
    private JCheckBox checkUsrActive;
    private JCheckBox checkUsrAdmin;
    private Action cmCancel;
    private Action cmOk;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private TextField textUsrDescription;
    private TextField textUsrId;
    private TextField textUsrName;

    public UserEditDialog(String usr_id) throws IntrospectionException, UseDBException {
        super(SwingUtil.getRootFrame());
        this.usr_id = usr_id;
        this.initComponents();
        this.init();
    }

    public UserEditDialog(User user) throws IntrospectionException, UseDBException {
        super(SwingUtil.getRootFrame());
        this.user = user;
        this.initComponents();
        this.init();
    }

    public static String showDialog(String drv_id) throws IntrospectionException, UseDBException {
        UserEditDialog dialog = new UserEditDialog(drv_id);
        dialog.setVisible(true);
        return dialog.getModalResult() == 1 ? dialog.usr_id : null;
    }

    public static String showDialog(User user) throws IntrospectionException, UseDBException {
        UserEditDialog dialog = new UserEditDialog(user);
        dialog.setVisible(true);
        return dialog.getModalResult() == 1 ? dialog.usr_id : null;
    }

    private void init() throws IntrospectionException, UseDBException {
        SwingUtil.centerWithinScreen((Window)this);
        this.link = new RecordLink();
        this.link.add("USR_ID", (Component)this.textUsrId);
        this.link.add("USR_NAME", (Component)this.textUsrName, (IFieldRequires)new FieldRequeiredNotNull(stringManager.getString("UserEditDialog-user_name")));
        this.link.add("USR_DESCRIPTION", (Component)this.textUsrDescription);
        this.link.add("USR_ACTIVE", (Component)this.checkUsrActive, "selected", FieldLinkType.Boolean_TF);
        this.link.add("USR_ADMIN", (Component)this.checkUsrAdmin, "selected", FieldLinkType.Boolean_YN);
        if (this.usr_id != null) {
            this.user = new User(Application.get().getOrbadaDatabase(), this.usr_id);
        } else if (this.user != null) {
            this.user.setUserId(new UniqueID().toString());
        } else {
            this.user = new User(Application.get().getOrbadaDatabase());
        }
        this.link.updateComponents((BufferedRecord)this.user);
        this.checkUsrActive.setEnabled(!Application.get().getUserId().equals(this.user.getUserId()));
        this.checkUsrAdmin.setEnabled(!Application.get().getUserId().equals(this.user.getUserId()));
        this.getRootPane().setDefaultButton(this.buttonOk);
        this.getRootPane().getInputMap(2).put(this.cmCancel.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmCancel);
    }

    public int getModalResult() {
        return this.modalResult;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    private void initComponents() {
        this.cmOk = new Action();
        this.cmCancel = new Action();
        this.jLabel1 = new JLabel();
        this.textUsrName = new TextField();
        this.buttonOk = new JButton();
        this.buttonCancel = new JButton();
        this.jLabel2 = new JLabel();
        this.textUsrDescription = new TextField();
        this.checkUsrActive = new JCheckBox();
        this.checkUsrAdmin = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.textUsrId = new TextField();
        this.cmOk.setShortCut(KeyStroke.getKeyStroke(10, 0));
        this.cmOk.setText(stringManager.getString("cmOk-text"));
        this.cmOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserEditDialog.this.cmOkActionPerformed(evt);
            }
        });
        this.cmCancel.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmCancel.setText(stringManager.getString("cmCancel-text"));
        this.cmCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserEditDialog.this.cmCancelActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(stringManager.getString("UserEditDialog-title"));
        this.setModal(true);
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setLabelFor((Component)this.textUsrName);
        this.jLabel1.setText(stringManager.getString("UserEditDialog-user-name-dd"));
        this.buttonOk.setAction((javax.swing.Action)this.cmOk);
        this.buttonOk.setMargin(new Insets(2, 2, 2, 2));
        this.buttonOk.setPreferredSize(new Dimension(85, 25));
        this.buttonCancel.setAction((javax.swing.Action)this.cmCancel);
        this.buttonCancel.setMargin(new Insets(2, 2, 2, 2));
        this.buttonCancel.setPreferredSize(new Dimension(85, 25));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setLabelFor((Component)this.textUsrName);
        this.jLabel2.setText(stringManager.getString("UserEditDialog-first-last-name-dd"));
        this.checkUsrActive.setText(stringManager.getString("UserEditDialog-active"));
        this.checkUsrAdmin.setText(stringManager.getString("UserEditDialog-administrator"));
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setLabelFor((Component)this.textUsrName);
        this.jLabel3.setText(stringManager.getString("UserEditDialog-user-id-dd"));
        this.textUsrId.setEditable(false);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3, -2, 145, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textUsrId, -1, 320, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -2, 145, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textUsrName, -1, 320, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2, -2, 145, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkUsrActive).addComponent(this.checkUsrAdmin).addComponent((Component)this.textUsrDescription, -1, 320, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.buttonOk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent((Component)this.textUsrId, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent((Component)this.textUsrName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent((Component)this.textUsrDescription, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkUsrActive).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkUsrAdmin).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 17, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel, -2, -1, -2).addComponent(this.buttonOk, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        this.modalResult = 2;
        this.dispose();
    }

    private void cmOkActionPerformed(ActionEvent evt) {
        try {
            this.link.updateRecord((BufferedRecord)this.user);
            if (this.user.isChanged()) {
                if (this.usr_id == null) {
                    this.user.applyInsert();
                } else {
                    this.user.applyUpdate();
                }
                this.usr_id = this.user.getUserId();
            }
            this.modalResult = 1;
            this.dispose();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            MessageBox.show((Component)this, (String)stringManager.getString("error"), (String)ex.getMessage(), (int[])new int[]{1});
        }
    }
}

