/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui.admin;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EventObject;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.Consts;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.db.InternalDatabase;
import pl.mpak.orbada.db.User;
import pl.mpak.orbada.gui.admin.UserEditDialog;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.core.QueryListener;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.FileUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.files.FileExtensionFilter;
import pl.mpak.util.variant.Variant;

public class UserListDialog
extends JDialog {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);
    private ISettings settings;
    private JButton buttonClose;
    private JButton buttonDelete;
    private JButton buttonEdit;
    private JButton buttonFunctions;
    private JButton buttonNew;
    private Action cmClose;
    private Action cmDelete;
    private Action cmEdit;
    private Action cmExport;
    private Action cmFunctions;
    private Action cmImport;
    private Action cmNew;
    private JScrollPane jScrollPane1;
    private JMenuItem menuExport;
    private JMenuItem menuImport;
    private JPopupMenu popupFunctions;
    private ViewTable tableUsers;

    public UserListDialog() {
        super(SwingUtil.getRootFrame());
        this.initComponents();
        this.init();
    }

    public static void showDialog() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                UserListDialog dialog = new UserListDialog();
                dialog.setVisible(true);
            }
        });
    }

    private void init() {
        this.settings = Application.get().getSettings("orbada-user-list-dialog");
        try {
            this.setBounds(0, 0, this.settings.getValue("width", new Variant(this.getWidth())).getInteger(), this.settings.getValue("height", new Variant(this.getHeight())).getInteger());
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.getRootPane().getInputMap(2).put(this.cmClose.getShortCut(), "cmClose");
        this.getRootPane().getActionMap().put("cmClose", (javax.swing.Action)this.cmClose);
        this.tableUsers.getQuery().setDatabase(InternalDatabase.get());
        this.tableUsers.getQuery().addQueryListener(new QueryListener(){

            public void beforeScroll(EventObject e) {
            }

            public void afterScroll(EventObject e) {
            }

            public void beforeOpen(EventObject e) {
            }

            public void afterOpen(EventObject e) {
                UserListDialog.this.cmNew.setEnabled(true);
                UserListDialog.this.cmImport.setEnabled(true);
            }

            public void beforeClose(EventObject e) {
            }

            public void afterClose(EventObject e) {
                UserListDialog.this.cmNew.setEnabled(false);
                UserListDialog.this.cmEdit.setEnabled(false);
                UserListDialog.this.cmDelete.setEnabled(false);
                UserListDialog.this.cmImport.setEnabled(false);
                UserListDialog.this.cmExport.setEnabled(false);
            }

            public void flushedPerformed(EventObject e) {
            }

            public void errorPerformed(EventObject e) {
            }
        });
        this.tableUsers.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (UserListDialog.this.tableUsers.getSelectedRow() >= 0) {
                    try {
                        UserListDialog.this.tableUsers.getQuery().getRecord(UserListDialog.this.tableUsers.getSelectedRow());
                        UserListDialog.this.cmEdit.setEnabled(e.getFirstIndex() >= 0 && (Application.get().isUserAdmin() || !UserListDialog.this.tableUsers.getQuery().fieldByName("drv_usr_id").isNull()));
                        UserListDialog.this.cmDelete.setEnabled(e.getFirstIndex() >= 0 && (Application.get().isUserAdmin() || !UserListDialog.this.tableUsers.getQuery().fieldByName("drv_usr_id").isNull()));
                        UserListDialog.this.cmExport.setEnabled(e.getFirstIndex() >= 0 && (Application.get().isUserAdmin() || !UserListDialog.this.tableUsers.getQuery().fieldByName("drv_usr_id").isNull()));
                    }
                    catch (Exception ex) {
                        ExceptionUtil.processException((Throwable)ex);
                    }
                } else {
                    UserListDialog.this.cmEdit.setEnabled(false);
                    UserListDialog.this.cmDelete.setEnabled(false);
                    UserListDialog.this.cmExport.setEnabled(false);
                }
            }
        });
        try {
            this.tableUsers.addColumn((TableColumn)new QueryTableColumn("usr_name", stringManager.getString("UserListDialog-name"), 150, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.tableUsers.addColumn((TableColumn)new QueryTableColumn("usr_created", stringManager.getString("UserListDialog-created"), 120, (TableCellRenderer)new QueryTableCellRenderer(SwingUtil.Color.GREEN)));
            this.tableUsers.addColumn((TableColumn)new QueryTableColumn("usr_description", stringManager.getString("UserListDialog-description"), 200));
            this.tableUsers.addColumn((TableColumn)new QueryTableColumn("usr_active", stringManager.getString("UserListDialog-active"), 30));
            this.tableUsers.addColumn((TableColumn)new QueryTableColumn("usr_admin", stringManager.getString("UserListDialog-admin"), 30));
            this.tableUsers.getQuery().setSqlText("select usr_id, usr_created, usr_updated, usr_name, usr_description, usr_admin, usr_active from users where case when usr_orbada is null then 'N' else usr_orbada end <> 'Y' order by usr_name");
            this.tableUsers.getQuery().open();
            if (!this.tableUsers.getQuery().isEmpty()) {
                this.tableUsers.setRowSelectionInterval(0, 0);
            }
        }
        catch (Exception exception) {
            ExceptionUtil.processException((Throwable)exception);
        }
        SwingUtil.setButtonSizesTheSame((AbstractButton[])new AbstractButton[]{this.buttonNew, this.buttonEdit, this.buttonDelete, this.buttonClose, this.buttonFunctions});
        SwingUtil.centerWithinScreen((Window)this);
    }

    @Override
    public void dispose() {
        this.settings.setValue("width", new Variant(this.getWidth()));
        this.settings.setValue("height", new Variant(this.getHeight()));
        this.settings.store();
        this.tableUsers.getQuery().close();
        super.dispose();
    }

    public void refreshQuery(final String usr_id) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                int lastRow = UserListDialog.this.tableUsers.getSelectedRow();
                try {
                    String id = usr_id;
                    if (UserListDialog.this.tableUsers.getQuery().isActive() && UserListDialog.this.tableUsers.getSelectedRow() >= 0 && id == null) {
                        UserListDialog.this.tableUsers.getQuery().getRecord(lastRow);
                        id = UserListDialog.this.tableUsers.getQuery().fieldByName("usr_id").getString();
                    }
                    UserListDialog.this.tableUsers.getQuery().refresh();
                    if (id != null && UserListDialog.this.tableUsers.getQuery().locate("usr_id", new Variant(id))) {
                        UserListDialog.this.tableUsers.changeSelection(UserListDialog.this.tableUsers.getQuery().getCurrentRecord().getIndex(), 0);
                    } else if (UserListDialog.this.tableUsers.getRowCount() > lastRow && lastRow >= 0) {
                        UserListDialog.this.tableUsers.changeSelection(lastRow, 0);
                    } else if (UserListDialog.this.tableUsers.getRowCount() > 0) {
                        UserListDialog.this.tableUsers.changeSelection(0, 0);
                    }
                }
                catch (Exception ex) {
                    ExceptionUtil.processException((Throwable)ex);
                }
            }
        });
    }

    private void initComponents() {
        this.cmClose = new Action();
        this.cmNew = new Action();
        this.cmEdit = new Action();
        this.cmDelete = new Action();
        this.cmFunctions = new Action();
        this.popupFunctions = new JPopupMenu();
        this.menuExport = new JMenuItem();
        this.menuImport = new JMenuItem();
        this.cmExport = new Action();
        this.cmImport = new Action();
        this.buttonClose = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.tableUsers = new ViewTable();
        this.buttonNew = new JButton();
        this.buttonEdit = new JButton();
        this.buttonDelete = new JButton();
        this.buttonFunctions = new JButton();
        this.cmClose.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmClose.setText(stringManager.getString("cmClose-text"));
        this.cmClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserListDialog.this.cmCloseActionPerformed(evt);
            }
        });
        this.cmNew.setEnabled(false);
        this.cmNew.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/new16.gif"));
        this.cmNew.setText(stringManager.getString("cmNew-text"));
        this.cmNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserListDialog.this.cmNewActionPerformed(evt);
            }
        });
        this.cmEdit.setEnabled(false);
        this.cmEdit.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/edit16.gif"));
        this.cmEdit.setText(stringManager.getString("cmEdit-text"));
        this.cmEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserListDialog.this.cmEditActionPerformed(evt);
            }
        });
        this.cmDelete.setEnabled(false);
        this.cmDelete.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmDelete.setText(stringManager.getString("cmDelete-text"));
        this.cmDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserListDialog.this.cmDeleteActionPerformed(evt);
            }
        });
        this.cmFunctions.setActionCommandKey("cmFunctions");
        this.cmFunctions.setText(stringManager.getString("UserListDialog-cmFunctions-text"));
        this.cmFunctions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserListDialog.this.cmFunctionsActionPerformed(evt);
            }
        });
        this.menuExport.setAction((javax.swing.Action)this.cmExport);
        this.popupFunctions.add(this.menuExport);
        this.menuImport.setAction((javax.swing.Action)this.cmImport);
        this.popupFunctions.add(this.menuImport);
        this.cmExport.setActionCommandKey("cmExport");
        this.cmExport.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/export.gif"));
        this.cmExport.setText(stringManager.getString("UserListDialog-cmExport-text"));
        this.cmExport.setTooltip(stringManager.getString("UserListDialog-cmExport-hint"));
        this.cmExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserListDialog.this.cmExportActionPerformed(evt);
            }
        });
        this.cmImport.setActionCommandKey("cmImport");
        this.cmImport.setEnabled(false);
        this.cmImport.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/import.gif"));
        this.cmImport.setText(stringManager.getString("UserListDialog-cmImport-text"));
        this.cmImport.setTooltip(stringManager.getString("UserListDialog-cmImport-hint"));
        this.cmImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserListDialog.this.cmImportActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(stringManager.getString("UserListDialog-title"));
        this.setModal(true);
        this.buttonClose.setAction((javax.swing.Action)this.cmClose);
        this.buttonClose.setMargin(new Insets(2, 2, 2, 2));
        this.buttonClose.setPreferredSize(new Dimension(85, 25));
        this.jScrollPane1.setViewportView((Component)((Object)this.tableUsers));
        this.buttonNew.setAction((javax.swing.Action)this.cmNew);
        this.buttonNew.setMargin(new Insets(2, 2, 2, 2));
        this.buttonNew.setPreferredSize(new Dimension(85, 25));
        this.buttonEdit.setAction((javax.swing.Action)this.cmEdit);
        this.buttonEdit.setMargin(new Insets(2, 2, 2, 2));
        this.buttonEdit.setPreferredSize(new Dimension(85, 25));
        this.buttonDelete.setAction((javax.swing.Action)this.cmDelete);
        this.buttonDelete.setMargin(new Insets(2, 2, 2, 2));
        this.buttonDelete.setPreferredSize(new Dimension(85, 25));
        this.buttonFunctions.setAction((javax.swing.Action)this.cmFunctions);
        this.buttonFunctions.setMargin(new Insets(2, 2, 2, 2));
        this.buttonFunctions.setPreferredSize(new Dimension(85, 25));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 559, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.buttonNew, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonEdit, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonDelete, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonFunctions, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 116, Short.MAX_VALUE).addComponent(this.buttonClose, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 264, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonClose, -2, -1, -2).addComponent(this.buttonNew, -2, -1, -2).addComponent(this.buttonEdit, -2, -1, -2).addComponent(this.buttonDelete, -2, -1, -2)).addComponent(this.buttonFunctions, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void cmDeleteActionPerformed(ActionEvent evt) {
        if (this.tableUsers.getQuery().isActive() && this.tableUsers.getSelectedRow() >= 0) {
            try {
                this.tableUsers.getQuery().getRecord(this.tableUsers.getSelectedRow());
                if (MessageBox.show((Component)this, (String)stringManager.getString("deleting"), (String)String.format(stringManager.getString("UserListDialog-delete-user-q"), this.tableUsers.getQuery().fieldByName("usr_id").getString(), this.tableUsers.getQuery().fieldByName("usr_name").getString()), (int[])ModalResult.YESNO, (int)3) == 5) {
                    User user = new User(Application.get().getOrbadaDatabase());
                    user.getPrimaryKeyField().setValue(new Variant(this.tableUsers.getQuery().fieldByName("usr_id").getString()));
                    user.applyDelete();
                    this.refreshQuery(null);
                }
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
                MessageBox.show((Component)this, (String)stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmEditActionPerformed(ActionEvent evt) {
        try {
            if (this.tableUsers.getQuery().isActive() && this.tableUsers.getSelectedRow() >= 0) {
                this.tableUsers.getQuery().getRecord(this.tableUsers.getSelectedRow());
                String usr_id = UserEditDialog.showDialog(this.tableUsers.getQuery().fieldByName("usr_id").getString());
                if (usr_id != null) {
                    this.refreshQuery(usr_id);
                }
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmNewActionPerformed(ActionEvent evt) {
        try {
            String usr_id;
            if (this.tableUsers.getQuery().isActive() && (usr_id = UserEditDialog.showDialog((String)null)) != null) {
                this.refreshQuery(usr_id);
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void cmFunctionsActionPerformed(ActionEvent evt) {
        this.popupFunctions.show(this.buttonFunctions, 0, this.buttonFunctions.getHeight());
    }

    private void cmExportActionPerformed(ActionEvent evt) {
        try {
            if (this.tableUsers.getQuery().isActive() && this.tableUsers.getSelectedRow() >= 0) {
                this.tableUsers.getQuery().getRecord(this.tableUsers.getSelectedRow());
                File file = FileUtil.selectFileToSave((Component)this, (String)stringManager.getString("UserListDialog-save-user"), (FileExtensionFilter[])new FileExtensionFilter[]{new FileExtensionFilter(stringManager.getString("UserListDialog-user-file"), new String[]{".xml.ouser"})});
                if (file != null) {
                    User user = new User(InternalDatabase.get(), this.tableUsers.getQuery().fieldByName("usr_id").getString());
                    user.storeToXML((OutputStream)new FileOutputStream(file), null, "utf-8");
                }
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmImportActionPerformed(ActionEvent evt) {
        try {
            File file;
            if (this.tableUsers.getQuery().isActive() && (file = FileUtil.selectFileToOpen((Component)this, (String)stringManager.getString("UserListDialog-open-user"), (File)null, (FileExtensionFilter[])new FileExtensionFilter[]{new FileExtensionFilter(stringManager.getString("UserListDialog-user-file"), new String[]{".xml.ouser"})})) != null) {
                User user = new User(InternalDatabase.get());
                user.loadFromXML((InputStream)new FileInputStream(file));
                String usr_id = UserEditDialog.showDialog(user);
                if (usr_id != null) {
                    this.refreshQuery(usr_id);
                }
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }
}

