/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui.cm;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import pl.mpak.orbada.Consts;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.gui.IRootTabObjectInfo;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.plugins.ComponentAction;
import pl.mpak.orbada.plugins.providers.ComponentActionProvider;
import pl.mpak.orbada.plugins.providers.ComponentActionsProvider;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.SearchPanel;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class ComponentActionsAction
extends Action {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);
    private Database database;
    private JComponent component;
    private JPopupMenu menuActions;
    private JToolBar toolBar;
    private JButton buttonActions;
    private String actionType;

    public ComponentActionsAction(Database database, JComponent component, JButton buttonActions, JPopupMenu menuActions, String actionType) {
        this.database = database;
        this.component = component;
        this.buttonActions = buttonActions;
        this.menuActions = menuActions;
        this.actionType = actionType;
        this.toolBar = (JToolBar)SwingUtil.getOwnerComponent(JToolBar.class, (Component)buttonActions);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ComponentActionsAction.this.init();
            }
        });
    }

    private void init() {
        this.addActionListener(this.createActionListener());
        this.setActionCommandKey("cmActions");
        this.setShortCut(KeyStroke.getKeyStroke(65, 8));
        this.setSmallIcon(ImageManager.getImage((String)"/pl/mpak/res/icons/down10.gif"));
        this.setText(stringManager.getString("ComponentActionsAction-text"));
        this.buttonActions.addMouseListener(new MouseListener(){
            private String lastTooltip;
            private boolean entered;

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (e.isControlDown()) {
                    this.lastTooltip = ComponentActionsAction.this.getTooltip();
                    ITabObjectInfo toi = (ITabObjectInfo)((Object)SwingUtil.getOwnerComponent(ITabObjectInfo.class, (Component)ComponentActionsAction.this.component));
                    IRootTabObjectInfo rtoi = (IRootTabObjectInfo)((Object)SwingUtil.getOwnerComponent(IRootTabObjectInfo.class, (Component)ComponentActionsAction.this.component));
                    ComponentActionsAction.this.setTooltip(String.format(stringManager.getString("ComponentActionsAction-programmers-hint"), ComponentActionsAction.this.component.getClass().getName(), ComponentActionsAction.this.actionType, toi != null ? stringManager.getString("ComponentActionsAction-implemented") : stringManager.getString("ComponentActionsAction-not-implemented"), rtoi != null ? stringManager.getString("ComponentActionsAction-implemented") : stringManager.getString("ComponentActionsAction-not-implemented")));
                    this.entered = true;
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (this.entered) {
                    ComponentActionsAction.this.setTooltip(this.lastTooltip);
                    this.entered = false;
                }
            }
        });
        this.buttonActions.setAction((javax.swing.Action)((Object)this));
        this.buttonActions.setHideActionText(false);
        this.buttonActions.setHorizontalTextPosition(2);
        this.buttonActions.setMaximumSize(new Dimension(60, 26));
        this.buttonActions.setPreferredSize(new Dimension(60, 26));
        this.buttonActions.setVerticalTextPosition(3);
        SwingUtil.addAction((JComponent)this.component, (javax.swing.Action)((Object)this));
        EventQueue.invokeLater(new Runnable(){
            Database database;
            JComponent component;
            JPopupMenu menuActions;
            JToolBar toolBar;
            JButton buttonActions;
            String actionType;
            {
                this.database = ComponentActionsAction.this.database;
                this.component = ComponentActionsAction.this.component;
                this.menuActions = ComponentActionsAction.this.menuActions;
                this.toolBar = ComponentActionsAction.this.toolBar;
                this.buttonActions = ComponentActionsAction.this.buttonActions;
                this.actionType = ComponentActionsAction.this.actionType;
            }

            @Override
            public void run() {
                int i;
                ComponentActionsProvider[] caspa;
                boolean first = true;
                ComponentActionProvider[] capa = (ComponentActionProvider[])Application.get().getServiceArray(ComponentActionProvider.class);
                if (capa != null && capa.length > 0) {
                    for (ComponentActionProvider cap : capa) {
                        if (!cap.isForComponent(this.database, this.actionType)) continue;
                        if ("-".equals(cap.getText())) {
                            this.menuActions.addSeparator();
                            if (!cap.isToolButton() || this.toolBar == null) continue;
                            SwingUtil.addBefore((JComponent)this.toolBar, (Component)this.component, (Component)new JToolBar.Separator());
                            continue;
                        }
                        cap.setComponent((Component)this.component);
                        cap.setDatabase(this.database);
                        if (cap.getShortCut() != null) {
                            SwingUtil.addAction((JComponent)this.component, (javax.swing.Action)cap);
                        }
                        if (first && this.menuActions.getComponentCount() > 0) {
                            this.menuActions.addSeparator();
                        }
                        first = false;
                        this.menuActions.add((javax.swing.Action)cap);
                        if (!cap.isToolButton() || this.toolBar == null) continue;
                        SwingUtil.addBefore((JComponent)this.toolBar, (Component)this.buttonActions, (Component)new ToolButton((javax.swing.Action)cap));
                    }
                }
                if ((caspa = (ComponentActionsProvider[])Application.get().getServiceArray(ComponentActionsProvider.class)) != null && caspa.length > 0) {
                    for (ComponentActionsProvider cap : caspa) {
                        ComponentAction[] actions = cap.getForComponent(this.database, this.actionType);
                        if (actions == null || actions.length <= 0) continue;
                        for (ComponentAction action : actions) {
                            if ("-".equals(action.getText())) {
                                this.menuActions.addSeparator();
                                if (!action.isToolButton() || this.toolBar == null) continue;
                                SwingUtil.addBefore((JComponent)this.toolBar, (Component)this.component, (Component)new JToolBar.Separator());
                                continue;
                            }
                            action.setComponent((Component)this.component);
                            action.setDatabase(this.database);
                            if (action.getShortCut() != null) {
                                SwingUtil.addAction((JComponent)this.component, (javax.swing.Action)action);
                            }
                            if (first && this.menuActions.getComponentCount() > 0) {
                                this.menuActions.addSeparator();
                            }
                            first = false;
                            this.menuActions.add((javax.swing.Action)action);
                            if (!action.isToolButton() || this.toolBar == null) continue;
                            SwingUtil.addBefore((JComponent)this.toolBar, (Component)this.buttonActions, (Component)new ToolButton((javax.swing.Action)action));
                        }
                    }
                }
                ArrayList<SearchPanel> spa = new ArrayList<SearchPanel>();
                for (i = 0; i < this.toolBar.getComponentCount(); ++i) {
                    Component comp = this.toolBar.getComponent(i);
                    if (!(comp instanceof SearchPanel)) continue;
                    spa.add((SearchPanel)comp);
                }
                first = true;
                for (i = 0; i < this.toolBar.getComponentCount(); ++i) {
                    Component comp = this.toolBar.getComponent(i);
                    javax.swing.Action action = null;
                    if (comp instanceof ToolButton) {
                        action = ((ToolButton)comp).getAction();
                    }
                    if (comp != this.buttonActions && comp instanceof ToolButton && action != null && !(action instanceof ComponentActionProvider) && !ComponentActionsAction.this.actionExists(action)) {
                        if (first && this.menuActions.getComponentCount() > 0) {
                            this.menuActions.addSeparator();
                        }
                        first = false;
                        final JMenuItem mi = this.menuActions.add(action);
                        mi.setVisible(comp.isVisible());
                        comp.addPropertyChangeListener("visible", new PropertyChangeListener(){

                            @Override
                            public void propertyChange(PropertyChangeEvent evt) {
                                mi.setVisible((Boolean)evt.getNewValue());
                            }
                        });
                        if (action.getValue("AcceleratorKey") != null) {
                            SwingUtil.addAction((JComponent)this.component, (javax.swing.Action)action);
                        }
                    } else if (comp instanceof JSeparator && this.menuActions.getComponentCount() > 0 && !(this.menuActions.getComponent(this.menuActions.getComponentCount() - 1) instanceof JSeparator)) {
                        this.menuActions.addSeparator();
                    }
                    if (spa.size() <= 0 || action == null || action.getValue("AcceleratorKey") == null) continue;
                    for (SearchPanel sp : spa) {
                        SwingUtil.addAction((JComponent)sp.getTextSearch(), (javax.swing.Action)action);
                    }
                }
                if (this.menuActions.getComponentCount() > 0 && this.menuActions.getComponent(this.menuActions.getComponentCount() - 1) instanceof JSeparator) {
                    this.menuActions.remove(this.menuActions.getComponentCount() - 1);
                }
                ComponentActionsAction.this.setEnabled(this.menuActions.getComponentCount() > 0);
            }
        });
    }

    private boolean actionExists(javax.swing.Action action) {
        if (action != null) {
            for (int i = 0; i < this.menuActions.getComponentCount(); ++i) {
                Component item = this.menuActions.getComponent(i);
                if (!(item instanceof JMenuItem) || ((JMenuItem)item).getAction() == null || ((JMenuItem)item).getAction() != action) continue;
                return true;
            }
        }
        return false;
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComponentActionsAction.this.menuActions.show(ComponentActionsAction.this.buttonActions, 0, ComponentActionsAction.this.buttonActions.getHeight());
            }
        };
    }
}

