/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui.cm;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import pl.mpak.orbada.Consts;
import pl.mpak.orbada.gui.PerspectivePanel;
import pl.mpak.orbada.plugins.providers.ViewProvider;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class CreateViewAction
extends Action {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);
    private PerspectivePanel panel;
    private ViewProvider view;

    public CreateViewAction(ViewProvider view, PerspectivePanel panel) {
        this.view = view;
        this.panel = panel;
        try {
            this.setSmallIcon(view.getIcon());
        }
        catch (Throwable ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        this.setText(view.getPublicName());
        this.setTooltip(view.getDescription());
        this.setActionCommandKey("cmCreateView");
        this.addActionListener(this.createActionListener());
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component component = CreateViewAction.this.panel.getViewComponent(CreateViewAction.this.view);
                if (component != null) {
                    switch (MessageBox.show((Component)CreateViewAction.this.panel, (String)stringManager.getString("view"), (String)stringManager.getString("CreateViewAction-select-open-view"), (int[])ModalResult.YESNOCANCEL, (int)3)) {
                        case 5: {
                            CreateViewAction.this.panel.createView(CreateViewAction.this.view, false, false);
                            break;
                        }
                        case 6: {
                            CreateViewAction.this.panel.setSelectedView(component);
                        }
                    }
                } else {
                    CreateViewAction.this.panel.createView(CreateViewAction.this.view, false, false);
                }
            }
        };
    }
}

