/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui.comps;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.EventObject;
import java.util.HashMap;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.event.EventListenerList;
import pl.mpak.orbada.Consts;
import pl.mpak.orbada.OrbadaException;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.gui.comps.SyntaxDatabaseObjectListener;
import pl.mpak.orbada.gui.editor.EditorPopupMenu;
import pl.mpak.orbada.plugins.providers.OrbadaSyntaxTextAreaProvider;
import pl.mpak.orbada.plugins.providers.SyntaxEditorActionProvider;
import pl.mpak.orbada.plugins.providers.SyntaxEditorAutoCompleteProvider;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.AutoCompleteListener;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.syntax.SyntaxTextArea;
import pl.mpak.usedb.core.Command;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.script.SimpleSQLScript;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.CloseAbilitable;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class AbsOrbadaSyntaxTextArea
extends SyntaxTextArea
implements CloseAbilitable {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);
    private static HashMap<String, CaretPosition> positionList = new HashMap();
    protected Database database;
    protected String schemaName;
    protected String objectType;
    protected String objectName;
    protected final EventListenerList objectListenerList = new EventListenerList();

    public AbsOrbadaSyntaxTextArea() {
        this.init();
    }

    private void init() {
        this.getEditorArea().setComponentPopupMenu((JPopupMenu)((Object)new EditorPopupMenu(this)));
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (Application.get() != null) {
                    SyntaxEditorAutoCompleteProvider[] seacps;
                    OrbadaSyntaxTextAreaProvider[] ostaps;
                    SyntaxEditorActionProvider[] list = (SyntaxEditorActionProvider[])Application.get().getServiceArray(SyntaxEditorActionProvider.class);
                    if (list.length > 0) {
                        AbsOrbadaSyntaxTextArea.this.getEditorArea().getComponentPopupMenu().addSeparator();
                        for (int i = 0; i < list.length; ++i) {
                            list[i].setSyntaxEditr(AbsOrbadaSyntaxTextArea.this.getEditorArea());
                            AbsOrbadaSyntaxTextArea.this.getEditorArea().getComponentPopupMenu().add((Action)list[i]);
                        }
                    }
                    if ((ostaps = (OrbadaSyntaxTextAreaProvider[])Application.get().getServiceArray(OrbadaSyntaxTextAreaProvider.class)).length > 0) {
                        for (OrbadaSyntaxTextAreaProvider ostap : ostaps) {
                            ostap.setSyntaxTextArea((SyntaxTextArea)AbsOrbadaSyntaxTextArea.this);
                        }
                    }
                    if ((seacps = (SyntaxEditorAutoCompleteProvider[])Application.get().getServiceArray(SyntaxEditorAutoCompleteProvider.class)).length > 0) {
                        for (SyntaxEditorAutoCompleteProvider seacp : seacps) {
                            if (!seacp.isForEditor((SyntaxTextArea)AbsOrbadaSyntaxTextArea.this)) continue;
                            AbsOrbadaSyntaxTextArea.this.getAutoComplete().addAutoCompleteListener((AutoCompleteListener)seacp);
                        }
                    }
                }
            }
        });
        this.getEditorArea().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                AbsOrbadaSyntaxTextArea.this.updateCaretPositionList();
            }
        });
    }

    public Database getDatabase() {
        return this.database;
    }

    public void setDatabase(Database database) {
        if (this.database != database) {
            this.database = database;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDatabaseObjectListener(SyntaxDatabaseObjectListener listener) {
        EventListenerList eventListenerList = this.objectListenerList;
        synchronized (eventListenerList) {
            this.objectListenerList.add(SyntaxDatabaseObjectListener.class, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDatabaseObjectListener(SyntaxDatabaseObjectListener listener) {
        EventListenerList eventListenerList = this.objectListenerList;
        synchronized (eventListenerList) {
            this.objectListenerList.remove(SyntaxDatabaseObjectListener.class, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireDatabaseObjectListener(DatabaseObjectEvent event) {
        EventListenerList eventListenerList = this.objectListenerList;
        synchronized (eventListenerList) {
            SyntaxDatabaseObjectListener[] listeners = (SyntaxDatabaseObjectListener[])this.objectListenerList.getListeners(SyntaxDatabaseObjectListener.class);
            EventObject e = new EventObject((Object)this);
            block10: for (int i = 0; i < listeners.length; ++i) {
                switch (event) {
                    case BEFORE_CHANGE: {
                        listeners[i].beforeChanged(e);
                        continue block10;
                    }
                    case AFTER_CHANGE: {
                        listeners[i].afterChanged(e);
                        continue block10;
                    }
                    case BEFORE_STORE_OBJECT: {
                        listeners[i].beforeStoreObject(e);
                        continue block10;
                    }
                    case AFTER_STORE_OBJECT: {
                        listeners[i].afterStoreObject(e);
                        continue block10;
                    }
                    case STORE_OBJECT_ERROR: {
                        listeners[i].storeObjectError(e);
                    }
                }
            }
        }
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setDatabaseObject(String schemaName, String objectType, String objectName, String text) {
        this.fireDatabaseObjectListener(DatabaseObjectEvent.BEFORE_CHANGE);
        this.updateCaretPositionList();
        if (this.getStatusBar().getPanel("ddl-status") == null) {
            this.getStatusBar().addPanel("ddl-status");
        }
        if (StringUtil.isEmpty((String)objectName)) {
            this.getStatusBar().getPanel("ddl-status").setText("");
        } else {
            this.getStatusBar().getPanel("ddl-status").setText(objectType + " " + (StringUtil.isEmpty((String)schemaName) ? "" : schemaName + ".") + objectName);
        }
        this.schemaName = schemaName;
        this.objectType = objectType;
        this.objectName = objectName;
        this.setText(text);
        this.setChanged(false);
        this.getEditorArea().getUndoManager().discardAllEdits();
        this.updateCaretPosition();
        this.fireDatabaseObjectListener(DatabaseObjectEvent.AFTER_CHANGE);
    }

    public Command storeObject() throws Exception {
        this.fireDatabaseObjectListener(DatabaseObjectEvent.BEFORE_STORE_OBJECT);
        Command command = this.getDatabase().createCommand();
        try {
            command.setParamCheck(false);
            command.execute(this.getText());
            this.setChanged(false);
            this.fireDatabaseObjectListener(DatabaseObjectEvent.AFTER_STORE_OBJECT);
        }
        catch (Exception ex) {
            this.fireDatabaseObjectListener(DatabaseObjectEvent.STORE_OBJECT_ERROR);
            throw ex;
        }
        return command;
    }

    public Command storeObject(String text) throws Exception {
        Command command = this.getDatabase().createCommand();
        command.setParamCheck(false);
        command.execute(text);
        return command;
    }

    public void storeScript() throws Exception {
        String text = this.getText();
        if (!StringUtil.isEmpty((String)text)) {
            this.fireDatabaseObjectListener(DatabaseObjectEvent.BEFORE_STORE_OBJECT);
            SimpleSQLScript script = new SimpleSQLScript(this.getDatabase());
            if (script.executeScript(text)) {
                this.setChanged(false);
                this.fireDatabaseObjectListener(DatabaseObjectEvent.AFTER_STORE_OBJECT);
            } else {
                this.fireDatabaseObjectListener(DatabaseObjectEvent.STORE_OBJECT_ERROR);
                throw new OrbadaException(script.getErrors());
            }
        }
    }

    public void storeScript(String text) throws Exception {
        SimpleSQLScript script;
        if (!StringUtil.isEmpty((String)text) && !(script = new SimpleSQLScript(this.getDatabase())).executeScript(text)) {
            throw new OrbadaException(script.getErrors());
        }
    }

    public void updateCaretPositionList() {
        if (!StringUtil.isEmpty((String)this.objectType) && !StringUtil.isEmpty((String)this.objectName)) {
            positionList.put(this.objectType + ":" + this.schemaName + "." + this.objectName, new CaretPosition(this.getCaretPosition(), this.getScrollPane().getVerticalScrollBar().getValue()));
        }
    }

    private void updateCaretPosition() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CaretPosition p;
                if (!StringUtil.isEmpty((String)AbsOrbadaSyntaxTextArea.this.objectType) && !StringUtil.isEmpty((String)AbsOrbadaSyntaxTextArea.this.objectName) && (p = (CaretPosition)positionList.get(AbsOrbadaSyntaxTextArea.this.objectType + ":" + AbsOrbadaSyntaxTextArea.this.schemaName + "." + AbsOrbadaSyntaxTextArea.this.objectName)) != null) {
                    try {
                        AbsOrbadaSyntaxTextArea.this.getEditorArea().setCaretPosition(p.offset);
                        AbsOrbadaSyntaxTextArea.this.getScrollPane().getVerticalScrollBar().setValue(p.top);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public boolean canClose() {
        return this.getDatabase() == null || StringUtil.isEmpty((String)this.objectName) || !this.isChanged() || MessageBox.show((Component)SwingUtil.getRootFrame(), (String)stringManager.getString("change"), (String)String.format(stringManager.getString("OrbadaSyntaxTextArea-close-q"), this.getObjectType() + " " + SQLUtil.createSqlName((String)this.getObjectName())), (int[])ModalResult.YESNO, (int)2) != 5;
    }

    class CaretPosition {
        int offset;
        int top;

        public CaretPosition(int offset, int top) {
            this.offset = offset;
            this.top = top;
        }
    }

    public static enum DatabaseObjectEvent {
        BEFORE_CHANGE,
        AFTER_CHANGE,
        BEFORE_STORE_OBJECT,
        AFTER_STORE_OBJECT,
        STORE_OBJECT_ERROR;

    }
}

