/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui.comps;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.Consts;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.gui.comps.OrbadaSyntaxTextArea;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.variant.Variant;

public class EditSqlCodeDialog
extends JDialog {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);
    private int modalResult = 0;
    private String sqlCode;
    private Database database;
    private Exception exception;
    private ISettings settings;
    private JButton buttonCancel;
    private JButton buttonOk;
    private Action cmCancel;
    private Action cmOk;
    private JScrollPane jScrollPane1;
    private JTextArea textError;
    private OrbadaSyntaxTextArea textSqlCode;

    public EditSqlCodeDialog(String sqlCode, Database database, Exception exception) {
        this.sqlCode = sqlCode;
        this.database = database;
        this.exception = exception;
        this.initComponents();
        this.init();
    }

    public static String show(String sqlCode, Database database, Exception exception) {
        EditSqlCodeDialog dialog = new EditSqlCodeDialog(sqlCode, database, exception);
        dialog.setVisible(true);
        if (dialog.modalResult == 1) {
            return dialog.textSqlCode.getText();
        }
        return null;
    }

    public static String show(String sqlCode, Database database) {
        return EditSqlCodeDialog.show(sqlCode, database, null);
    }

    private void init() {
        this.settings = Application.get().getSettings("orbada-edit-sql-code");
        try {
            this.setBounds(0, 0, this.settings.getValue("dialog-width", new Variant(this.getWidth())).getInteger(), this.settings.getValue("dialog-height", new Variant(this.getHeight())).getInteger());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getRootPane().getInputMap(2).put(this.cmCancel.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmCancel);
        this.getRootPane().setDefaultButton(this.buttonOk);
        if (this.database != null) {
            this.textSqlCode.setDatabase(this.database);
        }
        this.textSqlCode.setText(this.sqlCode);
        if (this.exception != null) {
            this.textError.setText(this.exception.getMessage());
            this.textError.setCaretPosition(0);
        } else {
            this.textError.setVisible(false);
        }
        SwingUtil.centerWithinScreen((Window)this);
    }

    @Override
    public void dispose() {
        this.settings.setValue("dialog-width", new Variant(this.getWidth()));
        this.settings.setValue("dialog-height", new Variant(this.getHeight()));
        this.settings.store();
        super.dispose();
    }

    private void initComponents() {
        this.cmCancel = new Action();
        this.cmOk = new Action();
        this.textSqlCode = new OrbadaSyntaxTextArea();
        this.buttonOk = new JButton();
        this.buttonCancel = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.textError = new JTextArea();
        this.cmCancel.setActionCommandKey("cmCancel");
        this.cmCancel.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmCancel.setText(stringManager.getString("cmCancel-text"));
        this.cmCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditSqlCodeDialog.this.cmCancelActionPerformed(evt);
            }
        });
        this.cmOk.setActionCommandKey("cmOk");
        this.cmOk.setText(stringManager.getString("cmOk-text"));
        this.cmOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditSqlCodeDialog.this.cmOkActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(stringManager.getString("EditSqlCodeDialog-title"));
        this.setModal(true);
        this.buttonOk.setAction((javax.swing.Action)this.cmOk);
        this.buttonOk.setPreferredSize(new Dimension(75, 23));
        this.buttonCancel.setAction((javax.swing.Action)this.cmCancel);
        this.buttonCancel.setPreferredSize(new Dimension(75, 23));
        this.textError.setColumns(20);
        this.textError.setEditable(false);
        this.textError.setFont(new Font("Courier New", 0, 12));
        this.textError.setRows(5);
        this.jScrollPane1.setViewportView(this.textError);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)((Object)this.textSqlCode), GroupLayout.Alignment.TRAILING, -1, 496, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 496, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.buttonOk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent((Component)((Object)this.textSqlCode), -1, 252, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 54, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel, -2, -1, -2).addComponent(this.buttonOk, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        this.modalResult = 2;
        this.dispose();
    }

    private void cmOkActionPerformed(ActionEvent evt) {
        this.modalResult = 1;
        this.dispose();
    }
}

