/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui.comps;

import java.awt.EventQueue;
import java.sql.ResultSet;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.db.OrbadaDatabase;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.providers.DatabaseInfoProvider;
import pl.mpak.sky.gui.swing.syntax.SQLSyntaxDocument;
import pl.mpak.sky.gui.swing.syntax.SyntaxDocument;
import pl.mpak.sky.gui.swing.syntax.SyntaxStyle;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.util.QueryUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.task.Task;
import pl.mpak.util.task.TaskPool;

public class OrbadaSQLSyntaxDocument
extends SQLSyntaxDocument {
    private Database database;
    private volatile boolean inited;

    public OrbadaSQLSyntaxDocument() {
        this(null);
    }

    public OrbadaSQLSyntaxDocument(Database database) {
        this.setDatabase(database);
    }

    public Database getDatabase() {
        return this.database;
    }

    private void revalidateEditor() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (OrbadaSQLSyntaxDocument.this.getTextComponent() != null) {
                    OrbadaSQLSyntaxDocument.this.getTextComponent().revalidate();
                    OrbadaSQLSyntaxDocument.this.getTextComponent().repaint();
                }
            }
        });
    }

    private void addKeywords(String[] list, int type) {
        if (list != null && list.length > 0) {
            if (list.length == 1) {
                this.addKeyWord(list[0], type);
            } else {
                for (String s : list) {
                    this.addKeyWord(s, type);
                }
            }
            if (this.getTextComponent() != null) {
                this.revalidateEditor();
            }
        }
    }

    public void refreshKeyWords() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                OrbadaSQLSyntaxDocument.this.refreshKeyWords(false);
            }
        });
    }

    public void refreshKeyWords(boolean resetInfo) {
        this.inited = true;
        boolean found = false;
        this.clearKeyWords();
        if (this.database != null && Application.get() != null) {
            DatabaseInfoProvider[] dip = (DatabaseInfoProvider[])Application.get().getServiceArray(DatabaseInfoProvider.class);
            if (dip != null && dip.length > 0) {
                for (int i = 0; i < dip.length; ++i) {
                    if (!dip[i].isForDatabase(this.database)) continue;
                    if (resetInfo) {
                        dip[i].resetDatabaseInfo(this.database);
                    }
                    found = true;
                    final DatabaseInfoProvider dis = dip[i];
                    TaskPool.getTaskPool((String)"sql-syntax-colector").addTask(new Task("Orbada SQL Syntax Document Info Refresh"){
                        Database runDatabase;
                        {
                            super(x0);
                            this.runDatabase = OrbadaSQLSyntaxDocument.this.database;
                            if (this.runDatabase.isConnected()) {
                                OrbadaSQLSyntaxDocument.this.addKeywords(dis.getDataTypes(this.runDatabase), 10);
                            }
                            if (this.runDatabase.isConnected()) {
                                OrbadaSQLSyntaxDocument.this.addKeywords(dis.getKeywords(this.runDatabase), 1);
                            }
                            if (this.runDatabase.isConnected()) {
                                OrbadaSQLSyntaxDocument.this.addKeywords(dis.getOperators(this.runDatabase), 3);
                            }
                            if (this.runDatabase.isConnected()) {
                                OrbadaSQLSyntaxDocument.this.addKeywords(dis.getSqlFunctions(this.runDatabase), 8);
                            }
                            OrbadaSQLSyntaxDocument.this.revalidateEditor();
                        }

                        public void run() {
                            if (this.runDatabase.isConnected()) {
                                OrbadaSQLSyntaxDocument.this.addKeywords(dis.getExceptions(this.runDatabase), 7);
                            }
                            if (this.runDatabase.isConnected()) {
                                OrbadaSQLSyntaxDocument.this.addKeywords(dis.getSchemas(this.runDatabase), 14);
                            }
                            if (this.runDatabase.isConnected()) {
                                OrbadaSQLSyntaxDocument.this.addKeywords(dis.getPublicTables(this.runDatabase), 14);
                            }
                            if (this.runDatabase.isConnected()) {
                                OrbadaSQLSyntaxDocument.this.addKeywords(dis.getUserTables(this.runDatabase), 4);
                            }
                            if (this.runDatabase.isConnected()) {
                                OrbadaSQLSyntaxDocument.this.addKeywords(dis.getUserFunctions(this.runDatabase), 9);
                            }
                        }
                    });
                }
            }
            if (!found) {
                this.defaultAll();
                ISettings localSettings = Application.get().getSettings(((OrbadaDatabase)this.database).getUserProperties().getProperty("schemaId"), "orbada-settings");
                if (localSettings.getValue("use-global-settings-disable-load-sql-syntax-info", Boolean.valueOf(true)).booleanValue() && !Application.get().getSettings().getValue("disable-load-sql-syntax-info", Boolean.valueOf(false)).booleanValue() || !localSettings.getValue("use-global-settings-disable-load-sql-syntax-info", Boolean.valueOf(true)).booleanValue() && !localSettings.getValue("disable-load-sql-syntax-info", Boolean.valueOf(false)).booleanValue()) {
                    TaskPool.getTaskPool((String)"sql-syntax-colector").addTask(new Task("Loading Objects For SQL Syntax Document"){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            this.setPercenExecution(0);
                            Query query = OrbadaSQLSyntaxDocument.this.database.createQuery();
                            try {
                                query.setResultSet(OrbadaSQLSyntaxDocument.this.database.getMetaData().getTables(null, OrbadaSQLSyntaxDocument.this.database.getUserName() == null ? null : OrbadaSQLSyntaxDocument.this.database.getUserName().toUpperCase(), null, new String[]{"TABLE", "VIEW"}));
                                String[] tableList = QueryUtil.queryToArray((String)"{TABLE_NAME}", (Query)query);
                                this.setPercenExecution(this.getPercenExecution() + 15);
                                OrbadaSQLSyntaxDocument.this.addKeywords(tableList, 4);
                                this.setPercenExecution(this.getPercenExecution() + 15);
                                query.close();
                                query.setResultSet(OrbadaSQLSyntaxDocument.this.database.getMetaData().getTables(null, null, null, new String[]{"SYSTEM TABLE", "SYNONYM"}));
                                tableList = QueryUtil.queryToArray((String)"{TABLE_NAME}", (Query)query);
                                this.setPercenExecution(this.getPercenExecution() + 15);
                                OrbadaSQLSyntaxDocument.this.addKeywords(tableList, 14);
                                this.setPercenExecution(this.getPercenExecution() + 15);
                                query.close();
                                ResultSet rs = OrbadaSQLSyntaxDocument.this.database.getMetaData().getProcedures(null, OrbadaSQLSyntaxDocument.this.database.getUserName() == null ? null : OrbadaSQLSyntaxDocument.this.database.getUserName().toUpperCase(), null);
                                if (rs != null) {
                                    query.setResultSet(rs);
                                    String[] procList = QueryUtil.queryToArray((String)"{PROCEDURE_NAME}", (Query)query);
                                    OrbadaSQLSyntaxDocument.this.addKeywords(procList, 9);
                                }
                                this.setPercenExecution(this.getPercenExecution() + 15);
                                this.setPercenExecution(this.getPercenExecution() + 15);
                                query.close();
                                if (OrbadaSQLSyntaxDocument.this.database.getMetaData().supportsSchemasInTableDefinitions()) {
                                    query.setResultSet(OrbadaSQLSyntaxDocument.this.database.getMetaData().getSchemas());
                                    String[] schemaList = QueryUtil.queryToArray((String)"{TABLE_SCHEM}", (Query)query);
                                    OrbadaSQLSyntaxDocument.this.addKeywords(schemaList, 14);
                                }
                                this.setPercenExecution(this.getPercenExecution() + 15);
                                OrbadaSQLSyntaxDocument.this.addKeywords(new String[]{"AND", "ALL", "ANY", "BETWEEN", "IN", "IS", "LIKE", "NOT", "OR", "EXISTS"}, 3);
                            }
                            catch (Exception ex) {
                                ExceptionUtil.processException((Throwable)ex);
                            }
                            finally {
                                query.close();
                                this.setPercenExecution(100);
                            }
                            OrbadaSQLSyntaxDocument.this.revalidateEditor();
                        }
                    });
                }
                this.revalidateEditor();
            }
        } else {
            this.defaultAll();
            this.revalidateEditor();
        }
    }

    public void setDatabase(Database database) {
        if (this.database != database) {
            this.database = database;
            this.refreshKeyWords();
        }
    }

    void externalInitKeywords() {
        if (!this.inited) {
            this.defaultAll();
            this.revalidateEditor();
        }
    }

    public static void loadSettings(SyntaxDocument doc) {
        ISettings settings = Application.get().getSettings("sql-syntax-settings");
        for (SyntaxStyle style : doc.getStyleMap().values()) {
            String ss = settings.getValue(style.getName(), "");
            if ("".equals(ss)) continue;
            try {
                style.fromString(ss);
            }
            catch (Exception ex) {}
        }
    }

    public static void storeSettings(SyntaxDocument doc) {
        ISettings settings = Application.get().getSettings("sql-syntax-settings");
        for (SyntaxStyle style : doc.getStyleMap().values()) {
            settings.setValue(style.getName(), style.toString());
        }
        settings.store();
    }
}

