/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui.comps;

import java.awt.EventQueue;
import javax.swing.Action;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.gui.comps.AbsOrbadaSyntaxTextArea;
import pl.mpak.orbada.gui.comps.OrbadaSQLSyntaxDocument;
import pl.mpak.orbada.gui.comps.cm.RefreshDatabaseInfoAction;
import pl.mpak.orbada.gui.comps.cm.SqlLowerCaseAction;
import pl.mpak.orbada.gui.comps.cm.SqlUpperCaseAction;
import pl.mpak.sky.gui.swing.syntax.SyntaxDocument;
import pl.mpak.usedb.core.Database;

public class OrbadaSyntaxTextArea
extends AbsOrbadaSyntaxTextArea {
    private OrbadaSQLSyntaxDocument syntaxDocument;

    public OrbadaSyntaxTextArea() {
        this.init();
    }

    private void init() {
        this.syntaxDocument = new OrbadaSQLSyntaxDocument();
        this.setDocument((SyntaxDocument)this.syntaxDocument);
        this.getEditorArea().getComponentPopupMenu().add((Action)((Object)new SqlLowerCaseAction()));
        this.getEditorArea().getComponentPopupMenu().add((Action)((Object)new SqlUpperCaseAction()));
        this.getEditorArea().getComponentPopupMenu().addSeparator();
        this.getEditorArea().getComponentPopupMenu().add((Action)((Object)new RefreshDatabaseInfoAction()));
        if (Application.get() != null) {
            OrbadaSQLSyntaxDocument.loadSettings((SyntaxDocument)this.syntaxDocument);
            this.getEditorArea().setBackground(Application.get().getSettings().getValue("syntax-editor-background-color", this.getEditorArea().getBackground()));
            this.getEditorArea().setFont(Application.get().getSettings().getValue("syntax-editor-font", this.getEditorArea().getFont()));
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                OrbadaSyntaxTextArea.this.syntaxDocument.externalInitKeywords();
            }
        });
    }

    @Override
    public void setDatabase(Database database) {
        if (this.database != database) {
            this.syntaxDocument.setDatabase(database);
        }
        super.setDatabase(database);
    }
}

