/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui.comps;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import pl.mpak.orbada.Consts;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.gui.comps.table.view.BeanPropertyPanel;
import pl.mpak.orbada.gui.comps.table.view.ViewAsBinaryPanel;
import pl.mpak.orbada.gui.comps.table.view.ViewAsHexPanel;
import pl.mpak.orbada.gui.comps.table.view.ViewAsPicturePanel;
import pl.mpak.orbada.gui.comps.table.view.ViewAsStringPanel;
import pl.mpak.orbada.gui.comps.table.view.ViewHtmlPanel;
import pl.mpak.orbada.gui.comps.table.view.cm.ViewValueServiceAction;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.providers.ViewValueProvider;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.core.QueryField;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.FileUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.variant.Variant;

public class ViewValueDialog
extends JDialog {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);
    private Object value;
    private Component currentPanel;
    private ISettings settings;
    private Action cmClose;
    private Action cmSaveAs;
    private Action cmViewAsBinary;
    private Action cmViewAsHex;
    private Action cmViewAsJavaObject;
    private Action cmViewAsPicture;
    private Action cmViewAsString;
    private Action cmViewHtml;
    private ButtonGroup groupView;
    private JMenuBar jMenuBar1;
    private JSeparator jSeparator1;
    private JMenuItem menuClose;
    private JMenu menuFile;
    private JMenuItem menuSaveAs;
    private JMenu menuView;
    private JRadioButtonMenuItem menuViewAsBinary;
    private JRadioButtonMenuItem menuViewAsHex;
    private JRadioButtonMenuItem menuViewAsJavaObject;
    private JRadioButtonMenuItem menuViewAsPicture;
    private JRadioButtonMenuItem menuViewAsString;
    private JRadioButtonMenuItem menuViewHtml;

    public ViewValueDialog(Object value) {
        this.value = value;
        this.initComponents();
        this.init();
    }

    public static void show(Object value) {
        ViewValueDialog dialog = new ViewValueDialog(value);
        dialog.setVisible(true);
    }

    private void init() {
        this.settings = Application.get().getSettings("orbada-view-value-dialog");
        try {
            this.setBounds(0, 0, this.settings.getValue("width", Long.valueOf(680L)).intValue(), this.settings.getValue("height", Long.valueOf(480L)).intValue());
        }
        catch (Exception ex) {
            this.setSize(680, 480);
        }
        if (this.value instanceof Variant) {
            Variant v = (Variant)this.value;
            if (v.getValueType() != 13) {
                this.cmViewAsString.performe();
            } else {
                this.cmViewAsBinary.performe();
            }
        } else if (this.value instanceof QueryField) {
            this.cmViewAsJavaObject.performe();
        } else {
            this.cmViewAsString.performe();
        }
        this.initServices();
        SwingUtil.centerWithinScreen((Window)this);
    }

    private void initServices() {
        ViewValueProvider[] vvp = (ViewValueProvider[])Application.get().getServiceArray(ViewValueProvider.class);
        if (vvp != null && vvp.length > 0) {
            for (int i = 0; i < vvp.length; ++i) {
                int vk = this.menuView.getItemCount() + 49;
                if (vk > 57) {
                    vk = i + 65;
                }
                JRadioButtonMenuItem item = new JRadioButtonMenuItem((javax.swing.Action)((Object)new ViewValueServiceAction(this, vvp[i], this.value, vk)));
                this.groupView.add(item);
                this.menuView.add(item);
            }
        }
    }

    public void setCurrentPanel(Component panel) {
        if (this.currentPanel instanceof Closeable) {
            try {
                ((Closeable)((Object)this.currentPanel)).close();
            }
            catch (IOException ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
        if (this.currentPanel != null) {
            this.getContentPane().remove(this.currentPanel);
        }
        this.currentPanel = panel;
        this.getContentPane().add(panel, "Center");
        this.getContentPane().validate();
    }

    @Override
    public void dispose() {
        this.settings.setValue("width", Long.valueOf(this.getWidth()));
        this.settings.setValue("height", Long.valueOf(this.getHeight()));
        this.settings.store();
        super.dispose();
    }

    private void initComponents() {
        this.cmSaveAs = new Action();
        this.cmClose = new Action();
        this.cmViewAsString = new Action();
        this.cmViewAsBinary = new Action();
        this.cmViewAsHex = new Action();
        this.cmViewAsPicture = new Action();
        this.groupView = new ButtonGroup();
        this.cmViewAsJavaObject = new Action();
        this.cmViewHtml = new Action();
        this.jMenuBar1 = new JMenuBar();
        this.menuFile = new JMenu();
        this.menuSaveAs = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.menuClose = new JMenuItem();
        this.menuView = new JMenu();
        this.menuViewAsString = new JRadioButtonMenuItem();
        this.menuViewAsBinary = new JRadioButtonMenuItem();
        this.menuViewAsHex = new JRadioButtonMenuItem();
        this.menuViewAsPicture = new JRadioButtonMenuItem();
        this.menuViewAsJavaObject = new JRadioButtonMenuItem();
        this.menuViewHtml = new JRadioButtonMenuItem();
        this.cmSaveAs.setActionCommandKey("cmSaveAs");
        this.cmSaveAs.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/save_as16.gif"));
        this.cmSaveAs.setText(stringManager.getString("cmSaveAs-text"));
        this.cmSaveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewValueDialog.this.cmSaveAsActionPerformed(evt);
            }
        });
        this.cmClose.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmClose.setText(stringManager.getString("cmClose-text"));
        this.cmClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewValueDialog.this.cmCloseActionPerformed(evt);
            }
        });
        this.cmViewAsString.setActionCommandKey("cmViewAsString");
        this.cmViewAsString.setShortCut(KeyStroke.getKeyStroke(49, 8));
        this.cmViewAsString.setText(stringManager.getString("ViewValueDialog-cmViewAsString-text"));
        this.cmViewAsString.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewValueDialog.this.cmViewAsStringActionPerformed(evt);
            }
        });
        this.cmViewAsBinary.setActionCommandKey("vmViewAsBinary");
        this.cmViewAsBinary.setShortCut(KeyStroke.getKeyStroke(50, 8));
        this.cmViewAsBinary.setText(stringManager.getString("ViewValueDialog-cmViewAsBinary-text"));
        this.cmViewAsBinary.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewValueDialog.this.cmViewAsBinaryActionPerformed(evt);
            }
        });
        this.cmViewAsHex.setActionCommandKey("cmViewAsHex");
        this.cmViewAsHex.setShortCut(KeyStroke.getKeyStroke(51, 8));
        this.cmViewAsHex.setText(stringManager.getString("ViewValueDialog-cmViewAsHex-text"));
        this.cmViewAsHex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewValueDialog.this.cmViewAsHexActionPerformed(evt);
            }
        });
        this.cmViewAsPicture.setActionCommandKey("cmViewAsPicture");
        this.cmViewAsPicture.setShortCut(KeyStroke.getKeyStroke(52, 8));
        this.cmViewAsPicture.setText(stringManager.getString("ViewValueDialog-cmViewAsPicture-text"));
        this.cmViewAsPicture.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewValueDialog.this.cmViewAsPictureActionPerformed(evt);
            }
        });
        this.cmViewAsJavaObject.setActionCommandKey("cmViewAsJavaObject");
        this.cmViewAsJavaObject.setShortCut(KeyStroke.getKeyStroke(53, 8));
        this.cmViewAsJavaObject.setText(stringManager.getString("ViewValueDialog-cmViewAsJavaObject-text"));
        this.cmViewAsJavaObject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewValueDialog.this.cmViewAsJavaObjectActionPerformed(evt);
            }
        });
        this.cmViewHtml.setActionCommandKey("cmViewHtml");
        this.cmViewHtml.setShortCut(KeyStroke.getKeyStroke(54, 8));
        this.cmViewHtml.setText(stringManager.getString("ViewValueDialog-cmViewHtml-text"));
        this.cmViewHtml.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewValueDialog.this.cmViewHtmlActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(stringManager.getString("ViewValueDialog-title"));
        this.setModal(true);
        this.menuFile.setMnemonic('P');
        this.menuFile.setText(stringManager.getString("ViewValueDialog-menuFile-text"));
        this.menuSaveAs.setAction((javax.swing.Action)this.cmSaveAs);
        this.menuFile.add(this.menuSaveAs);
        this.menuFile.add(this.jSeparator1);
        this.menuClose.setAction((javax.swing.Action)this.cmClose);
        this.menuFile.add(this.menuClose);
        this.jMenuBar1.add(this.menuFile);
        this.menuView.setMnemonic('W');
        this.menuView.setText(stringManager.getString("ViewValueDialog-menuView-text"));
        this.menuViewAsString.setAction((javax.swing.Action)this.cmViewAsString);
        this.groupView.add(this.menuViewAsString);
        this.menuView.add(this.menuViewAsString);
        this.menuViewAsBinary.setAction((javax.swing.Action)this.cmViewAsBinary);
        this.groupView.add(this.menuViewAsBinary);
        this.menuView.add(this.menuViewAsBinary);
        this.menuViewAsHex.setAction((javax.swing.Action)this.cmViewAsHex);
        this.groupView.add(this.menuViewAsHex);
        this.menuView.add(this.menuViewAsHex);
        this.menuViewAsPicture.setAction((javax.swing.Action)this.cmViewAsPicture);
        this.groupView.add(this.menuViewAsPicture);
        this.menuView.add(this.menuViewAsPicture);
        this.menuViewAsJavaObject.setAction((javax.swing.Action)this.cmViewAsJavaObject);
        this.groupView.add(this.menuViewAsJavaObject);
        this.menuView.add(this.menuViewAsJavaObject);
        this.menuViewHtml.setAction((javax.swing.Action)this.cmViewHtml);
        this.groupView.add(this.menuViewHtml);
        this.menuViewHtml.setSelected(true);
        this.menuView.add(this.menuViewHtml);
        this.jMenuBar1.add(this.menuView);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void cmViewAsJavaObjectActionPerformed(ActionEvent evt) {
        this.menuViewAsJavaObject.setSelected(true);
        if (this.value instanceof QueryField) {
            this.setCurrentPanel(new BeanPropertyPanel(this.value, new String[]{"class", "fieldClass", "metaData", "query", "resultSet"}));
        } else {
            this.setCurrentPanel(new BeanPropertyPanel(this.value));
        }
    }

    private void cmViewAsPictureActionPerformed(ActionEvent evt) {
        if (this.value instanceof Variant) {
            this.menuViewAsPicture.setSelected(true);
            this.setCurrentPanel(new ViewAsPicturePanel((Variant)this.value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cmSaveAsActionPerformed(ActionEvent evt) {
        if (this.value == null) {
            return;
        }
        File file = FileUtil.selectFileToSave((Component)this, null);
        if (file != null) {
            byte[] buffer = null;
            try {
                buffer = this.value instanceof Variant && ((Variant)this.value).getValueType() == 13 ? ((Variant)this.value).getBinary() : (this.value instanceof Variant ? ((Variant)this.value).getString().getBytes() : this.value.toString().getBytes());
                FileOutputStream stream = new FileOutputStream(file);
                try {
                    ((OutputStream)stream).write(buffer);
                }
                finally {
                    ((OutputStream)stream).close();
                }
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
                MessageBox.show((Component)this, (String)"B\u0142\u0105d", (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void cmViewAsHexActionPerformed(ActionEvent evt) {
        if (this.value instanceof Variant) {
            this.menuViewAsHex.setSelected(true);
            this.setCurrentPanel(new ViewAsHexPanel((Variant)this.value));
        }
    }

    private void cmViewAsBinaryActionPerformed(ActionEvent evt) {
        if (this.value instanceof Variant) {
            this.menuViewAsBinary.setSelected(true);
            this.setCurrentPanel(new ViewAsBinaryPanel((Variant)this.value));
        }
    }

    private void cmCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void cmViewAsStringActionPerformed(ActionEvent evt) {
        this.menuViewAsString.setSelected(true);
        this.setCurrentPanel(new ViewAsStringPanel(this.value));
    }

    private void cmViewHtmlActionPerformed(ActionEvent evt) {
        this.menuViewHtml.setSelected(true);
        this.setCurrentPanel(new ViewHtmlPanel(this.value));
    }
}

