/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui.comps.table;

import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.util.EventObject;
import java.util.concurrent.Callable;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.gui.comps.table.DataTablePopupMenu;
import pl.mpak.orbada.gui.comps.table.cm.ColumnFitWidthAction;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.core.DefaultQueryListener;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.core.QueryListener;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableColumnModel;
import pl.mpak.usedb.gui.swing.QueryTableColumnModelListener;

public class DataTable
extends QueryTable {
    private QueryTableColumnModelListener columnListener;
    public static Font dataFont = new Font("Courier New", 0, 11);
    private boolean autoFitWidth = true;
    private QueryListener queryListener;

    public DataTable(Query query) {
        super(query);
        this.init();
    }

    public DataTable() {
        this.init();
    }

    private void init() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DataTable.this.setComponentPopupMenu((JPopupMenu)((Object)new DataTablePopupMenu(DataTable.this)));
            }
        });
    }

    public void setColumnModel(TableColumnModel tcm) {
        if (this.getColumnModel() instanceof QueryTableColumnModel) {
            ((QueryTableColumnModel)this.getColumnModel()).removeQueryTableColumnListener(this.getColumnListener());
        }
        super.setColumnModel(tcm);
        if (this.getColumnModel() instanceof QueryTableColumnModel) {
            ((QueryTableColumnModel)this.getColumnModel()).addQueryTableColumnListener(this.getColumnListener());
        }
    }

    private void performAutoFitWidth() {
        if (Application.get() != null && Application.get().getSettings().getValue("data-table-auto-fit-width", Boolean.valueOf(true)).booleanValue() && this.autoFitWidth && this.getQuery() != null && this.getQuery().isActive()) {
            new ColumnFitWidthAction((JTable)((Object)this)).performe();
        }
    }

    private QueryTableColumnModelListener getColumnListener() {
        if (this.columnListener == null) {
            this.columnListener = new QueryTableColumnModelListener(){

                public void beforeCreateColumns(EventObject e) {
                }

                public void afterCreateColumns(EventObject e) {
                    SwingUtil.invokeLater((Callable)new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            DataTable.this.performAutoFitWidth();
                            DataTable.this.restoreColumnWidths();
                            return null;
                        }
                    });
                }
            };
        }
        return this.columnListener;
    }

    public boolean isAutoFitWidth() {
        return this.autoFitWidth;
    }

    public void setAutoFitWidth(boolean autoFitWidth) {
        this.autoFitWidth = autoFitWidth;
    }

    public void setQuery(Query query) {
        if (this.getQuery() != null) {
            this.getQuery().removeQueryListener(this.getQueryListener());
        }
        super.setQuery(query);
        if (this.getQuery() != null) {
            this.getQuery().addQueryListener(this.getQueryListener());
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        Graphics2D g = (Graphics2D)this.getGraphics();
        if (g != null) {
            FontMetrics fm = g.getFontMetrics();
            this.setRowHeight(fm.getHeight() + 1);
        }
        this.getTableHeader().setFont(dataFont);
    }

    private QueryListener getQueryListener() {
        if (this.queryListener == null) {
            this.queryListener = new DefaultQueryListener(){

                public void beforeOpen(EventObject e) {
                    DataTable.this.setFont(dataFont);
                }

                public void beforeClose(EventObject e) {
                    DataTable.this.saveColumnWidths();
                }
            };
        }
        return this.queryListener;
    }

    private void restoreColumnWidths() {
        if (Application.get() != null && Application.get().getSettings().getValue("auto-save-column-widths", Boolean.valueOf(true)).booleanValue()) {
            ISettings settings = Application.get().getSettings(this.getQuery().getDatabase().getUserProperties().getProperty("schemaId"), "orbada-data-table-columns-props");
            for (int i = 0; i < this.getColumnCount() && i < this.getColumnModel().getColumnCount(); ++i) {
                long width;
                TableColumn o = this.getColumnModel().getColumn(i);
                if (!(o instanceof QueryTableColumn)) continue;
                QueryTableColumn qtc = (QueryTableColumn)o;
                String fieldName = qtc.getFieldName();
                if (fieldName.length() > 200) {
                    fieldName = fieldName.substring(0, 199);
                }
                if ((width = settings.getValue(fieldName, Long.valueOf(qtc.getWidth())).longValue()) == (long)qtc.getWidth()) continue;
                qtc.setPreferredWidth((int)width);
            }
        }
    }

    private void saveColumnWidths() {
        if (Application.get() != null && Application.get().getSettings().getValue("auto-save-column-widths", Boolean.valueOf(true)).booleanValue()) {
            ISettings settings = Application.get().getSettings(this.getQuery().getDatabase().getUserProperties().getProperty("schemaId"), "orbada-data-table-columns-props");
            for (int i = 0; i < this.getColumnCount(); ++i) {
                TableColumn o = this.getColumnModel().getColumn(i);
                if (!(o instanceof QueryTableColumn)) continue;
                QueryTableColumn qtc = (QueryTableColumn)o;
                String fieldName = qtc.getFieldName();
                if (fieldName.length() > 200) {
                    fieldName = fieldName.substring(0, 199);
                }
                settings.setValue(fieldName, Long.valueOf(qtc.getWidth()));
            }
        }
    }
}

