/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui.comps.table;

import java.awt.EventQueue;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.EventObject;
import javax.swing.table.TableModel;
import pl.mpak.usedb.core.QueryListener;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.util.StringUtil;
import pl.mpak.util.timer.Timer;
import pl.mpak.util.timer.TimerManager;
import pl.mpak.util.timer.TimerQueue;

public class SearchOnQueryTable {
    private static final TimerQueue timerQueue = TimerManager.getTimer((String)"orbada-search-on-query-table");
    private QueryTable table;
    private Timer searchTimer;
    private String searchText = "";
    private long lastSearch = System.currentTimeMillis();

    public SearchOnQueryTable(QueryTable table) {
        this.table = table;
        this.init();
    }

    public void setSearchText(String searchText) {
        if (!StringUtil.nvl((String)this.searchText, (String)"").equals(searchText)) {
            this.searchText = searchText;
            this.lastSearch = System.currentTimeMillis();
            if (this.searchText.length() > 0 && this.searchTimer != null) {
                this.searchTimer.restart();
            }
        }
    }

    private void init() {
        this.table.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (!(SearchOnQueryTable.this.table.isEditing() || SearchOnQueryTable.this.searchTimer == null || e.isAltDown() || e.isControlDown())) {
                    if (System.currentTimeMillis() - SearchOnQueryTable.this.lastSearch > 1000L) {
                        SearchOnQueryTable.this.searchText = "";
                    }
                    if (e.getKeyCode() == 8) {
                        if (!StringUtil.nvl((String)SearchOnQueryTable.this.searchText, (String)"").equals("")) {
                            SearchOnQueryTable.this.setSearchText(SearchOnQueryTable.this.searchText.substring(0, SearchOnQueryTable.this.searchText.length() - 1));
                        }
                    } else if (Character.isJavaIdentifierPart(e.getKeyChar()) && e.getKeyChar() > '\u001f') {
                        SearchOnQueryTable.this.setSearchText(SearchOnQueryTable.this.searchText + e.getKeyChar());
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.table.getQuery().addQueryListener(new QueryListener(){

            public void beforeScroll(EventObject event) {
            }

            public void afterScroll(EventObject event) {
            }

            public void beforeOpen(EventObject event) {
            }

            public void afterOpen(EventObject event) {
                timerQueue.add(SearchOnQueryTable.this.searchTimer = new Timer(250L){
                    {
                        this.setEnabled(false);
                    }

                    public void run() {
                        this.setEnabled(false);
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SearchOnQueryTable.this.findRowBySearchText(false);
                            }
                        });
                    }
                });
            }

            public void beforeClose(EventObject event) {
                if (SearchOnQueryTable.this.searchTimer != null) {
                    SearchOnQueryTable.this.searchTimer.cancel();
                    SearchOnQueryTable.this.searchTimer = null;
                }
            }

            public void afterClose(EventObject event) {
            }

            public void flushedPerformed(EventObject event) {
            }

            public void errorPerformed(EventObject event) {
            }
        });
    }

    public int findRowBySearchText(boolean startSelected) {
        String searchText_l = new String(this.searchText);
        if (this.table.getSelectedColumn() >= 0 && !StringUtil.nvl((String)searchText_l, (String)"").equals("")) {
            int r;
            TableModel tm = this.table.getModel();
            int modelIndex = this.table.getColumnModel().getColumn(this.table.getSelectedColumn()).getModelIndex();
            int n = r = startSelected ? Math.max(this.table.getSelectedRow() + 1, 0) : 0;
            while (r < tm.getRowCount()) {
                Object value = tm.getValueAt(r, modelIndex);
                if (value != null && value.toString().toUpperCase().startsWith(searchText_l.toUpperCase())) {
                    final int row = r;
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SearchOnQueryTable.this.table.changeSelection(row, SearchOnQueryTable.this.table.getSelectedColumn());
                        }
                    });
                    return r;
                }
                ++r;
            }
        }
        return -1;
    }
}

