/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui.comps.table;

import java.awt.EventQueue;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import pl.mpak.util.StringUtil;
import pl.mpak.util.timer.Timer;
import pl.mpak.util.timer.TimerManager;
import pl.mpak.util.timer.TimerQueue;

public class SearchOnTable {
    private static final TimerQueue timerQueue = TimerManager.getTimer((String)"orbada-search-on-query-table");
    private JTable table;
    private Timer searchTimer;
    private String searchText = "";
    private long lastSearch = System.currentTimeMillis();

    public SearchOnTable(JTable table) {
        this.table = table;
        this.init();
    }

    public void setSearchText(String searchText) {
        if (!StringUtil.nvl((String)this.searchText, (String)"").equals(searchText)) {
            this.searchText = searchText;
            this.lastSearch = System.currentTimeMillis();
            if (this.searchText.length() > 0 && this.searchTimer != null) {
                this.searchTimer.restart();
            }
        }
    }

    private void init() {
        this.table.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (!(SearchOnTable.this.table.isEditing() || SearchOnTable.this.searchTimer == null || e.isAltDown() || e.isControlDown())) {
                    if (System.currentTimeMillis() - SearchOnTable.this.lastSearch > 1000L) {
                        SearchOnTable.this.searchText = "";
                    }
                    if (e.getKeyCode() == 8) {
                        if (!StringUtil.nvl((String)SearchOnTable.this.searchText, (String)"").equals("")) {
                            SearchOnTable.this.setSearchText(SearchOnTable.this.searchText.substring(0, SearchOnTable.this.searchText.length() - 1));
                        }
                    } else if (Character.isJavaIdentifierPart(e.getKeyChar()) && e.getKeyChar() > '\u001f') {
                        SearchOnTable.this.setSearchText(SearchOnTable.this.searchText + e.getKeyChar());
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.searchTimer = new Timer(250L){
            {
                this.setEnabled(false);
            }

            public void run() {
                this.setEnabled(false);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SearchOnTable.this.findRowBySearchText(false);
                    }
                });
            }
        };
        timerQueue.add(this.searchTimer);
    }

    public void done() {
        if (this.searchTimer != null) {
            this.searchTimer.cancel();
            this.searchTimer = null;
        }
    }

    public int findRowBySearchText(boolean startSelected) {
        String searchText = new String(this.searchText);
        if (this.table.getSelectedColumn() >= 0 && !StringUtil.nvl((String)searchText, (String)"").equals("")) {
            int r;
            TableModel tm = this.table.getModel();
            int modelIndex = this.table.getColumnModel().getColumn(this.table.getSelectedColumn()).getModelIndex();
            int n = r = startSelected ? Math.max(this.table.getSelectedRow() + 1, 0) : 0;
            while (r < tm.getRowCount()) {
                Object value = tm.getValueAt(r, modelIndex);
                if (value != null && value.toString().toUpperCase().startsWith(searchText.toUpperCase())) {
                    final int row = r;
                    EventQueue.invokeLater(new Runnable(){
                        int column;
                        {
                            this.column = SearchOnTable.this.table.getSelectedColumn();
                        }

                        @Override
                        public void run() {
                            SearchOnTable.this.table.changeSelection(row, this.column, false, false);
                        }
                    });
                    return row;
                }
                ++r;
            }
        }
        return -1;
    }
}

