/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui.comps.table;

import java.awt.Component;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import pl.mpak.orbada.Consts;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.gui.comps.table.cm.ColumnDecWidthAction;
import pl.mpak.orbada.gui.comps.table.cm.ColumnFitWidthAction;
import pl.mpak.orbada.gui.comps.table.cm.ColumnIncWidthAction;
import pl.mpak.orbada.gui.comps.table.cm.ColumnMoveToCurrentAction;
import pl.mpak.orbada.gui.comps.table.cm.ColumnMoveToEndAction;
import pl.mpak.orbada.gui.comps.table.cm.CopyCellToClipboardAction;
import pl.mpak.orbada.gui.comps.table.cm.RefreshAction;
import pl.mpak.orbada.gui.comps.table.cm.RowDecHeightAction;
import pl.mpak.orbada.gui.comps.table.cm.RowIncHeightAction;
import pl.mpak.orbada.gui.comps.table.cm.ViewQueryFieldAction;
import pl.mpak.orbada.gui.comps.table.cm.ViewValueAction;
import pl.mpak.orbada.plugins.providers.ExportTableActionProvider;
import pl.mpak.orbada.plugins.providers.TableActionProvider;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.PopupMenu;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class TablePopupMenu
extends PopupMenu {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);

    public TablePopupMenu(JTable popupComponent) {
        super((JComponent)popupComponent);
        if (popupComponent instanceof QueryTable) {
            this.add((Action)((Object)new RefreshAction((QueryTable)popupComponent)));
            this.addSeparator();
        }
        this.add((Action)((Object)new ColumnFitWidthAction(popupComponent)));
        this.addSeparator();
        this.add((Action)((Object)new ColumnIncWidthAction(popupComponent)));
        this.add((Action)((Object)new ColumnDecWidthAction(popupComponent)));
        this.add((Action)((Object)new RowIncHeightAction(popupComponent)));
        this.add((Action)((Object)new RowDecHeightAction(popupComponent)));
        this.addSeparator();
        this.add((Action)((Object)new ColumnMoveToEndAction(popupComponent)));
        this.add((Action)((Object)new ColumnMoveToCurrentAction(popupComponent)));
        this.addSeparator();
        this.add((Action)((Object)new CopyCellToClipboardAction(popupComponent)));
        if (popupComponent instanceof QueryTable) {
            this.add((Action)((Object)new ViewValueAction((QueryTable)popupComponent)));
            this.add((Action)((Object)new ViewQueryFieldAction((QueryTable)popupComponent)));
        }
        if (Application.get() != null) {
            ExportTableActionProvider[] exportList;
            JMenu exportMenu = new JMenu(stringManager.getString("SubMenuExport"));
            exportMenu.addMenuListener(this.getMenuListener());
            for (ExportTableActionProvider eta : exportList = (ExportTableActionProvider[])Application.get().getServiceArray(ExportTableActionProvider.class)) {
                eta.setTable(popupComponent);
                exportMenu.add((Action)eta);
                SwingUtil.addAction((JComponent)popupComponent, (Action)eta);
            }
            this.add(exportMenu);
            TableActionProvider[] list = (TableActionProvider[])Application.get().getServiceArray(TableActionProvider.class);
            if (list.length > 0) {
                this.addSeparator();
                for (TableActionProvider ta : list) {
                    ta.setTable(popupComponent);
                    this.add((Action)ta);
                }
            }
        }
        this.addPopupMenuListener(this.getPopupMenuListener());
    }

    private MenuListener getMenuListener() {
        return new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                TablePopupMenu.this.checkEnable((JComponent)e.getSource());
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        };
    }

    private PopupMenuListener getPopupMenuListener() {
        return new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                TablePopupMenu.this.checkEnable((JComponent)e.getSource());
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        };
    }

    private void checkEnable(JComponent menu) {
        for (int i = 0; i < menu.getComponentCount(); ++i) {
            Component c = menu.getComponent(i);
            if (!(c instanceof JMenuItem) || ((JMenuItem)c).getAction() == null) continue;
            if (((JMenuItem)c).getAction() instanceof ExportTableActionProvider) {
                ((ExportTableActionProvider)((JMenuItem)c).getAction()).checkEnable();
                continue;
            }
            if (!(((JMenuItem)c).getAction() instanceof TableActionProvider)) continue;
            ((TableActionProvider)((JMenuItem)c).getAction()).checkEnable();
        }
    }
}

