/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui.comps.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Closeable;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import pl.mpak.orbada.Consts;
import pl.mpak.orbada.gui.comps.table.Table;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.util.QueryUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.Titleable;

public class VerticalQueryTablePanel
extends JPanel
implements Titleable,
Closeable {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);
    private Database database;
    private String title;
    private JScrollPane jScrollPane1;
    private Table tableData;

    public VerticalQueryTablePanel(Database database, String title) {
        this.database = database;
        this.title = title;
        this.initComponents();
        this.init();
    }

    public VerticalQueryTablePanel(Database database) {
        this(database, null);
    }

    private void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(String sqlText) {
        Query query = this.database.createQuery();
        try {
            this.refresh(query.open(sqlText));
        }
        catch (Exception ex) {
            MessageBox.show((Component)this, (String)stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
        }
        finally {
            query.close();
        }
    }

    public void refresh(Query query) {
        try {
            int column = this.tableData.getSelectedColumn();
            int index = Math.max(0, this.tableData.getSelectedRow());
            Vector data = QueryUtil.rotateRows((Query)query, (int[])new int[]{1, 3});
            Vector<String> columnNames = new Vector<String>();
            columnNames.add(stringManager.getString("VerticalQueryTablePanel-name"));
            for (int c = 1; c < ((Vector)data.get(0)).size(); ++c) {
                columnNames.add(stringManager.getString("VerticalQueryTablePanel-value"));
            }
            this.tableData.setModel(new DefaultTableModel(data, columnNames){

                @Override
                public boolean isCellEditable(int row, int col) {
                    return false;
                }
            });
            if (data.size() > 0) {
                this.tableData.changeSelection(Math.min(index, this.tableData.getRowCount() - 1), column);
            }
        }
        catch (Exception ex) {
            MessageBox.show((Component)this, (String)stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
        }
    }

    @Override
    public void close() throws IOException {
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public JTable getTable() {
        return this.tableData;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.tableData = new Table();
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView(this.tableData);
        this.add((Component)this.jScrollPane1, "Center");
    }
}

