/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui.comps.table;

import java.awt.Component;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.StringTokenizer;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.gui.comps.table.SearchOnQueryTable;
import pl.mpak.orbada.gui.comps.table.ViewTablePopupMenu;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.util.Utils;
import pl.mpak.usedb.core.DefaultQueryListener;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.core.QueryListener;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableColumnModel;

public class ViewTable
extends QueryTable {
    private QueryListener queryListener;
    private ArrayList<OryginalColumnProps> orygColumnList;

    public ViewTable() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ViewTable.this.setComponentPopupMenu((JPopupMenu)((Object)new ViewTablePopupMenu((JTable)((Object)ViewTable.this))));
            }
        });
        new SearchOnQueryTable(this);
        this.setRowHeight(18);
    }

    public void setQuery(Query query) {
        if (this.getQuery() != null) {
            this.getQuery().removeQueryListener(this.getQueryListener());
        }
        super.setQuery(query);
        if (this.getQuery() != null) {
            this.getQuery().addQueryListener(this.getQueryListener());
        }
    }

    private QueryListener getQueryListener() {
        if (this.queryListener == null) {
            this.queryListener = new DefaultQueryListener(){

                public void afterOpen(EventObject e) {
                    ViewTable.this.restoreColumnProps();
                }

                public void beforeClose(EventObject e) {
                    ViewTable.this.storeColumnProps();
                }
            };
        }
        return this.queryListener;
    }

    public void restoreOryginalColumnProps() {
        if (this.getColumnModel() instanceof QueryTableColumnModel && this.orygColumnList.size() > 0) {
            QueryTableColumnModel model = (QueryTableColumnModel)this.getColumnModel();
            model.clearColumns();
            for (OryginalColumnProps ocp : this.orygColumnList) {
                ocp.column.setPreferredWidth(ocp.width);
                model.addColumn(ocp.column);
            }
        }
    }

    private void restoreColumnProps() {
        if (Application.get() != null && Application.get().getSettings().getValue("auto-save-column-widths", Boolean.valueOf(true)).booleanValue() && this.getColumnModel() instanceof QueryTableColumnModel) {
            ISettings settings = Application.get().getSettings(this.getQuery().getDatabase().getUserProperties().getProperty("schemaId"), "orbada-view-table-columns-props-" + Utils.getUniqueCompId((Component)((Object)this)));
            QueryTableColumnModel model = (QueryTableColumnModel)this.getColumnModel();
            if (this.orygColumnList == null) {
                this.orygColumnList = new ArrayList();
                for (int i = 0; i < model.getColumnCount(); ++i) {
                    TableColumn tc = model.getColumn(i);
                    this.orygColumnList.add(new OryginalColumnProps(tc, tc.getWidth()));
                }
            }
            TableColumn[] tcs = new TableColumn[model.getColumnCount()];
            for (int i = 0; i < model.getColumnCount(); ++i) {
                tcs[i] = model.getColumn(i);
            }
            for (TableColumn tc : tcs) {
                int index;
                StringTokenizer st;
                if (!(tc instanceof QueryTableColumn)) continue;
                QueryTableColumn qtc = (QueryTableColumn)tc;
                String fieldName = qtc.getFieldName();
                if (fieldName.length() > 200) {
                    fieldName = fieldName.substring(0, 199);
                }
                int oinx = -1;
                for (int i = 0; i < model.getColumnCount(); ++i) {
                    if (model.getColumn(i) != tc) continue;
                    oinx = i;
                    break;
                }
                if (!(st = new StringTokenizer(settings.getValue(fieldName, qtc.getWidth() + "," + oinx), ",")).hasMoreTokens()) continue;
                int width = Integer.parseInt(st.nextToken());
                if (width != qtc.getWidth()) {
                    qtc.setPreferredWidth(width);
                }
                if (!st.hasMoreTokens() || (index = Integer.parseInt(st.nextToken())) == oinx) continue;
                try {
                    model.moveColumn(oinx, index);
                }
                catch (IllegalArgumentException ex) {
                    // empty catch block
                }
            }
        }
    }

    private void storeColumnProps() {
        if (Application.get() != null && Application.get().getSettings().getValue("auto-save-column-widths", Boolean.valueOf(true)).booleanValue() && this.getColumnModel() instanceof QueryTableColumnModel) {
            ISettings settings = Application.get().getSettings(this.getQuery().getDatabase().getUserProperties().getProperty("schemaId"), "orbada-view-table-columns-props-" + Utils.getUniqueCompId((Component)((Object)this)));
            for (int i = 0; i < this.getColumnCount(); ++i) {
                TableColumn o = this.getColumnModel().getColumn(i);
                if (!(o instanceof QueryTableColumn)) continue;
                QueryTableColumn qtc = (QueryTableColumn)o;
                String fieldName = qtc.getFieldName();
                if (fieldName.length() > 200) {
                    fieldName = fieldName.substring(0, 199);
                }
                settings.setValue(fieldName, qtc.getWidth() + "," + i);
            }
            settings.store();
        }
    }

    private static class OryginalColumnProps {
        TableColumn column;
        int width;

        public OryginalColumnProps(TableColumn column, int width) {
            this.column = column;
            this.width = width;
        }
    }
}

