/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui.comps.table.cm;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import pl.mpak.orbada.Consts;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.variant.Variant;

public class ColumnFitWidthAction
extends Action {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);
    private JTable table;

    public ColumnFitWidthAction(JTable table) {
        this.table = table;
        this.setText(stringManager.getString("ColumnFitWidth-text"));
        this.setShortCut(73, 2);
        this.setActionCommandKey("cmColumnFitWidth");
        this.addActionListener(this.createActionListener());
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Variant v = new Variant();
                if (ColumnFitWidthAction.this.table.isShowing()) {
                    TableModel tm = ColumnFitWidthAction.this.table.getModel();
                    Graphics g = ColumnFitWidthAction.this.table.getGraphics();
                    FontMetrics fm = g.getFontMetrics();
                    for (int c = 0; c < ColumnFitWidthAction.this.table.getColumnCount(); ++c) {
                        TableColumn tc = ColumnFitWidthAction.this.table.getColumnModel().getColumn(c);
                        int width = fm.stringWidth(((String)tc.getHeaderValue()).toString());
                        for (int r = Math.max(ColumnFitWidthAction.this.table.getSelectedRow(), 0); r < Math.min(tm.getRowCount(), Math.max(ColumnFitWidthAction.this.table.getSelectedRow(), 0) + 50); ++r) {
                            Object value = tm.getValueAt(r, tc.getModelIndex());
                            if (value instanceof Icon || value instanceof Image || value == null) continue;
                            if (c >= ColumnFitWidthAction.this.table.getColumnCount()) break;
                            v.setValue(value);
                            Component comp = ColumnFitWidthAction.this.table.getCellRenderer(r, c).getTableCellRendererComponent(ColumnFitWidthAction.this.table, v.toString(), false, false, r, c);
                            int twidth = comp.getWidth();
                            if (comp instanceof JLabel) {
                                twidth = fm.stringWidth(((JLabel)comp).getText());
                            } else if (comp instanceof JCheckBox) {
                                twidth = fm.stringWidth(((JCheckBox)comp).getText()) + 30;
                            }
                            if (twidth > width) {
                                width = twidth;
                            }
                            if (width <= 1000) continue;
                            width = 1000;
                        }
                        if (c >= ColumnFitWidthAction.this.table.getColumnCount()) break;
                        ColumnFitWidthAction.this.table.getColumnModel().getColumn(c).setPreferredWidth(width + 10);
                        ColumnFitWidthAction.this.table.getColumnModel().getColumn(c).setWidth(width + 10);
                    }
                    ColumnFitWidthAction.this.table.revalidate();
                    ColumnFitWidthAction.this.table.repaint();
                }
            }
        };
    }
}

