/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui.comps.table.cm;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTable;
import pl.mpak.orbada.Consts;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.variant.Variant;

public class CopyCellToClipboardAction
extends Action {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);
    private JTable table;

    public CopyCellToClipboardAction(JTable table) {
        this.table = table;
        this.setText(stringManager.getString("CopyCellToClipoard-text"));
        this.setShortCut(67, 2);
        this.setActionCommandKey("cmCopyCellToClipboard");
        this.addActionListener(this.createActionListener());
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CopyCellToClipboardAction.this.table.getSelectedColumn() >= 0 && CopyCellToClipboardAction.this.table.getSelectedRow() >= 0) {
                    String value;
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    Object o = CopyCellToClipboardAction.this.table.getValueAt(CopyCellToClipboardAction.this.table.getSelectedRow(), CopyCellToClipboardAction.this.table.getSelectedColumn());
                    if (o instanceof Variant) {
                        try {
                            value = ((Variant)o).getString();
                        }
                        catch (Exception ex) {
                            value = "";
                        }
                    } else {
                        value = o != null ? o.toString() : "";
                    }
                    StringSelection data = new StringSelection(value);
                    clipboard.setContents(data, data);
                }
            }
        };
    }
}

