/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui.comps.table.cm;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import pl.mpak.orbada.Consts;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class RefreshAction
extends Action {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);
    private QueryTable table;

    public RefreshAction(QueryTable table) {
        this.table = table;
        this.setText(stringManager.getString("Refresh-text"));
        this.setShortCut(116, 0);
        this.setSmallIcon(ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.setActionCommandKey("cmRefresh");
        this.addActionListener(this.createActionListener());
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int row = -1;
                    int column = -1;
                    if (RefreshAction.this.table.getQuery().isActive()) {
                        row = RefreshAction.this.table.getSelectedRow();
                        column = RefreshAction.this.table.getSelectedColumn();
                    }
                    RefreshAction.this.table.getQuery().refresh();
                    if (row != -1) {
                        RefreshAction.this.table.changeSelection(row, column);
                    }
                }
                catch (Exception ex) {
                    ExceptionUtil.processException((Throwable)ex);
                }
            }
        };
    }
}

