/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui.comps.table.cm;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.Consts;
import pl.mpak.orbada.gui.util.SimpleSelectDialog;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.core.QueryField;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class SelectTableColumnAction
extends Action {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);
    private JTable table;
    private String formatData;

    public SelectTableColumnAction(JTable table, String formatData) {
        this.table = table;
        this.formatData = formatData;
        this.setText(stringManager.getString("SelectTableColumn-text"));
        this.setShortCut(69, 2);
        this.setActionCommandKey("cmSelectTableColumn");
        this.addActionListener(this.createActionListener());
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final Vector columns = new Vector();
                for (int i = 0; i < SelectTableColumnAction.this.table.getColumnCount(); ++i) {
                    TableColumn tc = SelectTableColumnAction.this.table.getColumnModel().getColumn(i);
                    Vector<String> item = new Vector<String>();
                    item.add(new Integer(i).toString());
                    item.add(tc.getHeaderValue().toString());
                    if (tc instanceof QueryTableColumn) {
                        QueryField qf = ((QueryTableColumn)tc).getField();
                        if (qf != null) {
                            item.add(qf.getDataTypeName());
                        } else {
                            item.add("");
                        }
                        item.add(SQLUtil.createSqlName((String)qf.getSchemaName(), (String)qf.getTableName()));
                    }
                    columns.add(item);
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Rectangle rect = SelectTableColumnAction.this.table.getCellRect(SelectTableColumnAction.this.table.getSelectedRow(), SelectTableColumnAction.this.table.getSelectedColumn(), true);
                        Point point = SelectTableColumnAction.this.table.getLocationOnScreen();
                        SimpleSelectDialog.select(SwingUtil.getWindowComponent((Component)SelectTableColumnAction.this.table), point.x + rect.x, point.y + ((SelectTableColumnAction)SelectTableColumnAction.this).table.getVisibleRect().y, SelectTableColumnAction.this.formatData, columns, SelectTableColumnAction.this.table.getSelectedColumn(), new SimpleSelectDialog.CallBack(){

                            @Override
                            public void selected(Object o) {
                                final Vector value = (Vector)o;
                                if (value != null) {
                                    EventQueue.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            SelectTableColumnAction.this.table.changeSelection(SelectTableColumnAction.this.table.getSelectedRow(), Integer.parseInt((String)value.get(0)), false, false);
                                        }
                                    });
                                }
                            }
                        });
                    }
                });
            }
        };
    }
}

