/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui.comps.table.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.io.Closeable;
import java.io.IOException;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.variant.Variant;

public class ViewAsBinaryPanel
extends JPanel
implements Closeable {
    private Variant value;
    private JScrollPane jScrollPane1;
    private JTextArea textView;

    public ViewAsBinaryPanel(Variant value) {
        this.value = value;
        this.initComponents();
        this.init();
    }

    private void init() {
        if (this.value != null) {
            this.convert();
        }
    }

    private void convert() {
        StringBuilder sb = new StringBuilder();
        try {
            byte[] buffer = null;
            buffer = this.value.getValueType() == 13 ? this.value.getBinary() : this.value.getString().getBytes();
            for (int i = 0; i < buffer.length; ++i) {
                if (buffer[i] < 32) {
                    sb.append('\u0000');
                } else {
                    sb.append((char)buffer[i]);
                }
                if ((i + 1) % 80 != 0) continue;
                sb.append('\n');
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        this.textView.setText(sb.toString());
        this.textView.setCaretPosition(0);
    }

    @Override
    public void close() throws IOException {
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.textView = new JTextArea();
        this.setLayout(new BorderLayout());
        this.textView.setColumns(20);
        this.textView.setEditable(false);
        this.textView.setFont(new Font("Courier New", 0, 12));
        this.textView.setRows(5);
        this.jScrollPane1.setViewportView(this.textView);
        this.add((Component)this.jScrollPane1, "Center");
    }
}

