/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui.comps.table.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.io.Closeable;
import java.io.IOException;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.variant.Variant;

public class ViewAsHexPanel
extends JPanel
implements Closeable {
    private Variant value;
    private JScrollPane jScrollPane1;
    private JTextArea textView;

    public ViewAsHexPanel(Variant value) {
        this.value = value;
        this.initComponents();
        this.init();
    }

    private void init() {
        if (this.value != null) {
            this.convert();
        }
    }

    private void convert() {
        StringBuilder sb = new StringBuilder();
        StringBuilder sbLine = new StringBuilder();
        try {
            int i;
            byte[] buffer = null;
            buffer = this.value.getValueType() == 13 ? this.value.getBinary() : this.value.getString().getBytes();
            for (i = 0; i < buffer.length; ++i) {
                sb.append(String.format("%02X", buffer[i]));
                if ((i + 1) % 8 == 0 && (i + 1) % 16 != 0) {
                    sb.append('|');
                } else {
                    sb.append(' ');
                }
                if (buffer[i] < 32) {
                    sbLine.append('\u0000');
                } else {
                    sbLine.append((char)buffer[i]);
                }
                if ((i + 1) % 8 == 0 && (i + 1) % 16 != 0) {
                    sbLine.append('|');
                }
                if ((i + 1) % 16 != 0) continue;
                sb.append(" | " + sbLine.toString());
                sbLine.setLength(0);
                sb.append('\n');
            }
            if (sbLine.length() > 0) {
                for (i = buffer.length % 16; i < 16; ++i) {
                    sb.append("   ");
                }
                sb.append(" | " + sbLine.toString());
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        this.textView.setText(sb.toString());
        this.textView.setCaretPosition(0);
    }

    @Override
    public void close() throws IOException {
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.textView = new JTextArea();
        this.setLayout(new BorderLayout());
        this.textView.setColumns(20);
        this.textView.setEditable(false);
        this.textView.setFont(new Font("Courier New", 0, 12));
        this.textView.setRows(5);
        this.jScrollPane1.setViewportView(this.textView);
        this.add((Component)this.jScrollPane1, "Center");
    }
}

