/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui.comps.util;

import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import pl.mpak.orbada.db.Schema;
import pl.mpak.util.StringUtil;

public class SchemasListCellRenderer
extends DefaultListCellRenderer {
    public SchemasListCellRenderer() {
        this.setVerticalAlignment(1);
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value instanceof Schema) {
            Schema schema = (Schema)value;
            String text = "<html>";
            String name = schema.getPublicNameResolved();
            name = name.toUpperCase().startsWith("<HTML>") ? name.substring(6) : "<b>" + name + "</b>";
            text = text + name;
            String url = schema.getUrl();
            if (StringUtil.isEmpty((String)url)) {
                url = schema.replacePatts(schema.fieldByName("drv_url_template").getValue().toString());
            }
            text = text + " (" + (url.length() > 50 ? url.substring(0, 49) + "..." : url) + ")";
            value = text;
        }
        return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
    }
}

