/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui.gadgets;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Closeable;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import pl.mpak.orbada.Consts;
import pl.mpak.orbada.gui.GadgetAccesibilities;
import pl.mpak.orbada.gui.PerspectivePanel;
import pl.mpak.orbada.plugins.IGadgetAccesibilities;
import pl.mpak.orbada.plugins.providers.PerpectiveGadgetProvider;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.util.Configurable;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.Titleable;

public class GadgetPanel
extends JPanel
implements Closeable {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);
    private int lastHeight;
    private PerspectivePanel perspectivePanel;
    private PerpectiveGadgetProvider provider;
    private GadgetAccesibilities accesibilities;
    private Component gadgetComponent;
    private int initialHeight;
    private ToolButton buttonClose;
    private ToolButton buttonConfig;
    private ToolButton buttonMinimize;
    private Action cmClose;
    private Action cmConfig;
    private Action cmMinimize;
    private JLabel labelTitle;
    private JPanel panelButtons;
    private JPanel panelFillWest;
    private JPanel panelGadget;
    private JPanel panelLabel;
    private JPanel panelTitle;

    public GadgetPanel(PerspectivePanel perspectivePanel, PerpectiveGadgetProvider provider, int initialHeight) {
        this.perspectivePanel = perspectivePanel;
        this.provider = provider;
        this.initialHeight = initialHeight;
        this.accesibilities = new GadgetAccesibilities(perspectivePanel){

            public void updated() {
                GadgetPanel.this.gadgetUpdated();
            }
        };
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setMinimumSize(new Dimension(0, 100));
        SwingUtil.addAction((JComponent)this.panelGadget, (javax.swing.Action)this.cmClose);
        SwingUtil.addAction((JComponent)this.panelGadget, (javax.swing.Action)this.cmMinimize);
        SwingUtil.addAction((JComponent)this.panelGadget, (javax.swing.Action)this.cmConfig);
        this.gadgetComponent = this.provider.createGadget((IGadgetAccesibilities)this.accesibilities);
        this.panelGadget.add(this.gadgetComponent);
        this.gadgetUpdated();
    }

    private void gadgetUpdated() {
        if (this.gadgetComponent instanceof Titleable) {
            this.labelTitle.setText("<html>" + ((Titleable)this.gadgetComponent).getTitle());
        } else {
            this.labelTitle.setText("<html>" + this.provider.getPublicName());
        }
        if (this.gadgetComponent instanceof Configurable) {
            this.cmConfig.setEnabled(((Configurable)this.gadgetComponent).isConfig());
        } else {
            this.cmConfig.setEnabled(false);
        }
        this.labelTitle.setIcon(this.provider.getIcon());
    }

    @Override
    public void close() throws IOException {
        if (this.gadgetComponent instanceof Closeable) {
            ((Closeable)((Object)this.gadgetComponent)).close();
        }
        this.accesibilities.close();
    }

    public PerpectiveGadgetProvider getProvider() {
        return this.provider;
    }

    public boolean isMinimized() {
        return !this.gadgetComponent.isVisible();
    }

    public void setMinimized(boolean value) {
        if (value) {
            this.lastHeight = this.getHeight();
            this.panelGadget.setVisible(false);
            this.setPreferredSize(new Dimension(0, this.panelTitle.getHeight()));
        } else {
            if (this.lastHeight == 0) {
                this.lastHeight = this.getPreferredSize().height;
            }
            this.setPreferredSize(new Dimension(0, this.lastHeight));
            this.panelGadget.setVisible(true);
        }
        if (this.getParent() != null) {
            this.getParent().validate();
        }
    }

    public int getInitialHeight() {
        return this.initialHeight;
    }

    private void initComponents() {
        this.cmClose = new Action();
        this.cmMinimize = new Action();
        this.cmConfig = new Action();
        this.panelTitle = new JPanel();
        this.panelButtons = new JPanel();
        this.buttonConfig = new ToolButton();
        this.buttonMinimize = new ToolButton();
        this.buttonClose = new ToolButton();
        this.panelLabel = new JPanel();
        this.labelTitle = new JLabel();
        this.panelFillWest = new JPanel();
        this.panelGadget = new JPanel();
        this.cmClose.setActionCommandKey("cmClose");
        this.cmClose.setShortCut(KeyStroke.getKeyStroke(115, 2));
        this.cmClose.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/stop10.gif"));
        this.cmClose.setText(stringManager.getString("cmClose-text"));
        this.cmClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GadgetPanel.this.cmCloseActionPerformed(evt);
            }
        });
        this.cmMinimize.setActionCommandKey("cmMinimize");
        this.cmMinimize.setEnabled(false);
        this.cmMinimize.setShortCut(KeyStroke.getKeyStroke(77, 3));
        this.cmMinimize.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/minimize10.gif"));
        this.cmMinimize.setText(stringManager.getString("cmMinimize-text"));
        this.cmMinimize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GadgetPanel.this.cmMinimizeActionPerformed(evt);
            }
        });
        this.cmConfig.setActionCommandKey("cmConfig");
        this.cmConfig.setShortCut(KeyStroke.getKeyStroke(67, 3));
        this.cmConfig.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/config10.gif"));
        this.cmConfig.setText(stringManager.getString("GadgetPanel-cmConfig-text"));
        this.cmConfig.setTooltip(stringManager.getString("GadgetPanel-cmConfig-hint"));
        this.cmConfig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GadgetPanel.this.cmConfigActionPerformed(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.panelTitle.setBackground(UIManager.getDefaults().getColor("textHighlight"));
        this.panelTitle.setBorder(BorderFactory.createEtchedBorder());
        this.panelTitle.setLayout(new BorderLayout());
        this.panelButtons.setOpaque(false);
        this.panelButtons.setLayout(new FlowLayout(1, 2, 2));
        this.buttonConfig.setAction((javax.swing.Action)this.cmConfig);
        this.buttonConfig.setPreferredSize(new Dimension(16, 16));
        this.panelButtons.add((Component)this.buttonConfig);
        this.buttonMinimize.setAction((javax.swing.Action)this.cmMinimize);
        this.buttonMinimize.setPreferredSize(new Dimension(16, 16));
        this.panelButtons.add((Component)this.buttonMinimize);
        this.buttonClose.setAction((javax.swing.Action)this.cmClose);
        this.buttonClose.setPreferredSize(new Dimension(16, 16));
        this.panelButtons.add((Component)this.buttonClose);
        this.panelTitle.add((Component)this.panelButtons, "East");
        this.panelLabel.setOpaque(false);
        this.panelLabel.setLayout(new BorderLayout(2, 0));
        this.labelTitle.setForeground(UIManager.getDefaults().getColor("TextArea.background"));
        this.labelTitle.setText(stringManager.getString("GadgetPanel-labelTitle-text"));
        this.panelLabel.add((Component)this.labelTitle, "Center");
        this.panelTitle.add((Component)this.panelLabel, "Center");
        this.panelFillWest.setOpaque(false);
        this.panelFillWest.setPreferredSize(new Dimension(5, 0));
        this.panelFillWest.setLayout(new BorderLayout());
        this.panelTitle.add((Component)this.panelFillWest, "West");
        this.add((Component)this.panelTitle, "First");
        this.panelGadget.setLayout(new BorderLayout());
        this.add((Component)this.panelGadget, "Center");
    }

    private void cmMinimizeActionPerformed(ActionEvent evt) {
        this.setMinimized(this.panelGadget.isVisible());
        if (this.getParent() != null) {
            this.getParent().validate();
        }
    }

    private void cmCloseActionPerformed(ActionEvent evt) {
        this.perspectivePanel.closeGadget(this);
    }

    private void cmConfigActionPerformed(ActionEvent evt) {
        if (this.gadgetComponent instanceof Configurable && ((Configurable)this.gadgetComponent).configure()) {
            this.accesibilities.updated();
        }
    }
}

