/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.gui.laf;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.OceanTheme;
import pl.mpak.orbada.Consts;
import pl.mpak.orbada.gui.laf.BluesMetalTheme;
import pl.mpak.orbada.plugins.IApplication;
import pl.mpak.orbada.plugins.ISettingsComponent;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.ComboBox;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class CrossPlatformLookAndFeelSettingsPanel
extends JPanel
implements ISettingsComponent {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);
    private IApplication application;
    private File propFile;
    private Properties props;
    private String[] themeNames;
    private Class[] themeClasses = new Class[]{DefaultMetalTheme.class, BluesMetalTheme.class, OceanTheme.class};
    private int selectedTheme = -1;
    private ComboBox comboTheme;
    private JLabel jLabel1;

    public CrossPlatformLookAndFeelSettingsPanel(IApplication application) {
        this.application = application;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.themeNames = new String[]{stringManager.getString("CrossPlatformLookAndFeelSettingsPanel-default"), stringManager.getString("CrossPlatformLookAndFeelSettingsPanel-blue"), stringManager.getString("CrossPlatformLookAndFeelSettingsPanel-ocean")};
        this.propFile = new File(this.application.getConfigPath() + "/laf-cross-platform.properties");
        this.comboTheme.setModel(new DefaultComboBoxModel<String>(this.themeNames));
        this.props = new Properties();
        if (this.propFile.exists()) {
            try {
                this.props.load(new FileInputStream(this.propFile));
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
                ExceptionUtil.processException((Throwable)ex);
            }
        }
        this.restoreSettings();
    }

    public void restoreSettings() {
        String currentTheme = this.props.getProperty("current-theme", this.themeClasses[0].getName());
        for (int i = 0; i < this.themeClasses.length; ++i) {
            if (!this.themeClasses[i].getName().equals(currentTheme)) continue;
            this.comboTheme.setSelectedIndex(i);
            break;
        }
        this.selectedTheme = this.comboTheme.getSelectedIndex();
        if (this.comboTheme.getSelectedIndex() == -1) {
            this.comboTheme.setSelectedIndex(0);
        }
    }

    public void applySettings() {
        this.props.setProperty("current-theme", this.themeClasses[this.comboTheme.getSelectedIndex()].getName());
        try {
            this.props.store(new FileOutputStream(this.propFile), "");
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        if (this.selectedTheme != this.comboTheme.getSelectedIndex() && "cross-platform-look-and-feel-service".equals(this.application.getSettings("orbada-settings").getValue("look-and-feel", ""))) {
            this.application.updateLAF();
        }
    }

    public void cancelSettings() {
        this.restoreSettings();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.comboTheme = new ComboBox();
        this.jLabel1.setText(stringManager.getString("CrossPlatformLookAndFeelSettingsPanel-select-theme-dd"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.comboTheme, -2, 196, -2).addComponent(this.jLabel1)).addContainerGap(194, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.comboTheme, -2, -1, -2).addContainerGap(247, Short.MAX_VALUE)));
    }
}

